/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.DirectOrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationContinuityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationTrajectoryCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.NativeQPInputTypeA;

public class OrientationTrajectoryInputCalculator {
    private final SE3MPCIndexHandler indexHandler;
    private static final DMatrixRMaj identity6 = CommonOps_DDRM.identity((int)6);
    private final DMatrixRMaj tempObjective = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj orientationWeight = new DMatrixRMaj(6, 6);

    public OrientationTrajectoryInputCalculator(SE3MPCIndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public int compute(NativeQPInputTypeA inputToPack, DirectOrientationValueCommand command) {
        int orientationIndex = this.indexHandler.getOrientationStartIndex(command.getSegmentNumber());
        if (this.computeInternal(inputToPack, command, this.indexHandler.getTotalProblemSize(), orientationIndex)) {
            return 0;
        }
        return -1;
    }

    public int computeCompact(NativeQPInputTypeA inputToPack, DirectOrientationValueCommand command) {
        int orientationIndex = this.indexHandler.getOrientationStartIndex(command.getSegmentNumber());
        if (this.computeInternal(inputToPack, command, 6, 0)) {
            return orientationIndex;
        }
        return -1;
    }

    private boolean computeInternal(NativeQPInputTypeA inputToPack, DirectOrientationValueCommand command, int numberOfVariables, int startIndex) {
        inputToPack.setConstraintType(command.getConstraintType());
        inputToPack.setWeight(command.getObjectiveWeight());
        inputToPack.setUseWeightScalar(true);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(6);
        inputToPack.getTaskJacobian().zero();
        inputToPack.getTaskJacobian().insert(identity6, 0, startIndex);
        inputToPack.getTaskObjective().set(command.getObjectiveValue());
        return true;
    }

    public int compute(NativeQPInputTypeA inputToPack, OrientationValueCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        if (this.computeInternal(inputToPack, command, this.indexHandler.getTotalProblemSize(), comIndex, orientationIndex)) {
            return 0;
        }
        return -1;
    }

    public int computeCompact(NativeQPInputTypeA inputToPack, OrientationValueCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        if (this.computeInternal(inputToPack, command, this.indexHandler.getVariablesInSegment(segmentNumber), 6, 0)) {
            return orientationIndex;
        }
        return -1;
    }

    private boolean computeInternal(NativeQPInputTypeA inputToPack, OrientationValueCommand command, int numberOfVariables, int comIndex, int orientationIndex) {
        inputToPack.setConstraintType(command.getConstraintType());
        inputToPack.setWeight(command.getObjectiveWeight());
        inputToPack.setUseWeightScalar(true);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(6);
        this.tempObjective.reshape(6, 1);
        inputToPack.getTaskJacobian().zero();
        inputToPack.getTaskJacobian().insert(command.getAMatrix(), 0, orientationIndex);
        inputToPack.getTaskJacobian().insert(command.getBMatrix(), 0, comIndex);
        CommonOps_DDRM.subtract((DMatrixD1)command.getObjectiveValue(), (DMatrixD1)command.getCMatrix(), (DMatrixD1)this.tempObjective);
        inputToPack.getTaskObjective().set(this.tempObjective);
        return true;
    }

    public int compute(NativeQPInputTypeA inputToPack, OrientationContinuityCommand command) {
        int segmentNumber = command.getSegmentNumber();
        if (segmentNumber == this.indexHandler.getNumberOfSegments() - 1) {
            return -1;
        }
        if (this.computeInternal(inputToPack, command, this.indexHandler.getTotalProblemSize(), this.indexHandler.getComCoefficientStartIndex(segmentNumber), this.indexHandler.getOrientationStartIndex(segmentNumber), this.indexHandler.getOrientationStartIndex(segmentNumber + 1))) {
            return 0;
        }
        return -1;
    }

    public int computeCompact(NativeQPInputTypeA inputToPack, OrientationContinuityCommand command) {
        int segmentNumber = command.getSegmentNumber();
        if (segmentNumber == this.indexHandler.getNumberOfSegments() - 1) {
            return -1;
        }
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber) - orientationIndex;
        int nextOrientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber + 1) - orientationIndex;
        int numberOfVariables = this.indexHandler.getVariablesInSegment(segmentNumber) + 6;
        if (this.computeInternal(inputToPack, command, numberOfVariables, comIndex, 0, nextOrientationIndex)) {
            return orientationIndex;
        }
        return -1;
    }

    private boolean computeInternal(NativeQPInputTypeA inputToPack, OrientationContinuityCommand command, int numberOfVariables, int comIndex, int orientationIndex, int nextOrientationIndex) {
        int segmentNumber = command.getSegmentNumber();
        if (segmentNumber == this.indexHandler.getNumberOfSegments() - 1) {
            return false;
        }
        inputToPack.setConstraintType(command.getConstraintType());
        inputToPack.setWeight(command.getObjectiveWeight());
        inputToPack.setUseWeightScalar(true);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(6);
        inputToPack.getTaskJacobian().zero();
        inputToPack.getTaskJacobian().insertScaled(command.getAMatrix(), 0, orientationIndex, -1.0);
        inputToPack.getTaskJacobian().insertScaled(command.getBMatrix(), 0, comIndex, -1.0);
        inputToPack.getTaskJacobian().insert(identity6, 0, nextOrientationIndex);
        inputToPack.getTaskObjective().set(command.getCMatrix());
        return true;
    }

    public int compute(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        if (this.computeInternal(tick, inputToPack, command, this.indexHandler.getTotalProblemSize(), comIndex, orientationIndex)) {
            return 0;
        }
        return -1;
    }

    public int computeCompact(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        int numberOfVariables = this.indexHandler.getVariablesInSegment(segmentNumber);
        if (this.computeInternal(tick, inputToPack, command, numberOfVariables, comIndex - orientationIndex, 0)) {
            return orientationIndex;
        }
        return -1;
    }

    public boolean computeInternal(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command, int numberOfVariables, int comIndex, int orientationIndex) {
        inputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(6);
        inputToPack.getTaskObjective().zero();
        inputToPack.setUseWeightScalar(false);
        for (int i = 0; i < 3; ++i) {
            this.orientationWeight.set(i, i, command.getAngleErrorMinimizationWeight());
            this.orientationWeight.set(i + 3, i + 3, command.getVelocityErrorMinimizationWeight());
        }
        inputToPack.setTaskWeightMatrix((DMatrix)this.orientationWeight);
        inputToPack.getTaskJacobian().zero();
        inputToPack.getTaskJacobian().insert(command.getAMatrix(tick), 0, orientationIndex);
        inputToPack.getTaskJacobian().insert(command.getBMatrix(tick), 0, comIndex);
        inputToPack.getTaskObjective().scale(-1.0, command.getCMatrix(tick));
        return true;
    }

    public int computeAngleErrorMinimization(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        if (this.computeAngleErrorMinimizationInternal(tick, inputToPack, command, this.indexHandler.getTotalProblemSize(), comIndex, orientationIndex)) {
            return 0;
        }
        return -1;
    }

    public int computeAngleErrorMinimizationCompact(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        int numberOfVariables = this.indexHandler.getVariablesInSegment(segmentNumber);
        if (this.computeAngleErrorMinimizationInternal(tick, inputToPack, command, numberOfVariables, comIndex - orientationIndex, 0)) {
            return orientationIndex;
        }
        return -1;
    }

    public boolean computeAngleErrorMinimizationInternal(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command, int numberOfVariables, int comIndex, int orientationIndex) {
        int segmentNumber = command.getSegmentNumber();
        int numberOfLinearVariables = 6 + this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(3);
        inputToPack.getTaskJacobian().zero();
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(command.getAngleErrorMinimizationWeight());
        inputToPack.getTaskJacobian().insert(command.getAMatrix(tick), 0, 3, 0, 6, 0, orientationIndex);
        inputToPack.getTaskJacobian().insert(command.getBMatrix(tick), 0, 3, 0, numberOfLinearVariables, 0, comIndex);
        inputToPack.getTaskObjective().insertScaled(command.getCMatrix(tick), 0, 3, 0, 1, 0, 0, -1.0);
        return true;
    }

    public int computeVelocityErrorMinimization(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        if (this.computeVelocityErrorMinimizationInternal(tick, inputToPack, command, this.indexHandler.getTotalProblemSize(), comIndex, orientationIndex)) {
            return 0;
        }
        return -1;
    }

    public int computeVelocityErrorMinimizationCompact(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command) {
        int segmentNumber = command.getSegmentNumber();
        int comIndex = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int orientationIndex = this.indexHandler.getOrientationStartIndex(segmentNumber);
        int numberOfVariables = this.indexHandler.getVariablesInSegment(segmentNumber);
        if (this.computeVelocityErrorMinimizationInternal(tick, inputToPack, command, numberOfVariables, comIndex - orientationIndex, 0)) {
            return orientationIndex;
        }
        return -1;
    }

    public boolean computeVelocityErrorMinimizationInternal(int tick, NativeQPInputTypeA inputToPack, OrientationTrajectoryCommand command, int numberOfVariables, int comIndex, int orientationIndex) {
        int segmentNumber = command.getSegmentNumber();
        int numberOfLinearVariables = 6 + this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(3);
        inputToPack.getTaskJacobian().zero();
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(command.getVelocityErrorMinimizationWeight());
        inputToPack.getTaskJacobian().insert(command.getAMatrix(tick), 3, 6, 0, 6, 0, orientationIndex);
        inputToPack.getTaskJacobian().insert(command.getBMatrix(tick), 3, 6, 0, numberOfLinearVariables, 0, comIndex);
        inputToPack.getTaskObjective().insertScaled(command.getCMatrix(tick), 3, 6, 0, 1, 0, 0, -1.0);
        return true;
    }
}

