/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationTrajectoryCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.OrientationDynamicsCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.LinearMPCTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.OrientationMPCTrajectoryHandler;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class OrientationTrajectoryConstructor {
    private final OrientationDynamicsCalculator dynamicsCalculator;
    private final RecyclingArrayList<OrientationTrajectoryCommand> trajectoryCommandsForSegments = new RecyclingArrayList(OrientationTrajectoryCommand::new);
    private final FrameVector3D referenceBodyAngularVelocityInBodyFrame = new FrameVector3D();
    private final Vector3D desiredInternalAngularMomentumRate = new Vector3D();
    private final Vector3D desiredNetAngularMomentumRate = new Vector3D();
    private final SE3MPCIndexHandler indexHandler;
    private final DoubleProvider orientationAngleTrackingWeight;
    private final DoubleProvider orientationVelocityTrackingWeight;
    private final DoubleProvider omega;

    public OrientationTrajectoryConstructor(SE3MPCIndexHandler indexHandler, DoubleProvider orientationAngleTrackingWeight, DoubleProvider orientationVelocityTrackingWeight, DoubleProvider omega, double mass, double gravity) {
        this.indexHandler = indexHandler;
        this.orientationAngleTrackingWeight = orientationAngleTrackingWeight;
        this.orientationVelocityTrackingWeight = orientationVelocityTrackingWeight;
        this.omega = omega;
        this.dynamicsCalculator = new OrientationDynamicsCalculator(mass, gravity);
    }

    public List<OrientationTrajectoryCommand> getOrientationTrajectoryCommands() {
        return this.trajectoryCommandsForSegments;
    }

    public void compute(List<ContactPlaneProvider> previewWindowContactSequence, Matrix3DReadOnly momentOfInertia, LinearMPCTrajectoryHandler linearTrajectoryHandler, OrientationMPCTrajectoryHandler orientationTrajectoryHandler, List<? extends List<MPCContactPlane>> contactPlaneHelpers) {
        this.dynamicsCalculator.setMomentumOfInertiaInBodyFrame(momentOfInertia);
        this.trajectoryCommandsForSegments.clear();
        double trajectoryStartTime = previewWindowContactSequence.get(0).getTimeInterval().getStartTime();
        for (int segmentNumber = 0; segmentNumber < previewWindowContactSequence.size(); ++segmentNumber) {
            OrientationTrajectoryCommand command = (OrientationTrajectoryCommand)this.trajectoryCommandsForSegments.add();
            command.reset();
            command.setSegmentNumber(segmentNumber);
            int ticksInSegment = this.indexHandler.getTicksInSegment(segmentNumber);
            double tickDuration = this.indexHandler.getTickDuration(segmentNumber);
            double timeInSegment = 0.0;
            command.setAngleErrorMinimizationWeight(tickDuration * this.orientationAngleTrackingWeight.getValue());
            command.setVelocityErrorMinimizationWeight(tickDuration * this.orientationVelocityTrackingWeight.getValue());
            for (int tick = 0; tick < ticksInSegment; ++tick) {
                linearTrajectoryHandler.compute(trajectoryStartTime);
                orientationTrajectoryHandler.computeDiscretizedReferenceTrajectory(trajectoryStartTime);
                FrameOrientation3DReadOnly referenceOrientation = orientationTrajectoryHandler.getReferenceBodyOrientation();
                this.referenceBodyAngularVelocityInBodyFrame.set((FrameTuple3DReadOnly)orientationTrajectoryHandler.getReferenceBodyVelocity());
                referenceOrientation.transform((FixedFrameTuple3DBasics)this.referenceBodyAngularVelocityInBodyFrame);
                if (orientationTrajectoryHandler.hasInternalAngularMomentum()) {
                    this.desiredInternalAngularMomentumRate.set((Tuple3DReadOnly)orientationTrajectoryHandler.getDesiredInternalAngularMomentumRate());
                    if (contactPlaneHelpers.get(segmentNumber).size() > 0) {
                        this.desiredNetAngularMomentumRate.set((Tuple3DReadOnly)orientationTrajectoryHandler.getDesiredInternalAngularMomentumRate());
                    } else {
                        this.desiredNetAngularMomentumRate.setToZero();
                    }
                } else {
                    this.desiredNetAngularMomentumRate.setToZero();
                    this.desiredInternalAngularMomentumRate.setToZero();
                }
                this.dynamicsCalculator.compute(linearTrajectoryHandler.getDesiredCoMPosition(), linearTrajectoryHandler.getDesiredCoMAcceleration(), referenceOrientation, (Vector3DReadOnly)this.referenceBodyAngularVelocityInBodyFrame, (Vector3DReadOnly)this.desiredNetAngularMomentumRate, (Vector3DReadOnly)this.desiredInternalAngularMomentumRate, contactPlaneHelpers.get(segmentNumber), timeInSegment, tickDuration, this.omega.getValue());
                DMatrixRMaj previousA = command.getLastAMatrix();
                DMatrixRMaj previousB = command.getLastBMatrix();
                DMatrixRMaj previousC = command.getLastCMatrix();
                DMatrixRMaj nextA = command.addAMatrix();
                DMatrixRMaj nextB = command.addBMatrix();
                DMatrixRMaj nextC = command.addCMatrix();
                nextB.set((DMatrixD1)this.dynamicsCalculator.getDiscreteBMatrix());
                nextC.set((DMatrixD1)this.dynamicsCalculator.getDiscreteCMatrix());
                if (tick > 0) {
                    CommonOps_DDRM.mult((DMatrix1Row)this.dynamicsCalculator.getDiscreteAMatrix(), (DMatrix1Row)previousA, (DMatrix1Row)nextA);
                    CommonOps_DDRM.multAdd((DMatrix1Row)this.dynamicsCalculator.getDiscreteAMatrix(), (DMatrix1Row)previousB, (DMatrix1Row)nextB);
                    CommonOps_DDRM.multAdd((DMatrix1Row)this.dynamicsCalculator.getDiscreteAMatrix(), (DMatrix1Row)previousC, (DMatrix1Row)nextC);
                } else {
                    nextA.set((DMatrixD1)this.dynamicsCalculator.getDiscreteAMatrix());
                }
                trajectoryStartTime += tickDuration;
                timeInSegment += tickDuration;
            }
        }
    }
}

