/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.RowMajorNativeMatrixGrower;
import us.ihmc.commons.MathTools;
import us.ihmc.convexOptimization.IntermediateSolutionListener;
import us.ihmc.convexOptimization.quadraticProgram.InverseMatrixCalculator;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.NativeMatrix;

public class MPCQPSolver {
    private static final boolean debug = false;
    private static final double violationFractionToAdd = 0.8;
    private static final double violationFractionToRemove = 0.95;
    private double convergenceThreshold = 1.0E-10;
    private double convergenceThresholdForLagrangeMultipliers = 1.0E-10;
    private int maxNumberOfIterations = 10;
    private boolean reportFailedConvergenceAsNaN = true;
    private boolean resetActiveSetOnSizeChange = true;
    private final RowMajorNativeMatrixGrower nativeMatrixGrower = new RowMajorNativeMatrixGrower();
    private final DMatrixRMaj activeVariables = new DMatrixRMaj(0, 0);
    private final TIntArrayList activeInequalityIndices = new TIntArrayList();
    protected final NativeMatrix nativexSolutionMatrix = new NativeMatrix(0, 0);
    public final NativeMatrix costQuadraticMatrix = new NativeMatrix(0, 0);
    private final NativeMatrix linearInequalityConstraintsCheck = new NativeMatrix(0, 0);
    public final NativeMatrix quadraticCostQVector = new NativeMatrix(0, 0);
    public final NativeMatrix quadraticCostQMatrix = new NativeMatrix(0, 0);
    public final NativeMatrix linearEqualityConstraintsAMatrix = new NativeMatrix(0, 0);
    public final NativeMatrix linearEqualityConstraintsBVector = new NativeMatrix(0, 0);
    public final NativeMatrix linearInequalityConstraintsCMatrixO = new NativeMatrix(0, 0);
    public final NativeMatrix linearInequalityConstraintsDVectorO = new NativeMatrix(0, 0);
    public final DMatrixRMaj linearInequalityConstraintsSlackVariableCost = new DMatrixRMaj(0, 0);
    private final NativeMatrix CBar = new NativeMatrix(0, 0);
    private final NativeMatrix DBar = new NativeMatrix(0, 0);
    private final DMatrixRMaj slackBar = new DMatrixRMaj(0, 0);
    private final NativeMatrix inverseSlackHessian = new NativeMatrix(0, 0);
    private final NativeMatrix QInverse = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverse = new NativeMatrix(0, 0);
    private final NativeMatrix QInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverse = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix AQInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverseATranspose = new NativeMatrix(0, 0);
    private final NativeMatrix QInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix CBarQInverseCBarTranspose = new NativeMatrix(0, 0);
    private final NativeMatrix AAndC = new NativeMatrix(0, 0);
    private final NativeMatrix ATransposeMuAndCTransposeLambda = new NativeMatrix(0, 0);
    private final NativeMatrix bigMatrixForLagrangeMultiplierSolution = new NativeMatrix(0, 0);
    private final NativeMatrix bigVectorForLagrangeMultiplierSolution = new NativeMatrix(0, 0);
    private final NativeMatrix tempVector = new NativeMatrix(0, 0);
    private final NativeMatrix augmentedLagrangeMultipliers = new NativeMatrix(0, 0);
    private final TIntArrayList inequalityIndicesToAddToActiveSet = new TIntArrayList();
    private final TIntArrayList inequalityIndicesToRemoveFromActiveSet = new TIntArrayList();
    protected final NativeMatrix computedObjectiveFunctionValue = new NativeMatrix(1, 1);
    private InverseMatrixCalculator<NativeMatrix> inverseSolver = new DefaultInverseMatrixCalculator();
    private boolean useWarmStart = false;
    private int previousNumberOfVariables = 0;
    private int previousNumberOfEqualityConstraints = 0;
    private int previousNumberOfInequalityConstraints = 0;
    private final List<IntermediateSolutionListener> solutionListeners = new ArrayList<IntermediateSolutionListener>();
    private final NativeMatrix tempJtW = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeEqualityConstraintMultipliers = new NativeMatrix(0, 0);
    private final NativeMatrix lagrangeInequalityConstraintMultipliers = new NativeMatrix(0, 0);

    public void setConvergenceThreshold(double convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold;
    }

    public void setConvergenceThresholdForLagrangeMultipliers(double convergenceThresholdForLagrangeMultipliers) {
        this.convergenceThresholdForLagrangeMultipliers = convergenceThresholdForLagrangeMultipliers;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void addIntermediateSolutionListener(IntermediateSolutionListener solutionListener) {
        this.solutionListeners.add(solutionListener);
    }

    public void setReportFailedConvergenceAsNaN(boolean reportFailedConvergenceAsNaN) {
        this.reportFailedConvergenceAsNaN = reportFailedConvergenceAsNaN;
    }

    public void setResetActiveSetOnSizeChange(boolean resetActiveSetOnSizeChange) {
        this.resetActiveSetOnSizeChange = resetActiveSetOnSizeChange;
    }

    public void setActiveInequalityIndices(TIntList activeInequalityIndices) {
        this.activeInequalityIndices.reset();
        for (int i = 0; i < activeInequalityIndices.size(); ++i) {
            this.activeInequalityIndices.add(activeInequalityIndices.get(i));
        }
    }

    public TIntList getActiveInequalityIndices() {
        return this.activeInequalityIndices;
    }

    public void initialize(int problemSize) {
        this.costQuadraticMatrix.reshape(problemSize, problemSize);
        this.quadraticCostQVector.reshape(problemSize, 1);
        this.linearEqualityConstraintsAMatrix.zero();
        this.linearEqualityConstraintsBVector.zero();
        this.linearInequalityConstraintsCMatrixO.zero();
        this.linearInequalityConstraintsDVectorO.zero();
        this.linearInequalityConstraintsSlackVariableCost.zero();
        this.linearEqualityConstraintsAMatrix.reshape(0, problemSize);
        this.linearEqualityConstraintsBVector.reshape(0, 1);
        this.linearInequalityConstraintsCMatrixO.reshape(0, problemSize);
        this.linearInequalityConstraintsDVectorO.reshape(0, 1);
        this.linearInequalityConstraintsSlackVariableCost.reshape(0, 1);
        this.costQuadraticMatrix.zero();
        this.quadraticCostQVector.zero();
    }

    public void addRegularization(int startIndex, int numberOfVariables, double value) {
        for (int i = 0; i < numberOfVariables; ++i) {
            this.costQuadraticMatrix.add(startIndex + i, startIndex + i, value);
        }
    }

    public void addRateRegularization(int startIndex, int numberOfVariables, double value, DMatrix previousSolution) {
        for (int i = 0; i < numberOfVariables; ++i) {
            double previousValue = previousSolution.get(startIndex + i, 0);
            if (Double.isNaN(previousValue)) continue;
            this.costQuadraticMatrix.add(startIndex + i, startIndex + i, value);
            this.quadraticCostQVector.add(startIndex + i, 0, -previousValue * value);
        }
    }

    public void addObjective(NativeMatrix taskJacobian, NativeMatrix taskObjective, double taskWeight, int offset) {
        this.addObjective(taskJacobian, taskObjective, taskWeight, taskJacobian.getNumCols(), offset);
    }

    public void addObjective(NativeMatrix taskJacobian, NativeMatrix taskObjective, double taskWeight, int problemSize, int offset) {
        if (taskJacobian.getNumCols() != problemSize) {
            throw new RuntimeException("Motion task needs to have size matching the DoFs of the robot.");
        }
        int variables = taskJacobian.getNumCols();
        if (variables > problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.costQuadraticMatrix.multAddBlockTransA(taskWeight, taskJacobian, taskJacobian, offset, offset);
        this.quadraticCostQVector.multAddBlockTransA(-taskWeight, taskJacobian, taskObjective, offset, 0);
    }

    public void addObjective(NativeMatrix taskJacobian, NativeMatrix taskObjective, NativeMatrix taskWeight, int offset) {
        this.addObjective(taskJacobian, taskObjective, taskWeight, taskJacobian.getNumCols(), offset);
    }

    public void addObjective(NativeMatrix taskJacobian, NativeMatrix taskObjective, NativeMatrix taskWeight, int problemSize, int offset) {
        int taskSize = taskJacobian.getNumRows();
        if (taskJacobian.getNumCols() != problemSize) {
            throw new RuntimeException("Motion task needs to have size matching the DoFs of the robot.");
        }
        int variables = taskJacobian.getNumCols();
        if (variables > problemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.tempJtW.reshape(variables, taskSize);
        this.tempJtW.multTransA(taskJacobian, taskWeight);
        this.costQuadraticMatrix.multAddBlock(this.tempJtW, taskJacobian, offset, offset);
        this.quadraticCostQVector.multAddBlock(-1.0, this.tempJtW, taskObjective, offset, 0);
    }

    public void addDirectObjective(NativeMatrix directCostHessian, NativeMatrix directCostGradient, double weightScalar, int offset) {
        int size = directCostHessian.getNumCols();
        this.costQuadraticMatrix.addBlock(directCostHessian, offset, offset, 0, 0, size, size, weightScalar);
        this.quadraticCostQVector.addBlock(directCostGradient, offset, 0, 0, 0, size, 1, weightScalar);
    }

    public void addEqualityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int taskColOffset) {
        this.addEqualityConstraint(taskJacobian, taskObjective, taskJacobian.getNumCols(), problemSize, taskColOffset);
    }

    public void addEqualityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int totalProblemSize, int colOffset) {
        if (taskJacobian.getNumCols() != problemSize) {
            throw new RuntimeException("Motion task needs to have size matching the DoFs of the robot.");
        }
        int variables = taskJacobian.getNumCols();
        if (variables + colOffset > totalProblemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.nativeMatrixGrower.appendRows(this.linearEqualityConstraintsAMatrix, colOffset, taskJacobian);
        this.nativeMatrixGrower.appendRows(this.linearEqualityConstraintsBVector, taskObjective);
    }

    public void addMotionLesserOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int colOffset) {
        this.addMotionLesserOrEqualInequalityConstraint(taskJacobian, taskObjective, taskJacobian.getNumCols(), problemSize, colOffset);
    }

    public void addMotionLesserOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, double slackVariableWeight, int problemSize, int colOffset) {
        this.addMotionLesserOrEqualInequalityConstraint(taskJacobian, taskObjective, slackVariableWeight, taskJacobian.getNumCols(), problemSize, colOffset);
    }

    public void addMotionLesserOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int totalProblemSize, int colOffset) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, 1.0, problemSize, totalProblemSize, colOffset);
    }

    public void addMotionLesserOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, double slackVariableWeight, int problemSize, int totalProblemSize, int colOffset) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, 1.0, slackVariableWeight, problemSize, totalProblemSize, colOffset);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int colOffset) {
        this.addMotionGreaterOrEqualInequalityConstraint(taskJacobian, taskObjective, taskJacobian.getNumCols(), problemSize, colOffset);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, double slackVariableWeight, int problemSize, int colOffset) {
        this.addMotionGreaterOrEqualInequalityConstraint(taskJacobian, taskObjective, slackVariableWeight, taskJacobian.getNumCols(), problemSize, colOffset);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, int problemSize, int totalProblemSize, int colOffset) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, -1.0, problemSize, totalProblemSize, colOffset);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(NativeMatrix taskJacobian, NativeMatrix taskObjective, double slackVariableWeight, int problemSize, int totalProblemSize, int colOffset) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, -1.0, slackVariableWeight, problemSize, totalProblemSize, colOffset);
    }

    private void addInequalityConstraintInternal(NativeMatrix taskJacobian, NativeMatrix taskObjective, double sign, int problemSize, int totalProblemSize, int colOffset) {
        this.addInequalityConstraintInternal(taskJacobian, taskObjective, sign, Double.NaN, problemSize, totalProblemSize, colOffset);
    }

    private void addInequalityConstraintInternal(NativeMatrix taskJacobian, NativeMatrix taskObjective, double sign, double slackVariableWeight, int problemSize, int totalProblemSize, int colOffset) {
        int variables = taskJacobian.getNumCols();
        if (taskJacobian.getNumCols() != problemSize) {
            throw new RuntimeException("Motion task needs to have size matching the DoFs of the robot.");
        }
        if (variables > totalProblemSize) {
            throw new RuntimeException("This task does not fit.");
        }
        this.nativeMatrixGrower.appendRows(this.linearInequalityConstraintsCMatrixO, colOffset, sign, taskJacobian);
        this.nativeMatrixGrower.appendRows(this.linearInequalityConstraintsDVectorO, sign, taskObjective);
        int previousSize = this.linearInequalityConstraintsSlackVariableCost.getNumRows();
        int taskSize = taskObjective.getNumRows();
        this.linearInequalityConstraintsSlackVariableCost.reshape(previousSize + taskSize, 1, true);
        Arrays.fill(this.linearInequalityConstraintsSlackVariableCost.data, previousSize, previousSize + taskSize, slackVariableWeight);
    }

    public double getObjectiveCost(DMatrixRMaj x) {
        this.nativexSolutionMatrix.set(x);
        this.computedObjectiveFunctionValue.multQuad(this.nativexSolutionMatrix, this.quadraticCostQMatrix);
        this.computedObjectiveFunctionValue.scale(0.5);
        this.computedObjectiveFunctionValue.multAddTransA(this.quadraticCostQVector, this.nativexSolutionMatrix);
        return this.computedObjectiveFunctionValue.get(0, 0);
    }

    public int getNumberOfEqualityConstraints() {
        return this.linearEqualityConstraintsAMatrix.getNumRows();
    }

    public int getNumberOfInequalityConstraints() {
        return this.linearInequalityConstraintsCMatrixO.getNumRows();
    }

    private void assertSizesCorrect() {
        if (this.quadraticCostQVector.getNumCols() != 1) {
            throw new RuntimeException("costLinearVector.getNumCols() != 1");
        }
        if (this.costQuadraticMatrix.getNumRows() != this.quadraticCostQVector.getNumRows()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costLinearVector.getNumRows()");
        }
        if (this.costQuadraticMatrix.getNumRows() != this.costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("costQuadraticMatrix.getNumRows() != costQuadraticMatrix.getNumCols()");
        }
        if (this.linearEqualityConstraintsBVector.getNumCols() != 1) {
            throw new RuntimeException("linearEqualityConstraintsBVector.getNumCols() != 1");
        }
        if (this.linearEqualityConstraintsAMatrix.getNumRows() != this.linearEqualityConstraintsBVector.getNumRows()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumRows() != linearEqualityConstraintsBVector.getNumRows()");
        }
        if (this.linearEqualityConstraintsAMatrix.getNumCols() != this.costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("linearEqualityConstraintsAMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
        if (this.linearInequalityConstraintsDVectorO.getNumCols() != 1) {
            throw new RuntimeException("linearInequalityConstraintDVector.getNumCols() != 1");
        }
        if (this.linearInequalityConstraintsCMatrixO.getNumRows() != this.linearInequalityConstraintsDVectorO.getNumRows()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumRows() != linearInequalityConstraintDVector.getNumRows()");
        }
        if (this.linearInequalityConstraintsCMatrixO.getNumCols() != this.costQuadraticMatrix.getNumCols()) {
            throw new RuntimeException("linearInequalityConstraintCMatrix.getNumCols() != quadraticCostQMatrix.getNumCols()");
        }
    }

    private void computeSymmetricHessian() {
        this.quadraticCostQMatrix.transpose(this.costQuadraticMatrix);
        this.quadraticCostQMatrix.addEquals(this.costQuadraticMatrix);
        this.quadraticCostQMatrix.scale(0.5);
    }

    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    public void resetActiveSet() {
        this.CBar.reshape(0, 0);
        this.DBar.reshape(0, 0);
        this.activeInequalityIndices.reset();
    }

    public int solve(DMatrix solutionToPack) {
        int i;
        this.assertSizesCorrect();
        this.computeSymmetricHessian();
        if (!this.useWarmStart || this.resetActiveSetOnSizeChange && this.problemSizeChanged()) {
            this.resetActiveSet();
        } else {
            this.addActiveSetConstraintsAsEqualityConstraints();
        }
        int numberOfIterations = 0;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        this.nativexSolutionMatrix.reshape(numberOfVariables, 1);
        this.lagrangeEqualityConstraintMultipliers.reshape(numberOfEqualityConstraints, 1);
        this.lagrangeEqualityConstraintMultipliers.zero();
        this.lagrangeInequalityConstraintMultipliers.reshape(numberOfInequalityConstraints, 1);
        this.lagrangeInequalityConstraintMultipliers.zero();
        this.computeQInverseAndAQInverse();
        this.solveEqualityConstrainedSubproblemEfficiently(this.nativexSolutionMatrix, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers);
        if (numberOfInequalityConstraints == 0) {
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
            return numberOfIterations;
        }
        for (i = 0; i < this.maxNumberOfIterations; ++i) {
            boolean activeSetWasModified = this.modifyActiveSetAndTryAgain(this.nativexSolutionMatrix, this.lagrangeEqualityConstraintMultipliers, this.lagrangeInequalityConstraintMultipliers);
            ++numberOfIterations;
            if (activeSetWasModified) continue;
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
            return numberOfIterations;
        }
        if (this.reportFailedConvergenceAsNaN) {
            if (solutionToPack.getNumRows() != numberOfVariables) {
                throw new IllegalArgumentException("Bad number of rows.");
            }
            for (i = 0; i < numberOfVariables; ++i) {
                solutionToPack.set(i, 0, Double.NaN);
            }
        } else {
            solutionToPack.set((Matrix)this.nativexSolutionMatrix);
        }
        return numberOfIterations;
    }

    private boolean problemSizeChanged() {
        boolean sizeChanged = this.checkProblemSize();
        this.previousNumberOfVariables = (int)CommonOps_DDRM.elementSum((DMatrixD1)this.activeVariables);
        this.previousNumberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.previousNumberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        return sizeChanged;
    }

    private boolean checkProblemSize() {
        if ((double)this.previousNumberOfVariables != CommonOps_DDRM.elementSum((DMatrixD1)this.activeVariables)) {
            return true;
        }
        if (this.previousNumberOfEqualityConstraints != this.linearEqualityConstraintsAMatrix.getNumRows()) {
            return true;
        }
        return this.previousNumberOfInequalityConstraints != this.linearInequalityConstraintsCMatrixO.getNumRows();
    }

    private void computeQInverseAndAQInverse() {
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        this.inverseSolver.computeInverse((DMatrix)this.quadraticCostQMatrix, (DMatrix)this.QInverse);
        if (numberOfEqualityConstraints > 0) {
            this.AQInverse.mult(this.linearEqualityConstraintsAMatrix, this.QInverse);
            this.QInverseATranspose.multTransB(this.QInverse, this.linearEqualityConstraintsAMatrix);
            this.AQInverseATranspose.multTransB(this.AQInverse, this.linearEqualityConstraintsAMatrix);
        } else {
            this.AQInverse.reshape(numberOfEqualityConstraints, numberOfVariables);
            this.QInverseATranspose.reshape(numberOfVariables, numberOfEqualityConstraints);
            this.AQInverseATranspose.reshape(numberOfEqualityConstraints, numberOfEqualityConstraints);
        }
    }

    private void computeCBarTempMatrices() {
        int size = this.CBar.getNumRows();
        if (size > 0) {
            this.CBarQInverseATranspose.mult(this.CBar, this.QInverseATranspose);
            this.AQInverseCBarTranspose.transpose(this.CBarQInverseATranspose);
            this.CBarQInverse.mult(this.CBar, this.QInverse);
            this.QInverseCBarTranspose.transpose(this.CBarQInverse);
            this.CBarQInverseCBarTranspose.mult(this.CBar, this.QInverseCBarTranspose);
            this.inverseSlackHessian.reshape(size, size);
            this.inverseSlackHessian.zero();
            for (int i = 0; i < size; ++i) {
                double slackCost = this.slackBar.get(i, 0);
                if (MathTools.epsilonEquals((double)slackCost, (double)0.0, (double)1.0E-5) || !Double.isFinite(slackCost)) continue;
                this.inverseSlackHessian.set(i, i, 1.0 / slackCost);
            }
            this.CBarQInverseCBarTranspose.addEquals(this.inverseSlackHessian);
        } else {
            this.AQInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseATranspose.reshape(0, 0);
            this.CBarQInverse.reshape(0, 0);
            this.QInverseCBarTranspose.reshape(0, 0);
            this.CBarQInverseCBarTranspose.reshape(0, 0);
        }
    }

    private boolean modifyActiveSetAndTryAgain(NativeMatrix solutionToPack, NativeMatrix lagrangeEqualityConstraintMultipliersToPack, NativeMatrix lagrangeInequalityConstraintMultipliersToPack) {
        int i;
        if (solutionToPack.containsNaN()) {
            return false;
        }
        boolean activeSetWasModified = false;
        int numberOfInequalityConstraints = this.linearInequalityConstraintsCMatrixO.getNumRows();
        double maxInequalityViolation = Double.NEGATIVE_INFINITY;
        if (numberOfInequalityConstraints != 0) {
            this.linearInequalityConstraintsCheck.scale(-1.0, this.linearInequalityConstraintsDVectorO);
            this.linearInequalityConstraintsCheck.multAdd(this.linearInequalityConstraintsCMatrixO, solutionToPack);
            for (int i2 = 0; i2 < this.linearInequalityConstraintsCheck.getNumRows(); ++i2) {
                if (this.activeInequalityIndices.contains(i2) || !(this.linearInequalityConstraintsCheck.get(i2, 0) >= maxInequalityViolation)) continue;
                maxInequalityViolation = this.linearInequalityConstraintsCheck.get(i2, 0);
            }
        }
        double minViolationToAdd = 0.19999999999999996 * maxInequalityViolation + this.convergenceThreshold;
        this.inequalityIndicesToAddToActiveSet.reset();
        if (maxInequalityViolation > minViolationToAdd) {
            for (int i3 = 0; i3 < numberOfInequalityConstraints; ++i3) {
                if (this.activeInequalityIndices.contains(i3) || !(this.linearInequalityConstraintsCheck.get(i3, 0) > minViolationToAdd)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToAddToActiveSet.add(i3);
            }
        }
        int numberOfActiveInequalityConstraints = this.activeInequalityIndices.size();
        double minLagrangeInequalityMultiplier = Double.POSITIVE_INFINITY;
        if (numberOfActiveInequalityConstraints != 0) {
            minLagrangeInequalityMultiplier = lagrangeInequalityConstraintMultipliersToPack.min();
        }
        double maxLagrangeMultiplierToRemove = -0.050000000000000044 * minLagrangeInequalityMultiplier - this.convergenceThresholdForLagrangeMultipliers;
        this.inequalityIndicesToRemoveFromActiveSet.reset();
        if (minLagrangeInequalityMultiplier < maxLagrangeMultiplierToRemove) {
            for (i = 0; i < this.activeInequalityIndices.size(); ++i) {
                int indexToCheck = this.activeInequalityIndices.get(i);
                double lagrangeMultiplier = lagrangeInequalityConstraintMultipliersToPack.get(indexToCheck, 0);
                if (!(lagrangeMultiplier < maxLagrangeMultiplierToRemove)) continue;
                activeSetWasModified = true;
                this.inequalityIndicesToRemoveFromActiveSet.add(indexToCheck);
            }
        }
        if (!activeSetWasModified) {
            return false;
        }
        for (i = 0; i < this.inequalityIndicesToAddToActiveSet.size(); ++i) {
            this.activeInequalityIndices.add(this.inequalityIndicesToAddToActiveSet.get(i));
        }
        for (i = 0; i < this.inequalityIndicesToRemoveFromActiveSet.size(); ++i) {
            this.activeInequalityIndices.remove(this.inequalityIndicesToRemoveFromActiveSet.get(i));
        }
        this.addActiveSetConstraintsAsEqualityConstraints();
        this.solveEqualityConstrainedSubproblemEfficiently(solutionToPack, lagrangeEqualityConstraintMultipliersToPack, lagrangeInequalityConstraintMultipliersToPack);
        return true;
    }

    private void addActiveSetConstraintsAsEqualityConstraints() {
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int sizeOfActiveSet = this.activeInequalityIndices.size();
        this.CBar.reshape(sizeOfActiveSet, numberOfVariables);
        this.DBar.reshape(sizeOfActiveSet, 1);
        this.slackBar.reshape(sizeOfActiveSet, 1);
        for (int i = 0; i < sizeOfActiveSet; ++i) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i);
            this.CBar.insert(this.linearInequalityConstraintsCMatrixO, inequalityConstraintIndex, inequalityConstraintIndex + 1, 0, numberOfVariables, i, 0);
            this.DBar.insert(this.linearInequalityConstraintsDVectorO, inequalityConstraintIndex, inequalityConstraintIndex + 1, 0, 1, i, 0);
            this.slackBar.set(i, 0, this.linearInequalityConstraintsSlackVariableCost.get(inequalityConstraintIndex, 0));
        }
    }

    private void printSetChanges() {
        int i;
        if (!this.inequalityIndicesToAddToActiveSet.isEmpty()) {
            LogTools.info((String)"Inequality constraint indices added : ");
            for (i = 0; i < this.inequalityIndicesToAddToActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.inequalityIndicesToAddToActiveSet.get(i)));
            }
        }
        if (!this.inequalityIndicesToRemoveFromActiveSet.isEmpty()) {
            LogTools.info((String)"Inequality constraint indices removed : ");
            for (i = 0; i < this.inequalityIndicesToRemoveFromActiveSet.size(); ++i) {
                LogTools.info((String)("" + this.inequalityIndicesToRemoveFromActiveSet.get(i)));
            }
        }
    }

    private void solveEqualityConstrainedSubproblemEfficiently(NativeMatrix xSolutionToPack, NativeMatrix lagrangeEqualityConstraintMultipliersToPack, NativeMatrix lagrangeInequalityConstraintMultipliersToPack) {
        int numberOfActiveInequalityConstraints;
        int numberOfVariables = this.quadraticCostQMatrix.getNumRows();
        int numberOfOriginalEqualityConstraints = this.linearEqualityConstraintsAMatrix.getNumRows();
        int numberOfAugmentedEqualityConstraints = numberOfOriginalEqualityConstraints + (numberOfActiveInequalityConstraints = this.activeInequalityIndices.size());
        if (numberOfAugmentedEqualityConstraints == 0) {
            xSolutionToPack.mult(-1.0, this.QInverse, this.quadraticCostQVector);
            this.reportSolution(xSolutionToPack);
            return;
        }
        this.computeCBarTempMatrices();
        this.bigMatrixForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, numberOfAugmentedEqualityConstraints);
        this.bigVectorForLagrangeMultiplierSolution.reshape(numberOfAugmentedEqualityConstraints, 1);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.AQInverseATranspose, 0, 0);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.AQInverseCBarTranspose, 0, numberOfOriginalEqualityConstraints);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CBarQInverseATranspose, numberOfOriginalEqualityConstraints, 0);
        this.bigMatrixForLagrangeMultiplierSolution.insert(this.CBarQInverseCBarTranspose, numberOfOriginalEqualityConstraints, numberOfOriginalEqualityConstraints);
        if (numberOfOriginalEqualityConstraints > 0) {
            this.bigVectorForLagrangeMultiplierSolution.insert(this.linearEqualityConstraintsBVector, 0, 0);
            this.bigVectorForLagrangeMultiplierSolution.multAddBlock(this.AQInverse, this.quadraticCostQVector, 0, 0);
        }
        if (numberOfActiveInequalityConstraints > 0) {
            this.bigVectorForLagrangeMultiplierSolution.insert(this.DBar, numberOfOriginalEqualityConstraints, 0);
            this.bigVectorForLagrangeMultiplierSolution.multAddBlock(this.CBarQInverse, this.quadraticCostQVector, numberOfOriginalEqualityConstraints, 0);
        }
        this.bigVectorForLagrangeMultiplierSolution.scale(-1.0, this.bigVectorForLagrangeMultiplierSolution);
        this.augmentedLagrangeMultipliers.solve(this.bigMatrixForLagrangeMultiplierSolution, this.bigVectorForLagrangeMultiplierSolution);
        this.AAndC.reshape(numberOfAugmentedEqualityConstraints, numberOfVariables);
        this.AAndC.insert(this.linearEqualityConstraintsAMatrix, 0, 0);
        this.AAndC.insert(this.CBar, numberOfOriginalEqualityConstraints, 0);
        this.ATransposeMuAndCTransposeLambda.multTransA(this.AAndC, this.augmentedLagrangeMultipliers);
        this.tempVector.add(this.quadraticCostQVector, this.ATransposeMuAndCTransposeLambda);
        xSolutionToPack.mult(-1.0, this.QInverse, this.tempVector);
        this.reportSolution(xSolutionToPack);
        int startRow = 0;
        int numberOfRows = numberOfOriginalEqualityConstraints;
        lagrangeEqualityConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow, startRow + numberOfRows, 0, 1, 0, 0);
        startRow += numberOfRows;
        lagrangeInequalityConstraintMultipliersToPack.zero();
        for (int i = 0; i < numberOfActiveInequalityConstraints; ++i) {
            int inequalityConstraintIndex = this.activeInequalityIndices.get(i);
            lagrangeInequalityConstraintMultipliersToPack.insert(this.augmentedLagrangeMultipliers, startRow + i, startRow + i + 1, 0, 1, inequalityConstraintIndex, 0);
        }
    }

    private void reportSolution(NativeMatrix solution) {
        for (int i = 0; i < this.solutionListeners.size(); ++i) {
            this.solutionListeners.get(i).reportSolution(solution, this.activeInequalityIndices, null, null);
        }
    }

    public void getLagrangeEqualityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeEqualityConstraintMultipliers.get(multipliersMatrixToPack);
    }

    public void getLagrangeInequalityConstraintMultipliers(DMatrixRMaj multipliersMatrixToPack) {
        this.lagrangeInequalityConstraintMultipliers.get(multipliersMatrixToPack);
    }

    public void setInverseHessianCalculator(InverseMatrixCalculator<NativeMatrix> inverseSolver) {
        this.inverseSolver = inverseSolver;
    }

    private static class DefaultInverseMatrixCalculator
    implements InverseMatrixCalculator<NativeMatrix> {
        private DefaultInverseMatrixCalculator() {
        }

        public void computeInverse(NativeMatrix matrixToInvert, NativeMatrix inverseMatrixToPack) {
            inverseMatrixToPack.invert(matrixToInvert);
        }
    }
}

