/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.ForceObjectiveCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.ForceRateTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.ForceTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCContinuityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.NormalForceBoundCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoBoundCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoObjectiveCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoRateTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.VRPTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.CoMCoefficientJacobianCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.ContactPlaneJacobianCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.IntegrationInputCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.VRPTrackingCostCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPoint;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.NativeQPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.NativeQPInputTypeC;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;

public class MPCQPInputCalculator {
    public static final double sufficientlyLongTime = 5.0;
    public static final double sufficientlyLargeValue = 100000.0;
    private final LinearMPCIndexHandler indexHandler;
    private final VRPTrackingCostCalculator vrpTrackingCostCalculator;
    private final DMatrixRMaj selectionMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj selectedJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj selectedObjective = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempJacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempObjective = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempHessian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj tempGradient = new DMatrixRMaj(0, 0);
    private final double gravityZ;

    public MPCQPInputCalculator(LinearMPCIndexHandler indexHandler, double gravityZ) {
        this.indexHandler = indexHandler;
        this.vrpTrackingCostCalculator = new VRPTrackingCostCalculator(indexHandler, gravityZ);
        this.gravityZ = -Math.abs(gravityZ);
    }

    public int calculateContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        switch (objective.getValueType()) {
            case COM: {
                return this.calculateCoMContinuityObjective(inputToPack, objective);
            }
            case VRP: {
                return this.calculateVRPContinuityObjective(inputToPack, objective);
            }
            case DCM: {
                throw new IllegalArgumentException();
            }
        }
        return -1;
    }

    public int calculateCompactContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        switch (objective.getValueType()) {
            case COM: {
                return this.calculateCompactCoMContinuityObjective(inputToPack, objective);
            }
            case VRP: {
                return this.calculateCompactVRPContinuityObjective(inputToPack, objective);
            }
            case DCM: {
                throw new IllegalArgumentException();
            }
        }
        return -1;
    }

    public int calculateCoMContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        int secondRhoStartIndex;
        int firstRhoStartIndex;
        int secondCoMStartIndex;
        int variableSize = this.indexHandler.getTotalProblemSize();
        int firstSegmentNumber = objective.getFirstSegmentNumber();
        int secondSegmentNumber = firstSegmentNumber + 1;
        int firstCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(firstSegmentNumber);
        if (this.calculateCoMContinuityObjectiveInternal(inputToPack, objective, variableSize, firstCoMStartIndex, secondCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(secondSegmentNumber), firstRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(firstSegmentNumber), secondRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(secondSegmentNumber))) {
            return 0;
        }
        return -1;
    }

    public int calculateVRPContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        int secondRhoStartIndex;
        int firstRhoStartIndex;
        int secondCoMStartIndex;
        int variableSize = this.indexHandler.getTotalProblemSize();
        int firstSegmentNumber = objective.getFirstSegmentNumber();
        int secondSegmentNumber = firstSegmentNumber + 1;
        int firstCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(firstSegmentNumber);
        if (this.calculateVRPContinuityObjectiveInternal(inputToPack, objective, variableSize, firstCoMStartIndex, secondCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(secondSegmentNumber), firstRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(firstSegmentNumber), secondRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(secondSegmentNumber))) {
            return 0;
        }
        return -1;
    }

    public int calculateCompactCoMContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        int firstSegmentNumber = objective.getFirstSegmentNumber();
        int secondSegmentNumber = firstSegmentNumber + 1;
        int variableSize = 12 + this.indexHandler.getRhoCoefficientsInSegment(firstSegmentNumber) + this.indexHandler.getRhoCoefficientsInSegment(secondSegmentNumber);
        int firstCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(firstSegmentNumber);
        int secondCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(secondSegmentNumber);
        int firstRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(firstSegmentNumber);
        int secondRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(secondSegmentNumber);
        if (this.calculateCoMContinuityObjectiveInternal(inputToPack, objective, variableSize, 0, secondCoMStartIndex -= firstCoMStartIndex, firstRhoStartIndex -= firstCoMStartIndex, secondRhoStartIndex -= firstRhoStartIndex)) {
            return firstCoMStartIndex;
        }
        return -1;
    }

    public int calculateCompactVRPContinuityObjective(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective) {
        int firstSegmentNumber = objective.getFirstSegmentNumber();
        int secondSegmentNumber = firstSegmentNumber + 1;
        int variableSize = 12 + this.indexHandler.getRhoCoefficientsInSegment(firstSegmentNumber) + this.indexHandler.getRhoCoefficientsInSegment(secondSegmentNumber);
        int firstCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(firstSegmentNumber);
        int secondCoMStartIndex = this.indexHandler.getComCoefficientStartIndex(secondSegmentNumber);
        int firstRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(firstSegmentNumber);
        int secondRhoStartIndex = this.indexHandler.getRhoCoefficientStartIndex(secondSegmentNumber);
        if (this.calculateVRPContinuityObjectiveInternal(inputToPack, objective, variableSize, 0, secondCoMStartIndex -= firstCoMStartIndex, firstRhoStartIndex -= firstCoMStartIndex, secondRhoStartIndex -= firstRhoStartIndex)) {
            return firstCoMStartIndex;
        }
        return -1;
    }

    public boolean calculateCoMContinuityObjectiveInternal(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective, int variableSize, int firstComStartCol, int secondComStartCol, int firstRhoStartCol, int secondRhoStartCol) {
        MPCContactPlane contactPlaneHelper;
        int i;
        inputToPack.setNumberOfVariables(variableSize);
        inputToPack.reshape(3);
        inputToPack.setConstraintType(objective.getConstraintType());
        this.tempJacobian.reshape(3, variableSize);
        this.tempObjective.reshape(3, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double firstSegmentDuration = objective.getFirstSegmentDuration();
        double omega = objective.getOmega();
        double weight = objective.getWeight();
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(firstComStartCol, firstSegmentDuration, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), 1.0);
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(secondComStartCol, 0.0, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), -1.0);
        for (i = 0; i < objective.getFirstSegmentNumberOfContacts(); ++i) {
            contactPlaneHelper = objective.getFirstSegmentContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(objective.getDerivativeOrder(), firstSegmentDuration, omega, firstRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            firstRhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        for (i = 0; i < objective.getSecondSegmentNumberOfContacts(); ++i) {
            contactPlaneHelper = objective.getSecondSegmentContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(-1.0, objective.getDerivativeOrder(), 0.0, omega, secondRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            secondRhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        this.tempObjective.set(2, 0, this.getGravityZObjective(objective.getDerivativeOrder(), 0.0));
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objective.getDerivativeOrder(), firstSegmentDuration));
        inputToPack.getTaskJacobian().set(this.tempJacobian);
        inputToPack.getTaskObjective().set(this.tempObjective);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return true;
    }

    public boolean calculateVRPContinuityObjectiveInternal(NativeQPInputTypeA inputToPack, MPCContinuityCommand objective, int variableSize, int firstComStartCol, int secondComStartCol, int firstRhoStartCol, int secondRhoStartCol) {
        MPCContactPlane contactPlaneHelper;
        int i;
        inputToPack.setNumberOfVariables(variableSize);
        inputToPack.reshape(3);
        inputToPack.setConstraintType(objective.getConstraintType());
        this.tempJacobian.reshape(3, variableSize);
        this.tempObjective.reshape(3, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double firstSegmentDuration = objective.getFirstSegmentDuration();
        double omega = objective.getOmega();
        double omega2 = omega * omega;
        double weight = objective.getWeight();
        CoMCoefficientJacobianCalculator.calculateVRPJacobian(firstComStartCol, omega, firstSegmentDuration, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), 1.0);
        CoMCoefficientJacobianCalculator.calculateVRPJacobian(secondComStartCol, omega, 0.0, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), -1.0);
        for (i = 0; i < objective.getFirstSegmentNumberOfContacts(); ++i) {
            contactPlaneHelper = objective.getFirstSegmentContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(objective.getDerivativeOrder(), firstSegmentDuration, omega, firstRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            ContactPlaneJacobianCalculator.computeLinearJacobian(-1.0 / omega2, objective.getDerivativeOrder() + 2, firstSegmentDuration, omega, firstRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            firstRhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        for (i = 0; i < objective.getSecondSegmentNumberOfContacts(); ++i) {
            contactPlaneHelper = objective.getSecondSegmentContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(-1.0, objective.getDerivativeOrder(), 0.0, omega, secondRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            ContactPlaneJacobianCalculator.computeLinearJacobian(1.0 / omega2, objective.getDerivativeOrder() + 2, 0.0, omega, secondRhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            secondRhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        this.tempObjective.set(2, 0, this.getGravityZObjective(objective.getDerivativeOrder(), 0.0));
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objective.getDerivativeOrder(), firstSegmentDuration));
        inputToPack.getTaskJacobian().set(this.tempJacobian);
        inputToPack.getTaskObjective().set(this.tempObjective);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return true;
    }

    public boolean calculateForceMinimizationObjective(NativeQPInputTypeC inputToPack, ForceObjectiveCommand objective) {
        throw new RuntimeException("This objective is not yet properly implemented.");
    }

    public int calculateForceTrackingObjective(NativeQPInputTypeC inputToPack, ForceTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int numberOfVariables = this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape();
        this.tempHessian.reshape(numberOfVariables, numberOfVariables);
        this.tempGradient.reshape(numberOfVariables, 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        double weight = objective.getWeight();
        double duration = objective.getSegmentDuration();
        int startCol = 0;
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(i);
            IntegrationInputCalculator.computeForceTrackingMatrix(startCol, this.tempGradient, this.tempHessian, contactPlane, duration, objective.getOmega(), objective.getObjectiveValue());
            startCol += contactPlane.getCoefficientSize();
        }
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
    }

    public int calculateForceRateTrackingObjective(NativeQPInputTypeC inputToPack, ForceRateTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int numberOfVariables = this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape();
        this.tempHessian.reshape(numberOfVariables, numberOfVariables);
        this.tempGradient.reshape(numberOfVariables, 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        double weight = objective.getWeight();
        double duration = objective.getSegmentDuration();
        int startCol = 0;
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(i);
            IntegrationInputCalculator.computeForceRateTrackingMatrix(startCol, this.tempGradient, this.tempHessian, contactPlane, duration, objective.getOmega(), objective.getObjectiveValue());
            startCol += contactPlane.getCoefficientSize();
        }
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
    }

    public int calculateRhoTrackingObjective(NativeQPInputTypeC inputToPack, RhoTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int numberOfVariables = this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape();
        this.tempHessian.reshape(numberOfVariables, numberOfVariables);
        this.tempGradient.reshape(numberOfVariables, 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        double weight = objective.getWeight();
        double duration = objective.getSegmentDuration();
        int startCol = 0;
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(i);
            IntegrationInputCalculator.computeRhoAccelerationTrackingMatrix(startCol, this.tempGradient, this.tempHessian, contactPlane.getRhoSize(), duration, objective.getOmega(), objective.getObjectiveValue());
            startCol += contactPlane.getCoefficientSize();
        }
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
    }

    public int calculateRhoRateTrackingObjective(NativeQPInputTypeC inputToPack, RhoRateTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int numberOfVariables = this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape();
        this.tempHessian.reshape(numberOfVariables, numberOfVariables);
        this.tempGradient.reshape(numberOfVariables, 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        double weight = objective.getWeight();
        double duration = objective.getSegmentDuration();
        int startCol = 0;
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(i);
            IntegrationInputCalculator.computeRhoJerkTrackingMatrix(startCol, this.tempGradient, this.tempHessian, contactPlane.getRhoSize(), duration, objective.getOmega(), objective.getObjectiveValue());
            startCol += contactPlane.getCoefficientSize();
        }
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
    }

    public int calculateValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        switch (objective.getValueType()) {
            case COM: {
                return this.calculateCoMValueObjective(inputToPack, objective);
            }
            case VRP: {
                return this.calculateVRPValueObjective(inputToPack, objective);
            }
            case DCM: {
                return this.calculateDCMValueObjective(inputToPack, objective);
            }
        }
        return -1;
    }

    public int calculateCompactValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        switch (objective.getValueType()) {
            case COM: {
                return this.calculateCompactCoMValueObjective(inputToPack, objective);
            }
            case VRP: {
                return this.calculateCompactVRPValueObjective(inputToPack, objective);
            }
            case DCM: {
                return this.calculateCompactDCMValueObjective(inputToPack, objective);
            }
        }
        return -1;
    }

    private int calculateCoMValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int variableSize = this.indexHandler.getTotalProblemSize();
        int segmentNumber = objective.getSegmentNumber();
        int comStartCol = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int rhoStartCol = this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        inputToPack.setNumberOfVariables(variableSize);
        if (this.calculateCoMValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol, rhoStartCol)) {
            return 0;
        }
        return -1;
    }

    private int calculateVRPValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int variableSize = this.indexHandler.getTotalProblemSize();
        int segmentNumber = objective.getSegmentNumber();
        int comStartCol = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int rhoStartCol = this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        inputToPack.setNumberOfVariables(variableSize);
        if (this.calculateVRPValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol, rhoStartCol)) {
            return 0;
        }
        return -1;
    }

    private int calculateDCMValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int variableSize = this.indexHandler.getTotalProblemSize();
        int segmentNumber = objective.getSegmentNumber();
        int comStartCol = this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        int rhoStartCol = this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        inputToPack.setNumberOfVariables(variableSize);
        if (this.calculateDCMValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol, rhoStartCol)) {
            return 0;
        }
        return -1;
    }

    private int calculateCompactCoMValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int rhoStartCol;
        int comStartCol;
        int segmentNumber = objective.getSegmentNumber();
        int variableSize = 6 + this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        if (this.calculateCoMValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol = 0, rhoStartCol = 6)) {
            return this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    private int calculateCompactVRPValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int rhoStartCol;
        int comStartCol;
        int segmentNumber = objective.getSegmentNumber();
        int variableSize = 6 + this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        if (this.calculateVRPValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol = 0, rhoStartCol = 6)) {
            return this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    private int calculateCompactDCMValueObjective(NativeQPInputTypeA inputToPack, MPCValueCommand objective) {
        int rhoStartCol;
        int comStartCol;
        int segmentNumber = objective.getSegmentNumber();
        int variableSize = 6 + this.indexHandler.getRhoCoefficientsInSegment(segmentNumber);
        if (this.calculateDCMValueObjectiveInternal(inputToPack, objective, variableSize, comStartCol = 0, rhoStartCol = 6)) {
            return this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    private boolean calculateCoMValueObjectiveInternal(NativeQPInputTypeA inputToPack, MPCValueCommand objective, int numberOfVariables, int comStartCol, int rhoStartCol) {
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(3);
        inputToPack.setConstraintType(objective.getConstraintType());
        this.tempJacobian.reshape(3, numberOfVariables);
        this.tempObjective.reshape(3, 1);
        this.tempJacobian.zero();
        double timeOfObjective = objective.getTimeOfObjective();
        double omega = objective.getOmega();
        double weight = objective.getWeight();
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(comStartCol, timeOfObjective, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), 1.0);
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlaneHelper = objective.getContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(objective.getDerivativeOrder(), timeOfObjective, omega, rhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            rhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        objective.getObjective().get((DMatrix)this.tempObjective);
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objective.getDerivativeOrder(), timeOfObjective));
        if (objective.getSelectionMatrix().getNumberOfSelectedAxes() != 3) {
            this.selectionMatrix.reshape(3, 3);
            objective.getSelectionMatrix().getCompactSelectionMatrixInFrame(ReferenceFrame.getWorldFrame(), 0, 0, this.selectionMatrix);
            this.selectedJacobian.reshape(this.selectionMatrix.getNumRows(), numberOfVariables);
            this.selectedObjective.reshape(this.selectionMatrix.getNumRows(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempJacobian, (DMatrix1Row)this.selectedJacobian);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempObjective, (DMatrix1Row)this.selectedObjective);
            inputToPack.getTaskJacobian().set(this.selectedJacobian);
            inputToPack.getTaskObjective().set(this.selectedObjective);
        } else {
            inputToPack.getTaskJacobian().set(this.tempJacobian);
            inputToPack.getTaskObjective().set(this.tempObjective);
        }
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return true;
    }

    private boolean calculateDCMValueObjectiveInternal(NativeQPInputTypeA inputToPack, MPCValueCommand objective, int numberOfVariables, int comStartCol, int rhoStartCol) {
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(3);
        inputToPack.setConstraintType(objective.getConstraintType());
        this.tempJacobian.reshape(3, numberOfVariables);
        this.tempObjective.reshape(3, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double timeOfObjective = objective.getTimeOfObjective();
        double omega = objective.getOmega();
        double weight = objective.getWeight();
        int objectiveOrder = objective.getDerivativeOrder();
        int objectiveHigherOrder = objectiveOrder + 1;
        CoMCoefficientJacobianCalculator.calculateDCMJacobian(comStartCol, omega, timeOfObjective, (DMatrix)this.tempJacobian, objectiveOrder, 1.0);
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlaneHelper = objective.getContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(objectiveOrder, timeOfObjective, omega, rhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            ContactPlaneJacobianCalculator.computeLinearJacobian(1.0 / omega, objectiveHigherOrder, timeOfObjective, omega, rhoStartCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            rhoStartCol += contactPlaneHelper.getCoefficientSize();
        }
        objective.getObjective().get((DMatrix)this.tempObjective);
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objectiveOrder, timeOfObjective));
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objectiveHigherOrder, timeOfObjective) / omega);
        if (objective.getSelectionMatrix().getNumberOfSelectedAxes() != 3) {
            objective.getSelectionMatrix().getCompactSelectionMatrixInFrame(ReferenceFrame.getWorldFrame(), 0, 0, this.selectionMatrix);
            this.selectedJacobian.reshape(this.selectionMatrix.getNumRows(), numberOfVariables);
            this.selectedObjective.reshape(this.selectionMatrix.getNumRows(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempJacobian, (DMatrix1Row)this.selectedJacobian);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempObjective, (DMatrix1Row)this.selectedObjective);
            inputToPack.getTaskJacobian().set(this.selectedJacobian);
            inputToPack.getTaskObjective().set(this.selectedObjective);
        } else {
            inputToPack.getTaskJacobian().set(this.tempJacobian);
            inputToPack.getTaskObjective().set(this.tempObjective);
        }
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return true;
    }

    private boolean calculateVRPValueObjectiveInternal(NativeQPInputTypeA inputToPack, MPCValueCommand objective, int numberOfVariables, int comStartIdx, int rhoStartIdx) {
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(3);
        inputToPack.setConstraintType(objective.getConstraintType());
        this.tempJacobian.reshape(3, numberOfVariables);
        this.tempObjective.reshape(3, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double timeOfObjective = objective.getTimeOfObjective();
        double omega = objective.getOmega();
        double weight = objective.getWeight();
        double omega2 = omega * omega;
        CoMCoefficientJacobianCalculator.calculateVRPJacobian(comStartIdx, omega, timeOfObjective, (DMatrix)this.tempJacobian, objective.getDerivativeOrder(), 1.0);
        for (int i = 0; i < objective.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlaneHelper = objective.getContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(objective.getDerivativeOrder(), timeOfObjective, omega, rhoStartIdx, contactPlaneHelper, (DMatrix)this.tempJacobian);
            ContactPlaneJacobianCalculator.computeLinearJacobian(-1.0 / omega2, objective.getDerivativeOrder() + 2, timeOfObjective, omega, rhoStartIdx, contactPlaneHelper, (DMatrix)this.tempJacobian);
            rhoStartIdx += contactPlaneHelper.getCoefficientSize();
        }
        objective.getObjective().get((DMatrix)this.tempObjective);
        this.tempObjective.add(2, 0, -this.getGravityZObjective(objective.getDerivativeOrder(), timeOfObjective));
        this.tempObjective.add(2, 0, this.getGravityZObjective(objective.getDerivativeOrder() + 2, timeOfObjective) / omega2);
        if (objective.getSelectionMatrix().getNumberOfSelectedAxes() != 3) {
            objective.getSelectionMatrix().getCompactSelectionMatrixInFrame(ReferenceFrame.getWorldFrame(), 0, 0, this.selectionMatrix);
            this.selectedJacobian.reshape(this.selectionMatrix.getNumRows(), numberOfVariables);
            this.selectedObjective.reshape(this.selectionMatrix.getNumRows(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempJacobian, (DMatrix1Row)this.selectedJacobian);
            CommonOps_DDRM.mult((DMatrix1Row)this.selectionMatrix, (DMatrix1Row)this.tempObjective, (DMatrix1Row)this.selectedObjective);
            inputToPack.getTaskJacobian().set(this.selectedJacobian);
            inputToPack.getTaskObjective().set(this.selectedObjective);
        } else {
            inputToPack.getTaskJacobian().set(this.tempJacobian);
            inputToPack.getTaskObjective().set(this.tempObjective);
        }
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        return true;
    }

    public int calculateRhoValueCommand(NativeQPInputTypeA inputToPack, RhoObjectiveCommand command) {
        int rhoStartIdx;
        int numberOfVariables = this.indexHandler.getTotalProblemSize();
        if (this.calculateRhoValueCommandInternal(inputToPack, command, numberOfVariables, rhoStartIdx = this.indexHandler.getRhoCoefficientStartIndex(command.getSegmentNumber()))) {
            return 0;
        }
        return -1;
    }

    public int calculateCompactRhoValueCommand(NativeQPInputTypeA inputToPack, RhoObjectiveCommand command) {
        int numberOfVariables = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            numberOfVariables += command.getContactPlaneHelper(i).getCoefficientSize();
        }
        int segmentNumber = command.getSegmentNumber();
        if (this.calculateRhoValueCommandInternal(inputToPack, command, numberOfVariables, 0)) {
            return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    public boolean calculateRhoValueCommandInternal(NativeQPInputTypeA inputToPack, RhoObjectiveCommand command, int numberOfVariables, int rhoStartIdx) {
        int i;
        int problemSize = 0;
        for (int i2 = 0; i2 < command.getNumberOfContacts(); ++i2) {
            problemSize += command.getContactPlaneHelper(i2).getRhoSize();
        }
        if (problemSize < 1) {
            return false;
        }
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(problemSize);
        this.tempJacobian.reshape(problemSize, numberOfVariables);
        this.tempObjective.reshape(problemSize, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double timeOfObjective = command.getTimeOfObjective();
        double omega = command.getOmega();
        int startCol = rhoStartIdx;
        int startRow = 0;
        for (i = 0; i < command.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlaneHelper = command.getContactPlaneHelper(i);
            ContactPlaneJacobianCalculator.computeRhoJacobian(command.getDerivativeOrder(), timeOfObjective, omega, startRow, startCol, contactPlaneHelper, (DMatrix)this.tempJacobian);
            startRow += contactPlaneHelper.getRhoSize();
            startCol += contactPlaneHelper.getCoefficientSize();
        }
        if (command.getUseScalarObjective()) {
            for (i = 0; i < problemSize; ++i) {
                this.tempObjective.set(i, 0, command.getScalarObjective());
            }
        } else {
            this.tempObjective.set((DMatrixD1)command.getObjectiveVector());
        }
        inputToPack.getTaskJacobian().set(this.tempJacobian);
        inputToPack.getTaskObjective().set(this.tempObjective);
        inputToPack.setConstraintType(command.getConstraintType());
        return true;
    }

    public int calculateVRPTrackingObjective(NativeQPInputTypeC inputToPack, VRPTrackingCommand objective) {
        inputToPack.setNumberOfVariables(this.indexHandler.getTotalProblemSize());
        inputToPack.reshape();
        this.tempHessian.reshape(this.indexHandler.getTotalProblemSize(), this.indexHandler.getTotalProblemSize());
        this.tempGradient.reshape(this.indexHandler.getTotalProblemSize(), 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        inputToPack.getDirectCostHessian().zero();
        inputToPack.getDirectCostGradient().zero();
        boolean success = this.vrpTrackingCostCalculator.calculateVRPTrackingObjective((DMatrix)this.tempHessian, (DMatrix)this.tempGradient, objective);
        double weight = objective.getWeight();
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        if (success) {
            return 0;
        }
        return -1;
    }

    public int calculateCompactVRPTrackingObjective(NativeQPInputTypeC inputToPack, VRPTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int numberOfVariables = this.indexHandler.getRhoCoefficientsInSegment(segmentNumber) + 6;
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape();
        this.tempHessian.reshape(numberOfVariables, numberOfVariables);
        this.tempGradient.reshape(numberOfVariables, 1);
        this.tempHessian.zero();
        this.tempGradient.zero();
        boolean success = this.vrpTrackingCostCalculator.calculateCompactVRPTrackingObjective((DMatrix)this.tempHessian, (DMatrix)this.tempGradient, objective);
        double weight = objective.getWeight();
        inputToPack.setUseWeightScalar(true);
        inputToPack.setWeight(weight);
        inputToPack.getDirectCostHessian().set(this.tempHessian);
        inputToPack.getDirectCostGradient().set(this.tempGradient);
        if (success) {
            return this.indexHandler.getComCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    public int calculateRhoBoundCommandCompact(NativeQPInputTypeA inputToPack, RhoBoundCommand command) {
        int numberOfVariables = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            numberOfVariables += command.getContactPlane(i).getCoefficientSize();
        }
        int segmentNumber = command.getSegmentNumber();
        if (this.calculateRhoBoundCommandInternal(inputToPack, command, numberOfVariables, 0)) {
            return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    private boolean calculateRhoBoundCommandInternal(NativeQPInputTypeA inputToPack, RhoBoundCommand command, int numberOfVariables, int rhoStartIdx) {
        int rhoSize = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            rhoSize += command.getContactPlane(i).getRhoSize();
        }
        if (rhoSize < 1) {
            return false;
        }
        int problemSize = 4 * rhoSize;
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(problemSize);
        this.tempJacobian.reshape(problemSize, numberOfVariables);
        this.tempObjective.reshape(problemSize, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double duration = command.getSegmentDuration();
        double omega = command.getOmega();
        double omega2 = omega * omega;
        double exponential = Math.exp(omega * duration);
        double alpha = 1.0 * omega;
        int startCol = rhoStartIdx;
        int startRow = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = command.getContactPlane(i);
            double rhoValue = command.getRhoValue(i);
            for (int rhoIdx = 0; rhoIdx < contactPlane.getRhoSize(); ++rhoIdx) {
                int startCol1 = startCol + 1;
                int startCol2 = startCol + 2;
                int startCol3 = startCol + 3;
                this.tempJacobian.set(startRow, startCol, omega2);
                this.tempJacobian.set(startRow, startCol1, omega2);
                this.tempJacobian.set(startRow, startCol3, 2.0);
                this.tempObjective.set(startRow, 0, rhoValue);
                this.tempJacobian.set(++startRow, startCol, omega2 * (1.0 + omega / alpha));
                this.tempJacobian.set(startRow, startCol1, omega2 * (1.0 - omega / alpha));
                this.tempJacobian.set(startRow, startCol2, 6.0 / alpha);
                this.tempJacobian.set(startRow, startCol3, 2.0);
                this.tempObjective.set(startRow, 0, rhoValue);
                this.tempJacobian.set(++startRow, startCol, omega2 * exponential * (1.0 - omega / alpha));
                this.tempJacobian.set(startRow, startCol1, omega2 / exponential * (1.0 + omega / alpha));
                this.tempJacobian.set(startRow, startCol2, 6.0 * (duration - 1.0 / alpha));
                this.tempJacobian.set(startRow, startCol3, 2.0);
                this.tempObjective.set(startRow, 0, rhoValue);
                this.tempJacobian.set(++startRow, startCol, omega2 * exponential);
                this.tempJacobian.set(startRow, startCol1, omega2 / exponential);
                this.tempJacobian.set(startRow, startCol2, 6.0 * duration);
                this.tempJacobian.set(startRow, startCol3, 2.0);
                this.tempObjective.set(startRow, 0, rhoValue);
                ++startRow;
                startCol += 4;
            }
        }
        inputToPack.getTaskJacobian().set(this.tempJacobian);
        inputToPack.getTaskObjective().set(this.tempObjective);
        inputToPack.setConstraintType(command.getConstraintType());
        return true;
    }

    public int calculateNormalForceBoundCommandCompact(NativeQPInputTypeA inputToPack, NormalForceBoundCommand command) {
        int numberOfVariables = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            numberOfVariables += command.getContactPlane(i).getCoefficientSize();
        }
        int segmentNumber = command.getSegmentNumber();
        if (this.calculateNormalForceBoundCommandInternal(inputToPack, command, numberOfVariables, 0)) {
            return this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        }
        return -1;
    }

    public boolean calculateNormalForceBoundCommandInternal(NativeQPInputTypeA inputToPack, NormalForceBoundCommand command, int numberOfVariables, int rhoStartIdx) {
        int rhoSize = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            rhoSize += command.getContactPlane(i).getRhoSize();
        }
        if (rhoSize < 1) {
            return false;
        }
        inputToPack.setNumberOfVariables(numberOfVariables);
        inputToPack.reshape(4 * rhoSize);
        this.tempJacobian.reshape(4 * rhoSize, numberOfVariables);
        this.tempObjective.reshape(4 * rhoSize, 1);
        this.tempJacobian.zero();
        this.tempObjective.zero();
        double duration = command.getSegmentDuration();
        double omega = command.getOmega();
        double omega2 = omega * omega;
        double exponential = Math.exp(omega * duration);
        int startCol = rhoStartIdx;
        int startRow = 0;
        for (int i = 0; i < command.getNumberOfContacts(); ++i) {
            MPCContactPlane contactPlane = command.getContactPlane(i);
            double normalForceLimit = command.getRhoValue(i);
            int row1 = startRow + 1;
            int row2 = startRow + 2;
            int row3 = startRow + 3;
            for (int pointIdx = 0; pointIdx < contactPlane.getNumberOfContactPoints(); ++pointIdx) {
                MPCContactPoint point = contactPlane.getContactPointHelper(pointIdx);
                for (int rhoIdx = 0; rhoIdx < point.getRhoSize(); ++rhoIdx) {
                    double rhoZ = point.getRhoNormalZ();
                    this.tempJacobian.set(startRow, startCol, rhoZ * omega2);
                    this.tempJacobian.set(startRow, startCol + 1, rhoZ * omega2);
                    this.tempJacobian.set(startRow, startCol + 3, rhoZ * 2.0);
                    this.tempJacobian.set(row1, startCol, 2.0 * rhoZ * omega2);
                    this.tempJacobian.set(row1, startCol + 2, 6.0 / rhoZ * omega);
                    this.tempJacobian.set(row1, startCol + 3, rhoZ * 2.0);
                    this.tempJacobian.set(row2, startCol + 1, rhoZ * omega2 / exponential * 2.0);
                    this.tempJacobian.set(row2, startCol + 2, 6.0 * rhoZ * (duration - 1.0 / omega));
                    this.tempJacobian.set(row2, startCol + 3, 2.0 * rhoZ);
                    this.tempJacobian.set(row3, startCol, rhoZ * omega2 * exponential);
                    this.tempJacobian.set(row3, startCol + 1, rhoZ * omega2 / exponential);
                    this.tempJacobian.set(row3, startCol + 2, 6.0 * rhoZ * duration);
                    this.tempJacobian.set(row3, startCol + 3, 2.0 * rhoZ);
                    startCol += 4;
                }
            }
            this.tempObjective.set(startRow, 0, normalForceLimit);
            this.tempObjective.set(row1, 0, normalForceLimit);
            this.tempObjective.set(row2, 0, normalForceLimit);
            this.tempObjective.set(row3, 0, normalForceLimit);
            startRow += 4;
        }
        inputToPack.getTaskJacobian().set(this.tempJacobian);
        inputToPack.getTaskObjective().set(this.tempObjective);
        inputToPack.setConstraintType(command.getConstraintType());
        return true;
    }

    private double getGravityZObjective(int derivativeOrder, double time) {
        switch (derivativeOrder) {
            case 0: {
                return 0.5 * time * time * this.gravityZ;
            }
            case 1: {
                return time * this.gravityZ;
            }
            case 2: {
                return this.gravityZ;
            }
            case 3: {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Derivative order must be less than 4.");
    }
}

