/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;

public class LinearMPCIndexHandler {
    public static final int coefficientsPerRho = 4;
    public static final int comCoefficientsPerSegment = 6;
    protected int totalProblemSize = 0;
    protected final int numberOfBasisVectorsPerContactPoint;
    protected final TIntArrayList comStartIndices = new TIntArrayList();
    protected final TIntArrayList rhoStartIndices = new TIntArrayList();
    protected final TIntArrayList rhoCoefficientsInSegment = new TIntArrayList();
    protected final TIntArrayList variablesInSegment = new TIntArrayList();
    protected final ListToSizeReturn listToSizeReturn = new ListToSizeReturn();

    public LinearMPCIndexHandler(int numberOfBasisVectorsPerContactPoint) {
        this.numberOfBasisVectorsPerContactPoint = numberOfBasisVectorsPerContactPoint;
    }

    public void initialize(List<ContactPlaneProvider> contactSequence) {
        this.listToSizeReturn.setContacts(contactSequence);
        this.initialize(this.listToSizeReturn, contactSequence.size());
    }

    public void initialize(IntUnaryOperator pointsInContact, int numberOfContacts) {
        this.rhoStartIndices.clear();
        this.comStartIndices.clear();
        this.rhoCoefficientsInSegment.clear();
        this.variablesInSegment.clear();
        this.totalProblemSize = 0;
        for (int i = 0; i < numberOfContacts; ++i) {
            this.comStartIndices.add(this.totalProblemSize);
            this.totalProblemSize += 6;
            int rhoCoefficients = 4 * this.numberOfBasisVectorsPerContactPoint * pointsInContact.applyAsInt(i);
            this.rhoCoefficientsInSegment.add(rhoCoefficients);
            this.variablesInSegment.add(6 + rhoCoefficients);
            this.rhoStartIndices.add(this.totalProblemSize);
            this.totalProblemSize += rhoCoefficients;
        }
    }

    public int getComCoefficientStartIndex(int segmentId) {
        return this.comStartIndices.get(segmentId);
    }

    public int getComCoefficientStartIndex(int segmentId, int axisOrdinal) {
        return this.getComCoefficientStartIndex(segmentId) + 2 * axisOrdinal;
    }

    public int getNumberOfSegments() {
        return this.comStartIndices.size();
    }

    public int getRhoCoefficientsInSegment(int segmentId) {
        return this.rhoCoefficientsInSegment.get(segmentId);
    }

    public int getVariablesInSegment(int segmentId) {
        return this.variablesInSegment.get(segmentId);
    }

    public int getRhoCoefficientStartIndex(int segmentId) {
        return this.rhoStartIndices.get(segmentId);
    }

    public int getTotalProblemSize() {
        return this.totalProblemSize;
    }

    protected static class ListToSizeReturn
    implements IntUnaryOperator {
        private List<ContactPlaneProvider> contacts;

        protected ListToSizeReturn() {
        }

        public void setContacts(List<ContactPlaneProvider> contacts) {
            this.contacts = contacts;
        }

        @Override
        public int applyAsInt(int operand) {
            return this.contacts.get(operand).getTotalNumberOfPointsInContact();
        }
    }
}

