/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;

public class VRPTrackingCommand
implements MPCCommand<VRPTrackingCommand> {
    private int commandId;
    private final List<MPCContactPlane> contactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private int segmentNumber;
    private double segmentDuration;
    private double omega;
    private double weight = 100.0;
    private final FramePoint3D startVRP = new FramePoint3D();
    private final FramePoint3D endVRP = new FramePoint3D();
    private final FrameVector3D startVRPVelocity = new FrameVector3D();
    private final FrameVector3D endVRPVelocity = new FrameVector3D();
    private DoubleConsumer costToGoConsumer;

    public VRPTrackingCommand() {
        this.startVRPVelocity.setToNaN();
        this.endVRPVelocity.setToNaN();
    }

    public void clear() {
        this.costToGoConsumer = null;
        this.contactPlaneHelpers.clear();
        this.segmentDuration = Double.NaN;
        this.segmentNumber = -1;
        this.startVRP.setToNaN();
        this.endVRP.setToNaN();
        this.startVRPVelocity.setToNaN();
        this.endVRPVelocity.setToNaN();
    }

    public void setStartVRP(FramePoint3DReadOnly startVRP) {
        this.startVRP.set((FrameTuple3DReadOnly)startVRP);
    }

    public void setEndVRP(FramePoint3DReadOnly endVRP) {
        this.endVRP.set((FrameTuple3DReadOnly)endVRP);
    }

    public void setStartVRPVelocity(FrameVector3DReadOnly startVRPVelocity) {
        this.startVRPVelocity.set((FrameTuple3DReadOnly)startVRPVelocity);
    }

    public void setEndVRPVelocity(FrameVector3DReadOnly endVRPVelocity) {
        this.endVRPVelocity.set((FrameTuple3DReadOnly)endVRPVelocity);
    }

    public FramePoint3DReadOnly getStartVRP() {
        return this.startVRP;
    }

    public FramePoint3DReadOnly getEndVRP() {
        return this.endVRP;
    }

    public FrameVector3DReadOnly getStartVRPVelocity() {
        return this.startVRPVelocity;
    }

    public FrameVector3DReadOnly getEndVRPVelocity() {
        return this.endVRPVelocity;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void addContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.contactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setSegmentDuration(double segmentDuration) {
        this.segmentDuration = segmentDuration;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getSegmentDuration() {
        return this.segmentDuration;
    }

    public double getOmega() {
        return this.omega;
    }

    public int getNumberOfContacts() {
        return this.contactPlaneHelpers.size();
    }

    public MPCContactPlane getContactPlaneHelper(int i) {
        return this.contactPlaneHelpers.get(i);
    }

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.VRP_TRACKING;
    }

    public void setCostToGoConsumer(DoubleConsumer costToGoConsumer) {
        this.costToGoConsumer = costToGoConsumer;
    }

    public DoubleConsumer getCostToGoConsumer() {
        return this.costToGoConsumer;
    }

    public void setCostToGo(double costToGo) {
        if (this.costToGoConsumer != null) {
            this.costToGoConsumer.accept(costToGo);
        }
    }

    public void set(VRPTrackingCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setSegmentDuration(other.getSegmentDuration());
        this.setOmega(other.getOmega());
        this.setWeight(other.getWeight());
        this.setStartVRP(other.getStartVRP());
        this.setEndVRP(other.getEndVRP());
        this.setCostToGoConsumer(other.getCostToGoConsumer());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlaneHelper(other.getContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof VRPTrackingCommand) {
            VRPTrackingCommand other = (VRPTrackingCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.segmentDuration != other.segmentDuration) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.weight != other.weight) {
                return false;
            }
            if (!this.startVRP.equals((FrameTuple3DReadOnly)other.startVRP)) {
                return false;
            }
            if (!this.endVRP.equals((FrameTuple3DReadOnly)other.endVRP)) {
                return false;
            }
            if (this.contactPlaneHelpers.size() != other.contactPlaneHelpers.size()) {
                return false;
            }
            for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
                if (this.contactPlaneHelpers.get(i).equals(other.contactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": segment number: " + this.segmentNumber + ", segment duration: " + this.segmentDuration + ", omega: " + this.omega + ", weight: " + this.weight + ", start vrp: " + this.startVRP + ", end vrp: " + this.endVRP + ".";
        for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
            string = string + "\ncontact " + i + ": " + this.contactPlaneHelpers.get(i);
        }
        return string;
    }
}

