/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;

public abstract class RhoObjectiveCommand
implements MPCCommand<RhoObjectiveCommand> {
    private int commandId;
    private final List<MPCContactPlane> contactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private int segmentNumber;
    private double timeOfObjective;
    private double omega;
    private ConstraintType constraintType;
    private double objective = Double.NaN;
    private final DMatrixRMaj objectiveVector = new DMatrixRMaj(0, 0);
    private boolean useScalarObjective = true;

    public void clear() {
        this.contactPlaneHelpers.clear();
        this.objective = 0.0;
        this.objectiveVector.reshape(0, 0);
        this.segmentNumber = -1;
        this.timeOfObjective = Double.NaN;
    }

    public abstract int getDerivativeOrder();

    public void addContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.contactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setTimeOfObjective(double timeOfObjective) {
        this.timeOfObjective = timeOfObjective;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void setScalarObjective(double objective) {
        this.objective = objective;
    }

    public void setObjectiveVector(DMatrix objective) {
        this.objectiveVector.set((Matrix)objective);
    }

    public void setUseScalarObjective(boolean useScalarObjective) {
        this.useScalarObjective = useScalarObjective;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getTimeOfObjective() {
        return this.timeOfObjective;
    }

    public double getOmega() {
        return this.omega;
    }

    public boolean getUseScalarObjective() {
        return this.useScalarObjective;
    }

    public double getScalarObjective() {
        return this.objective;
    }

    public DMatrixRMaj getObjectiveVector() {
        return this.objectiveVector;
    }

    public MPCContactPlane getContactPlaneHelper(int i) {
        return this.contactPlaneHelpers.get(i);
    }

    public int getNumberOfContacts() {
        return this.contactPlaneHelpers.size();
    }

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.RHO_VALUE;
    }

    public void set(RhoObjectiveCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setTimeOfObjective(other.getTimeOfObjective());
        this.setOmega(other.getOmega());
        this.setConstraintType(other.getConstraintType());
        this.setObjectiveVector((DMatrix)other.getObjectiveVector());
        this.setUseScalarObjective(other.getUseScalarObjective());
        this.setScalarObjective(other.getScalarObjective());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlaneHelper(other.getContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RhoObjectiveCommand) {
            RhoObjectiveCommand other = (RhoObjectiveCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.timeOfObjective != other.timeOfObjective) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.useScalarObjective != other.useScalarObjective) {
                return false;
            }
            if (this.useScalarObjective ? this.objective != other.objective : this.objectiveVector != other.objectiveVector) {
                return false;
            }
            if (this.contactPlaneHelpers.size() != other.contactPlaneHelpers.size()) {
                return false;
            }
            for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
                if (this.contactPlaneHelpers.get(i).equals(other.contactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": segment number: " + this.segmentNumber + ", time of objective: " + this.timeOfObjective + ", omega: " + this.omega + ", constraint type: " + (Object)((Object)this.constraintType);
        string = this.useScalarObjective ? string + "objective value: " + this.objective : string + "objective vector: " + this.objectiveVector + ".";
        for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
            string = string + "\ncontact " + i + ": " + this.contactPlaneHelpers.get(i);
        }
        return string;
    }
}

