/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCValueType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;

public abstract class MPCContinuityCommand
implements MPCCommand<MPCContinuityCommand> {
    private int commandId;
    private final List<MPCContactPlane> firstSegmentContactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private final List<MPCContactPlane> secondSegmentContactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private int firstSegmentNumber;
    private double firstSegmentDuration;
    private double omega;
    private double weight;
    private ConstraintType constraintType = ConstraintType.EQUALITY;

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.CONTINUITY;
    }

    public void setConstraintType(ConstraintType constraintType) {
        if (constraintType == ConstraintType.GEQ_INEQUALITY || constraintType == ConstraintType.LEQ_INEQUALITY) {
            throw new IllegalArgumentException("Continuity constraints cannot be inequalities.");
        }
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public abstract int getDerivativeOrder();

    public abstract MPCValueType getValueType();

    public void clear() {
        this.firstSegmentContactPlaneHelpers.clear();
        this.secondSegmentContactPlaneHelpers.clear();
        this.firstSegmentDuration = Double.NaN;
        this.firstSegmentNumber = -1;
    }

    public void addFirstSegmentContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.firstSegmentContactPlaneHelpers.add(contactPlaneHelper);
    }

    public void addSecondSegmentContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.secondSegmentContactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setFirstSegmentNumber(int firstSegmentNumber) {
        this.firstSegmentNumber = firstSegmentNumber;
    }

    public void setFirstSegmentDuration(double firstSegmentDuration) {
        this.firstSegmentDuration = firstSegmentDuration;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public int getFirstSegmentNumber() {
        return this.firstSegmentNumber;
    }

    public double getFirstSegmentDuration() {
        return this.firstSegmentDuration;
    }

    public double getOmega() {
        return this.omega;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getFirstSegmentNumberOfContacts() {
        return this.firstSegmentContactPlaneHelpers.size();
    }

    public MPCContactPlane getFirstSegmentContactPlaneHelper(int i) {
        return this.firstSegmentContactPlaneHelpers.get(i);
    }

    public int getSecondSegmentNumberOfContacts() {
        return this.secondSegmentContactPlaneHelpers.size();
    }

    public MPCContactPlane getSecondSegmentContactPlaneHelper(int i) {
        return this.secondSegmentContactPlaneHelpers.get(i);
    }

    public void set(MPCContinuityCommand other) {
        int i;
        if (this.getValueType() != other.getValueType()) {
            throw new IllegalArgumentException("Cannot set a command of type " + (Object)((Object)this.getValueType()) + " from a command of type " + (Object)((Object)other.getValueType()));
        }
        if (this.getDerivativeOrder() != other.getDerivativeOrder()) {
            throw new IllegalArgumentException("Cannot set a command of derivative order " + this.getDerivativeOrder() + " from a command of derivative order " + other.getDerivativeOrder());
        }
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setFirstSegmentNumber(other.getFirstSegmentNumber());
        this.setFirstSegmentDuration(other.getFirstSegmentDuration());
        this.setOmega(other.getOmega());
        this.setWeight(other.getWeight());
        this.setConstraintType(other.getConstraintType());
        for (i = 0; i < other.getFirstSegmentNumberOfContacts(); ++i) {
            this.addFirstSegmentContactPlaneHelper(other.getFirstSegmentContactPlaneHelper(i));
        }
        for (i = 0; i < other.getSecondSegmentNumberOfContacts(); ++i) {
            this.addSecondSegmentContactPlaneHelper(other.getSecondSegmentContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MPCContinuityCommand) {
            int i;
            MPCContinuityCommand other = (MPCContinuityCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (this.getValueType() != other.getValueType()) {
                return false;
            }
            if (this.getDerivativeOrder() != other.getDerivativeOrder()) {
                return false;
            }
            if (this.firstSegmentNumber != other.firstSegmentNumber) {
                return false;
            }
            if (this.firstSegmentDuration != other.firstSegmentDuration) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.weight != other.weight) {
                return false;
            }
            if (this.firstSegmentContactPlaneHelpers.size() != other.firstSegmentContactPlaneHelpers.size()) {
                return false;
            }
            for (i = 0; i < this.firstSegmentContactPlaneHelpers.size(); ++i) {
                if (this.firstSegmentContactPlaneHelpers.get(i).equals(other.firstSegmentContactPlaneHelpers.get(i))) continue;
                return false;
            }
            if (this.secondSegmentContactPlaneHelpers.size() != other.secondSegmentContactPlaneHelpers.size()) {
                return false;
            }
            for (i = 0; i < this.secondSegmentContactPlaneHelpers.size(); ++i) {
                if (this.secondSegmentContactPlaneHelpers.get(i).equals(other.secondSegmentContactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int i;
        String string = this.getClass().getSimpleName() + ": value: " + (Object)((Object)this.getValueType()) + ", derivative order: " + this.getDerivativeOrder() + ", first segment number: " + this.firstSegmentNumber + ", constraint type: " + (Object)((Object)this.constraintType) + ", first segment duration: " + this.firstSegmentDuration + ", omega: " + this.omega + ", weight: " + this.weight + ".";
        for (i = 0; i < this.firstSegmentContactPlaneHelpers.size(); ++i) {
            string = string + "\nfirst segment contact " + i + ": " + this.firstSegmentContactPlaneHelpers.get(i);
        }
        for (i = 0; i < this.secondSegmentContactPlaneHelpers.size(); ++i) {
            string = string + "\nsecond segment contact " + i + ": " + this.secondSegmentContactPlaneHelpers.get(i);
        }
        return string;
    }
}

