/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProviderTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.MultipleCoMSegmentTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ActiveSetData;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.MPCParameters;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.CoMPositionCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.CoMVelocityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.CommandProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.DCMPositionCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.ForceTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandList;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCContinuityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.NormalForceBoundCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoBoundCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoRateTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.RhoTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.VRPPositionCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.VRPTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCQPSolver;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.LinearMPCTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.PreviewWindowCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.WrenchMPCTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.ContactPlaneForceViewer;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.LinearMPCTrajectoryViewer;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.MPCCornerPointViewer;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class EuclideanModelPredictiveController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean useSlackVariablesForRhoBounds = true;
    private static final double firstSegmentSlackWeight = 1.0E7;
    protected static final int numberOfBasisVectorsPerContactPoint = 4;
    private final double maxContactForce;
    protected final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DMatrixRMaj solutionCoefficients = new DMatrixRMaj(0, 0);
    private final double mass;
    protected final DoubleProvider omega;
    protected final YoDouble comHeight = new YoDouble("comHeightForPlanning", this.registry);
    private final double gravityZ;
    private static final double mu = 0.8;
    private final FixedFramePoint3DBasics desiredCoMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMVelocity = new FrameVector3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMAcceleration = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredDCMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredDCMVelocity = new FrameVector3D(worldFrame);
    protected final FixedFramePoint3DBasics desiredVRPPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredVRPVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredECMPPosition = new FramePoint3D(worldFrame);
    private final RecyclingArrayList<FramePoint3D> startVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FrameVector3D> startVRPVelocities = new RecyclingArrayList(FrameVector3D::new);
    private final RecyclingArrayList<FramePoint3D> endVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FrameVector3D> endVRPVelocities = new RecyclingArrayList(FrameVector3D::new);
    protected final YoFramePoint3D currentCoMPosition = new YoFramePoint3D("currentCoMPosition", worldFrame, this.registry);
    protected final YoFrameVector3D currentCoMVelocity = new YoFrameVector3D("currentCoMVelocity", worldFrame, this.registry);
    protected final YoDouble currentTimeInState = new YoDouble("currentTimeInState", this.registry);
    private final YoFramePoint3D comPositionAtEndOfWindow = new YoFramePoint3D("comPositionAtEndOfWindow", worldFrame, this.registry);
    private final YoFrameVector3D comVelocityAtEndOfWindow = new YoFrameVector3D("comVelocityAtEndOfWindow", worldFrame, this.registry);
    private final YoFramePoint3D dcmAtEndOfWindow = new YoFramePoint3D("dcmAtEndOfWindow", worldFrame, this.registry);
    private final YoFramePoint3D vrpAtEndOfWindow = new YoFramePoint3D("vrpAtEndOfWindow", worldFrame, this.registry);
    protected final MPCParameters mpcParameters;
    protected final MPCContactHandler contactHandler;
    protected final PreviewWindowCalculator previewWindowCalculator;
    final LinearMPCTrajectoryHandler linearTrajectoryHandler;
    protected final WrenchMPCTrajectoryHandler wrenchTrajectoryHandler;
    private final LinearMPCIndexHandler indexHandler;
    protected final CommandProvider commandProvider = new CommandProvider();
    final MPCCommandList mpcCommands = new MPCCommandList();
    private final ExecutionTimer mpcTotalTime = new ExecutionTimer("mpcTotalTime", this.registry);
    private final ExecutionTimer mpcAssemblyTime = new ExecutionTimer("mpcAssemblyTime", this.registry);
    private final ExecutionTimer mpcQPTime = new ExecutionTimer("mpcQPTime", this.registry);
    private final ExecutionTimer mpcExtractionTime = new ExecutionTimer("mpcExtractionTime", this.registry);
    protected final YoBoolean useWarmStart = new YoBoolean("mpcUseWarmStart", this.registry);
    protected final DMatrixRMaj previousSolution = new DMatrixRMaj(1, 1);
    protected final TIntArrayList activeInequalityConstraints = new TIntArrayList();
    private MPCCornerPointViewer cornerPointViewer = null;
    private LinearMPCTrajectoryViewer trajectoryViewer = null;
    private final FrameVector3DReadOnly zeroVector = new FrameVector3D();

    public EuclideanModelPredictiveController(LinearMPCIndexHandler indexHandler, MPCParameters mpcParameters, double mass, double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry) {
        this.mpcParameters = mpcParameters;
        this.gravityZ = Math.abs(gravityZ);
        YoDouble omega = new YoDouble("omegaForPlanning", this.registry);
        this.mass = mass;
        this.omega = omega;
        this.indexHandler = indexHandler;
        this.maxContactForce = 2.0 * Math.abs(gravityZ);
        this.previewWindowCalculator = new PreviewWindowCalculator(this.registry);
        this.linearTrajectoryHandler = new LinearMPCTrajectoryHandler(indexHandler, gravityZ, nominalCoMHeight, this.registry);
        this.wrenchTrajectoryHandler = new WrenchMPCTrajectoryHandler(this.registry);
        this.contactHandler = new MPCContactHandler(indexHandler, gravityZ, mass);
        this.comHeight.addListener(v -> omega.set(Math.sqrt(Math.abs(gravityZ) / this.comHeight.getDoubleValue())));
        this.comHeight.set(nominalCoMHeight);
        this.useWarmStart.set(true);
        parentRegistry.addChild(this.registry);
    }

    public void setCornerPointViewer(MPCCornerPointViewer viewer) {
        this.cornerPointViewer = viewer;
    }

    public void setupCoMTrajectoryViewer(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.trajectoryViewer = new LinearMPCTrajectoryViewer(this.registry, yoGraphicsListRegistry);
    }

    public void setContactPlaneViewers(Supplier<ContactPlaneForceViewer> viewerSupplier) {
        this.contactHandler.setContactPlaneViewers(viewerSupplier);
    }

    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.comHeight.set(nominalCoMHeight);
        this.linearTrajectoryHandler.setNominalCoMHeight(nominalCoMHeight);
    }

    public double getNominalCoMHeight() {
        return this.comHeight.getDoubleValue();
    }

    public void solveForTrajectory(List<ContactPlaneProvider> contactSequence) {
        if (!ContactStateProviderTools.checkContactSequenceIsValid(contactSequence)) {
            throw new IllegalArgumentException("The contact sequence is not valid.");
        }
        this.mpcTotalTime.startMeasurement();
        this.mpcAssemblyTime.startMeasurement();
        this.previewWindowCalculator.compute(contactSequence, this.currentTimeInState.getDoubleValue());
        List<ContactPlaneProvider> planningWindow = this.previewWindowCalculator.getPlanningWindow();
        this.initializeIndexHandler();
        this.solveForTrajectoryOutsidePreviewWindow(contactSequence);
        this.setTerminalConditions();
        if (this.previewWindowCalculator.activeSegmentChanged()) {
            this.resetActiveSet();
        }
        CoMTrajectoryPlannerTools.computeVRPWaypoints(this.comHeight.getDoubleValue(), this.gravityZ, this.omega.getValue(), (FrameVector3DReadOnly)this.currentCoMVelocity, planningWindow, this.startVRPPositions, this.endVRPPositions, false);
        CoMTrajectoryPlannerTools.computeVRPVelocites(planningWindow, this.startVRPVelocities, this.endVRPVelocities);
        this.commandProvider.reset();
        this.mpcCommands.clear();
        this.contactHandler.computeMatrixHelpers(planningWindow, this.linearTrajectoryHandler.getPlanningWindowForSolution(), this.omega.getValue());
        this.computeObjectives(planningWindow);
        this.mpcAssemblyTime.stopMeasurement();
        this.mpcQPTime.startMeasurement();
        NativeMatrix solutionCoefficients = this.solveQP();
        this.mpcQPTime.stopMeasurement();
        this.mpcExtractionTime.startMeasurement();
        if (solutionCoefficients != null) {
            this.solutionCoefficients.reshape(this.indexHandler.getTotalProblemSize(), 1);
            solutionCoefficients.get(this.solutionCoefficients);
            this.extractSolution(this.solutionCoefficients);
        }
        if (this.cornerPointViewer != null) {
            this.cornerPointViewer.updateCornerPoints(this.linearTrajectoryHandler, this.previewWindowCalculator.getFullPlanningSequence());
        }
        this.updateCoMTrajectoryViewer();
        this.mpcExtractionTime.stopMeasurement();
        this.mpcTotalTime.stopMeasurement();
    }

    protected void assembleActiveSet(IntUnaryOperator startIndexGetter) {
        this.activeInequalityConstraints.reset();
        this.previousSolution.reshape(this.indexHandler.getTotalProblemSize(), 1);
        int inequalityStartIndex = 0;
        boolean lowerBoundStartIndex = false;
        boolean upperBoundStartIndex = false;
        for (int segmentId = 0; segmentId < this.indexHandler.getNumberOfSegments(); ++segmentId) {
            ActiveSetData activeSetData = this.contactHandler.getActiveSetData(segmentId);
            MatrixTools.setMatrixBlock((DMatrix)this.previousSolution, (int)startIndexGetter.applyAsInt(segmentId), (int)0, (DMatrix)activeSetData.getPreviousSolution(), (int)0, (int)0, (int)this.indexHandler.getVariablesInSegment(segmentId), (int)1, (double)1.0);
            for (int i = 0; i < activeSetData.getNumberOfActiveInequalityConstraints(); ++i) {
                this.activeInequalityConstraints.add(activeSetData.getActiveInequalityIndex(i) + inequalityStartIndex);
            }
            inequalityStartIndex += activeSetData.getNumberOfInequalityConstraints();
        }
    }

    protected void extractNewActiveSetData(boolean foundSolution, LinearMPCQPSolver qpSolver, IntUnaryOperator startIndexGetter) {
        TIntList activeInequalityIndices = qpSolver.getActiveInequalityIndices();
        int inequalityStartIndex = 0;
        int currentInequalityIndex = 0;
        for (int segmentId = 0; segmentId < this.indexHandler.getNumberOfSegments(); ++segmentId) {
            ActiveSetData activeSetData = this.contactHandler.getActiveSetData(segmentId);
            activeSetData.clearActiveSet();
            if (foundSolution) {
                MatrixTools.setMatrixBlock((DMatrix)activeSetData.getPreviousSolution(), (int)0, (int)0, (DMatrix)qpSolver.getSolution(), (int)startIndexGetter.applyAsInt(segmentId), (int)0, (int)this.indexHandler.getVariablesInSegment(segmentId), (int)1, (double)1.0);
            }
            int inequalityEndIndex = inequalityStartIndex + activeSetData.getNumberOfInequalityConstraints();
            while (currentInequalityIndex < activeInequalityIndices.size() && activeInequalityIndices.get(currentInequalityIndex) < inequalityEndIndex) {
                activeSetData.addActiveInequalityConstraint(activeInequalityIndices.get(currentInequalityIndex) - inequalityStartIndex);
                ++currentInequalityIndex;
            }
            inequalityStartIndex = inequalityEndIndex;
        }
    }

    protected abstract void initializeIndexHandler();

    protected void solveForTrajectoryOutsidePreviewWindow(List<ContactPlaneProvider> contactSequence) {
        List<ContactPlaneProvider> planningWindow = this.previewWindowCalculator.getPlanningWindow();
        this.linearTrajectoryHandler.solveForTrajectoryOutsidePreviewWindow(contactSequence);
        this.linearTrajectoryHandler.computeOutsidePreview(planningWindow.get(planningWindow.size() - 1).getTimeInterval().getEndTime());
    }

    protected void setTerminalConditions() {
        this.comPositionAtEndOfWindow.set((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMPositionOutsidePreview());
        this.comVelocityAtEndOfWindow.set((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMVelocityOutsidePreview());
        this.dcmAtEndOfWindow.set((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredDCMPositionOutsidePreview());
        this.vrpAtEndOfWindow.set((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredVRPPositionOutsidePreview());
    }

    protected void extractSolution(DMatrixRMaj solutionCoefficients) {
        List<ContactPlaneProvider> planningWindow = this.previewWindowCalculator.getPlanningWindow();
        this.linearTrajectoryHandler.extractSolutionForPreviewWindow(solutionCoefficients, planningWindow, this.contactHandler.getContactPlanes(), this.previewWindowCalculator.getFullPlanningSequence(), this.omega.getValue());
        this.wrenchTrajectoryHandler.extractSolutionForPreviewWindow(planningWindow, this.contactHandler.getContactPlanes(), this.mass, this.omega.getValue());
    }

    protected void computeObjectives(List<ContactPlaneProvider> contactSequence) {
        int numberOfPhases = contactSequence.size();
        int numberOfTransitions = numberOfPhases - 1;
        for (int i = 0; i < numberOfPhases; ++i) {
            this.contactHandler.getActiveSetData(i).resetConstraintCounter();
        }
        this.mpcCommands.addCommand(this.computeInitialCoMPositionObjective(this.commandProvider.getNextCoMPositionCommand()));
        if (this.mpcParameters.includeVelocityObjective()) {
            this.mpcCommands.addCommand(this.computeInitialCoMVelocityObjective(this.commandProvider.getNextCoMVelocityCommand()));
        }
        double initialDuration = contactSequence.get(0).getTimeInterval().getDuration();
        if (contactSequence.get(0).getContactState().isLoadBearing()) {
            this.mpcCommands.addCommand(this.computeVRPTrackingObjective(this.commandProvider.getNextVRPTrackingCommand(), (FramePoint3DReadOnly)this.startVRPPositions.get(0), (FrameVector3DReadOnly)this.startVRPVelocities.get(0), (FramePoint3DReadOnly)this.endVRPPositions.get(0), (FrameVector3DReadOnly)this.endVRPVelocities.get(0), 0, initialDuration, null));
            if (this.mpcParameters.includeForceMinimization()) {
                for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(0); ++i) {
                    this.mpcCommands.addCommand(this.computeForceMinimizationObjective(this.commandProvider.getForceTrackingCommand(), 0, initialDuration, i));
                }
            }
            if (this.mpcParameters.includeRhoMinimization()) {
                this.mpcCommands.addCommand(this.computeRhoMinimizationObjective(this.commandProvider.getRhoMinimizationCommand(), 0, initialDuration));
            }
            if (this.mpcParameters.includeRhoRateMinimization()) {
                this.mpcCommands.addCommand(this.computeRhoRateMinimizationObjective(this.commandProvider.getRhoRateMinimizationCommand(), 0, initialDuration));
            }
            if (this.mpcParameters.includeRhoMinInequality()) {
                this.mpcCommands.addCommand(this.computeMinForceObjective(this.commandProvider.getNextRhoBoundCommand(), 0, initialDuration));
            }
            if (this.mpcParameters.includeRhoMaxInequality()) {
                this.mpcCommands.addCommand(this.computeMaxForceObjective(this.commandProvider.getNextNormalForceBoundCommand(), 0, initialDuration));
            }
        }
        for (int transition = 0; transition < numberOfTransitions; ++transition) {
            int nextSequence = transition + 1;
            double firstSegmentDuration = contactSequence.get(transition).getTimeInterval().getDuration();
            this.mpcCommands.addCommand(this.computeContinuityObjective(this.commandProvider.getNextComPositionContinuityCommand(), transition, firstSegmentDuration));
            this.mpcCommands.addCommand(this.computeContinuityObjective(this.commandProvider.getNextComVelocityContinuityCommand(), transition, firstSegmentDuration));
            if (contactSequence.get(transition).getContactState().isLoadBearing() && contactSequence.get(nextSequence).getContactState().isLoadBearing()) {
                this.mpcCommands.addCommand(this.computeContinuityObjective(this.commandProvider.getNextVRPPositionContinuityCommand(), transition, firstSegmentDuration));
            }
            if (contactSequence.get(transition).getContactState().isLoadBearing()) {
                // empty if block
            }
            double nextDuration = Math.min(contactSequence.get(nextSequence).getTimeInterval().getDuration(), 5.0);
            if (!contactSequence.get(nextSequence).getContactState().isLoadBearing()) continue;
            this.mpcCommands.addCommand(this.computeVRPTrackingObjective(this.commandProvider.getNextVRPTrackingCommand(), (FramePoint3DReadOnly)this.startVRPPositions.get(nextSequence), (FrameVector3DReadOnly)this.startVRPVelocities.get(nextSequence), (FramePoint3DReadOnly)this.endVRPPositions.get(nextSequence), (FrameVector3DReadOnly)this.endVRPVelocities.get(nextSequence), nextSequence, nextDuration, null));
            if (this.mpcParameters.includeForceMinimization()) {
                for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(nextSequence); ++i) {
                    this.mpcCommands.addCommand(this.computeForceMinimizationObjective(this.commandProvider.getForceTrackingCommand(), nextSequence, nextDuration, i));
                }
            }
            if (this.mpcParameters.includeRhoMinimization()) {
                this.mpcCommands.addCommand(this.computeRhoMinimizationObjective(this.commandProvider.getRhoMinimizationCommand(), nextSequence, nextDuration));
            }
            if (this.mpcParameters.includeRhoRateMinimization()) {
                this.mpcCommands.addCommand(this.computeRhoRateMinimizationObjective(this.commandProvider.getRhoRateMinimizationCommand(), nextSequence, nextDuration));
            }
            if (this.mpcParameters.includeRhoMinInequality()) {
                this.mpcCommands.addCommand(this.computeMinForceObjective(this.commandProvider.getNextRhoBoundCommand(), nextSequence, nextDuration));
            }
            if (!this.mpcParameters.includeRhoMaxInequality()) continue;
            this.mpcCommands.addCommand(this.computeMaxForceObjective(this.commandProvider.getNextNormalForceBoundCommand(), nextSequence, nextDuration));
        }
        ContactStateProvider lastContactPhase = contactSequence.get(numberOfPhases - 1);
        double finalDuration = Math.min(lastContactPhase.getTimeInterval().getDuration(), 5.0);
        this.mpcCommands.addCommand(this.computeFinalCoMPositionObjective(this.commandProvider.getNextCoMPositionCommand(), (FramePoint3DReadOnly)this.comPositionAtEndOfWindow, numberOfPhases - 1, finalDuration));
        this.mpcCommands.addCommand(this.computeFinalCoMVelocityObjective(this.commandProvider.getNextCoMVelocityCommand(), (FrameVector3DReadOnly)this.comVelocityAtEndOfWindow, numberOfPhases - 1, finalDuration));
        this.mpcCommands.addCommand(this.computeVRPPositionObjective(this.commandProvider.getNextVRPPositionCommand(), (FramePoint3DReadOnly)this.vrpAtEndOfWindow, numberOfPhases - 1, finalDuration));
    }

    private MPCCommand<?> computeInitialCoMPositionObjective(CoMPositionCommand objectiveToPack) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setWeight(this.mpcParameters.getInitialComWeight());
        objectiveToPack.setConstraintType(this.mpcParameters.getInitialCoMPositionConstraintType());
        objectiveToPack.setSegmentNumber(0);
        objectiveToPack.setTimeOfObjective(0.0);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)this.currentCoMPosition);
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(0); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(0, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeInitialCoMVelocityObjective(CoMVelocityCommand objectiveToPack) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setConstraintType(this.mpcParameters.getInitialCoMVelocityConstraintType());
        objectiveToPack.setWeight(this.mpcParameters.getInitialComVelocityWeight());
        objectiveToPack.setSegmentNumber(0);
        objectiveToPack.setTimeOfObjective(0.0);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)this.currentCoMVelocity);
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(0); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(0, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeContinuityObjective(MPCContinuityCommand continuityObjectiveToPack, int firstSegmentNumber, double firstSegmentDuration) {
        int i;
        continuityObjectiveToPack.clear();
        continuityObjectiveToPack.setOmega(this.omega.getValue());
        continuityObjectiveToPack.setFirstSegmentNumber(firstSegmentNumber);
        continuityObjectiveToPack.setFirstSegmentDuration(firstSegmentDuration);
        continuityObjectiveToPack.setConstraintType(ConstraintType.EQUALITY);
        for (i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(firstSegmentNumber); ++i) {
            continuityObjectiveToPack.addFirstSegmentContactPlaneHelper(this.contactHandler.getContactPlane(firstSegmentNumber, i));
        }
        for (i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(firstSegmentNumber + 1); ++i) {
            continuityObjectiveToPack.addSecondSegmentContactPlaneHelper(this.contactHandler.getContactPlane(firstSegmentNumber + 1, i));
        }
        return continuityObjectiveToPack;
    }

    private MPCCommand<?> computeMinForceObjective(RhoBoundCommand valueObjective, int segmentNumber, double segmentDuration) {
        int numberOfContactPlanes = this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber);
        if (numberOfContactPlanes < 1) {
            return null;
        }
        valueObjective.clear();
        valueObjective.setSlackVariableWeight(1.0E7 / MathTools.pow((double)10.0, (int)segmentNumber));
        valueObjective.setOmega(this.omega.getValue());
        valueObjective.setSegmentDuration(segmentDuration);
        valueObjective.setSegmentNumber(segmentNumber);
        valueObjective.setConstraintType(ConstraintType.GEQ_INEQUALITY);
        for (int i = 0; i < numberOfContactPlanes; ++i) {
            MPCContactPlane contactPlane = this.contactHandler.getContactPlane(segmentNumber, i);
            valueObjective.addContactPlane(contactPlane, this.mpcParameters.getMinRhoValue());
            this.contactHandler.getActiveSetData(segmentNumber).addInequalityConstraints(4 * contactPlane.getRhoSize());
        }
        return valueObjective;
    }

    private MPCCommand<?> computeMaxForceObjective(NormalForceBoundCommand valueObjective, int segmentNumber, double segmentDuration) {
        valueObjective.clear();
        valueObjective.setOmega(this.omega.getValue());
        valueObjective.setSegmentDuration(segmentDuration);
        valueObjective.setSegmentNumber(segmentNumber);
        valueObjective.setConstraintType(ConstraintType.LEQ_INEQUALITY);
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            MPCContactPlane contactPlane = this.contactHandler.getContactPlane(segmentNumber, i);
            valueObjective.addContactPlane(contactPlane, this.maxContactForce);
            this.contactHandler.getActiveSetData(segmentNumber).addInequalityConstraints(contactPlane.getRhoSize());
        }
        return valueObjective;
    }

    private MPCCommand<?> computeVRPTrackingObjective(VRPTrackingCommand objectiveToPack, FramePoint3DReadOnly desiredStartVRPPosition, FrameVector3DReadOnly desiredStartVRPVelocity, FramePoint3DReadOnly desiredEndVRPPosition, FrameVector3DReadOnly desiredEndVRPVelocity, int segmentNumber, double segmentDuration, DoubleConsumer costToGoConsumer) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setWeight(this.mpcParameters.getVRPTrackingWeight());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setSegmentDuration(segmentDuration);
        objectiveToPack.setStartVRP(desiredStartVRPPosition);
        objectiveToPack.setStartVRPVelocity(desiredStartVRPVelocity);
        objectiveToPack.setEndVRP(desiredEndVRPPosition);
        objectiveToPack.setEndVRPVelocity(desiredEndVRPVelocity);
        objectiveToPack.setCostToGoConsumer(costToGoConsumer);
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeForceMinimizationObjective(ForceTrackingCommand objectiveToPack, int segmentNumber, double segmentDuration, int contactNumber) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setWeight(this.mpcParameters.getForceMinimizationWeight());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setSegmentDuration(segmentDuration);
        objectiveToPack.setObjectiveValue(this.zeroVector);
        objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, contactNumber));
        return objectiveToPack;
    }

    private MPCCommand<?> computeRhoMinimizationObjective(RhoTrackingCommand objectiveToPack, int segmentNumber, double segmentDuration) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setWeight(this.mpcParameters.getRhoMinimizationWeight());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setSegmentDuration(segmentDuration);
        objectiveToPack.setObjectiveValue(this.mpcParameters.getMinRhoValue());
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeRhoRateMinimizationObjective(RhoRateTrackingCommand objectiveToPack, int segmentNumber, double segmentDuration) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setWeight(this.mpcParameters.getRhoRateMinimizationWeight());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setSegmentDuration(segmentDuration);
        objectiveToPack.setObjectiveValue(this.mpcParameters.getMinRhoValue());
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeDCMPositionObjective(DCMPositionCommand objectiveToPack, FramePoint3DReadOnly desiredPosition, int segmentNumber, double timeOfObjective) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setTimeOfObjective(timeOfObjective);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)desiredPosition);
        objectiveToPack.setConstraintType(ConstraintType.EQUALITY);
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeFinalCoMPositionObjective(CoMPositionCommand objectiveToPack, FramePoint3DReadOnly desiredPosition, int segmentNumber, double timeOfObjective) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setTimeOfObjective(timeOfObjective);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)desiredPosition);
        objectiveToPack.setWeight(this.mpcParameters.getFinalComWeight());
        objectiveToPack.setConstraintType(this.mpcParameters.getFinalCoMPositionConstraintType());
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeFinalCoMVelocityObjective(CoMVelocityCommand objectiveToPack, FrameVector3DReadOnly desiredVelocity, int segmentNumber, double timeOfObjective) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setTimeOfObjective(timeOfObjective);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)desiredVelocity);
        objectiveToPack.setWeight(this.mpcParameters.getFinalComWeight());
        objectiveToPack.setConstraintType(this.mpcParameters.getFinalCoMVelocityConstraintType());
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    private MPCCommand<?> computeVRPPositionObjective(VRPPositionCommand objectiveToPack, FramePoint3DReadOnly desiredPosition, int segmentNumber, double timeOfObjective) {
        objectiveToPack.clear();
        objectiveToPack.setOmega(this.omega.getValue());
        objectiveToPack.setSegmentNumber(segmentNumber);
        objectiveToPack.setTimeOfObjective(timeOfObjective);
        objectiveToPack.setObjective((FrameTuple3DReadOnly)desiredPosition);
        objectiveToPack.setWeight(this.mpcParameters.getFinalVRPWeight());
        objectiveToPack.setConstraintType(this.mpcParameters.getFinalVRPPositionConstraintType());
        for (int i = 0; i < this.contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            objectiveToPack.addContactPlaneHelper(this.contactHandler.getContactPlane(segmentNumber, i));
        }
        return objectiveToPack;
    }

    protected abstract void resetActiveSet();

    protected abstract NativeMatrix solveQP();

    public void compute(double timeInPhase) {
        this.compute(timeInPhase, this.desiredCoMPosition, this.desiredCoMVelocity, this.desiredCoMAcceleration, this.desiredDCMPosition, this.desiredDCMVelocity, this.desiredVRPPosition, this.desiredVRPVelocity, this.desiredECMPPosition);
    }

    protected void updateCoMTrajectoryViewer() {
        if (this.trajectoryViewer != null) {
            this.trajectoryViewer.compute(this, this.currentTimeInState.getDoubleValue());
        }
    }

    public void compute(double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        this.linearTrajectoryHandler.compute(timeInPhase);
        this.wrenchTrajectoryHandler.compute(timeInPhase);
        comPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMPosition());
        comVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMVelocity());
        comAccelerationToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMAcceleration());
        dcmPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredDCMPosition());
        dcmVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredDCMVelocity());
        vrpPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredVRPPosition());
        vrpVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredVRPVelocity());
        ecmpPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)vrpPositionToPack);
        double nominalHeight = this.gravityZ / MathTools.square((double)this.omega.getValue());
        ecmpPositionToPack.set((FrameTuple3DReadOnly)this.desiredVRPPosition);
        ecmpPositionToPack.subZ(nominalHeight);
    }

    public int getCurrentSegmentIndex() {
        return this.linearTrajectoryHandler.getComTrajectory().getCurrentSegmentIndex();
    }

    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.linearTrajectoryHandler.setInitialCenterOfMassState(centerOfMassPosition, centerOfMassVelocity);
    }

    public void setCurrentCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity, double timeInState) {
        this.currentCoMPosition.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassPosition);
        this.currentCoMVelocity.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassVelocity);
        this.currentTimeInState.set(timeInState);
    }

    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.desiredDCMPosition;
    }

    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.desiredDCMVelocity;
    }

    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.desiredCoMPosition;
    }

    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.desiredCoMVelocity;
    }

    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.desiredCoMAcceleration;
    }

    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.desiredVRPPosition;
    }

    public FrameVector3DReadOnly getDesiredVRPVelocity() {
        return this.desiredVRPVelocity;
    }

    public FramePoint3DReadOnly getDesiredECMPPosition() {
        return this.desiredECMPPosition;
    }

    public List<? extends Polynomial3DReadOnly> getVRPTrajectories() {
        return this.linearTrajectoryHandler.getVrpTrajectories();
    }

    public List<ContactPlaneProvider> getContactStateProviders() {
        return this.linearTrajectoryHandler.getFullPlanningSequence();
    }

    public boolean hasTrajectories() {
        return this.linearTrajectoryHandler.hasTrajectory() && this.wrenchTrajectoryHandler.hasTrajectory();
    }

    public void reset() {
        this.linearTrajectoryHandler.clearTrajectory();
        this.wrenchTrajectoryHandler.clearTrajectory();
    }

    public MultipleCoMSegmentTrajectoryGenerator getCoMTrajectory() {
        if (!this.hasTrajectories()) {
            throw new RuntimeException("CoM Trajectories are not calculated");
        }
        return this.linearTrajectoryHandler.getComTrajectory();
    }

    public List<? extends List<MPCContactPlane>> getContactPlanes() {
        return this.contactHandler.getContactPlanes();
    }
}

