/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class ContactPlaneProviderTools {
    public static final double gridSizeXY = 0.05;
    public static final double rateGridSizeXY = 0.1;
    public static final int yawDivisions = 36;
    public static final double gridSizeYaw = 0.17453292519943295;
    public static final double timeGridSize = 0.01;
    public static final double areaGridSize = 0.0025000000000000005;
    public static final int prime = 31;

    public static int computePlaneHashCode(Pose3DReadOnly pose, ConvexPolygon2DReadOnly polygon) {
        int result = ContactPlaneProviderTools.computePointHashCode(pose.getPosition());
        result += 31 * Math.floorMod((int)Math.round(pose.getYaw() / 0.17453292519943295), 36);
        return result += 31 * (int)Math.round(polygon.getArea() / 0.0025000000000000005);
    }

    public static int computePointHashCode(Point3DReadOnly point) {
        int result = 1;
        result += 31 * (int)Math.round(point.getX() / 0.05);
        return result += 31 * (int)Math.round(point.getY() / 0.05);
    }

    public static int computeVectorHashCode(Vector3DReadOnly vector) {
        int result = 1;
        result += 31 * (int)Math.round(vector.getX() / 0.1);
        return result += 31 * (int)Math.round(vector.getY() / 0.1);
    }

    public static int computePlaneProviderHashCode(int planeHashCode, int timeHashCode, int startHashCode, int startVelHashCode, int endHashCode, int endVelHashCode) {
        int result = 1;
        result += 31 * planeHashCode;
        result += 31 * timeHashCode;
        result += 31 * startHashCode;
        result += 31 * startVelHashCode;
        result += 31 * endHashCode;
        return result += 31 * endVelHashCode;
    }

    public static int computeTimeHashCode(TimeIntervalReadOnly timeInterval) {
        int result = 1;
        result += 31 * (int)Math.round(timeInterval.getDuration() / 0.01);
        return result += 31 * (int)Math.round(timeInterval.getEndTime() / 0.01);
    }
}

