/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateBasics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProviderTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;

public class ContactPlaneProvider
implements ContactStateBasics<ContactPlaneProvider> {
    private int planeProviderId = -1;
    private ContactState contactState = ContactState.IN_CONTACT;
    private final FramePoint3D startECMPPosition = new FramePoint3D();
    private final FramePoint3D endECMPPosition = new FramePoint3D();
    private final FrameVector3D startECMPVelocity = new FrameVector3D();
    private final FrameVector3D endECMPVelocity = new FrameVector3D();
    private final TimeIntervalBasics timeInterval = new TimeInterval();
    private final List<ConvexPolygon2DReadOnly> contactPointsInBodyFrame = new ArrayList<ConvexPolygon2DReadOnly>();
    private final List<FramePose3DReadOnly> contactPoses = new ArrayList<FramePose3DReadOnly>();
    private int totalContactPoints = 0;
    private int hashCode;
    private int planeHashCode;
    private int timeHashCode;
    private int startHashCode;
    private int startVelHashCode;
    private int endHashCode;
    private int endVelHashCode;
    private static final double timeEpsilon = 0.01;
    private static final double positionEpsilon = 0.005;

    public ContactPlaneProvider() {
        this.reset();
    }

    @Override
    public void reset() {
        this.planeProviderId = -1;
        this.startECMPPosition.setToNaN();
        this.endECMPPosition.setToNaN();
        this.startECMPVelocity.setToNaN();
        this.endECMPVelocity.setToNaN();
        this.totalContactPoints = 0;
        this.contactPointsInBodyFrame.clear();
        this.contactPoses.clear();
        this.planeHashCode = 0;
        this.hashCode = -1;
    }

    public void set(ContactPlaneProvider other) {
        this.set((ContactStateProvider<?>)other);
        this.setPlaneProviderId(other.getPlaneProviderId());
        for (int i = 0; i < other.getNumberOfContactPlanes(); ++i) {
            this.addContact(other.getContactPose(i), other.getContactsInBodyFrame(i));
        }
    }

    public void setPlaneProviderId(int planeProviderId) {
        this.planeProviderId = planeProviderId;
    }

    public int getPlaneProviderId() {
        return this.planeProviderId;
    }

    @Override
    public void setStartECMPPosition(FramePoint3DReadOnly startECMPPosition) {
        this.startECMPPosition.set((FrameTuple3DReadOnly)startECMPPosition);
        this.startHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.startECMPPosition);
    }

    public void setStartECMPPosition(FramePoint2DReadOnly startECMPPosition, double height) {
        this.startECMPPosition.set((FrameTuple2DReadOnly)startECMPPosition, height);
        this.startHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.startECMPPosition);
    }

    public void setStartECMPPosition(Point2DReadOnly startECMPPosition, double height) {
        this.startECMPPosition.set((Tuple2DReadOnly)startECMPPosition, height);
        this.startHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.startECMPPosition);
    }

    @Override
    public void setStartECMPVelocity(FrameVector3DReadOnly startECMPVelocity) {
        this.startECMPVelocity.set((FrameTuple3DReadOnly)startECMPVelocity);
        this.startVelHashCode = ContactPlaneProviderTools.computeVectorHashCode((Vector3DReadOnly)this.startECMPVelocity);
    }

    @Override
    public void setEndECMPPosition(FramePoint3DReadOnly endECMPPosition) {
        this.endECMPPosition.set((FrameTuple3DReadOnly)endECMPPosition);
        this.endHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.endECMPPosition);
    }

    public void setEndECMPPosition(FramePoint2DReadOnly endECMPPosition, double height) {
        this.endECMPPosition.set((FrameTuple2DReadOnly)endECMPPosition, height);
        this.endHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.endECMPPosition);
    }

    public void setEndECMPPosition(Point2DReadOnly endECMPPosition, double height) {
        this.endECMPPosition.set((Tuple2DReadOnly)endECMPPosition, height);
        this.endHashCode = ContactPlaneProviderTools.computePointHashCode((Point3DReadOnly)this.endECMPPosition);
    }

    @Override
    public void setEndECMPVelocity(FrameVector3DReadOnly endECMPVelocity) {
        this.endECMPVelocity.set((FrameTuple3DReadOnly)endECMPVelocity);
        this.endVelHashCode = ContactPlaneProviderTools.computeVectorHashCode((Vector3DReadOnly)this.endECMPVelocity);
    }

    public void setLinearECMPVelocity() {
        this.startECMPVelocity.sub((FrameTuple3DReadOnly)this.getECMPEndPosition(), (FrameTuple3DReadOnly)this.getECMPStartPosition());
        this.startECMPVelocity.scale(1.0 / Math.min(this.getTimeInterval().getDuration(), 10.0));
        this.endECMPVelocity.set(this.startECMPVelocity);
        this.endVelHashCode = this.startVelHashCode = ContactPlaneProviderTools.computeVectorHashCode((Vector3DReadOnly)this.startECMPVelocity);
    }

    public void setTimeInterval(TimeIntervalReadOnly timeInterval) {
        this.timeInterval.set(timeInterval);
        this.timeHashCode = ContactPlaneProviderTools.computeTimeHashCode((TimeIntervalReadOnly)this.timeInterval);
    }

    @Override
    public void setContactState(ContactState contactState) {
        this.contactState = contactState;
    }

    @Override
    public FramePoint3DReadOnly getECMPStartPosition() {
        return this.startECMPPosition;
    }

    @Override
    public FramePoint3DReadOnly getECMPEndPosition() {
        return this.endECMPPosition;
    }

    @Override
    public FrameVector3DReadOnly getECMPStartVelocity() {
        if (this.startECMPVelocity.containsNaN()) {
            this.setLinearECMPVelocity();
        }
        return this.startECMPVelocity;
    }

    @Override
    public FrameVector3DReadOnly getECMPEndVelocity() {
        if (this.endECMPVelocity.containsNaN()) {
            this.setLinearECMPVelocity();
        }
        return this.endECMPVelocity;
    }

    @Override
    public ContactState getContactState() {
        return this.contactState;
    }

    public TimeIntervalBasics getTimeInterval() {
        return this.timeInterval;
    }

    public void setDuration(double duration) {
        this.setEndTime(this.getTimeInterval().getStartTime() + duration);
    }

    public void setStartTime(double startTime) {
        this.getTimeInterval().setStartTime(startTime);
        this.timeHashCode = ContactPlaneProviderTools.computeTimeHashCode((TimeIntervalReadOnly)this.timeInterval);
    }

    public void setEndTime(double endTime) {
        this.getTimeInterval().setEndTime(endTime);
        this.timeHashCode = ContactPlaneProviderTools.computeTimeHashCode((TimeIntervalReadOnly)this.timeInterval);
    }

    public void addContact(FramePose3DReadOnly contactPose, ConvexPolygon2DReadOnly contactPointsInBodyFrame) {
        this.contactPoses.add(contactPose);
        this.contactPointsInBodyFrame.add(contactPointsInBodyFrame);
        this.totalContactPoints += contactPointsInBodyFrame.getNumberOfVertices();
        this.planeHashCode += 31 * ContactPlaneProviderTools.computePlaneHashCode((Pose3DReadOnly)contactPose, contactPointsInBodyFrame);
    }

    public void setStartFromEnd(ContactStateProvider previousContactState) {
        this.setStartTime(previousContactState.getTimeInterval().getEndTime());
        this.setStartECMPPosition(previousContactState.getECMPEndPosition());
    }

    public int getNumberOfContactPlanes() {
        return this.contactPointsInBodyFrame.size();
    }

    public int getTotalNumberOfPointsInContact() {
        return this.totalContactPoints;
    }

    public int getNumberOfContactPointsInPlane(int contactPlane) {
        return this.contactPointsInBodyFrame.get(contactPlane).getNumberOfVertices();
    }

    public ConvexPolygon2DReadOnly getContactsInBodyFrame(int contactPlane) {
        return this.contactPointsInBodyFrame.get(contactPlane);
    }

    public FramePose3DReadOnly getContactPose(int contactPlane) {
        return this.contactPoses.get(contactPlane);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = ContactPlaneProviderTools.computePlaneProviderHashCode(this.planeHashCode, this.timeHashCode, this.startHashCode, this.startVelHashCode, this.endHashCode, this.endVelHashCode);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactPlaneProvider other = (ContactPlaneProvider)obj;
        return ContactPlaneProvider.equals(this, other);
    }

    private static boolean equals(ContactPlaneProvider planeA, ContactPlaneProvider planeB) {
        return ContactPlaneProvider.epsilonEquals(planeA, planeB, 0.01, 0.005);
    }

    public static boolean epsilonEquals(ContactPlaneProvider planeA, ContactPlaneProvider planeB, double timeEpsilon, double positionEpsilon) {
        if (planeA == null || planeB == null) {
            return false;
        }
        if (!MathTools.epsilonEquals((double)planeA.getTimeInterval().getEndTime(), (double)planeB.getTimeInterval().getEndTime(), (double)timeEpsilon)) {
            return false;
        }
        if (planeA.getContactState() != planeB.getContactState()) {
            return false;
        }
        if (planeA.getContactState() == ContactState.FLIGHT) {
            return true;
        }
        if (planeA.getNumberOfContactPlanes() != planeB.getNumberOfContactPlanes()) {
            return false;
        }
        for (int i = 0; i < planeA.getNumberOfContactPlanes(); ++i) {
            if (planeA.getNumberOfContactPointsInPlane(i) != planeB.getNumberOfContactPointsInPlane(i)) {
                return false;
            }
            if (!(planeA.getContactPose(i).getPosition().distanceXYSquared(planeB.getContactPose(i).getPosition()) > positionEpsilon * positionEpsilon)) continue;
            return false;
        }
        return true;
    }
}

