/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.messageHandlers;

import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.PlanOffsetStatus;
import controller_msgs.msg.dds.TextToSpeechPacket;
import controller_msgs.msg.dds.WalkingControllerFailureStatusMessage;
import controller_msgs.msg.dds.WalkingStatusMessage;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import us.ihmc.commonWalkingControlModules.desiredFootStep.FootstepListVisualizer;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.messageHandlers.CenterOfMassTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.MomentumTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.PlanarRegionsListHandler;
import us.ihmc.commonWalkingControlModules.messageHandlers.StepConstraintRegionHandler;
import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.communication.packets.ExecutionTiming;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.AdjustFootstepCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.CenterOfMassTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.MomentumTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PauseWalkingCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PlanarRegionsListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StepConstraintRegionCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameSE3TrajectoryPoint;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;

public class WalkingMessageHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final int maxNumberOfFootsteps = 100;
    private final RecyclingArrayList<Footstep> upcomingFootsteps = new RecyclingArrayList(100, Footstep.class);
    private final RecyclingArrayList<FootstepTiming> upcomingFootstepTimings = new RecyclingArrayList(100, FootstepTiming.class);
    private final RecyclingArrayList<MutableDouble> pauseDurationAfterStep = new RecyclingArrayList(100, MutableDouble.class);
    private final YoBoolean isPausedWithSteps = new YoBoolean("IsPausedWithSteps", this.registry);
    private final YoDouble timeToContinueWalking = new YoDouble("TimeToContinueWalking", this.registry);
    private final DoubleProvider minimumPauseTime = new DoubleParameter("MinimumPauseTime", this.registry, 0.0);
    private final YoBoolean hasNewFootstepAdjustment = new YoBoolean("hasNewFootstepAdjustement", this.registry);
    private final AdjustFootstepCommand requestedFootstepAdjustment = new AdjustFootstepCommand();
    private final SideDependentList<Footstep> footstepsAtCurrentLocation = new SideDependentList();
    private final SideDependentList<Footstep> lastDesiredFootsteps = new SideDependentList();
    private final SideDependentList<ReferenceFrame> soleFrames = new SideDependentList();
    private final SideDependentList<RecyclingArrayDeque<FootTrajectoryCommand>> upcomingFootTrajectoryCommandListForFlamingoStance = new SideDependentList();
    private final StatusMessageOutputManager statusOutputManager;
    private final PlanOffsetStatus planOffsetStatus = new PlanOffsetStatus();
    private final YoInteger currentFootstepIndex = new YoInteger("currentFootstepIndex", this.registry);
    private final YoInteger currentNumberOfFootsteps = new YoInteger("currentNumberOfFootsteps", this.registry);
    private final YoBoolean isWalkingPaused = new YoBoolean("isWalkingPaused", this.registry);
    private final YoBoolean isWalkingResuming = new YoBoolean("isWalkingResuming", this.registry);
    private final YoDouble defaultTransferTime = new YoDouble("defaultTransferTime", this.registry);
    private final YoDouble finalTransferTime = new YoDouble("finalTransferTime", this.registry);
    private final YoDouble defaultSwingTime = new YoDouble("defaultSwingTime", this.registry);
    private final YoDouble defaultInitialTransferTime = new YoDouble("defaultInitialTransferTime", this.registry);
    private final YoDouble defaultFinalTransferTime = new YoDouble("defaultFinalTransferTime", this.registry);
    private final YoLong lastCommandID = new YoLong("lastFootStepDataListCommandID", this.registry);
    private final YoBoolean isWalking = new YoBoolean("isWalking", this.registry);
    private final int numberOfFootstepsToVisualize = 4;
    private final YoEnum<RobotSide>[] upcomingFoostepSide = new YoEnum[4];
    private final FootstepListVisualizer footstepListVisualizer;
    private final YoDouble yoTime;
    private final YoDouble footstepDataListReceivedTime = new YoDouble("footstepDataListReceivedTime", this.registry);
    private final YoDouble timeElapsedWhenFootstepExecuted = new YoDouble("timeElapsedWhenFootstepExecuted", this.registry);
    private final YoBoolean executingFootstep = new YoBoolean("ExecutingFootstep", this.registry);
    private final FootstepTiming lastTimingExecuted = new FootstepTiming();
    private final MomentumTrajectoryHandler momentumTrajectoryHandler;
    private final CenterOfMassTrajectoryHandler comTrajectoryHandler;
    private final PlanarRegionsListHandler planarRegionsListHandler;
    private final StepConstraintRegionHandler stepConstraintRegionHandler;
    private final YoBoolean offsettingXYPlanWithFootstepError = new YoBoolean("offsettingXYPlanWithFootstepError", this.registry);
    private final YoBoolean offsettingHeightPlanWithFootstepError = new YoBoolean("offsettingHeightPlanWithFootstepError", this.registry);
    private final YoFrameVector3D planOffsetInWorld = new YoFrameVector3D("planOffsetInWorld", worldFrame, this.registry);
    private final YoFrameVector3D planOffsetFromAdjustment = new YoFrameVector3D("comPlanOffsetFromAdjustment", worldFrame, this.registry);
    private final DoubleProvider maxStepDistance = new DoubleParameter("MaxStepDistance", this.registry, Double.POSITIVE_INFINITY);
    private final DoubleProvider maxStepHeightChange = new DoubleParameter("MaxStepHeightChange", this.registry, Double.POSITIVE_INFINITY);
    private final DoubleProvider maxSwingDistance = new DoubleParameter("MaxSwingDistance", this.registry, Double.POSITIVE_INFINITY);
    private final TextToSpeechPacket reusableSpeechPacket = new TextToSpeechPacket();
    private final WalkingControllerFailureStatusMessage failureStatusMessage = new WalkingControllerFailureStatusMessage();
    private final FootstepStatusMessage footstepStatus = new FootstepStatusMessage();
    private final WalkingStatusMessage walkingStatusMessage = new WalkingStatusMessage();
    private final FramePose3D tempPose = new FramePose3D();
    private final TransferToAndNextFootstepsData transferToAndNextFootstepsData = new TransferToAndNextFootstepsData();
    private final FramePoint3DBasics tempStanceLocation = new FramePoint3D();
    private final FramePoint3DBasics tempStepOrigin = new FramePoint3D();
    private final FrameVector3D footstepOffsetVector = new FrameVector3D();
    private final SideDependentList<FramePoint3DReadOnly> desiredFootstepPositions = new SideDependentList();
    private final SideDependentList<FramePoint3DReadOnly> actualFootstepPositions = new SideDependentList();
    private final FrameVector3D touchdownErrorVector = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final FrameVector3D totalOffset = new FrameVector3D();

    public WalkingMessageHandler(double defaultTransferTime, double defaultSwingTime, double defaultInitialTransferTime, double defaultFinalTransferTime, SideDependentList<? extends ContactablePlaneBody> contactableFeet, StatusMessageOutputManager statusOutputManager, YoDouble yoTime, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.statusOutputManager = statusOutputManager;
        this.yoTime = yoTime;
        this.footstepDataListReceivedTime.setToNaN();
        this.defaultTransferTime.set(defaultTransferTime);
        this.defaultSwingTime.set(defaultSwingTime);
        this.defaultInitialTransferTime.set(defaultInitialTransferTime);
        this.defaultFinalTransferTime.set(defaultFinalTransferTime);
        this.finalTransferTime.set(defaultFinalTransferTime);
        for (RobotSide robotSide : RobotSide.values) {
            ContactablePlaneBody contactableFoot = (ContactablePlaneBody)contactableFeet.get((Enum)robotSide);
            Footstep footstepAtCurrentLocation = new Footstep(robotSide);
            this.footstepsAtCurrentLocation.put((Enum)robotSide, (Object)footstepAtCurrentLocation);
            this.soleFrames.put((Enum)robotSide, (Object)contactableFoot.getSoleFrame());
            this.upcomingFootTrajectoryCommandListForFlamingoStance.put((Enum)robotSide, (Object)new RecyclingArrayDeque(FootTrajectoryCommand.class, FootTrajectoryCommand::set));
        }
        for (int i = 0; i < 4; ++i) {
            this.upcomingFoostepSide[i] = new YoEnum("upcomingFoostepSide" + i, this.registry, RobotSide.class, true);
        }
        this.footstepListVisualizer = yoGraphicsListRegistry != null ? new FootstepListVisualizer(contactableFeet, yoGraphicsListRegistry, this.registry) : null;
        this.updateVisualization();
        this.momentumTrajectoryHandler = new MomentumTrajectoryHandler(yoTime, this.registry);
        this.comTrajectoryHandler = new CenterOfMassTrajectoryHandler(yoTime, this.registry);
        this.planarRegionsListHandler = new PlanarRegionsListHandler(statusOutputManager, this.registry);
        this.stepConstraintRegionHandler = new StepConstraintRegionHandler(this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void handleFootstepDataListCommand(FootstepDataListCommand command) {
        double commandFinalTransferTime;
        if (command.getNumberOfFootsteps() > 0) {
            switch (command.getExecutionMode()) {
                case OVERRIDE: {
                    this.offsettingXYPlanWithFootstepError.set(command.isOffsetFootstepsWithExecutionError());
                    this.offsettingHeightPlanWithFootstepError.set(command.isOffsetFootstepsHeightWithExecutionError());
                    this.planOffsetInWorld.setToZero();
                    this.clearFootsteps();
                    this.clearFootTrajectory();
                    break;
                }
                case QUEUE: {
                    if (this.offsettingXYPlanWithFootstepError.getValue() != command.isOffsetFootstepsWithExecutionError()) {
                        LogTools.warn((String)"Recieved a queued message that has a different setting for offsetting footsteps with execution error!");
                    }
                    if (this.offsettingHeightPlanWithFootstepError.getValue() != command.isOffsetFootstepsHeightWithExecutionError()) {
                        LogTools.warn((String)"Recieved a queued message that has a different setting for offsetting height of footsteps with execution error!");
                    }
                    if (this.currentNumberOfFootsteps.getIntegerValue() >= 1 || this.executingFootstep.getBooleanValue()) break;
                    if (command.getExecutionTiming() == ExecutionTiming.CONTROL_ABSOLUTE_TIMINGS) {
                        LogTools.warn((String)"Can not command a queued message with absolute timings if all footsteps were already exectuted. You gotta send faster!");
                        return;
                    }
                    if (command.getPreviousCommandId() == this.lastCommandID.getValue()) break;
                    if (this.lastCommandID.getValue() == 0L) {
                        LogTools.warn((String)"Can not queue footsteps if no footsteps are present. Send an override message instead. Command ignored.");
                    } else {
                        LogTools.warn((String)"Queued footstep previous command id {} != controller's previous command id {}. Send an override message instead. Command ignored.", (Object)command.getPreviousCommandId(), (Object)this.lastCommandID.getValue());
                    }
                    return;
                }
                default: {
                    LogTools.warn((String)("Unknown " + ExecutionMode.class.getSimpleName() + " value: " + command.getExecutionMode() + ". Command ignored."));
                    return;
                }
            }
        }
        if (command.getNumberOfFootsteps() + this.currentNumberOfFootsteps.getIntegerValue() > 100) {
            LogTools.warn((String)"Can not exceed 100 footsteps stopping execution.");
            this.clearFootsteps();
            return;
        }
        this.lastCommandID.set(command.getCommandId());
        if (this.isWalkingPaused.getValue()) {
            this.isWalking.set(false);
        }
        this.isWalkingPaused.set(false);
        double commandDefaultTransferTime = command.getDefaultTransferDuration();
        double commandDefaultSwingTime = command.getDefaultSwingDuration();
        if (!Double.isNaN(commandDefaultSwingTime) && commandDefaultSwingTime > 0.01 && !Double.isNaN(commandDefaultTransferTime) && commandDefaultTransferTime >= 0.0) {
            this.defaultTransferTime.set(commandDefaultTransferTime);
            this.defaultSwingTime.set(commandDefaultSwingTime);
        }
        if ((commandFinalTransferTime = command.getFinalTransferDuration()) > 0.0) {
            this.finalTransferTime.set(commandFinalTransferTime);
        } else {
            this.finalTransferTime.set(this.defaultFinalTransferTime.getDoubleValue());
        }
        boolean trustHeightOfFootsteps = command.isTrustHeightOfFootsteps();
        boolean areFootstepsAdjustable = command.areFootstepsAdjustable();
        for (int i = 0; i < command.getNumberOfFootsteps(); ++i) {
            this.setFootstepTiming(command.getFootstep(i), command.getExecutionTiming(), (FootstepTiming)this.upcomingFootstepTimings.add(), (MutableDouble)this.pauseDurationAfterStep.add(), command.getExecutionMode());
            this.setFootstep(command.getFootstep(i), trustHeightOfFootsteps, areFootstepsAdjustable, (Footstep)this.upcomingFootsteps.add());
            this.currentNumberOfFootsteps.increment();
        }
        if (!WalkingMessageHandler.checkTimings(this.upcomingFootstepTimings, this.yoTime)) {
            this.clearFootsteps();
        }
        if (!WalkingMessageHandler.checkFootsteps(this.upcomingFootsteps, this.soleFrames, this.maxStepDistance.getValue(), this.maxStepHeightChange.getValue(), this.maxSwingDistance.getValue(), this.tempStanceLocation, this.tempStepOrigin)) {
            this.clearFootsteps();
        }
        this.checkForPause();
        this.updateVisualization();
    }

    public void handlePlanarRegionsListCommand(PlanarRegionsListCommand planarRegionsListCommand) {
        this.planarRegionsListHandler.handlePlanarRegionsListCommand(planarRegionsListCommand);
    }

    public void handleStepConstraintRegionCommand(StepConstraintRegionCommand stepConstraintRegionCommand) {
        this.stepConstraintRegionHandler.handleStepConstraintRegionCommand(stepConstraintRegionCommand);
    }

    public PlanarRegionsListHandler getPlanarRegionsListHandler() {
        return this.planarRegionsListHandler;
    }

    public StepConstraintRegionHandler getStepConstraintRegionHandler() {
        return this.stepConstraintRegionHandler;
    }

    public void handleAdjustFootstepCommand(AdjustFootstepCommand command) {
        if (this.isWalkingPaused.getBooleanValue()) {
            LogTools.warn((String)("Received " + AdjustFootstepCommand.class.getSimpleName() + " but walking is currently paused. Command ignored."));
            this.requestedFootstepAdjustment.clear();
            this.hasNewFootstepAdjustment.set(false);
            return;
        }
        this.requestedFootstepAdjustment.set(command);
        this.hasNewFootstepAdjustment.set(true);
    }

    public void handlePauseWalkingCommand(PauseWalkingCommand command) {
        if (!command.isPauseRequested() && this.isWalkingPaused.getValue()) {
            this.isWalkingResuming.set(true);
        }
        this.isWalkingPaused.set(command.isPauseRequested());
    }

    public void handleFootTrajectoryCommand(List<FootTrajectoryCommand> commands) {
        for (int i = 0; i < commands.size(); ++i) {
            FootTrajectoryCommand command = commands.get(i);
            ((RecyclingArrayDeque)this.upcomingFootTrajectoryCommandListForFlamingoStance.get((Enum)command.getRobotSide())).addLast((Object)command);
        }
    }

    public void handleMomentumTrajectoryCommand(MomentumTrajectoryCommand command) {
        this.momentumTrajectoryHandler.handleMomentumTrajectory(command);
    }

    public void getAngularMomentumTrajectory(double startTime, double endTime, int numberOfPoints, RecyclingArrayList<EuclideanTrajectoryPoint> trajectoryToPack) {
        this.momentumTrajectoryHandler.getAngularMomentumTrajectory(startTime, endTime, numberOfPoints, trajectoryToPack);
    }

    public MomentumTrajectoryHandler getMomentumTrajectoryHandler() {
        return this.momentumTrajectoryHandler;
    }

    public CenterOfMassTrajectoryHandler getComTrajectoryHandler() {
        return this.comTrajectoryHandler;
    }

    public void handleComTrajectoryCommand(CenterOfMassTrajectoryCommand command) {
        this.comTrajectoryHandler.handleComTrajectory(command);
    }

    public void setUpcomingFootstepTransferDuration(double duration) {
        if (this.upcomingFootstepTimings.isEmpty()) {
            throw new RuntimeException("Can not get timing, no upcoming footstep.");
        }
        ((FootstepTiming)this.upcomingFootstepTimings.get(0)).setTransferTime(duration);
    }

    public void peekTiming(int i, FootstepTiming timingToPack) {
        if (i >= this.upcomingFootstepTimings.size()) {
            throw new RuntimeException("Can not get timing " + i + " since there are only " + this.upcomingFootstepTimings.size() + " upcoming timings.");
        }
        timingToPack.set((FootstepTiming)this.upcomingFootstepTimings.get(i));
    }

    public void peekFootstep(int i, Footstep footstepToPack) {
        if (i >= this.upcomingFootsteps.size()) {
            throw new RuntimeException("Can not get footstep " + i + " since there are only " + this.upcomingFootsteps.size() + " upcoming steps.");
        }
        footstepToPack.set((Footstep)this.upcomingFootsteps.get(i));
    }

    public void poll(Footstep footstepToPack, FootstepTiming timingToPack) {
        if (this.getStepsBeforePause() == 0) {
            throw new RuntimeException("Can not poll footstep since there are no upcoming steps.");
        }
        footstepToPack.set((Footstep)this.upcomingFootsteps.get(0));
        timingToPack.set((FootstepTiming)this.upcomingFootstepTimings.get(0));
        this.lastTimingExecuted.set((FootstepTiming)this.upcomingFootstepTimings.get(0));
        this.updateVisualization();
        this.currentNumberOfFootsteps.decrement();
        this.currentFootstepIndex.increment();
        this.upcomingFootstepTimings.remove(0);
        this.pauseDurationAfterStep.remove(0);
        this.upcomingFootsteps.remove(0);
    }

    public void adjustTiming(double newSwingDuration, double newTransferDuration) {
        if (this.upcomingFootstepTimings.isEmpty()) {
            throw new RuntimeException("Can not adjust timing of upciming step - have no steps.");
        }
        ((FootstepTiming)this.upcomingFootstepTimings.get(0)).setTimings(newSwingDuration, newTransferDuration);
    }

    public FootTrajectoryCommand pollFootTrajectoryForFlamingoStance(RobotSide swingSide) {
        return (FootTrajectoryCommand)((RecyclingArrayDeque)this.upcomingFootTrajectoryCommandListForFlamingoStance.get((Enum)swingSide)).poll();
    }

    public boolean pollRequestedFootstepAdjustment(Footstep footstepToAdjust) {
        if (!this.hasNewFootstepAdjustment.getBooleanValue()) {
            return false;
        }
        if (footstepToAdjust.getRobotSide() != this.requestedFootstepAdjustment.getRobotSide()) {
            LogTools.warn((String)("RobotSide does not match: side of footstep to be adjusted: " + footstepToAdjust.getRobotSide() + ", side of adjusted footstep: " + this.requestedFootstepAdjustment.getRobotSide()));
            this.hasNewFootstepAdjustment.set(false);
            this.requestedFootstepAdjustment.clear();
            return false;
        }
        FramePoint3D adjustedPosition = this.requestedFootstepAdjustment.getPosition();
        FrameQuaternion adjustedOrientation = this.requestedFootstepAdjustment.getOrientation();
        footstepToAdjust.setPose((FrameTuple3DReadOnly)adjustedPosition, (FrameQuaternionReadOnly)adjustedOrientation);
        if (!this.requestedFootstepAdjustment.getPredictedContactPoints().isEmpty()) {
            ArrayList<Point2D> contactPoints = new ArrayList<Point2D>();
            for (int i = 0; i < footstepToAdjust.getPredictedContactPoints().size(); ++i) {
                contactPoints.add((Point2D)footstepToAdjust.getPredictedContactPoints().get(i));
            }
            footstepToAdjust.setPredictedContactPoints(contactPoints);
        }
        this.hasNewFootstepAdjustment.set(false);
        this.requestedFootstepAdjustment.clear();
        return true;
    }

    public boolean hasUpcomingFootsteps() {
        return this.getStepsBeforePause() > 0 && !this.isWalkingPaused.getBooleanValue();
    }

    private void checkForPause() {
        if (!this.pauseDurationAfterStep.isEmpty() && Double.isFinite(((MutableDouble)this.pauseDurationAfterStep.get(0)).doubleValue())) {
            double pause = ((MutableDouble)this.pauseDurationAfterStep.get(0)).doubleValue();
            this.timeToContinueWalking.set(this.yoTime.getValue() + pause);
            this.isPausedWithSteps.set(true);
            ((MutableDouble)this.pauseDurationAfterStep.get(0)).setValue(Double.NaN);
        }
    }

    private int getStepsBeforePause() {
        int stepIndex;
        if (this.isPausedWithSteps.getValue() && this.yoTime.getValue() >= this.timeToContinueWalking.getValue()) {
            this.isPausedWithSteps.set(false);
        }
        if (this.isPausedWithSteps.getValue()) {
            return 0;
        }
        for (stepIndex = 0; stepIndex < this.upcomingFootsteps.size(); ++stepIndex) {
            if (!Double.isFinite(((MutableDouble)this.pauseDurationAfterStep.get(stepIndex)).doubleValue())) continue;
            return stepIndex;
        }
        return stepIndex;
    }

    public boolean hasRequestedFootstepAdjustment() {
        if (this.isWalkingPaused.getBooleanValue()) {
            this.hasNewFootstepAdjustment.set(false);
            this.requestedFootstepAdjustment.clear();
        }
        return this.hasNewFootstepAdjustment.getBooleanValue();
    }

    public boolean isNextFootstepFor(RobotSide swingSide) {
        if (!this.hasUpcomingFootsteps()) {
            return false;
        }
        return ((Footstep)this.upcomingFootsteps.get(0)).getRobotSide() == swingSide;
    }

    public boolean hasFootTrajectoryForFlamingoStance() {
        for (RobotSide robotSide : RobotSide.values) {
            if (!this.hasFootTrajectoryForFlamingoStance(robotSide)) continue;
            return true;
        }
        return false;
    }

    public boolean hasFootTrajectoryForFlamingoStance(RobotSide swingSide) {
        return !((RecyclingArrayDeque)this.upcomingFootTrajectoryCommandListForFlamingoStance.get((Enum)swingSide)).isEmpty();
    }

    public void clearFootTrajectory(RobotSide robotSide) {
        ((RecyclingArrayDeque)this.upcomingFootTrajectoryCommandListForFlamingoStance.get((Enum)robotSide)).clear();
    }

    public void clearFootTrajectory() {
        for (RobotSide robotSide : RobotSide.values) {
            this.clearFootTrajectory(robotSide);
        }
    }

    public void clearFootsteps() {
        this.upcomingFootsteps.clear();
        this.upcomingFootstepTimings.clear();
        this.pauseDurationAfterStep.clear();
        this.currentNumberOfFootsteps.set(0);
        this.currentFootstepIndex.set(0);
        this.updateVisualization();
    }

    public void reportFootstepStarted(RobotSide robotSide, FramePose3DReadOnly desiredFootPoseInWorld, FramePose3DReadOnly actualFootPoseInWorld, double swingDuration) {
        this.reportFootstepStatus(robotSide, FootstepStatus.STARTED, desiredFootPoseInWorld, actualFootPoseInWorld, swingDuration);
        this.executingFootstep.set(true);
        if (this.yoTime != null) {
            this.timeElapsedWhenFootstepExecuted.set(this.yoTime.getDoubleValue() - this.footstepDataListReceivedTime.getDoubleValue());
        }
    }

    public void reportFootstepCompleted(RobotSide robotSide, FramePose3DReadOnly desiredFootPoseInWorld, FramePose3DReadOnly actualFootPoseInWorld, double swingDuration) {
        this.reportFootstepStatus(robotSide, FootstepStatus.COMPLETED, desiredFootPoseInWorld, actualFootPoseInWorld, swingDuration);
        this.executingFootstep.set(false);
    }

    private void reportFootstepStatus(RobotSide robotSide, FootstepStatus status, FramePose3DReadOnly desiredFootPoseInWorld, FramePose3DReadOnly actualFootPoseInWorld, double swingDuration) {
        desiredFootPoseInWorld.checkReferenceFrameMatch(worldFrame);
        actualFootPoseInWorld.checkReferenceFrameMatch(worldFrame);
        this.footstepStatus.setFootstepStatus(status.toByte());
        this.footstepStatus.setRobotSide(robotSide.toByte());
        this.footstepStatus.setFootstepIndex(this.currentFootstepIndex.getIntegerValue());
        this.footstepStatus.getActualFootOrientationInWorld().set((QuaternionReadOnly)actualFootPoseInWorld.getOrientation());
        this.footstepStatus.getActualFootPositionInWorld().set((Tuple3DReadOnly)actualFootPoseInWorld.getPosition());
        this.footstepStatus.getDesiredFootOrientationInWorld().set((QuaternionReadOnly)desiredFootPoseInWorld.getOrientation());
        this.footstepStatus.getDesiredFootPositionInWorld().set((Tuple3DReadOnly)desiredFootPoseInWorld.getPosition());
        this.footstepStatus.setSwingDuration(swingDuration);
        this.statusOutputManager.reportStatusMessage((Object)this.footstepStatus);
    }

    public void reportWalkingStarted() {
        if (this.isWalking.getValue()) {
            if (this.isWalkingResuming.getValue()) {
                this.walkingStatusMessage.setWalkingStatus(WalkingStatus.RESUMED.toByte());
                this.statusOutputManager.reportStatusMessage((Object)this.walkingStatusMessage);
                this.isWalkingResuming.set(false);
            }
            return;
        }
        this.walkingStatusMessage.setWalkingStatus(WalkingStatus.STARTED.toByte());
        this.statusOutputManager.reportStatusMessage((Object)this.walkingStatusMessage);
        this.reusableSpeechPacket.setTextToSpeak("walking");
        this.statusOutputManager.reportStatusMessage((Object)this.reusableSpeechPacket);
        this.isWalking.set(true);
    }

    public void reportWalkingComplete() {
        if (!this.isWalking.getValue()) {
            return;
        }
        if (!this.upcomingFootsteps.isEmpty()) {
            this.walkingStatusMessage.setWalkingStatus(WalkingStatus.PAUSED.toByte());
            this.statusOutputManager.reportStatusMessage((Object)this.walkingStatusMessage);
            this.checkForPause();
            return;
        }
        this.walkingStatusMessage.setWalkingStatus(WalkingStatus.COMPLETED.toByte());
        this.statusOutputManager.reportStatusMessage((Object)this.walkingStatusMessage);
        this.isWalking.set(false);
    }

    public void reportWalkingAbortRequested() {
        WalkingStatusMessage walkingStatusMessage = new WalkingStatusMessage();
        walkingStatusMessage.setWalkingStatus(WalkingStatus.ABORT_REQUESTED.toByte());
        this.statusOutputManager.reportStatusMessage((Object)walkingStatusMessage);
    }

    public void reportControllerFailure(FrameVector3D fallingDirection) {
        fallingDirection.changeFrame(worldFrame);
        this.failureStatusMessage.getFallingDirection().set((Tuple3DReadOnly)fallingDirection);
        this.statusOutputManager.reportStatusMessage((Object)this.failureStatusMessage);
    }

    public void requestPlanarRegions() {
        this.planarRegionsListHandler.requestPlanarRegions();
    }

    public void registerCompletedDesiredFootstep(Footstep completedFesiredFootstep) {
        this.lastDesiredFootsteps.put((Enum)completedFesiredFootstep.getRobotSide(), (Object)completedFesiredFootstep);
    }

    public Footstep getLastDesiredFootstep(RobotSide footstepSide) {
        return (Footstep)this.lastDesiredFootsteps.get((Enum)footstepSide);
    }

    public Footstep getFootstepAtCurrentLocation(RobotSide robotSide) {
        this.tempPose.setToZero((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        this.tempPose.changeFrame(worldFrame);
        Footstep footstep = (Footstep)this.footstepsAtCurrentLocation.get((Enum)robotSide);
        footstep.setPose((FramePose3DReadOnly)this.tempPose);
        return footstep;
    }

    public void setDefaultTransferTime(double transferTime) {
        this.defaultTransferTime.set(transferTime);
    }

    public void setDefaultSwingTime(double swingTime) {
        this.defaultSwingTime.set(swingTime);
    }

    public double getDefaultTransferTime() {
        return this.defaultTransferTime.getDoubleValue();
    }

    public double getNextTransferTime() {
        if (this.upcomingFootstepTimings.isEmpty()) {
            return this.getDefaultTransferTime();
        }
        return ((FootstepTiming)this.upcomingFootstepTimings.get(0)).getTransferTime();
    }

    public double getDefaultSwingTime() {
        return this.defaultSwingTime.getDoubleValue();
    }

    public double getNextSwingTime() {
        if (this.upcomingFootstepTimings.isEmpty()) {
            return this.getDefaultSwingTime();
        }
        return ((FootstepTiming)this.upcomingFootstepTimings.get(0)).getSwingTime();
    }

    public double getInitialTransferTime() {
        return this.defaultInitialTransferTime.getDoubleValue();
    }

    public double getFinalTransferTime() {
        return this.finalTransferTime.getDoubleValue();
    }

    public double getDefaultStepTime() {
        return this.defaultTransferTime.getDoubleValue() + this.defaultSwingTime.getDoubleValue();
    }

    public double getNextStepTime() {
        if (this.upcomingFootstepTimings.isEmpty()) {
            return this.getDefaultStepTime();
        }
        return ((FootstepTiming)this.upcomingFootstepTimings.get(0)).getStepTime();
    }

    public int getCurrentNumberOfFootsteps() {
        return this.getStepsBeforePause();
    }

    private void updateVisualization() {
        int i;
        for (i = 0; i < this.upcomingFootsteps.size(); ++i) {
            if (i >= 4) continue;
            this.upcomingFoostepSide[i].set((Enum)((Footstep)this.upcomingFootsteps.get(i)).getRobotSide());
        }
        for (i = this.upcomingFootsteps.size(); i < 4; ++i) {
            this.upcomingFoostepSide[i].set(null);
        }
        if (this.footstepListVisualizer != null) {
            this.footstepListVisualizer.update((List<Footstep>)this.upcomingFootsteps);
        }
    }

    public void updateVisualizationAfterFootstepAdjustement(Footstep adjustedFootstep) {
        if (this.footstepListVisualizer != null) {
            this.footstepListVisualizer.updateFirstFootstep(adjustedFootstep);
        }
    }

    public TransferToAndNextFootstepsData createTransferToAndNextFootstepDataForDoubleSupport(RobotSide transferToSide) {
        this.transferToAndNextFootstepsData.setTransferToPosition((ReferenceFrame)this.soleFrames.get((Enum)transferToSide));
        this.transferToAndNextFootstepsData.setTransferToSide(transferToSide);
        return this.transferToAndNextFootstepsData;
    }

    public TransferToAndNextFootstepsData createTransferToAndNextFootstepDataForSingleSupport(Footstep transferToFootstep, RobotSide swingSide) {
        this.transferToAndNextFootstepsData.setTransferToPosition((FramePoint3DReadOnly)transferToFootstep.getFootstepPose().getPosition());
        this.transferToAndNextFootstepsData.setTransferToSide(swingSide);
        return this.transferToAndNextFootstepsData;
    }

    private void setFootstep(FootstepDataCommand footstepData, boolean trustHeight, boolean isAdjustable, Footstep footstepToSet) {
        footstepToSet.set(footstepData, trustHeight, isAdjustable);
        footstepToSet.addOffset((FrameVector3DReadOnly)this.planOffsetInWorld);
    }

    private void setFootstepTiming(FootstepDataCommand footstep, ExecutionTiming executionTiming, FootstepTiming timingToSet, MutableDouble pauseDurationToSet, ExecutionMode executionMode) {
        double transferDuration;
        int stepsInQueue = this.upcomingFootsteps.size();
        double swingDuration = footstep.getSwingDuration();
        if (Double.isNaN(swingDuration) || swingDuration <= 0.0) {
            swingDuration = this.defaultSwingTime.getDoubleValue();
        }
        if (Double.isNaN(transferDuration = footstep.getTransferDuration()) || transferDuration <= 0.0) {
            transferDuration = stepsInQueue == 0 && !this.isWalking.getBooleanValue() && executionMode == ExecutionMode.OVERRIDE ? this.defaultInitialTransferTime.getDoubleValue() : this.defaultTransferTime.getDoubleValue();
        }
        timingToSet.setTimings(swingDuration, transferDuration);
        timingToSet.setTouchdownDuration(footstep.getTouchdownDuration());
        timingToSet.setLiftoffDuration(footstep.getLiftoffDuration());
        switch (executionTiming) {
            case CONTROL_DURATIONS: {
                timingToSet.removeAbsoluteTime();
                break;
            }
            case CONTROL_ABSOLUTE_TIMINGS: {
                if (stepsInQueue == 0 && !this.executingFootstep.getBooleanValue() && executionMode == ExecutionMode.OVERRIDE) {
                    this.footstepDataListReceivedTime.set(this.yoTime.getDoubleValue());
                    timingToSet.setAbsoluteTime(transferDuration, this.footstepDataListReceivedTime.getDoubleValue());
                    break;
                }
                if (stepsInQueue == 0 && !this.executingFootstep.getBooleanValue()) {
                    throw new RuntimeException("This should not happen. We are not executing a footstep and there is no steps in queue so there is no way to compute absolute timings for the step as was requested.");
                }
                if (stepsInQueue == 0) {
                    double swingStartTime = this.lastTimingExecuted.getSwingStartTime() + this.lastTimingExecuted.getSwingTime() + transferDuration;
                    timingToSet.setAbsoluteTime(swingStartTime, this.footstepDataListReceivedTime.getDoubleValue());
                    break;
                }
                FootstepTiming previousTiming = (FootstepTiming)this.upcomingFootstepTimings.get(stepsInQueue - 1);
                double swingStartTime = previousTiming.getSwingStartTime() + previousTiming.getSwingTime() + transferDuration;
                timingToSet.setAbsoluteTime(swingStartTime, this.footstepDataListReceivedTime.getDoubleValue());
                break;
            }
            default: {
                throw new RuntimeException("Timing mode not implemented.");
            }
        }
        double timeToGoToStanding = stepsInQueue == 0 ? 0.0 : this.finalTransferTime.getValue();
        double pauseTime = timingToSet.getTransferTime() - timeToGoToStanding - this.defaultInitialTransferTime.getValue();
        if (pauseTime >= this.minimumPauseTime.getValue()) {
            timingToSet.setTransferTime(this.defaultInitialTransferTime.getValue());
            pauseDurationToSet.setValue(pauseTime);
        } else {
            pauseDurationToSet.setValue(Double.NaN);
        }
    }

    private static boolean checkTimings(List<FootstepTiming> upcomingFootstepTimings, YoDouble yoTime) {
        if (upcomingFootstepTimings.isEmpty()) {
            return true;
        }
        boolean timingsValid = upcomingFootstepTimings.get(0).hasAbsoluteTime();
        boolean atLeastOneFootstepHadTiming = upcomingFootstepTimings.get(0).hasAbsoluteTime();
        double lastTime = upcomingFootstepTimings.get(0).getSwingStartTime();
        timingsValid = timingsValid && lastTime > 0.0;
        for (int footstepIdx = 1; footstepIdx < upcomingFootstepTimings.size(); ++footstepIdx) {
            FootstepTiming footstep = upcomingFootstepTimings.get(footstepIdx);
            boolean timeIncreasing = footstep.getSwingStartTime() > lastTime;
            timingsValid = timingsValid && footstep.hasAbsoluteTime() && timeIncreasing;
            atLeastOneFootstepHadTiming = atLeastOneFootstepHadTiming || footstep.hasAbsoluteTime();
            lastTime = footstep.getSwingStartTime();
            if (!timingsValid) break;
        }
        if (atLeastOneFootstepHadTiming && !timingsValid) {
            LogTools.warn((String)"Recieved footstep data with invalid timings. Using swing and transfer times instead.");
            return false;
        }
        if (atLeastOneFootstepHadTiming && yoTime == null) {
            LogTools.warn((String)("Recieved absolute footstep timings but " + WalkingMessageHandler.class.getSimpleName() + " was created with no yoTime."));
            return false;
        }
        return true;
    }

    private static boolean checkFootsteps(List<Footstep> footsteps, SideDependentList<ReferenceFrame> soleFrames, double maxStepDistance, double maxStepHeightChange, double maxSwingDistance, FramePoint3DBasics tempStanceLocation, FramePoint3DBasics tempStepOrigin) {
        if (footsteps.isEmpty()) {
            return true;
        }
        tempStanceLocation.setToZero((ReferenceFrame)soleFrames.get((Enum)footsteps.get(0).getRobotSide().getOppositeSide()));
        tempStepOrigin.setToZero((ReferenceFrame)soleFrames.get((Enum)footsteps.get(0).getRobotSide()));
        tempStanceLocation.changeFrame(worldFrame);
        tempStepOrigin.changeFrame(worldFrame);
        for (int i = 0; i < footsteps.size(); ++i) {
            FramePoint3DReadOnly position;
            int j;
            Footstep footstep = footsteps.get(i);
            FixedFramePoint3DBasics stepPosition = footstep.getFootstepPose().getPosition();
            double distance = stepPosition.distanceXY((FramePoint3DReadOnly)tempStanceLocation);
            if (distance > maxStepDistance) {
                LogTools.warn((String)("Received step that was too far to be executed safely. Distance from previous step was " + distance + ". If that is acceptable increase the MaxStepDistance parameter."));
                return false;
            }
            double heightChange = Math.abs(stepPosition.getZ() - tempStanceLocation.getZ());
            if (heightChange > maxStepHeightChange) {
                LogTools.warn((String)("Received step that was too far to be executed safely. Height change w.r.t. previous step was " + heightChange + ". If that is acceptable increase the MaxStepHeightChange parameter."));
                return false;
            }
            if (footstep.getTrajectoryType() == TrajectoryType.WAYPOINTS) {
                RecyclingArrayList swingTrajectory = footstep.getSwingTrajectory();
                for (j = 0; j < swingTrajectory.size(); ++j) {
                    position = ((FrameSE3TrajectoryPoint)swingTrajectory.get(j)).getPosition();
                    if (WalkingMessageHandler.checkPositionIsValid(position, (FramePoint3DReadOnly)tempStepOrigin, (FramePoint3DReadOnly)stepPosition, maxSwingDistance)) continue;
                    return false;
                }
            }
            if (footstep.getTrajectoryType() == TrajectoryType.CUSTOM) {
                List positionWaypoints = footstep.getCustomPositionWaypoints();
                for (j = 0; j < positionWaypoints.size(); ++j) {
                    position = (FramePoint3DReadOnly)positionWaypoints.get(j);
                    if (WalkingMessageHandler.checkPositionIsValid(position, (FramePoint3DReadOnly)tempStepOrigin, (FramePoint3DReadOnly)stepPosition, maxSwingDistance)) continue;
                    return false;
                }
            }
            if (i >= footsteps.size() - 1) continue;
            if (footsteps.get(i + 1).getRobotSide() != footstep.getRobotSide()) {
                tempStepOrigin.set((FrameTuple3DReadOnly)tempStanceLocation);
                tempStanceLocation.set((FrameTuple3DReadOnly)stepPosition);
                continue;
            }
            tempStepOrigin.set((FrameTuple3DReadOnly)stepPosition);
        }
        return true;
    }

    private static boolean checkPositionIsValid(FramePoint3DReadOnly positionToCheck, FramePoint3DReadOnly location1, FramePoint3DReadOnly location2, double maxDistance) {
        double distanceXY = EuclidGeometryTools.distanceFromPoint2DToLineSegment2D((double)positionToCheck.getX(), (double)positionToCheck.getY(), (double)location1.getX(), (double)location1.getY(), (double)location2.getX(), (double)location2.getY());
        if (distanceXY > maxDistance) {
            LogTools.warn((String)("Got a footstep with a trajectory that is far from the step origin and goal location. The XY distance from a straight line trajectory was " + distanceXY + ". If that is acceptable increase the MaxSwingDistance parameter."));
            return false;
        }
        double distanceZ = Math.min(Math.abs(location1.getZ() - positionToCheck.getZ()), Math.abs(location2.getZ() - positionToCheck.getZ()));
        if (distanceZ > maxDistance) {
            LogTools.warn((String)("Got a footstep with a trajectory that is far from the step origin and goal location. The Z distance from the closer location was " + distanceZ + ". If that is acceptable increase the MaxSwingDistance parameter."));
            return false;
        }
        return true;
    }

    public void registerDesiredFootstepPosition(RobotSide robotSide, FramePoint3DReadOnly desiredFootstepPosition) {
        this.desiredFootstepPositions.put((Enum)robotSide, (Object)desiredFootstepPosition);
    }

    public void registerActualFootstepPosition(RobotSide robotSide, FramePoint3DReadOnly actualFootstepPosition) {
        this.actualFootstepPositions.put((Enum)robotSide, (Object)actualFootstepPosition);
    }

    public void addOffsetVectorFromTouchdownError(RobotSide robotSide) {
        this.touchdownErrorVector.sub((FrameTuple3DReadOnly)this.actualFootstepPositions.get((Enum)robotSide), (FrameTuple3DReadOnly)this.desiredFootstepPositions.get((Enum)robotSide));
        this.addOffsetVectorOnTouchdown((FrameVector3DReadOnly)this.touchdownErrorVector);
    }

    public void addOffsetVectorOnTouchdown(FrameVector3DReadOnly offset) {
        if (!this.offsettingXYPlanWithFootstepError.getValue() && !this.offsettingHeightPlanWithFootstepError.getValue()) {
            return;
        }
        this.footstepOffsetVector.setIncludingFrame((FrameTuple3DReadOnly)offset);
        if (!this.offsettingXYPlanWithFootstepError.getValue()) {
            this.footstepOffsetVector.setX(0.0);
            this.footstepOffsetVector.setY(0.0);
        }
        if (!this.offsettingHeightPlanWithFootstepError.getValue()) {
            this.footstepOffsetVector.setZ(0.0);
        }
        for (int stepIdx = 0; stepIdx < this.upcomingFootsteps.size(); ++stepIdx) {
            Footstep footstep = (Footstep)this.upcomingFootsteps.get(stepIdx);
            footstep.addOffset((FrameVector3DReadOnly)this.footstepOffsetVector);
        }
        this.planOffsetInWorld.add((FrameTuple3DReadOnly)this.footstepOffsetVector);
        this.setPlanOffsetInternal((FrameVector3DReadOnly)this.planOffsetInWorld);
        this.planOffsetFromAdjustment.setToZero();
        this.updateVisualization();
    }

    public void setPlanOffsetFromAdjustment(FrameVector3DReadOnly planOffsetFromAdjustment) {
        this.planOffsetFromAdjustment.set((FrameTuple3DReadOnly)planOffsetFromAdjustment);
        this.totalOffset.add((FrameTuple3DReadOnly)this.planOffsetInWorld, (FrameTuple3DReadOnly)planOffsetFromAdjustment);
        this.setPlanOffsetInternal((FrameVector3DReadOnly)this.totalOffset);
    }

    private void setPlanOffsetInternal(FrameVector3DReadOnly planOffset) {
        this.comTrajectoryHandler.setPositionOffset(planOffset);
        this.planOffsetStatus.getOffsetVector().set((Tuple3DReadOnly)planOffset);
        this.statusOutputManager.reportStatusMessage((Object)this.planOffsetStatus);
    }
}

