/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.messageHandlers;

import us.ihmc.commons.PrintTools;
import us.ihmc.commons.lists.RecyclingIterator;
import us.ihmc.commons.lists.RecyclingLinkedList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.robotics.math.trajectories.trajectorypoints.EuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoInteger;

public class EuclideanTrajectoryHandler {
    private static final int defaultMaxNumberOfPoints = 1000;
    private final YoRegistry registry;
    private final EuclideanTrajectoryPointBasics lastPoint = new EuclideanTrajectoryPoint();
    private final EuclideanTrajectoryPointBasics firstPoint = new EuclideanTrajectoryPoint();
    private final EuclideanTrajectoryPointBasics secondPoint = new EuclideanTrajectoryPoint();
    private final EuclideanTrajectoryPointBasics tempPoint = new EuclideanTrajectoryPoint();
    private final RecyclingLinkedList<EuclideanTrajectoryPointBasics> trajectoryPoints = new RecyclingLinkedList(1000, EuclideanTrajectoryPoint::new, EuclideanTrajectoryPointBasics::set);
    private final RecyclingIterator<EuclideanTrajectoryPointBasics> trajectoryIterator = this.trajectoryPoints.createForwardIterator();
    private final DoubleProvider yoTime;
    private final YoPolynomial polynomial;
    private final YoFramePoint3D position;
    private final YoFrameVector3D velocity;
    private final YoFrameVector3D acceleration;
    private final YoInteger numberOfPoints;
    private long lastMessageID = -1L;

    public EuclideanTrajectoryHandler(String name, DoubleProvider yoTime, YoRegistry parentRegistry) {
        this.yoTime = yoTime;
        this.registry = new YoRegistry(name + "TrajectoryHandler");
        this.polynomial = new YoPolynomial(name + "CubicPolynomial", 4, this.registry);
        this.position = new YoFramePoint3D(name + "Position", ReferenceFrame.getWorldFrame(), this.registry);
        this.velocity = new YoFrameVector3D(name + "Velocity", ReferenceFrame.getWorldFrame(), this.registry);
        this.acceleration = new YoFrameVector3D(name + "Acceleration", ReferenceFrame.getWorldFrame(), this.registry);
        this.numberOfPoints = new YoInteger(name + "NumberOfPoints", this.registry);
        parentRegistry.addChild(this.registry);
    }

    protected FramePoint3DReadOnly getPosition() {
        return this.position;
    }

    protected FrameVector3DReadOnly getVelocity() {
        return this.velocity;
    }

    protected FrameVector3DReadOnly getAcceleration() {
        return this.acceleration;
    }

    protected double getCurrentTime() {
        return this.yoTime.getValue();
    }

    protected void handleTrajectory(EuclideanTrajectoryControllerCommand command) {
        switch (command.getExecutionMode()) {
            case OVERRIDE: {
                command.addTimeOffset(this.yoTime.getValue());
                while (!this.trajectoryPoints.isEmpty()) {
                    this.trajectoryPoints.removeFirst();
                }
                break;
            }
            case QUEUE: {
                if (this.trajectoryPoints.isEmpty()) {
                    PrintTools.warn((String)"Can not queue without points");
                    return;
                }
                if (command.getTrajectoryPoint(0).getTime() <= 0.0) {
                    PrintTools.warn((String)"Can not queue trajectory with initial time 0.0");
                    return;
                }
                if (command.getPreviousCommandId() != this.lastMessageID) {
                    PrintTools.warn((String)"Invalid message ID.");
                    return;
                }
                this.trajectoryPoints.peekLast((Object)this.lastPoint);
                double lastTime = this.lastPoint.getTime();
                command.addTimeOffset(lastTime);
                break;
            }
            default: {
                throw new RuntimeException("Unhadled execution mode.");
            }
        }
        this.lastMessageID = command.getCommandId();
        for (int idx = 0; idx < command.getNumberOfTrajectoryPoints(); ++idx) {
            this.trajectoryPoints.addLast((Object)command.getTrajectoryPoint(idx));
        }
        this.numberOfPoints.set(this.trajectoryPoints.size());
    }

    public boolean isWithinInterval(double time) {
        if (this.trajectoryPoints.size() < 2) {
            return false;
        }
        this.trajectoryPoints.peekFirst((Object)this.firstPoint);
        if (time < this.firstPoint.getTime()) {
            return false;
        }
        this.trajectoryPoints.peekLast((Object)this.lastPoint);
        return !(time > this.lastPoint.getTime());
    }

    public boolean isEmpty() {
        return this.trajectoryPoints.isEmpty();
    }

    public void clearPointsInPast() {
        double currentTime = this.yoTime.getValue();
        boolean removedPoints = false;
        while (!this.trajectoryPoints.isEmpty()) {
            this.trajectoryPoints.peekFirst((Object)this.firstPoint);
            if (!(this.firstPoint.getTime() < currentTime)) break;
            this.tempPoint.set(this.firstPoint);
            this.trajectoryPoints.removeFirst();
            removedPoints = true;
        }
        if (removedPoints && !this.trajectoryPoints.isEmpty()) {
            this.trajectoryPoints.addFirst((Object)this.tempPoint);
        }
        this.numberOfPoints.set(this.trajectoryPoints.size());
    }

    protected void packDesiredsAtTime(double time) {
        this.trajectoryIterator.reset();
        this.trajectoryIterator.next((Object)this.firstPoint);
        while (this.trajectoryIterator.hasNext()) {
            this.trajectoryIterator.next((Object)this.secondPoint);
            if (this.secondPoint.getTime() >= time) break;
            this.firstPoint.set(this.secondPoint);
        }
        double t0 = this.firstPoint.getTime();
        double t1 = this.secondPoint.getTime();
        for (int i = 0; i < 3; ++i) {
            double p0 = this.firstPoint.getPosition().getElement(i);
            double v0 = this.firstPoint.getLinearVelocity().getElement(i);
            double p1 = this.secondPoint.getPosition().getElement(i);
            double v1 = this.secondPoint.getLinearVelocity().getElement(i);
            this.polynomial.setCubic(t0, t1, p0, v0, p1, v1);
            this.polynomial.compute(time);
            this.position.setElement(i, this.polynomial.getValue());
            this.velocity.setElement(i, this.polynomial.getVelocity());
            this.acceleration.setElement(i, this.polynomial.getAcceleration());
        }
    }
}

