/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.inverseKinematics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsSolution;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.inverseKinematics.InverseKinematicsOptimizationException;
import us.ihmc.commonWalkingControlModules.inverseKinematics.InverseKinematicsQPSolver;
import us.ihmc.commonWalkingControlModules.momentumBasedController.WholeBodyControllerBoundCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MotionQPInputCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPVariableSubstitution;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.convexOptimization.quadraticProgram.SimpleEfficientActiveSetQPSolverWithInactiveVariables;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class InverseKinematicsOptimizationControlModule {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final InverseKinematicsQPSolver qpSolver;
    private final QPInputTypeA qpInput;
    private final QPVariableSubstitution qpVariableSubstitution;
    private final MotionQPInputCalculator motionQPInputCalculator;
    private final WholeBodyControllerBoundCalculator boundCalculator;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final JointBasics[] jointsToOptimizeFor;
    private final List<KinematicLoopFunction> kinematicLoopFunctions;
    private final int numberOfDoFs;
    private final Map<OneDoFJointBasics, YoDouble> jointMaximumVelocities = new HashMap<OneDoFJointBasics, YoDouble>();
    private final Map<OneDoFJointBasics, YoDouble> jointMinimumVelocities = new HashMap<OneDoFJointBasics, YoDouble>();
    private final DMatrixRMaj qDotMinMatrix;
    private final DMatrixRMaj qDotMaxMatrix;
    private final JointIndexHandler jointIndexHandler;
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("hasNotConvergedInPast", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("hasNotConvergedCounts", this.registry);
    private final InverseKinematicsSolution inverseKinematicsSolution;

    public InverseKinematicsOptimizationControlModule(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this.jointIndexHandler = toolbox.getJointIndexHandler();
        this.jointsToOptimizeFor = this.jointIndexHandler.getIndexedJoints();
        this.oneDoFJoints = this.jointIndexHandler.getIndexedOneDoFJoints();
        this.kinematicLoopFunctions = toolbox.getKinematicLoopFunctions();
        this.inverseKinematicsSolution = new InverseKinematicsSolution(this.jointsToOptimizeFor);
        this.numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])this.jointsToOptimizeFor);
        this.qpInput = new QPInputTypeA(this.numberOfDoFs);
        this.qpVariableSubstitution = new QPVariableSubstitution();
        this.motionQPInputCalculator = toolbox.getMotionQPInputCalculator();
        this.boundCalculator = toolbox.getQPBoundCalculator();
        this.qDotMinMatrix = new DMatrixRMaj(this.numberOfDoFs, 1);
        this.qDotMaxMatrix = new DMatrixRMaj(this.numberOfDoFs, 1);
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.oneDoFJoints[i];
            this.jointMaximumVelocities.put(joint, new YoDouble("qd_max_qp_" + joint.getName(), this.registry));
            this.jointMinimumVelocities.put(joint, new YoDouble("qd_min_qp_" + joint.getName(), this.registry));
        }
        ControllerCoreOptimizationSettings optimizationSettings = toolbox.getOptimizationSettings();
        Object activeSetQPSolver = optimizationSettings == null ? new SimpleEfficientActiveSetQPSolverWithInactiveVariables() : optimizationSettings.getActiveSetQPSolver();
        double controlDT = toolbox.getControlDT();
        this.qpSolver = new InverseKinematicsQPSolver((ActiveSetQPSolverWithInactiveVariablesInterface)activeSetQPSolver, this.numberOfDoFs, controlDT, this.registry);
        if (optimizationSettings != null) {
            this.qpSolver.setVelocityRegularizationWeight(optimizationSettings.getJointVelocityWeight());
            this.qpSolver.setAccelerationRegularizationWeight(optimizationSettings.getJointAccelerationWeight());
        }
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        this.qpSolver.reset();
        this.motionQPInputCalculator.initialize();
    }

    public InverseKinematicsSolution compute() throws InverseKinematicsOptimizationException {
        NoConvergenceException noConvergenceException = null;
        this.computePrivilegedJointVelocities();
        this.computeJointVelocityLimits();
        this.qpSolver.setMaxJointVelocities(this.qDotMaxMatrix);
        this.qpSolver.setMinJointVelocities(this.qDotMinMatrix);
        for (int i = 0; i < this.kinematicLoopFunctions.size(); ++i) {
            this.motionQPInputCalculator.convertKinematicLoopFunction(this.kinematicLoopFunctions.get(i), this.qpVariableSubstitution);
            this.qpSolver.addVariableSubstitution(this.qpVariableSubstitution);
        }
        try {
            this.qpSolver.solve();
        }
        catch (NoConvergenceException e) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                e.printStackTrace();
                LogTools.warn((String)("Only showing the stack trace of the first " + ((Object)((Object)e)).getClass().getSimpleName() + ". This may be happening more than once."));
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
            noConvergenceException = e;
        }
        DMatrixRMaj jointVelocities = this.qpSolver.getJointVelocities();
        MomentumReadOnly centroidalMomentumSoltuion = this.motionQPInputCalculator.computeCentroidalMomentumFromSolution(jointVelocities);
        this.inverseKinematicsSolution.setJointVelocities(jointVelocities);
        this.inverseKinematicsSolution.setCentroidalMomentumSolution(centroidalMomentumSoltuion);
        if (noConvergenceException != null) {
            throw new InverseKinematicsOptimizationException(noConvergenceException, this.inverseKinematicsSolution);
        }
        return this.inverseKinematicsSolution;
    }

    private void computeJointVelocityLimits() {
        this.boundCalculator.computeJointVelocityLimits(this.qDotMinMatrix, this.qDotMaxMatrix);
        for (int i = 0; i < this.oneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.oneDoFJoints[i];
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            double qDotMin = this.qDotMinMatrix.get(jointIndex, 0);
            double qDotMax = this.qDotMaxMatrix.get(jointIndex, 0);
            this.jointMinimumVelocities.get(joint).set(qDotMin);
            this.jointMaximumVelocities.get(joint).set(qDotMax);
        }
    }

    private void computePrivilegedJointVelocities() {
        boolean success = this.motionQPInputCalculator.computePrivilegedJointVelocities(this.qpInput);
        if (success) {
            this.qpSolver.addMotionInput(this.qpInput);
        }
    }

    public void submitSpatialVelocityCommand(SpatialVelocityCommand command) {
        boolean success = this.motionQPInputCalculator.convertSpatialVelocityCommand(command, this.qpInput);
        if (success) {
            this.qpSolver.addMotionInput(this.qpInput);
        }
    }

    public void submitJointspaceVelocityCommand(JointspaceVelocityCommand command) {
        boolean success = this.motionQPInputCalculator.convertJointspaceVelocityCommand(command, this.qpInput);
        if (success) {
            this.qpSolver.addMotionInput(this.qpInput);
        }
    }

    public void submitMomentumCommand(MomentumCommand command) {
        boolean success = this.motionQPInputCalculator.convertMomentumCommand(command, this.qpInput);
        if (success) {
            this.qpSolver.addMotionInput(this.qpInput);
        }
    }

    public void submitLinearMomentumConvexConstraint2DCommand(LinearMomentumConvexConstraint2DCommand command) {
        boolean success = this.motionQPInputCalculator.convertLinearMomentumConvexConstraint2DCommand(command, this.qpInput);
        if (success) {
            this.qpSolver.addMotionInput(this.qpInput);
        }
    }

    public void submitPrivilegedConfigurationCommand(PrivilegedConfigurationCommand command) {
        this.motionQPInputCalculator.updatePrivilegedConfiguration(command);
    }

    public void submitPrivilegedVelocityCommand(PrivilegedJointSpaceCommand command) {
        this.motionQPInputCalculator.submitPrivilegedVelocities(command);
    }

    public void submitJointLimitReductionCommand(JointLimitReductionCommand command) {
        this.boundCalculator.submitJointLimitReductionCommand(command);
    }

    public void submitJointLimitEnforcementMethodCommand(JointLimitEnforcementMethodCommand command) {
        this.boundCalculator.submitJointLimitEnforcementMethodCommand(command);
    }

    public void submitOptimizationSettingsCommand(InverseKinematicsOptimizationSettingsCommand command) {
        if (command.hasJointVelocityWeight()) {
            this.qpSolver.setVelocityRegularizationWeight(command.getJointVelocityWeight());
        }
        if (command.hasJointAccelerationWeight()) {
            this.qpSolver.setAccelerationRegularizationWeight(command.getJointAccelerationWeight());
        }
        if (command.hashJointVelocityLimitMode()) {
            this.boundCalculator.considerJointVelocityLimits(command.jointVelocityLimitMode == InverseKinematicsOptimizationSettingsCommand.JointVelocityLimitMode.ENABLED);
        }
    }
}

