/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.math.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class QuadrupedFeetLoadedTransition
implements StateTransitionCondition {
    protected final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final double MINIMUM_WEIGHT_FRACTION = 0.08333333333333333;
    private static final double TIME_WINDOW = 3.0;
    private final QuadrantDependentList<FootSwitchInterface> footSwitches;
    private final YoBoolean areFeetLoaded;
    private final YoDouble weightPerFootForLoaded;
    private final QuadrantDependentList<YoDouble> prepFootFzs = new QuadrantDependentList();
    private final QuadrantDependentList<SimpleMovingAverageFilteredYoVariable> prepFootFzAverages = new QuadrantDependentList();
    private final Wrench temporaryFootWrench = new Wrench();

    public QuadrupedFeetLoadedTransition(QuadrantDependentList<FootSwitchInterface> footSwitches, double controlDT, double gravityZ, double totalMass, YoRegistry parentRegistry) {
        this.footSwitches = footSwitches;
        int windowSize = (int)Math.floor(3.0 / controlDT);
        this.areFeetLoaded = new YoBoolean("areFeetLoaded", this.registry);
        this.weightPerFootForLoaded = new YoDouble("weightPerFootForLoaded", this.registry);
        this.weightPerFootForLoaded.set(gravityZ * totalMass * 0.08333333333333333);
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            YoDouble prepFootFz = new YoDouble("prep" + robotQuadrant.getCamelCaseName() + "FootFz", this.registry);
            SimpleMovingAverageFilteredYoVariable prepFootFzAverage = new SimpleMovingAverageFilteredYoVariable("prep" + robotQuadrant.getCamelCaseName() + "FootFzAverage", windowSize, prepFootFz, this.registry);
            this.prepFootFzs.put((Enum)robotQuadrant, (Object)prepFootFz);
            this.prepFootFzAverages.put((Enum)robotQuadrant, (Object)prepFootFzAverage);
        }
        parentRegistry.addChild(this.registry);
    }

    private boolean areFeetLoaded() {
        this.temporaryFootWrench.setToZero(ReferenceFrame.getWorldFrame());
        double averageWeight = 0.0;
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            YoDouble prepFootFz = (YoDouble)this.prepFootFzs.get((Enum)robotQuadrant);
            SimpleMovingAverageFilteredYoVariable prepFootFzAverage = (SimpleMovingAverageFilteredYoVariable)this.prepFootFzAverages.get((Enum)robotQuadrant);
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotQuadrant)).computeAndPackFootWrench(this.temporaryFootWrench);
            this.temporaryFootWrench.changeFrame(ReferenceFrame.getWorldFrame());
            prepFootFz.set(this.temporaryFootWrench.getLinearPartZ());
            prepFootFzAverage.update();
            averageWeight += prepFootFzAverage.getDoubleValue();
        }
        this.areFeetLoaded.set(averageWeight > 2.0 * this.weightPerFootForLoaded.getDoubleValue());
        return this.areFeetLoaded.getBooleanValue();
    }

    public boolean testCondition(double timeInState) {
        return this.areFeetLoaded();
    }
}

