/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions;

import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.stateTransitions.QuadrupedFeetLoadedTransition;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class QuadrupedFeetLoadedToWalkingStandTransition
extends QuadrupedFeetLoadedTransition {
    private final HighLevelControllerName nextStateEnum;
    private final YoEnum<HighLevelControllerName> requestedState;
    private final YoBoolean waitForRequest;
    private final YoDouble minimumTimeInState;

    public QuadrupedFeetLoadedToWalkingStandTransition(HighLevelControllerName nextStateEnum, YoEnum<HighLevelControllerName> requestedState, QuadrantDependentList<FootSwitchInterface> footSwitches, double controlDT, double totalMass, double gravityZ, HighLevelControllerParameters highLevelControllerParameters, YoRegistry parentRegistry) {
        super(footSwitches, controlDT, totalMass, gravityZ, parentRegistry);
        this.nextStateEnum = nextStateEnum;
        this.requestedState = requestedState;
        this.minimumTimeInState = new YoDouble("minimumTimeLoadingFeet", this.registry);
        this.minimumTimeInState.set(highLevelControllerParameters.getMinimumTimeInStandReady());
        this.waitForRequest = new YoBoolean("waitForRequestToTransitionToWalking", this.registry);
        this.waitForRequest.set(!highLevelControllerParameters.automaticallyTransitionToWalkingWhenReady());
    }

    @Override
    public boolean testCondition(double timeInState) {
        if (!super.testCondition(timeInState)) {
            return false;
        }
        if (timeInState < this.minimumTimeInState.getDoubleValue()) {
            return false;
        }
        boolean transitionRequested = this.nextStateEnum.equals((Object)this.requestedState.getEnumValue());
        if (this.waitForRequest.getBooleanValue()) {
            return transitionRequested;
        }
        return true;
    }
}

