/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.manipulation.individual;

import java.util.LinkedHashMap;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.NormOps_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.kinematics.InverseJacobianSolver;
import us.ihmc.robotics.math.YoSolvePseudoInverseSVDWithDampedLeastSquaresNearSingularities;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFramePoint;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameQuaternion;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class TaskspaceToJointspaceCalculator {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final RigidBodyTransform desiredControlFrameTransform = new RigidBodyTransform();
    private final FramePose3D desiredControlFramePose = new FramePose3D();
    private final Twist desiredControlFrameTwist = new Twist();
    private final OneDoFJointBasics[] originalJoints;
    private final OneDoFJointBasics[] localJoints;
    private final ReferenceFrame originalBaseFrame;
    private final ReferenceFrame localBaseFrame;
    private final ReferenceFrame originalBaseParentJointFrame;
    private final PoseReferenceFrame localBaseParentJointFrame;
    private final ReferenceFrame localEndEffectorFrame;
    private final ReferenceFrame originalEndEffectorFrame;
    private final ReferenceFrame localControlFrame;
    private ReferenceFrame originalControlFrame;
    private final Map<ReferenceFrame, ReferenceFrame> originalToLocalFramesMap = new LinkedHashMap<ReferenceFrame, ReferenceFrame>();
    private final GeometricJacobian jacobian;
    private final YoSolvePseudoInverseSVDWithDampedLeastSquaresNearSingularities solver;
    private final InverseJacobianSolver inverseJacobianSolver;
    private final int numberOfDoF;
    private final int maxNumberOfConstraints = 6;
    private final YoDouble jointAngleRegularizationWeight;
    private final YoInteger exponentForPNorm;
    private final YoEnum<SecondaryObjective> currentSecondaryObjective;
    private final YoDouble maximumJointVelocity;
    private final YoDouble maximumJointAcceleration;
    private final YoDouble maximumTaskspaceAngularVelocityMagnitude;
    private final YoDouble maximumTaskspaceLinearVelocityMagnitude;
    private final YoFramePoseUsingYawPitchRoll yoDesiredControlFramePose;
    private final YoFrameVector3D yoErrorRotation;
    private final YoFrameVector3D yoErrorTranslation;
    private final YoFrameVector3D yoAngularVelocityFromError;
    private final YoFrameVector3D yoLinearVelocityFromError;
    private final YoDouble alphaSpatialVelocityFromError;
    private final AlphaFilteredYoFrameVector filteredAngularVelocityFromError;
    private final AlphaFilteredYoFrameVector filteredLinearVelocityFromError;
    private final YoFramePoint3D yoBaseParentJointFramePosition;
    private final YoFrameQuaternion yoBaseParentJointFrameOrientation;
    private final YoDouble alphaBaseParentJointPose;
    private final AlphaFilteredYoFramePoint yoBaseParentJointFramePositionFiltered;
    private final AlphaFilteredYoFrameQuaternion yoBaseParentJointFrameOrientationFiltered;
    private final YoBoolean enableFeedbackControl;
    private final YoDouble kpTaskspaceAngularError;
    private final YoDouble kpTaskspaceLinearError;
    private final FramePoint3D baseParentJointFramePosition = new FramePoint3D();
    private final FrameQuaternion baseParentJointFrameOrientation = new FrameQuaternion();
    private final AxisAngle errorAxisAngle = new AxisAngle();
    private final Vector3D errorRotationVector = new Vector3D();
    private final Vector3D errorTranslationVector = new Vector3D();
    private final DMatrixRMaj spatialVelocityFromError = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj subspaceSpatialError = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj spatialDesiredVelocity = new DMatrixRMaj(6, 1);
    private final YoDouble[] yoPrivilegedJointPositions;
    private final AlphaFilteredYoVariable[] yoPrivilegedJointPositionsFiltered;
    private final DMatrixRMaj privilegedJointVelocities;
    private final DMatrixRMaj jointSquaredRangeOfMotions;
    private final DMatrixRMaj jointAnglesAtMidRangeOfMotion;
    private final DMatrixRMaj desiredJointAngles;
    private final DMatrixRMaj desiredJointVelocities;
    private final DMatrixRMaj desiredJointAccelerations;
    private final FramePose3D originalBasePose = new FramePose3D();
    private final double controlDT;
    private final AxisAngle tempAxisAngle = new AxisAngle();
    private final FrameVector3D angularPart = new FrameVector3D();
    private final FrameVector3D linearPart = new FrameVector3D();
    private final DMatrixRMaj subspaceSpatialVector = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempSpatialVector = new DMatrixRMaj(1, 1);
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final FrameVector3D tempPositionError = new FrameVector3D();
    private final DMatrixRMaj tempSpatialError = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempSubspaceError = new DMatrixRMaj(6, 1);
    private final FrameQuaternion tempOrientation = new FrameQuaternion();

    public TaskspaceToJointspaceCalculator(String namePrefix, RigidBodyBasics base, RigidBodyBasics endEffector, double controlDT, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.controlDT = controlDT;
        this.originalBaseParentJointFrame = base.getParentJoint().getFrameAfterJoint();
        this.originalBaseFrame = base.getBodyFixedFrame();
        this.localBaseParentJointFrame = new PoseReferenceFrame(base.getName() + "Local", worldFrame);
        String localBaseFrameName = this.originalBaseFrame.getName() + "Local";
        RigidBodyTransform transformToParent = this.originalBaseFrame.getTransformToDesiredFrame(this.originalBaseParentJointFrame);
        this.localBaseFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)localBaseFrameName, (ReferenceFrame)this.localBaseParentJointFrame, (RigidBodyTransformReadOnly)transformToParent);
        this.originalJoints = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)base, (RigidBodyBasics)endEffector);
        this.localJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])this.originalJoints, (String)"Local", (ReferenceFrame)this.localBaseParentJointFrame), OneDoFJointBasics.class);
        this.numberOfDoF = this.localJoints.length;
        this.originalEndEffectorFrame = endEffector.getBodyFixedFrame();
        this.originalControlFrame = endEffector.getBodyFixedFrame();
        this.localEndEffectorFrame = this.localJoints[this.numberOfDoF - 1].getSuccessor().getBodyFixedFrame();
        this.localControlFrame = this.createLocalControlFrame(this.localEndEffectorFrame, this.originalEndEffectorFrame);
        this.populateRefrenceFrameMap();
        this.jacobian = new GeometricJacobian((JointBasics[])this.localJoints, this.localEndEffectorFrame, true);
        this.solver = new YoSolvePseudoInverseSVDWithDampedLeastSquaresNearSingularities(namePrefix, 6, 6, this.registry);
        this.inverseJacobianSolver = new InverseJacobianSolver(6, this.numberOfDoF, (LinearSolverDense)this.solver);
        this.jointAngleRegularizationWeight = new YoDouble(namePrefix + "JointAngleRegularizationWeight", this.registry);
        this.exponentForPNorm = new YoInteger(namePrefix + "ExponentForPNorm", this.registry);
        this.exponentForPNorm.set(6);
        this.currentSecondaryObjective = new YoEnum(namePrefix + "SecondaryObjective", this.registry, SecondaryObjective.class);
        this.currentSecondaryObjective.set((Enum)SecondaryObjective.TOWARD_RESTING_CONFIGURATION);
        this.yoPrivilegedJointPositions = new YoDouble[this.numberOfDoF];
        this.yoPrivilegedJointPositionsFiltered = new AlphaFilteredYoVariable[this.numberOfDoF];
        this.privilegedJointVelocities = new DMatrixRMaj(this.numberOfDoF, 1);
        this.desiredJointAngles = new DMatrixRMaj(this.numberOfDoF, 1);
        this.desiredJointVelocities = new DMatrixRMaj(this.numberOfDoF, 1);
        this.desiredJointAccelerations = new DMatrixRMaj(this.numberOfDoF, 1);
        this.jointSquaredRangeOfMotions = new DMatrixRMaj(this.numberOfDoF, 1);
        this.jointAnglesAtMidRangeOfMotion = new DMatrixRMaj(this.numberOfDoF, 1);
        this.maximumJointVelocity = new YoDouble(namePrefix + "MaximumJointVelocity", this.registry);
        this.maximumJointVelocity.set(Double.POSITIVE_INFINITY);
        this.maximumJointAcceleration = new YoDouble(namePrefix + "MaximumJointAcceleration", this.registry);
        this.maximumJointAcceleration.set(Double.POSITIVE_INFINITY);
        this.maximumTaskspaceAngularVelocityMagnitude = new YoDouble(namePrefix + "MaximumTaskspaceAngularVelocityMagnitude", this.registry);
        this.maximumTaskspaceLinearVelocityMagnitude = new YoDouble(namePrefix + "MaximumTaskspaceLinearVelocityMagnitude", this.registry);
        this.maximumTaskspaceAngularVelocityMagnitude.set(Double.POSITIVE_INFINITY);
        this.maximumTaskspaceLinearVelocityMagnitude.set(Double.POSITIVE_INFINITY);
        for (int i = 0; i < this.numberOfDoF; ++i) {
            String jointName = this.originalJoints[i].getName();
            this.yoPrivilegedJointPositions[i] = new YoDouble("q_privileged_" + jointName, this.registry);
            this.yoPrivilegedJointPositionsFiltered[i] = new AlphaFilteredYoVariable("q_privileged_filt_" + jointName, this.registry, 0.99, this.yoPrivilegedJointPositions[i]);
            this.jointSquaredRangeOfMotions.set(i, 0, MathTools.square((double)(this.localJoints[i].getJointLimitUpper() - this.localJoints[i].getJointLimitLower())));
            this.jointAnglesAtMidRangeOfMotion.set(i, 0, 0.5 * (this.localJoints[i].getJointLimitUpper() + this.localJoints[i].getJointLimitLower()));
        }
        this.yoDesiredControlFramePose = new YoFramePoseUsingYawPitchRoll(namePrefix + "Desired", worldFrame, this.registry);
        this.yoErrorRotation = new YoFrameVector3D(namePrefix + "ErrorRotation", this.localControlFrame, this.registry);
        this.yoErrorTranslation = new YoFrameVector3D(namePrefix + "ErrorTranslation", this.localControlFrame, this.registry);
        this.yoAngularVelocityFromError = new YoFrameVector3D(namePrefix + "AngularVelocityFromError", this.localControlFrame, this.registry);
        this.yoLinearVelocityFromError = new YoFrameVector3D(namePrefix + "LinearVelocityFromError", this.localControlFrame, this.registry);
        this.alphaSpatialVelocityFromError = new YoDouble(namePrefix + "AlphaSpatialVelocityFromError", this.registry);
        this.filteredAngularVelocityFromError = new AlphaFilteredYoFrameVector(namePrefix + "FilteredAngularVelocityFromError", "", this.registry, (DoubleProvider)this.alphaSpatialVelocityFromError, (FrameTuple3DReadOnly)this.yoAngularVelocityFromError);
        this.filteredLinearVelocityFromError = new AlphaFilteredYoFrameVector(namePrefix + "FilteredLinearVelocityFromError", "", this.registry, (DoubleProvider)this.alphaSpatialVelocityFromError, (FrameTuple3DReadOnly)this.yoLinearVelocityFromError);
        this.yoBaseParentJointFramePosition = new YoFramePoint3D(namePrefix + "BaseParentJointFrame", worldFrame, this.registry);
        this.yoBaseParentJointFrameOrientation = new YoFrameQuaternion(namePrefix + "BaseParentJointFrame", worldFrame, this.registry);
        this.alphaBaseParentJointPose = new YoDouble(namePrefix + "AlphaBaseParentJointPose", this.registry);
        this.yoBaseParentJointFramePositionFiltered = new AlphaFilteredYoFramePoint(namePrefix + "BaseParentJointFramePositionFiltered", "", this.registry, (DoubleProvider)this.alphaBaseParentJointPose, (FrameTuple3DReadOnly)this.yoBaseParentJointFramePosition);
        this.yoBaseParentJointFrameOrientationFiltered = new AlphaFilteredYoFrameQuaternion(namePrefix + "BaseParentJointFrameOrientationFiltered", "", this.yoBaseParentJointFrameOrientation, (DoubleProvider)this.alphaBaseParentJointPose, this.registry);
        this.enableFeedbackControl = new YoBoolean(namePrefix + "EnableFeedBackControl", this.registry);
        this.kpTaskspaceAngularError = new YoDouble(namePrefix + "KpTaskspaceAngularError", this.registry);
        this.kpTaskspaceLinearError = new YoDouble(namePrefix + "KpTaskspaceLinearError", this.registry);
        parentRegistry.addChild(this.registry);
    }

    private void populateRefrenceFrameMap() {
        this.originalToLocalFramesMap.put(this.originalBaseParentJointFrame, (ReferenceFrame)this.localBaseParentJointFrame);
        this.originalToLocalFramesMap.put(this.originalControlFrame, this.localControlFrame);
        this.originalToLocalFramesMap.put(this.originalBaseFrame, this.localBaseFrame);
        for (int i = 0; i < this.numberOfDoF; ++i) {
            OneDoFJointBasics originalJoint = this.originalJoints[i];
            RigidBodyBasics originalBody = originalJoint.getSuccessor();
            OneDoFJointBasics localJoint = this.localJoints[i];
            RigidBodyBasics localBody = localJoint.getSuccessor();
            this.originalToLocalFramesMap.put((ReferenceFrame)originalJoint.getFrameAfterJoint(), (ReferenceFrame)localJoint.getFrameAfterJoint());
            this.originalToLocalFramesMap.put((ReferenceFrame)originalJoint.getFrameBeforeJoint(), (ReferenceFrame)localJoint.getFrameBeforeJoint());
            this.originalToLocalFramesMap.put((ReferenceFrame)originalBody.getBodyFixedFrame(), (ReferenceFrame)localBody.getBodyFixedFrame());
        }
    }

    private ReferenceFrame createLocalControlFrame(ReferenceFrame localEndEffectorFrame, final ReferenceFrame originalEndEffectorFrame) {
        ReferenceFrame localControlFrame = new ReferenceFrame("controlFrame", localEndEffectorFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                TaskspaceToJointspaceCalculator.this.originalControlFrame.getTransformToDesiredFrame(transformToParent, originalEndEffectorFrame);
            }
        };
        return localControlFrame;
    }

    public void setupWithDefaultParameters() {
        this.setFullyConstrained();
        this.setPrivilegedJointPositionsToMidRange();
        this.setJointAngleRegularizationWeight(5.0);
        this.setMaximumJointVelocity(5.0);
        this.setMaximumJointAcceleration(50.0);
        this.setMaximumTaskspaceVelocity(1.5, 0.5);
        this.setFilterBreakFrequencyForBaseFrameUpdater(1.0);
        this.setEnableFeedbackControl(false);
        this.setTaskspaceProportionalGainsForFeedbackControl(0.3, 0.3);
        this.setTaskspaceVelocityFromErrorFilterBreakFrequency(Double.POSITIVE_INFINITY);
    }

    public void setSelectionMatrix(DMatrixRMaj selectionMatrix) {
        this.inverseJacobianSolver.setSelectionMatrix(selectionMatrix);
    }

    public void setFullyConstrained() {
        this.inverseJacobianSolver.setSelectionMatrixForFullConstraint();
    }

    public void setControlFrameFixedInEndEffector(ReferenceFrame controlFrame) {
        this.originalControlFrame = controlFrame;
        this.localControlFrame.update();
        this.jacobian.changeFrame(this.localControlFrame);
    }

    public void initialize(DMatrixRMaj jointAngles) {
        this.setLocalBaseFrameToActualAndResetFilters();
        MultiBodySystemTools.insertJointsState((JointBasics[])this.localJoints, (JointStateType)JointStateType.CONFIGURATION, (DMatrix)jointAngles);
        this.localJoints[0].updateFramesRecursively();
    }

    public void initializeFromCurrentJointAngles() {
        this.setLocalBaseFrameToActualAndResetFilters();
        this.setLocalJointAnglesToCurrentJointAngles();
    }

    private void setLocalJointAnglesToCurrentJointAngles() {
        for (int i = 0; i < this.numberOfDoF; ++i) {
            this.localJoints[i].setQ(this.originalJoints[i].getQ());
            this.localJoints[i].getFrameAfterJoint().update();
        }
    }

    public void setSecondaryObjective(SecondaryObjective secondaryObjective) {
        this.currentSecondaryObjective.set((Enum)secondaryObjective);
    }

    public void setJointAngleRegularizationWeight(double weight) {
        this.jointAngleRegularizationWeight.set(weight);
    }

    public void setPrivilegedJointPositionsToMidRange() {
        for (int i = 0; i < this.numberOfDoF; ++i) {
            this.yoPrivilegedJointPositions[i].set(this.jointAnglesAtMidRangeOfMotion.get(i, 0));
        }
    }

    public void setPrivilegedJointPositionsToZero() {
        for (int i = 0; i < this.numberOfDoF; ++i) {
            this.yoPrivilegedJointPositions[i].set(0.0);
        }
    }

    public void setPrivilegedJointPosition(int jointIndex, double qPrivileged) {
        this.yoPrivilegedJointPositions[jointIndex].set(qPrivileged);
    }

    public void setMaximumJointVelocity(double maximumJointVelocity) {
        this.maximumJointVelocity.set(maximumJointVelocity);
    }

    public void setMaximumJointAngleCorrection(double maximumJointAngleCorrection) {
        this.maximumJointVelocity.set(maximumJointAngleCorrection / this.controlDT);
    }

    public void setMaximumJointAcceleration(double maximumJointAcceleration) {
        this.maximumJointAcceleration.set(maximumJointAcceleration);
    }

    public void setMaximumTaskspaceVelocity(double maximumAngularVelocity, double maximumLinearVelocity) {
        this.maximumTaskspaceAngularVelocityMagnitude.set(maximumAngularVelocity);
        this.maximumTaskspaceLinearVelocityMagnitude.set(maximumLinearVelocity);
    }

    public void setTaskspaceVelocityFromErrorFilterBreakFrequency(double breakFrequency) {
        this.alphaSpatialVelocityFromError.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)breakFrequency, (double)this.controlDT));
    }

    public void setFilterBreakFrequencyForBaseFrameUpdater(double breakFrequency) {
        this.alphaBaseParentJointPose.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)breakFrequency, (double)this.controlDT));
    }

    public void setEnableFeedbackControl(boolean enable) {
        this.enableFeedbackControl.set(enable);
    }

    public void setTaskspaceProportionalGainsForFeedbackControl(double kPAngularError, double kPLinearError) {
        this.kpTaskspaceAngularError.set(kPAngularError);
        this.kpTaskspaceLinearError.set(kPLinearError);
    }

    public void compute(FramePoint3D desiredPosition, FrameQuaternion desiredOrientation, FrameVector3D desiredLinearVelocity, FrameVector3D desiredAngularVelocity) {
        this.desiredControlFramePose.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition, (FrameOrientation3DReadOnly)desiredOrientation);
        this.desiredControlFrameTwist.setIncludingFrame(this.originalEndEffectorFrame, this.originalBaseFrame, this.originalControlFrame, (Vector3DReadOnly)desiredAngularVelocity, (Vector3DReadOnly)desiredLinearVelocity);
        this.compute(this.desiredControlFramePose, (TwistReadOnly)this.desiredControlFrameTwist);
    }

    public void compute(FramePose3D desiredPose, TwistReadOnly desiredTwist) {
        this.jacobian.compute();
        this.desiredControlFramePose.setIncludingFrame((FramePose3DReadOnly)desiredPose);
        this.desiredControlFrameTwist.setIncludingFrame((SpatialMotionReadOnly)desiredTwist);
        this.computeJointAnglesAndVelocities(this.desiredControlFramePose, (TwistReadOnly)this.desiredControlFrameTwist);
    }

    public boolean computeIteratively(FramePose3D desiredPose, TwistReadOnly desiredTwist, double maxIterations, double epsilon) {
        int i = 0;
        while ((double)i < maxIterations) {
            this.compute(desiredPose, desiredTwist);
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)desiredPose.getPosition());
            this.tempPoint.changeFrame(this.localControlFrame);
            double translationDistance = this.tempPoint.distanceFromOrigin();
            this.tempOrientation.setIncludingFrame((FrameQuaternionReadOnly)desiredPose.getOrientation());
            this.tempOrientation.changeFrame(this.localControlFrame);
            this.tempAxisAngle.set((Orientation3DReadOnly)this.tempOrientation);
            double angle = Math.abs(AngleTools.trimAngleMinusPiToPi((double)this.tempAxisAngle.getAngle()));
            if (translationDistance < epsilon && angle < epsilon) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void computeJointAnglesAndVelocities(FramePose3D desiredControlFramePose, TwistReadOnly desiredControlFrameTwist) {
        if (this.enableFeedbackControl.getBooleanValue()) {
            this.setLocalJointAnglesToCurrentJointAngles();
        }
        this.updateLocalBaseFrame();
        desiredControlFrameTwist.checkReferenceFrameMatch(this.originalEndEffectorFrame, this.originalBaseFrame, this.originalControlFrame);
        this.yoDesiredControlFramePose.setMatchingFrame((FramePose3DReadOnly)desiredControlFramePose);
        ReferenceFrame originalControlledWithRespectToFrame = desiredControlFramePose.getReferenceFrame();
        ReferenceFrame localControlledWithRespectToFrame = this.originalToLocalFramesMap.get(originalControlledWithRespectToFrame);
        if (localControlledWithRespectToFrame != null) {
            desiredControlFramePose.get((RigidBodyTransformBasics)this.desiredControlFrameTransform);
            desiredControlFramePose.setIncludingFrame(localControlledWithRespectToFrame, (RigidBodyTransformReadOnly)this.desiredControlFrameTransform);
        }
        desiredControlFramePose.changeFrame(this.localControlFrame);
        this.errorAxisAngle.set((Orientation3DReadOnly)desiredControlFramePose.getOrientation());
        this.errorRotationVector.set(this.errorAxisAngle.getX(), this.errorAxisAngle.getY(), this.errorAxisAngle.getZ());
        this.errorRotationVector.scale(this.errorAxisAngle.getAngle());
        this.errorTranslationVector.set((Tuple3DReadOnly)desiredControlFramePose.getPosition());
        this.yoErrorRotation.set((Tuple3DReadOnly)this.errorRotationVector);
        this.yoErrorTranslation.set((Tuple3DReadOnly)this.errorTranslationVector);
        if (this.enableFeedbackControl.getBooleanValue()) {
            this.errorRotationVector.scale(this.kpTaskspaceAngularError.getDoubleValue());
            this.errorTranslationVector.scale(this.kpTaskspaceLinearError.getDoubleValue());
        }
        this.errorRotationVector.get(0, (DMatrix)this.spatialVelocityFromError);
        this.errorTranslationVector.get(3, (DMatrix)this.spatialVelocityFromError);
        CommonOps_DDRM.scale((double)(1.0 / this.controlDT), (DMatrixD1)this.spatialVelocityFromError);
        this.computeDesiredSpatialVelocityToSolveFor(this.spatialDesiredVelocity, this.spatialVelocityFromError, desiredControlFrameTwist);
        if (this.currentSecondaryObjective.getEnumValue() == SecondaryObjective.TOWARD_RESTING_CONFIGURATION) {
            this.computePrivilegedJointVelocitiesForPriviligedJointAngles(this.privilegedJointVelocities, this.jointAngleRegularizationWeight.getDoubleValue());
        } else {
            this.computePrivilegedVelocitiesForStayingAwayFromJointLimits(this.privilegedJointVelocities, this.jointAngleRegularizationWeight.getDoubleValue());
        }
        this.inverseJacobianSolver.solveUsingNullspaceMethod(this.spatialDesiredVelocity, this.jacobian.getJacobianMatrix(), this.privilegedJointVelocities);
        this.desiredJointVelocities.set((DMatrixD1)this.inverseJacobianSolver.getJointspaceVelocity());
        if (Double.isNaN(this.desiredJointVelocities.get(0))) {
            throw new RuntimeException("Invalid computed desired joint velocities: " + this.desiredJointVelocities.toString());
        }
        this.subspaceSpatialError.reshape(this.inverseJacobianSolver.getNumberOfConstraints(), 1);
        this.subspaceSpatialError.set((DMatrixD1)this.inverseJacobianSolver.getSubspaceSpatialVelocity());
        CommonOps_DDRM.scale((double)this.controlDT, (DMatrixD1)this.subspaceSpatialError);
        for (int i = 0; i < this.numberOfDoF; ++i) {
            OneDoFJointBasics joint = this.localJoints[i];
            double qDotDesired = MathTools.clamp((double)this.desiredJointVelocities.get(i, 0), (double)this.maximumJointVelocity.getDoubleValue());
            double qDotDotDesired = (qDotDesired - joint.getQd()) / this.controlDT;
            qDotDotDesired = MathTools.clamp((double)qDotDotDesired, (double)this.maximumJointAcceleration.getDoubleValue());
            qDotDesired = joint.getQd() + qDotDotDesired * this.controlDT;
            double qDesired = joint.getQ() + qDotDesired * this.controlDT;
            qDesired = MathTools.clamp((double)qDesired, (double)joint.getJointLimitLower(), (double)joint.getJointLimitUpper());
            qDotDesired = (qDesired - joint.getQ()) / this.controlDT;
            qDotDotDesired = (qDotDesired - joint.getQd()) / this.controlDT;
            joint.setQ(qDesired);
            joint.setQd(qDotDesired);
            joint.setQdd(qDotDotDesired);
            this.desiredJointAngles.set(i, qDesired);
            this.desiredJointVelocities.set(i, 0, qDotDesired);
            this.desiredJointAccelerations.set(i, 0, qDotDotDesired);
            joint.getFrameAfterJoint().update();
        }
    }

    private void updateLocalBaseFrame() {
        this.originalBasePose.setToZero(this.originalBaseParentJointFrame);
        this.originalBasePose.changeFrame(worldFrame);
        this.originalBasePose.get((FrameTuple3DBasics)this.baseParentJointFramePosition, (FrameOrientation3DBasics)this.baseParentJointFrameOrientation);
        this.yoBaseParentJointFrameOrientation.set((FrameQuaternionReadOnly)this.baseParentJointFrameOrientation);
        this.yoBaseParentJointFramePosition.set((FrameTuple3DReadOnly)this.baseParentJointFramePosition);
        this.yoBaseParentJointFrameOrientationFiltered.update();
        this.yoBaseParentJointFramePositionFiltered.update();
        this.baseParentJointFrameOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.yoBaseParentJointFrameOrientationFiltered);
        this.baseParentJointFramePosition.setIncludingFrame((FrameTuple3DReadOnly)this.yoBaseParentJointFramePositionFiltered);
        this.localBaseParentJointFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.baseParentJointFramePosition, (FrameOrientation3DReadOnly)this.baseParentJointFrameOrientation);
        this.updateFrames();
    }

    private void setLocalBaseFrameToActualAndResetFilters() {
        this.yoBaseParentJointFrameOrientationFiltered.reset();
        this.yoBaseParentJointFramePositionFiltered.reset();
        this.updateLocalBaseFrame();
    }

    private void computeDesiredSpatialVelocityToSolveFor(DMatrixRMaj spatialDesiredVelocityToPack, DMatrixRMaj spatialVelocityFromError, TwistReadOnly desiredControlFrameTwist) {
        DMatrixRMaj selectionMatrix = this.inverseJacobianSolver.getSelectionMatrix();
        this.clipSpatialVector(spatialVelocityFromError, selectionMatrix, this.maximumTaskspaceAngularVelocityMagnitude.getDoubleValue(), this.maximumTaskspaceLinearVelocityMagnitude.getDoubleValue());
        this.getAngularAndLinearPartsFromSpatialVector(this.yoAngularVelocityFromError, this.yoLinearVelocityFromError, spatialVelocityFromError);
        this.filteredAngularVelocityFromError.update();
        this.filteredLinearVelocityFromError.update();
        this.setSpatialVectorFromAngularAndLinearParts(spatialVelocityFromError, (YoFrameVector3D)this.filteredAngularVelocityFromError, (YoFrameVector3D)this.filteredLinearVelocityFromError);
        desiredControlFrameTwist.get(0, (DMatrix)spatialDesiredVelocityToPack);
        CommonOps_DDRM.add((DMatrixD1)spatialVelocityFromError, (DMatrixD1)spatialDesiredVelocityToPack, (DMatrixD1)spatialDesiredVelocityToPack);
    }

    private void clipSpatialVector(DMatrixRMaj spatialVectorToClip, DMatrixRMaj selectionMatrix, double maximumAngularMagnitude, double maximumLinearMagnitude) {
        this.getAngularAndLinearPartsFromSpatialVector(this.angularPart, this.linearPart, spatialVectorToClip);
        this.subspaceSpatialVector.reshape(selectionMatrix.getNumRows(), 1);
        this.tempSpatialVector.reshape(6, 1);
        this.angularPart.get(0, (DMatrix)this.tempSpatialVector);
        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.tempSpatialVector, (DMatrix1Row)this.subspaceSpatialVector);
        double angularPartmagnitude = NormOps_DDRM.normP2((DMatrixRMaj)this.subspaceSpatialVector);
        if (angularPartmagnitude > maximumAngularMagnitude) {
            this.angularPart.scale(maximumAngularMagnitude / angularPartmagnitude);
        }
        this.subspaceSpatialVector.reshape(selectionMatrix.getNumRows(), 1);
        this.tempSpatialVector.reshape(6, 1);
        this.linearPart.get(3, (DMatrix)this.tempSpatialVector);
        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.tempSpatialVector, (DMatrix1Row)this.subspaceSpatialVector);
        double linearPartMagnitude = NormOps_DDRM.normP2((DMatrixRMaj)this.subspaceSpatialVector);
        if (linearPartMagnitude > maximumAngularMagnitude) {
            this.linearPart.scale(maximumAngularMagnitude / linearPartMagnitude);
        }
        this.setSpatialVectorFromAngularAndLinearParts(spatialVectorToClip, this.angularPart, this.linearPart);
    }

    private void timeDerivative(DMatrixRMaj spatialVectorRateToPack, DMatrixRMaj spatialVector, DMatrixRMaj previousSpatialVector) {
        CommonOps_DDRM.subtract((DMatrixD1)spatialVector, (DMatrixD1)previousSpatialVector, (DMatrixD1)spatialVectorRateToPack);
        CommonOps_DDRM.scale((double)(1.0 / this.controlDT), (DMatrixD1)spatialVectorRateToPack);
    }

    private void timeIntegration(DMatrixRMaj spatialVectorToPack, DMatrixRMaj previousSpatialVector, DMatrixRMaj spatialVectorRate) {
        CommonOps_DDRM.add((DMatrixD1)previousSpatialVector, (double)this.controlDT, (DMatrixD1)spatialVectorRate, (DMatrixD1)spatialVectorToPack);
    }

    private void getAngularAndLinearPartsFromSpatialVector(YoFrameVector3D angularPartToPack, YoFrameVector3D linearPartToPack, DMatrixRMaj spatialVector) {
        this.getAngularAndLinearPartsFromSpatialVector(this.angularPart, this.linearPart, spatialVector);
        angularPartToPack.setMatchingFrame((FrameTuple3DReadOnly)this.angularPart);
        linearPartToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearPart);
    }

    private void getAngularAndLinearPartsFromSpatialVector(FrameVector3D angularPartToPack, FrameVector3D linearPartToPack, DMatrixRMaj spatialVector) {
        angularPartToPack.setIncludingFrame(this.localControlFrame, 0, (DMatrix)spatialVector);
        linearPartToPack.setIncludingFrame(this.localControlFrame, 3, (DMatrix)spatialVector);
    }

    private void setSpatialVectorFromAngularAndLinearParts(DMatrixRMaj spatialVectorToPack, YoFrameVector3D yoAngularPart, YoFrameVector3D yoLinearPart) {
        this.angularPart.setIncludingFrame((FrameTuple3DReadOnly)yoAngularPart);
        this.linearPart.setIncludingFrame((FrameTuple3DReadOnly)yoLinearPart);
        this.angularPart.get(0, (DMatrix)spatialVectorToPack);
        this.linearPart.get(3, (DMatrix)spatialVectorToPack);
    }

    private void setSpatialVectorFromAngularAndLinearParts(DMatrixRMaj spatialVectorToPack, FrameVector3D angularPart, FrameVector3D linearPart) {
        angularPart.get(0, (DMatrix)spatialVectorToPack);
        linearPart.get(3, (DMatrix)spatialVectorToPack);
    }

    private void computePrivilegedJointVelocitiesForPriviligedJointAngles(DMatrixRMaj privilegedJointVelocitiesToPack, double weight) {
        for (int i = 0; i < this.numberOfDoF; ++i) {
            this.yoPrivilegedJointPositionsFiltered[i].update();
            privilegedJointVelocitiesToPack.set(i, 0, -2.0 * weight * (this.localJoints[i].getQ() - this.yoPrivilegedJointPositionsFiltered[i].getDoubleValue()) / this.jointSquaredRangeOfMotions.get(i, 0));
        }
    }

    private void computePrivilegedVelocitiesForStayingAwayFromJointLimits(DMatrixRMaj privilegedJointVelocitiesToPack, double weight) {
        int i;
        int p = this.exponentForPNorm.getIntegerValue();
        double sumOfPows = 0.0;
        double pThRootOfSumOfPows = 0.0;
        for (i = 0; i < this.numberOfDoF; ++i) {
            sumOfPows += MathTools.pow((double)Math.abs(this.localJoints[i].getQ() - this.jointAnglesAtMidRangeOfMotion.get(i, 0)), (int)p);
        }
        pThRootOfSumOfPows = Math.pow(sumOfPows, 1.0 / (double)p);
        for (i = 0; i < this.numberOfDoF; ++i) {
            double numerator = MathTools.pow((double)Math.abs(this.localJoints[i].getQ() - this.jointAnglesAtMidRangeOfMotion.get(i, 0)), (int)(p - 1)) * pThRootOfSumOfPows;
            double qDotPrivileged = -weight * numerator / sumOfPows;
            privilegedJointVelocitiesToPack.set(i, 0, qDotPrivileged);
        }
    }

    private void updateFrames() {
        this.localJoints[0].getPredecessor().updateFramesRecursively();
    }

    public ReferenceFrame getControlFrame() {
        return this.originalControlFrame;
    }

    public DMatrixRMaj getSubspaceSpatialError() {
        return this.subspaceSpatialError;
    }

    public double getSpatialErrorScalar() {
        return NormOps_DDRM.normP2((DMatrixRMaj)this.subspaceSpatialError);
    }

    public double getNormPositionError(FramePoint3D desiredPosition) {
        this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.tempPoint.changeFrame(this.localControlFrame);
        this.tempPositionError.setIncludingFrame((FrameTuple3DReadOnly)this.tempPoint);
        DMatrixRMaj selectionMatrix = this.inverseJacobianSolver.getSelectionMatrix();
        this.tempSpatialError.reshape(6, 1);
        this.tempSubspaceError.reshape(selectionMatrix.getNumRows(), 1);
        this.tempPositionError.get(3, (DMatrix)this.tempSpatialError);
        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.tempSpatialError, (DMatrix1Row)this.tempSubspaceError);
        return NormOps_DDRM.normP2((DMatrixRMaj)this.tempSubspaceError);
    }

    public double getNormRotationError(FrameQuaternion desiredOrientation) {
        this.tempOrientation.setIncludingFrame((FrameQuaternionReadOnly)desiredOrientation);
        this.tempOrientation.changeFrame(this.localControlFrame);
        this.errorAxisAngle.set((Orientation3DReadOnly)this.tempOrientation);
        this.errorRotationVector.set(this.errorAxisAngle.getX(), this.errorAxisAngle.getY(), this.errorAxisAngle.getZ());
        this.errorRotationVector.scale(this.errorAxisAngle.getAngle());
        DMatrixRMaj selectionMatrix = this.inverseJacobianSolver.getSelectionMatrix();
        this.tempSpatialError.reshape(6, 1);
        this.tempSubspaceError.reshape(selectionMatrix.getNumRows(), 1);
        this.errorRotationVector.get((DMatrix)this.tempSpatialError);
        CommonOps_DDRM.mult((DMatrix1Row)selectionMatrix, (DMatrix1Row)this.tempSpatialError, (DMatrix1Row)this.tempSubspaceError);
        return NormOps_DDRM.normP2((DMatrixRMaj)this.tempSubspaceError);
    }

    public DMatrixRMaj getDesiredJointAngles() {
        return this.desiredJointAngles;
    }

    public DMatrixRMaj getDesiredJointVelocities() {
        return this.desiredJointVelocities;
    }

    public DMatrixRMaj getDesiredJointAccelerations() {
        return this.desiredJointAccelerations;
    }

    public void getDesiredJointAngles(DMatrixRMaj desiredJointAnglesToPack) {
        desiredJointAnglesToPack.reshape(this.numberOfDoF, 1);
        desiredJointAnglesToPack.set((DMatrixD1)this.desiredJointAngles);
    }

    public void getDesiredJointVelocities(DMatrixRMaj desiredJointVelocitiesToPack) {
        desiredJointVelocitiesToPack.reshape(this.numberOfDoF, 1);
        desiredJointVelocitiesToPack.set((DMatrixD1)this.desiredJointVelocities);
    }

    public void getDesiredJointAccelerationsIntoOneDoFJoints(OneDoFJointBasics[] joints) {
        MultiBodySystemTools.insertJointsState((JointBasics[])joints, (JointStateType)JointStateType.ACCELERATION, (DMatrix)this.desiredJointAccelerations);
    }

    public double computeDeterminant() {
        this.jacobian.compute();
        return this.inverseJacobianSolver.computeDeterminant(this.jacobian.getJacobianMatrix());
    }

    public double getLastComputedDeterminant() {
        return this.inverseJacobianSolver.getLastComputedDeterminant();
    }

    public void getDesiredEndEffectorPoseFromQDesireds(FramePose3D desiredPose, ReferenceFrame desiredFrame) {
        desiredPose.setToZero(this.localControlFrame);
        desiredPose.changeFrame(desiredFrame);
    }

    public FrameVector3D getInitialHandPoseVelocity(ReferenceFrame referenceFrame) {
        return new FrameVector3D(referenceFrame);
    }

    public FrameVector3D getInitialHandPoseAngularVelocity(ReferenceFrame referenceFrame) {
        return new FrameVector3D(referenceFrame);
    }

    public static enum SecondaryObjective {
        TOWARD_RESTING_CONFIGURATION,
        AWAY_FROM_JOINT_LIMITS;

    }
}

