/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FootControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.TouchdownErrorCompensator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class TransferToStandingState
extends WalkingState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoDouble maxICPErrorToSwitchToStanding;
    private final YoBoolean doFootExplorationInTransferToStanding;
    private final WalkingMessageHandler walkingMessageHandler;
    private final TouchdownErrorCompensator touchdownErrorCompensator;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final CenterOfMassHeightManager comHeightManager;
    private final BalanceManager balanceManager;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final FeetManager feetManager;
    private final LegConfigurationManager legConfigurationManager;
    private final FramePoint3D actualFootPositionInWorld;
    private final Point3D midFootPosition;
    private final FramePoint2D filteredDesiredCoP;

    public TransferToStandingState(WalkingMessageHandler walkingMessageHandler, TouchdownErrorCompensator touchdownErrorCompensator, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(WalkingStateEnum.TO_STANDING, parentRegistry);
        this.maxICPErrorToSwitchToStanding = new YoDouble("maxICPErrorToSwitchToStanding", this.registry);
        this.doFootExplorationInTransferToStanding = new YoBoolean("doFootExplorationInTransferToStanding", this.registry);
        this.actualFootPositionInWorld = new FramePoint3D();
        this.midFootPosition = new Point3D();
        this.filteredDesiredCoP = new FramePoint2D();
        this.maxICPErrorToSwitchToStanding.set(0.025);
        this.walkingMessageHandler = walkingMessageHandler;
        this.touchdownErrorCompensator = touchdownErrorCompensator;
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        this.doFootExplorationInTransferToStanding.set(false);
    }

    public void doAction(double timeInState) {
        this.balanceManager.computeICPPlan();
        this.switchToPointToeOffIfAlreadyInLine();
        this.comHeightManager.setSupportLeg(RobotSide.LEFT);
    }

    public void switchToPointToeOffIfAlreadyInLine() {
        RobotSide sideOnToes = this.getSideThatCouldBeOnToes();
        if (sideOnToes == null) {
            return;
        }
        if (this.feetManager.getCurrentConstraintType(sideOnToes) == FootControlModule.ConstraintType.TOES && !this.feetManager.isUsingPointContactInToeOff(sideOnToes) && !this.feetManager.useToeLineContactInTransfer()) {
            FramePoint3DReadOnly trailingFootExitCMP = this.balanceManager.getFirstExitCMPForToeOff(true);
            this.controllerToolbox.getFilteredDesiredCenterOfPressure((ContactablePlaneBody)this.controllerToolbox.getContactableFeet().get((Enum)sideOnToes), this.filteredDesiredCoP);
            this.feetManager.requestPointToeOff(sideOnToes, trailingFootExitCMP, (FramePoint2DReadOnly)this.filteredDesiredCoP);
        }
    }

    private RobotSide getSideThatCouldBeOnToes() {
        WalkingStateEnum previousWalkingState = this.getPreviousWalkingStateEnum();
        if (previousWalkingState == null) {
            return null;
        }
        RobotSide sideOnToes = null;
        if (previousWalkingState.isSingleSupport()) {
            sideOnToes = previousWalkingState.getSupportSide();
        } else if (previousWalkingState.getTransferToSide() != null) {
            sideOnToes = previousWalkingState.getTransferToSide().getOppositeSide();
        }
        return sideOnToes;
    }

    private RobotSide getSideCarryingMostWeight(Footstep leftFootstep, Footstep rightFootstep) {
        boolean rightStepLower;
        WalkingStateEnum previousWalkingState = this.getPreviousWalkingStateEnum();
        if (previousWalkingState == null) {
            return null;
        }
        RobotSide mostSupportingSide = null;
        boolean leftStepLower = leftFootstep.getZ() <= rightFootstep.getZ();
        boolean bl = rightStepLower = leftFootstep.getZ() > rightFootstep.getZ();
        if (previousWalkingState.isSingleSupport() && leftStepLower) {
            mostSupportingSide = RobotSide.LEFT;
        } else if (previousWalkingState.isSingleSupport() && rightStepLower) {
            mostSupportingSide = RobotSide.RIGHT;
        } else if (previousWalkingState.getTransferToSide() != null) {
            mostSupportingSide = previousWalkingState.getTransferToSide().getOppositeSide();
        }
        return mostSupportingSide;
    }

    public boolean isDone(double timeInState) {
        if (!this.balanceManager.isICPPlanDone()) {
            return false;
        }
        return this.balanceManager.getICPErrorMagnitude() < this.maxICPErrorToSwitchToStanding.getDoubleValue();
    }

    public void onEntry() {
        this.balanceManager.clearICPPlan();
        this.balanceManager.clearSwingFootTrajectory();
        this.balanceManager.resetPushRecovery();
        WalkingStateEnum previousStateEnum = this.getPreviousWalkingStateEnum();
        if (previousStateEnum != null && previousStateEnum.isSingleSupport()) {
            this.balanceManager.setHoldSplitFractions(true);
        }
        if (previousStateEnum != null && previousStateEnum.isDoubleSupport()) {
            this.feetManager.initializeContactStatesForDoubleSupport(null);
        }
        RobotSide previousSupportSide = null;
        if (previousStateEnum != null) {
            if (previousStateEnum.getSupportSide() != null) {
                previousSupportSide = previousStateEnum.getSupportSide();
            } else if (previousStateEnum.getTransferToSide() != null) {
                previousSupportSide = previousStateEnum.getTransferToSide();
            }
        }
        if (this.doFootExplorationInTransferToStanding.getBooleanValue() && previousSupportSide != null) {
            this.feetManager.initializeFootExploration(previousSupportSide.getOppositeSide());
        }
        this.controllerToolbox.updateBipedSupportPolygons();
        this.failureDetectionControlModule.setNextFootstep(null);
        Footstep footstepLeft = this.walkingMessageHandler.getFootstepAtCurrentLocation(RobotSide.LEFT);
        Footstep footstepRight = this.walkingMessageHandler.getFootstepAtCurrentLocation(RobotSide.RIGHT);
        RobotSide supportingSide = this.getSideCarryingMostWeight(footstepLeft, footstepRight);
        supportingSide = supportingSide == null ? RobotSide.RIGHT : supportingSide;
        double extraToeOffHeight = 0.0;
        if (this.feetManager.getCurrentConstraintType(supportingSide.getOppositeSide()) == FootControlModule.ConstraintType.TOES) {
            extraToeOffHeight = this.feetManager.getToeOffManager().getExtraCoMMaxHeightWithToes();
        }
        TransferToAndNextFootstepsData transferToAndNextFootstepsDataForDoubleSupport = this.walkingMessageHandler.createTransferToAndNextFootstepDataForDoubleSupport(supportingSide);
        this.comHeightManager.setSupportLeg(supportingSide);
        this.comHeightManager.initialize(transferToAndNextFootstepsDataForDoubleSupport, extraToeOffHeight);
        double finalTransferTime = this.walkingMessageHandler.getFinalTransferTime();
        this.midFootPosition.interpolate((Tuple3DReadOnly)footstepLeft.getFootstepPose().getPosition(), (Tuple3DReadOnly)footstepRight.getFootstepPose().getPosition(), 0.5);
        this.pelvisOrientationManager.centerInMidFeetZUpFrame(finalTransferTime);
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.initializeICPPlanForTransferToStanding();
        this.touchdownErrorCompensator.clear();
        if (previousSupportSide != null) {
            RobotSide previousSwingSide = previousSupportSide.getOppositeSide();
            this.legConfigurationManager.setFullyExtendLeg(previousSwingSide, false);
            this.legConfigurationManager.beginStraightening(previousSwingSide);
        } else {
            for (RobotSide robotSide : RobotSide.values) {
                this.legConfigurationManager.setFullyExtendLeg(robotSide, false);
                this.legConfigurationManager.setStraight(robotSide);
            }
        }
    }

    public void onExit() {
    }
}

