/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.TouchdownErrorCompensator;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StandingState
extends WalkingState {
    private static final boolean holdDesiredHeightConstantWhenStanding = false;
    private final CommandInputManager commandInputManager;
    private final WalkingMessageHandler walkingMessageHandler;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final TouchdownErrorCompensator touchdownErrorCompensator;
    private final CenterOfMassHeightManager comHeightManager;
    private final BalanceManager balanceManager;
    private final PelvisOrientationManager pelvisOrientationManager;
    private final LegConfigurationManager legConfigurationManager;
    private final SideDependentList<RigidBodyControlManager> handManagers = new SideDependentList();
    private final FeetManager feetManager;

    public StandingState(CommandInputManager commandInputManager, WalkingMessageHandler walkingMessageHandler, TouchdownErrorCompensator touchdownErrorCompensator, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, WalkingControllerParameters walkingControllerParameters, YoRegistry parentRegistry) {
        super(WalkingStateEnum.STANDING, parentRegistry);
        this.commandInputManager = commandInputManager;
        this.walkingMessageHandler = walkingMessageHandler;
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.touchdownErrorCompensator = touchdownErrorCompensator;
        RigidBodyBasics chest = controllerToolbox.getFullRobotModel().getChest();
        if (chest != null) {
            MovingReferenceFrame chestBodyFrame = chest.getBodyFixedFrame();
            for (RobotSide robotSide : RobotSide.values) {
                RigidBodyBasics hand = controllerToolbox.getFullRobotModel().getHand(robotSide);
                if (hand == null) continue;
                MovingReferenceFrame handControlFrame = controllerToolbox.getFullRobotModel().getHandControlFrame(robotSide);
                RigidBodyControlManager handManager = managerFactory.getOrCreateRigidBodyManager(hand, chest, (ReferenceFrame)handControlFrame, (ReferenceFrame)chestBodyFrame);
                this.handManagers.put((Enum)robotSide, (Object)handManager);
            }
        }
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.legConfigurationManager = managerFactory.getOrCreateLegConfigurationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
    }

    public void doAction(double timeInState) {
        this.comHeightManager.setSupportLeg(RobotSide.LEFT);
        this.balanceManager.computeICPPlan();
    }

    public void onEntry() {
        this.commandInputManager.clearAllCommands();
        this.feetManager.reset();
        this.touchdownErrorCompensator.clear();
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.resetPushRecovery();
        this.balanceManager.enablePelvisXYControl();
        this.balanceManager.initializeICPPlanForStanding();
        this.balanceManager.setHoldSplitFractions(false);
        TransferToAndNextFootstepsData transferToAndNextFootstepsDataForDoubleSupport = this.walkingMessageHandler.createTransferToAndNextFootstepDataForDoubleSupport(RobotSide.RIGHT);
        this.comHeightManager.initialize(transferToAndNextFootstepsDataForDoubleSupport, 0.0);
        this.walkingMessageHandler.reportWalkingComplete();
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.initializeStanding();
        }
        this.failureDetectionControlModule.setNextFootstep(null);
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.STANDING);
        for (RobotSide robotSide : RobotSide.values) {
            this.legConfigurationManager.setFullyExtendLeg(robotSide, false);
            this.legConfigurationManager.setStraight(robotSide);
        }
    }

    public void onExit() {
        this.feetManager.saveCurrentPositionsAsLastFootstepPositions();
        for (RobotSide robotSide : RobotSide.values) {
            if (this.handManagers.get((Enum)robotSide) == null) continue;
            ((RigidBodyControlManager)this.handManagers.get((Enum)robotSide)).prepareForLocomotion();
        }
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.prepareForLocomotion(this.walkingMessageHandler.getNextStepTime());
            this.comHeightManager.prepareForLocomotion();
        }
        this.balanceManager.disablePelvisXYControl();
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.IN_MOTION);
    }

    @Override
    public boolean isStateSafeToConsumePelvisTrajectoryCommand() {
        return true;
    }

    @Override
    public boolean isStateSafeToConsumeManipulationCommands() {
        return true;
    }

    public boolean isDone(double timeInState) {
        return true;
    }
}

