/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states;

import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class SingleSupportState
extends WalkingState {
    protected final RobotSide swingSide;
    protected final RobotSide supportSide;
    private final YoBoolean hasMinimumTimePassed;
    protected final YoDouble minimumSwingFraction;
    protected final WalkingMessageHandler walkingMessageHandler;
    protected final SideDependentList<FootSwitchInterface> footSwitches;
    protected final FullHumanoidRobotModel fullRobotModel;
    protected final BalanceManager balanceManager;
    private final CenterOfMassHeightManager comHeightManager;

    public SingleSupportState(WalkingStateEnum singleSupportStateEnum, WalkingMessageHandler walkingMessageHandler, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControlManagerFactory managerFactory, YoRegistry parentRegistry) {
        super(singleSupportStateEnum, parentRegistry);
        this.hasMinimumTimePassed = new YoBoolean("hasMinimumTimePassed", this.registry);
        this.minimumSwingFraction = new YoDouble("minimumSwingFraction", this.registry);
        this.supportSide = singleSupportStateEnum.getSupportSide();
        this.swingSide = this.supportSide.getOppositeSide();
        this.minimumSwingFraction.set(0.5);
        this.walkingMessageHandler = walkingMessageHandler;
        this.footSwitches = controllerToolbox.getFootSwitches();
        this.fullRobotModel = controllerToolbox.getFullRobotModel();
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.comHeightManager = managerFactory.getOrCreateCenterOfMassHeightManager();
    }

    public RobotSide getSwingSide() {
        return this.swingSide;
    }

    @Override
    public RobotSide getSupportSide() {
        return this.supportSide;
    }

    public void doAction(double timeInState) {
    }

    public boolean isDone(double timeInState) {
        this.hasMinimumTimePassed.set(this.hasMinimumTimePassed(timeInState));
        if (!this.hasMinimumTimePassed.getBooleanValue()) {
            return false;
        }
        return this.hasMinimumTimePassed.getBooleanValue() && ((FootSwitchInterface)this.footSwitches.get((Enum)this.swingSide)).hasFootHitGround();
    }

    protected abstract boolean hasMinimumTimePassed(double var1);

    public void onEntry() {
        this.balanceManager.clearICPPlan();
        ((FootSwitchInterface)this.footSwitches.get((Enum)this.swingSide)).reset();
        this.balanceManager.setHoldSplitFractions(false);
        this.comHeightManager.setSupportLeg(this.swingSide.getOppositeSide());
    }

    public void onExit() {
        this.balanceManager.resetPushRecovery();
    }
}

