/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController;

import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class TouchdownErrorCompensator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<FramePoint3DReadOnly> desiredFootstepPositions = new SideDependentList();
    private final SideDependentList<YoBoolean> planShouldBeOffsetFromStep = new SideDependentList();
    private final SideDependentList<MovingReferenceFrame> soleFrames;
    private final WalkingMessageHandler walkingMessageHandler;
    private final FrameVector3D touchdownErrorVector = new FrameVector3D(ReferenceFrame.getWorldFrame());
    private final DoubleParameter spatialVelocityThreshold = new DoubleParameter("spatialVelocityThresholdForSupportConfidence", this.registry, Double.POSITIVE_INFINITY);
    private final DoubleParameter touchdownErrorCorrectionScale = new DoubleParameter("touchdownErrorCorrectionScale", this.registry, 1.0);
    private final FrameVector3D linearVelocity = new FrameVector3D();

    public TouchdownErrorCompensator(WalkingMessageHandler walkingMessageHandler, SideDependentList<MovingReferenceFrame> soleFrames, YoRegistry parentRegistry) {
        this.walkingMessageHandler = walkingMessageHandler;
        this.soleFrames = soleFrames;
        for (RobotSide robotSide : RobotSide.values) {
            YoBoolean planShouldBeOffsetFromStep = new YoBoolean("planShouldBeOffsetFromStep" + robotSide.getPascalCaseName(), this.registry);
            planShouldBeOffsetFromStep.set(false);
            this.planShouldBeOffsetFromStep.put((Enum)robotSide, (Object)planShouldBeOffsetFromStep);
        }
        parentRegistry.addChild(this.registry);
    }

    public void clear() {
        this.desiredFootstepPositions.clear();
        for (RobotSide robotSide : RobotSide.values) {
            ((YoBoolean)this.planShouldBeOffsetFromStep.get((Enum)robotSide)).set(false);
        }
    }

    public boolean isFootPositionTrusted(RobotSide robotSide) {
        this.linearVelocity.setIncludingFrame((FrameTuple3DReadOnly)((MovingReferenceFrame)this.soleFrames.get((Enum)robotSide)).getTwistOfFrame().getLinearPart());
        this.linearVelocity.changeFrame((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        return Math.abs(this.linearVelocity.getZ()) < this.spatialVelocityThreshold.getValue();
    }

    public boolean planShouldBeOffsetFromStep(RobotSide robotSide) {
        return ((YoBoolean)this.planShouldBeOffsetFromStep.get((Enum)robotSide)).getBooleanValue();
    }

    public void registerDesiredFootstepPosition(RobotSide robotSide, FramePoint3DReadOnly desiredFootstepPosition) {
        this.desiredFootstepPositions.put((Enum)robotSide, (Object)desiredFootstepPosition);
        ((YoBoolean)this.planShouldBeOffsetFromStep.get((Enum)robotSide)).set(true);
    }

    public void addOffsetVectorFromTouchdownError(RobotSide robotSide, FramePoint3DReadOnly actualFootPosition) {
        if (!((YoBoolean)this.planShouldBeOffsetFromStep.get((Enum)robotSide)).getBooleanValue()) {
            return;
        }
        this.touchdownErrorVector.sub((FrameTuple3DReadOnly)actualFootPosition, (FrameTuple3DReadOnly)this.desiredFootstepPositions.get((Enum)robotSide));
        this.touchdownErrorVector.scale(this.touchdownErrorCorrectionScale.getValue());
        this.walkingMessageHandler.addOffsetVectorOnTouchdown((FrameVector3DReadOnly)this.touchdownErrorVector);
        ((YoBoolean)this.planShouldBeOffsetFromStep.get((Enum)robotSide)).set(false);
    }
}

