/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFeetManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingPelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStateEnum;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;

public class TransferToJumpingStandingState
extends JumpingState {
    private final JumpingControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final JumpingBalanceManager balanceManager;
    private final JumpingPelvisOrientationManager pelvisOrientationManager;
    private final JumpingFeetManager feetManager;
    private final FramePoint3D leftFootPosition = new FramePoint3D();
    private final FramePoint3D rightFootPosition = new FramePoint3D();
    private final Point3D midFootPosition = new Point3D();

    public TransferToJumpingStandingState(JumpingControllerToolbox controllerToolbox, JumpingControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, YoRegistry parentRegistry) {
        super(JumpingStateEnum.TO_STANDING, parentRegistry);
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.pelvisOrientationManager = managerFactory.getOrCreatePelvisOrientationManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
    }

    public void doAction(double timeInState) {
        this.balanceManager.computeCoMPlanForStanding();
    }

    public boolean isDone(double timeInState) {
        return this.balanceManager.isCoMPlanDone();
    }

    public void onEntry() {
        for (RobotSide robotSide : RobotSide.values) {
            this.feetManager.setFlatFootContactState(robotSide);
        }
        this.balanceManager.clearICPPlan();
        this.balanceManager.setDesiredCoMHeight(this.controllerToolbox.getStandingHeight());
        this.controllerToolbox.updateBipedSupportPolygons();
        this.failureDetectionControlModule.setNextFootstep(null);
        double finalTransferTime = this.controllerToolbox.getFinalTransferTime();
        this.leftFootPosition.setToZero((ReferenceFrame)this.controllerToolbox.getFullRobotModel().getSoleFrames().get((Enum)RobotSide.LEFT));
        this.rightFootPosition.setToZero((ReferenceFrame)this.controllerToolbox.getFullRobotModel().getSoleFrames().get((Enum)RobotSide.RIGHT));
        this.leftFootPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.rightFootPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.midFootPosition.interpolate((Tuple3DReadOnly)this.leftFootPosition, (Tuple3DReadOnly)this.rightFootPosition, 0.5);
        this.pelvisOrientationManager.centerInMidFeetZUpFrame(finalTransferTime);
        this.balanceManager.setFinalTransferTime(finalTransferTime);
        this.balanceManager.initializeCoMPlanForTransferToStanding();
    }
}

