/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlState;
import us.ihmc.commonWalkingControlModules.trajectories.TwoWaypointSwingGenerator;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.trajectories.TrajectoryType;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingSwingFootState
implements JumpingFootControlState {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final RobotSide robotSide;
    private final ContactableFoot contactableFoot;
    private final FramePoint3D desiredPosition = new FramePoint3D(worldFrame);
    private final FrameVector3D desiredLinearVelocity = new FrameVector3D(worldFrame);
    private final FrameVector3D desiredLinearAcceleration = new FrameVector3D(worldFrame);
    private final FrameQuaternion desiredOrientation = new FrameQuaternion(worldFrame);
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D(worldFrame);
    private final FrameVector3D desiredAngularAcceleration = new FrameVector3D(worldFrame);
    private final JumpingControllerToolbox controllerToolbox;
    private final TwoWaypointSwingGenerator swingTrajectoryOptimizer;
    private final MultipleWaypointsPoseTrajectoryGenerator swingTrajectory;
    private final FramePoint3D initialPosition = new FramePoint3D();
    private final FrameVector3D initialLinearVelocity = new FrameVector3D();
    private final FrameQuaternion initialOrientation = new FrameQuaternion();
    private final FrameVector3D initialAngularVelocity = new FrameVector3D();
    private final FramePoint3D finalPosition = new FramePoint3D();
    private final FrameVector3D finalLinearVelocity = new FrameVector3D();
    private final FrameQuaternion finalOrientation = new FrameQuaternion();
    private final FrameVector3D finalAngularVelocity = new FrameVector3D();
    private final double[] waypointProportions = new double[2];
    private final List<DoubleProvider> defaultWaypointProportions = new ArrayList<DoubleProvider>();
    private final YoDouble swingDuration;
    private final YoDouble swingHeight;
    private final YoDouble currentTime;
    private final MovingReferenceFrame centerOfMassFrame;
    private final MovingReferenceFrame soleFrame;
    private final PoseReferenceFrame desiredSoleFrame = new PoseReferenceFrame("desiredSoleFrame", worldFrame);
    private final PoseReferenceFrame desiredControlFrame = new PoseReferenceFrame("desiredControlFrame", (ReferenceFrame)this.desiredSoleFrame);
    private final YoGraphicReferenceFrame desiredFrameGraphic;
    private final YoGraphicReferenceFrame controlFrameGraphic;
    private final FramePose3D desiredPose = new FramePose3D();
    private final Twist desiredTwist = new Twist();
    private final Twist relativeTwist = new Twist();
    private final SpatialAcceleration desiredSpatialAcceleration = new SpatialAcceleration();
    private final FramePose3D footstepPose = new FramePose3D();
    private final FrameEuclideanTrajectoryPoint tempPositionTrajectoryPoint = new FrameEuclideanTrajectoryPoint();
    private final YoFramePoint3D yoDesiredSolePosition;
    private final YoFrameVector3D yoDesiredSoleLinearVelocity;
    private final YoFrameVector3D yoDesiredSoleLinearAcceleration;
    private final YoFramePoint3D yoDesiredSolePositionInCoMFrame;
    private final YoFrameVector3D yoDesiredSoleLinearVelocityInCoMFrame;
    private final YoFrameVector3D yoDesiredSoleLinearAccelerationInCoMFrame;
    private final YoFrameQuaternion yoDesiredSoleOrientationInCoMFrame;
    private final YoFrameVector3D yoDesiredSoleAngularVelocityInCoMFrame;
    private final YoFrameVector3D yoDesiredSoleAngularAccelerationInCoMFrame;
    private final YoFrameQuaternion yoDesiredSoleOrientation;
    private final YoFrameVector3D yoDesiredSoleAngularVelocity;
    private final SpatialFeedbackControlCommand spatialFeedbackControlCommand = new SpatialFeedbackControlCommand();
    private Vector3DReadOnly nominalAngularWeight;
    private Vector3DReadOnly nominalLinearWeight;
    private final PoseReferenceFrame controlFrame;
    private final PIDSE3GainsReadOnly gains;
    private final double gravityZ;

    public JumpingSwingFootState(JumpingFootControlHelper footControlHelper, double gravityZ, PIDSE3GainsReadOnly gains, YoRegistry registry) {
        this.contactableFoot = footControlHelper.getContactableFoot();
        this.controllerToolbox = footControlHelper.getJumpingControllerToolbox();
        this.centerOfMassFrame = this.controllerToolbox.getCenterOfMassFrame();
        this.robotSide = footControlHelper.getRobotSide();
        FullHumanoidRobotModel fullRobotModel = footControlHelper.getJumpingControllerToolbox().getFullRobotModel();
        this.gravityZ = gravityZ;
        this.gains = gains;
        RigidBodyBasics foot = this.contactableFoot.getRigidBody();
        String namePrefix = this.robotSide.getCamelCaseNameForStartOfExpression() + "FootSwing";
        this.spatialFeedbackControlCommand.set(fullRobotModel.getElevator(), foot);
        this.spatialFeedbackControlCommand.setPrimaryBase(fullRobotModel.getPelvis());
        ReferenceFrame linearGainsFrame = footControlHelper.getJumpingControllerToolbox().getPelvisZUpFrame();
        this.spatialFeedbackControlCommand.setGainsFrames(null, linearGainsFrame);
        this.spatialFeedbackControlCommand.setControlBaseFrame((ReferenceFrame)this.centerOfMassFrame);
        this.controlFrame = new PoseReferenceFrame("controlFrame", (ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        FramePose3D controlFramePose = new FramePose3D((ReferenceFrame)this.controlFrame);
        controlFramePose.changeFrame((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.changeControlFrame((FramePose3DReadOnly)controlFramePose);
        WalkingControllerParameters walkingControllerParameters = footControlHelper.getWalkingControllerParameters();
        SwingTrajectoryParameters swingTrajectoryParameters = walkingControllerParameters.getSwingTrajectoryParameters();
        int numberWaypoints = 2;
        double[] defaultWaypointProportions = swingTrajectoryParameters.getSwingWaypointProportions();
        for (int i = 0; i < numberWaypoints; ++i) {
            DoubleParameter waypointProportion = new DoubleParameter(namePrefix + "WaypointProportion" + i, registry, defaultWaypointProportions[i]);
            this.defaultWaypointProportions.add((DoubleProvider)waypointProportion);
        }
        this.soleFrame = footControlHelper.getJumpingControllerToolbox().getReferenceFrames().getSoleFrame((Enum)this.robotSide);
        MovingReferenceFrame footFrame = this.contactableFoot.getFrameAfterParentJoint();
        RigidBodyTransform soleToControlFrameTransform = new RigidBodyTransform();
        footFrame.getTransformToDesiredFrame(soleToControlFrameTransform, (ReferenceFrame)this.soleFrame);
        this.desiredControlFrame.setPoseAndUpdate((RigidBodyTransformReadOnly)soleToControlFrameTransform);
        double maxSwingHeightFromStanceFoot = walkingControllerParameters.getSteppingParameters().getMaxSwingHeightFromStanceFoot();
        double minSwingHeightFromStanceFoot = 0.0;
        double defaultSwingHeightFromStanceFoot = walkingControllerParameters.getSteppingParameters().getDefaultSwingHeightFromStanceFoot();
        double customWaypointAngleThreshold = walkingControllerParameters.getSteppingParameters().getCustomWaypointAngleThreshold();
        YoGraphicsListRegistry yoGraphicsListRegistry = this.controllerToolbox.getYoGraphicsListRegistry();
        this.swingTrajectoryOptimizer = new TwoWaypointSwingGenerator(namePrefix, minSwingHeightFromStanceFoot, maxSwingHeightFromStanceFoot, defaultSwingHeightFromStanceFoot, customWaypointAngleThreshold, (ReferenceFrame)this.centerOfMassFrame, registry, yoGraphicsListRegistry);
        this.swingTrajectory = new MultipleWaypointsPoseTrajectoryGenerator(namePrefix, 14, registry);
        this.swingDuration = new YoDouble(namePrefix + "Duration", registry);
        this.swingHeight = new YoDouble(namePrefix + "Height", registry);
        this.currentTime = new YoDouble(namePrefix + "CurrentTime", registry);
        this.footstepPose.setToNaN();
        this.yoDesiredSolePosition = new YoFramePoint3D(namePrefix + "DesiredSolePositionInWorld", worldFrame, registry);
        this.yoDesiredSoleLinearVelocity = new YoFrameVector3D(namePrefix + "DesiredSoleLinearVelocityInWorld", worldFrame, registry);
        this.yoDesiredSoleLinearAcceleration = new YoFrameVector3D(namePrefix + "DesiredSoleLinearAccelerationInWorld", worldFrame, registry);
        this.yoDesiredSolePositionInCoMFrame = new YoFramePoint3D(namePrefix + "DesiredSolePositionInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        this.yoDesiredSoleLinearVelocityInCoMFrame = new YoFrameVector3D(namePrefix + "DesiredSoleLinearVelocityInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        this.yoDesiredSoleLinearAccelerationInCoMFrame = new YoFrameVector3D(namePrefix + "DesiredSoleLinearAccelerationInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        this.yoDesiredSoleOrientation = new YoFrameQuaternion(namePrefix + "DesiredSoleOrientationInWorld", worldFrame, registry);
        this.yoDesiredSoleAngularVelocity = new YoFrameVector3D(namePrefix + "DesiredSoleAngularVelocityInWorld", worldFrame, registry);
        this.yoDesiredSoleOrientationInCoMFrame = new YoFrameQuaternion(namePrefix + "DesiredSoleOrientationInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        this.yoDesiredSoleAngularVelocityInCoMFrame = new YoFrameVector3D(namePrefix + "DesiredSoleAngularVelocityInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        this.yoDesiredSoleAngularAccelerationInCoMFrame = new YoFrameVector3D(namePrefix + "DesiredSoleAngularAccelerationInCoMFrame", (ReferenceFrame)this.centerOfMassFrame, registry);
        if (yoGraphicsListRegistry != null) {
            YoGraphicPosition desiredPosition = new YoGraphicPosition(namePrefix + "DesiredPosition", this.yoDesiredSolePosition, 0.015, YoAppearance.Green());
            yoGraphicsListRegistry.registerYoGraphic("Swing Foot", (YoGraphic)desiredPosition);
            this.desiredFrameGraphic = new YoGraphicReferenceFrame(namePrefix, (ReferenceFrame)this.desiredSoleFrame, registry, false, 0.1, YoAppearance.Gray());
            this.controlFrameGraphic = new YoGraphicReferenceFrame(namePrefix, (ReferenceFrame)this.desiredControlFrame, registry, false, 0.1, YoAppearance.Gray());
            yoGraphicsListRegistry.registerYoGraphic("Swing Foot", (YoGraphic)this.desiredFrameGraphic);
            yoGraphicsListRegistry.registerYoGraphic("Swing Foot", (YoGraphic)this.controlFrameGraphic);
        } else {
            this.desiredFrameGraphic = null;
            this.controlFrameGraphic = null;
        }
    }

    private void initializeTrajectory() {
        this.initialPosition.setToZero((ReferenceFrame)this.soleFrame);
        this.initialOrientation.setToZero((ReferenceFrame)this.soleFrame);
        this.initialPosition.changeFrame((ReferenceFrame)this.centerOfMassFrame);
        this.initialOrientation.changeFrame((ReferenceFrame)this.centerOfMassFrame);
        this.initialAngularVelocity.setToZero((ReferenceFrame)this.centerOfMassFrame);
        this.initialLinearVelocity.setToZero((ReferenceFrame)this.centerOfMassFrame);
        this.fillAndInitializeTrajectories(true);
    }

    public void onEntry() {
        this.currentTime.set(0.0);
        YoPlaneContactState contactState = this.controllerToolbox.getFootContactState(this.robotSide);
        contactState.notifyContactStateHasChanged();
        this.initializeTrajectory();
    }

    public void onExit() {
        this.currentTime.set(0.0);
        this.swingTrajectoryOptimizer.informDone();
        this.yoDesiredSolePosition.setToNaN();
        this.yoDesiredSoleOrientation.setToNaN();
        this.yoDesiredSoleLinearVelocity.setToNaN();
        this.yoDesiredSoleLinearAcceleration.setToNaN();
        this.yoDesiredSoleAngularVelocity.setToNaN();
    }

    public void doAction(double timeInState) {
        this.computeAndPackTrajectory(timeInState);
        this.spatialFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredOrientation, (FramePoint3DReadOnly)this.desiredPosition, (FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.spatialFeedbackControlCommand.setWeightsForSolver(this.nominalAngularWeight, this.nominalLinearWeight);
        this.spatialFeedbackControlCommand.setGains(this.gains);
    }

    private void computeAndPackTrajectory(double timeInState) {
        this.currentTime.set(Math.min(timeInState, this.swingDuration.getDoubleValue()));
        double time = this.currentTime.getDoubleValue();
        if (this.swingTrajectoryOptimizer.doOptimizationUpdate()) {
            this.fillAndInitializeTrajectories(false);
        }
        this.swingTrajectory.compute(time);
        this.swingTrajectory.getLinearData((FramePoint3DBasics)this.desiredPosition, (FrameVector3DBasics)this.desiredLinearVelocity, (FrameVector3DBasics)this.desiredLinearAcceleration);
        this.swingTrajectory.getAngularData((FrameOrientation3DBasics)this.desiredOrientation, (FrameVector3DBasics)this.desiredAngularVelocity, (FrameVector3DBasics)this.desiredAngularAcceleration);
        if (timeInState > this.swingDuration.getDoubleValue()) {
            this.desiredLinearVelocity.setToZero((ReferenceFrame)this.centerOfMassFrame);
            this.desiredLinearAcceleration.setToZero((ReferenceFrame)this.centerOfMassFrame);
            this.desiredAngularVelocity.setToZero((ReferenceFrame)this.centerOfMassFrame);
            this.desiredAngularAcceleration.setToZero((ReferenceFrame)this.centerOfMassFrame);
        }
        this.yoDesiredSolePositionInCoMFrame.set((FrameTuple3DReadOnly)this.desiredPosition);
        this.yoDesiredSoleLinearVelocityInCoMFrame.set((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredSoleLinearAccelerationInCoMFrame.set((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredSoleOrientationInCoMFrame.set((FrameQuaternionReadOnly)this.desiredOrientation);
        this.yoDesiredSoleAngularVelocityInCoMFrame.set((FrameTuple3DReadOnly)this.desiredAngularVelocity);
        this.yoDesiredSoleAngularAccelerationInCoMFrame.set((FrameTuple3DReadOnly)this.desiredAngularAcceleration);
        this.yoDesiredSolePosition.setMatchingFrame((FrameTuple3DReadOnly)this.desiredPosition);
        this.yoDesiredSoleOrientation.setMatchingFrame((FrameQuaternionReadOnly)this.desiredOrientation);
        this.transformDesiredVelocitiesAndAccelerationsToFrame(worldFrame);
        this.yoDesiredSoleLinearVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredSoleLinearAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredSoleAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.desiredAngularVelocity);
        this.transformDesiredsFromCoMFrameToControlFrame();
    }

    public void setFootstep(FramePose3DReadOnly footstepPoseRelativeToTouchdownCoM, double swingHeight, double swingTime) {
        this.footstepPose.setIncludingFrame((ReferenceFrame)this.centerOfMassFrame, (Pose3DReadOnly)footstepPoseRelativeToTouchdownCoM);
        this.swingHeight.set(swingHeight);
        List<DoubleProvider> waypointProportions = this.defaultWaypointProportions;
        this.waypointProportions[0] = waypointProportions.get(0).getValue();
        this.waypointProportions[1] = waypointProportions.get(1).getValue();
        this.swingDuration.set(swingTime);
    }

    private void fillAndInitializeTrajectories(boolean initializeOptimizer) {
        this.finalPosition.setIncludingFrame((FrameTuple3DReadOnly)this.footstepPose.getPosition());
        this.finalOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.footstepPose.getOrientation());
        this.finalLinearVelocity.setToZero((ReferenceFrame)this.centerOfMassFrame);
        this.finalAngularVelocity.setToZero(worldFrame);
        this.finalAngularVelocity.changeFrame((ReferenceFrame)this.centerOfMassFrame);
        this.swingTrajectory.clear((ReferenceFrame)this.centerOfMassFrame);
        this.swingTrajectory.appendPositionWaypoint(0.0, this.initialPosition, this.initialLinearVelocity);
        this.swingTrajectory.appendOrientationWaypoint(0.0, this.initialOrientation, this.initialAngularVelocity);
        if (initializeOptimizer) {
            this.initializeOptimizer();
        }
        for (int i = 0; i < this.swingTrajectoryOptimizer.getNumberOfWaypoints(); ++i) {
            this.swingTrajectoryOptimizer.getWaypointData(i, this.tempPositionTrajectoryPoint);
            this.swingTrajectory.appendPositionWaypoint(this.tempPositionTrajectoryPoint);
        }
        this.swingTrajectory.appendPositionWaypoint(this.swingDuration.getDoubleValue(), this.finalPosition, this.finalLinearVelocity);
        this.swingTrajectory.appendOrientationWaypoint(this.swingDuration.getDoubleValue(), this.finalOrientation, this.finalAngularVelocity);
        this.swingTrajectory.initialize();
    }

    private void initializeOptimizer() {
        this.swingTrajectoryOptimizer.setInitialConditions((FramePoint3DReadOnly)this.initialPosition, (FrameVector3DReadOnly)this.initialLinearVelocity);
        this.swingTrajectoryOptimizer.setFinalConditions((FramePoint3DReadOnly)this.finalPosition, (FrameVector3DReadOnly)this.finalLinearVelocity);
        this.swingTrajectoryOptimizer.setStepTime(this.swingDuration.getDoubleValue());
        this.swingTrajectoryOptimizer.setTrajectoryType(TrajectoryType.DEFAULT, null);
        this.swingTrajectoryOptimizer.setSwingHeight(this.swingHeight.getDoubleValue());
        this.swingTrajectoryOptimizer.setWaypointProportions(this.waypointProportions);
        this.swingTrajectoryOptimizer.initialize();
    }

    private void transformDesiredsFromCoMFrameToControlFrame() {
        this.desiredPosition.changeFrame(worldFrame);
        this.desiredOrientation.changeFrame(worldFrame);
        this.desiredSoleFrame.setPoseAndUpdate((FramePoint3DReadOnly)this.desiredPosition, (FrameOrientation3DReadOnly)this.desiredOrientation);
        this.desiredControlFrame.update();
        if (this.desiredFrameGraphic != null) {
            this.desiredFrameGraphic.update();
        }
        if (this.controlFrameGraphic != null) {
            this.controlFrameGraphic.update();
        }
        this.desiredPose.setToZero((ReferenceFrame)this.desiredControlFrame);
        this.desiredPose.changeFrame(worldFrame);
        this.desiredPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
        this.desiredOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPose.getOrientation());
        this.transformDesiredVelocitiesAndAccelerationsToFrame((ReferenceFrame)this.desiredControlFrame);
    }

    private void transformDesiredVelocitiesAndAccelerationsToFrame(ReferenceFrame desiredFrame) {
        this.desiredTwist.setIncludingFrame((ReferenceFrame)this.centerOfMassFrame, worldFrame, (ReferenceFrame)this.centerOfMassFrame, (Vector3DReadOnly)this.yoDesiredSoleAngularVelocityInCoMFrame, (Vector3DReadOnly)this.yoDesiredSoleLinearVelocityInCoMFrame);
        this.desiredTwist.changeFrame(desiredFrame);
        this.centerOfMassFrame.getTwistRelativeToOther(worldFrame, (TwistBasics)this.relativeTwist);
        this.relativeTwist.changeFrame(worldFrame);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredTwist.getLinearPart());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredTwist.getAngularPart());
        this.desiredLinearVelocity.changeFrame(worldFrame);
        this.desiredAngularVelocity.changeFrame(worldFrame);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.relativeTwist.getLinearPart());
        this.desiredAngularVelocity.add((FrameTuple3DReadOnly)this.relativeTwist.getAngularPart());
        this.desiredSpatialAcceleration.setIncludingFrame((ReferenceFrame)this.centerOfMassFrame, worldFrame, (ReferenceFrame)this.centerOfMassFrame, (Vector3DReadOnly)this.yoDesiredSoleAngularAccelerationInCoMFrame, (Vector3DReadOnly)this.yoDesiredSoleLinearAccelerationInCoMFrame);
        this.desiredSpatialAcceleration.changeFrame(desiredFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredSpatialAcceleration.getLinearPart());
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredSpatialAcceleration.getAngularPart());
        this.desiredLinearAcceleration.changeFrame(worldFrame);
        this.desiredAngularAcceleration.changeFrame(worldFrame);
        this.desiredLinearAcceleration.addZ(-this.gravityZ);
    }

    private void changeControlFrame(FramePose3DReadOnly controlFramePoseInEndEffector) {
        controlFramePoseInEndEffector.checkReferenceFrameMatch((ReferenceFrame)this.contactableFoot.getRigidBody().getBodyFixedFrame());
        this.spatialFeedbackControlCommand.setControlFrameFixedInEndEffector(controlFramePoseInEndEffector);
        this.controlFrame.setPoseAndUpdate(controlFramePoseInEndEffector);
    }

    public void setWeights(Vector3DReadOnly angularWeight, Vector3DReadOnly linearWeight) {
        this.nominalAngularWeight = angularWeight;
        this.nominalLinearWeight = linearWeight;
    }

    @Override
    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return null;
    }

    @Override
    public SpatialFeedbackControlCommand getFeedbackControlCommand() {
        return this.spatialFeedbackControlCommand;
    }
}

