/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.math.trajectories.SimpleOrientationTrajectoryGenerator;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingPelvisOrientationManager {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean doPrepareForLocomotion = new YoBoolean("doPreparePelvisForLocomotion", this.registry);
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final FrameQuaternion desiredPelvisOrientation = new FrameQuaternion();
    private final FrameVector3D desiredPelvisAngularVelocity = new FrameVector3D();
    private final FrameVector3D desiredPelvisAngularAcceleration = new FrameVector3D();
    private final FrameQuaternion desiredPelvisOrientationWithOffset = new FrameQuaternion();
    private final FrameQuaternion initialPelvisOrientation = new FrameQuaternion();
    private final FrameQuaternion finalPelvisOrientation = new FrameQuaternion();
    private final SimpleOrientationTrajectoryGenerator pelvisOrientationTrajectoryGenerator;
    private final SimpleOrientationTrajectoryGenerator pelvisOrientationOffsetTrajectoryGenerator;
    private final YoDouble initialPelvisOrientationTime = new YoDouble("initialPelvisOrientationTime", this.registry);
    private final YoDouble initialPelvisOrientationOffsetTime = new YoDouble("initialPelvisOrientationOffsetTime", this.registry);
    private final YoDouble yoTime;
    private final OrientationFeedbackControlCommand orientationFeedbackControlCommand = new OrientationFeedbackControlCommand();
    private Vector3DReadOnly pelvisAngularWeight = null;
    private final Vector3D tempWeight = new Vector3D();
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private final FrameQuaternion tempOrientation = new FrameQuaternion();
    private final FrameVector3D tempAngularVelocity = new FrameVector3D();
    private final FrameVector3D tempAngularAcceleration = new FrameVector3D();
    private final SideDependentList<MovingReferenceFrame> soleZUpFrames;
    private final ReferenceFrame midFeetZUpGroundFrame;
    private final ReferenceFrame pelvisFrame;
    private final ReferenceFrame desiredPelvisFrame;
    private final PID3DGainsReadOnly gains;
    private Footstep nextFootstep;
    private final ReferenceFrame nextSoleZUpFrame;
    private final ReferenceFrame nextSoleFrame;

    public JumpingPelvisOrientationManager(PID3DGainsReadOnly gains, JumpingControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        this.midFeetZUpGroundFrame = referenceFrames.getMidFootZUpGroundFrame();
        this.soleZUpFrames = referenceFrames.getSoleZUpFrames();
        this.pelvisFrame = referenceFrames.getPelvisFrame();
        this.yoTime = controllerToolbox.getYoTime();
        this.pelvisOrientationTrajectoryGenerator = new SimpleOrientationTrajectoryGenerator("pelvis", true, worldFrame, this.registry);
        this.gains = gains;
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        RigidBodyBasics elevator = fullRobotModel.getElevator();
        RigidBodyBasics pelvis = fullRobotModel.getPelvis();
        this.orientationFeedbackControlCommand.set(elevator, pelvis);
        this.selectionMatrix.resetSelection();
        this.desiredPelvisFrame = new ReferenceFrame("desiredPelvisFrame", worldFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                JumpingPelvisOrientationManager.this.pelvisFrame.getTransformToDesiredFrame(transformToParent, this.getParent());
                transformToParent.getRotation().set((Orientation3DReadOnly)JumpingPelvisOrientationManager.this.desiredPelvisOrientation);
            }
        };
        this.nextSoleFrame = new ReferenceFrame("nextSoleFrame", worldFrame){

            protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                JumpingPelvisOrientationManager.this.nextFootstep.getSoleReferenceFrame().getTransformToDesiredFrame(transformToParent, this.getParent());
            }
        };
        this.nextSoleZUpFrame = new ZUpFrame(worldFrame, this.nextSoleFrame, "nextAnkleZUp");
        this.pelvisOrientationOffsetTrajectoryGenerator = new SimpleOrientationTrajectoryGenerator("pelvisOffset", false, this.desiredPelvisFrame, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setPrepareForLocomotion(boolean value) {
        this.doPrepareForLocomotion.set(value);
    }

    public void compute() {
        double deltaTime = this.yoTime.getDoubleValue() - this.initialPelvisOrientationTime.getDoubleValue();
        this.pelvisOrientationTrajectoryGenerator.compute(deltaTime);
        this.pelvisOrientationTrajectoryGenerator.getAngularData((FrameOrientation3DBasics)this.desiredPelvisOrientation, (FrameVector3DBasics)this.desiredPelvisAngularVelocity, (FrameVector3DBasics)this.desiredPelvisAngularAcceleration);
        this.desiredPelvisOrientation.changeFrame(worldFrame);
        this.desiredPelvisAngularVelocity.changeFrame(worldFrame);
        this.desiredPelvisAngularAcceleration.changeFrame(worldFrame);
        this.desiredPelvisFrame.update();
        double deltaTimeOffset = this.yoTime.getDoubleValue() - this.initialPelvisOrientationOffsetTime.getDoubleValue();
        this.pelvisOrientationOffsetTrajectoryGenerator.compute(deltaTimeOffset);
        this.pelvisOrientationOffsetTrajectoryGenerator.getAngularData((FrameOrientation3DBasics)this.tempOrientation, (FrameVector3DBasics)this.tempAngularVelocity, (FrameVector3DBasics)this.tempAngularAcceleration);
        this.tempOrientation.changeFrame(worldFrame);
        this.tempAngularVelocity.changeFrame(worldFrame);
        this.tempAngularAcceleration.changeFrame(worldFrame);
        this.tempWeight.set((Tuple3DReadOnly)this.pelvisAngularWeight);
        this.desiredPelvisOrientationWithOffset.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.desiredPelvisAngularVelocity.add((FrameTuple3DReadOnly)this.tempAngularVelocity);
        this.desiredPelvisAngularAcceleration.add((FrameTuple3DReadOnly)this.tempAngularAcceleration);
        this.orientationFeedbackControlCommand.setInverseDynamics((FrameQuaternionReadOnly)this.desiredPelvisOrientationWithOffset, (FrameVector3DReadOnly)this.desiredPelvisAngularVelocity, (FrameVector3DReadOnly)this.desiredPelvisAngularAcceleration);
        this.orientationFeedbackControlCommand.setWeightsForSolver((Vector3DReadOnly)this.tempWeight);
        this.orientationFeedbackControlCommand.setGains(this.gains);
        this.orientationFeedbackControlCommand.setSelectionMatrix(this.selectionMatrix);
    }

    public void initialize() {
        this.resetOrientationOffset();
        this.setToZeroInMidFeetZUpFrame();
    }

    public void prepareForLocomotion(double trajectoryTime) {
        if (this.doPrepareForLocomotion.getValue()) {
            this.goToHomeFromCurrentDesired(trajectoryTime);
        }
    }

    public void initializeTrajectory() {
        this.updateTrajectoryFromFootstep();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        ret.addCommand(this.getFeedbackControlCommand());
        return ret;
    }

    public void setWeights(Vector3DReadOnly pelvisAngularWeight) {
        this.pelvisAngularWeight = pelvisAngularWeight;
    }

    public void setTrajectoryTime(double trajectoryTime) {
        if (trajectoryTime < 0.0) {
            throw new RuntimeException("Negative trajectory time: " + trajectoryTime);
        }
        this.pelvisOrientationTrajectoryGenerator.setTrajectoryTime(trajectoryTime);
    }

    private void initialize(ReferenceFrame desiredTrajectoryFrame) {
        this.initializeTrajectoryFrame(desiredTrajectoryFrame);
        this.initializeTiming();
    }

    private void initializeTrajectoryFrame(ReferenceFrame desiredTrajectoryFrame) {
        this.initialPelvisOrientation.changeFrame(desiredTrajectoryFrame);
        this.finalPelvisOrientation.changeFrame(desiredTrajectoryFrame);
        this.pelvisOrientationTrajectoryGenerator.setReferenceFrame(desiredTrajectoryFrame);
        this.pelvisOrientationTrajectoryGenerator.setInitialOrientation((FrameQuaternionReadOnly)this.initialPelvisOrientation);
        this.pelvisOrientationTrajectoryGenerator.setFinalOrientation((FrameQuaternionReadOnly)this.finalPelvisOrientation);
        this.pelvisOrientationTrajectoryGenerator.initialize();
        this.desiredPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.initialPelvisOrientation);
        this.desiredPelvisOrientation.changeFrame(worldFrame);
        this.desiredPelvisFrame.update();
    }

    private void initializeTiming() {
        this.initialPelvisOrientationTime.set(this.yoTime.getDoubleValue());
    }

    public void goToHomeFromCurrentDesired(double trajectoryTime) {
        this.initialPelvisOrientationOffsetTime.set(this.yoTime.getDoubleValue());
        this.tempOrientation.setIncludingFrame(this.pelvisOrientationOffsetTrajectoryGenerator.getOrientation());
        this.tempOrientation.changeFrame(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setInitialOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.tempOrientation.setToZero(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setFinalOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setTrajectoryTime(trajectoryTime);
        this.pelvisOrientationOffsetTrajectoryGenerator.initialize();
    }

    public void goToHomeFromOffset(FrameQuaternionReadOnly offset, double trajectoryTime) {
        this.initialPelvisOrientationOffsetTime.set(this.yoTime.getDoubleValue());
        this.tempOrientation.setIncludingFrame(offset);
        this.tempOrientation.changeFrame(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setInitialOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.tempOrientation.setToZero(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setFinalOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setTrajectoryTime(trajectoryTime);
        this.pelvisOrientationOffsetTrajectoryGenerator.initialize();
    }

    public void setOffset(FrameQuaternionReadOnly offset) {
        this.tempOrientation.setIncludingFrame(offset);
        this.tempOrientation.changeFrame(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setInitialOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setFinalOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setTrajectoryTime(0.0);
        this.pelvisOrientationOffsetTrajectoryGenerator.initialize();
    }

    public void resetOrientationOffset() {
        this.tempOrientation.setToZero(this.desiredPelvisFrame);
        this.pelvisOrientationOffsetTrajectoryGenerator.setInitialOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setFinalOrientation((FrameQuaternionReadOnly)this.tempOrientation);
        this.pelvisOrientationOffsetTrajectoryGenerator.setTrajectoryTime(0.0);
        this.pelvisOrientationOffsetTrajectoryGenerator.initialize();
    }

    public void setToHoldCurrentInWorldFrame() {
        this.setToHoldCurrent(worldFrame);
    }

    public void setToHoldCurrent(ReferenceFrame trajectoryFrame) {
        this.tempOrientation.setToZero(this.pelvisFrame);
        this.tempOrientation.changeFrame(worldFrame);
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.finalPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.desiredPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.resetOrientationOffset();
        this.initialize(trajectoryFrame);
    }

    public void centerInMidFeetZUpFrame(double trajectoryTime) {
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPelvisOrientation);
        this.finalPelvisOrientation.setToZero(this.midFeetZUpGroundFrame);
        this.setTrajectoryTime(trajectoryTime);
        this.initialize(this.midFeetZUpGroundFrame);
    }

    public void setToHoldCurrentDesiredInMidFeetZUpFrame() {
        this.setToHoldCurrentDesired(this.midFeetZUpGroundFrame);
    }

    public void setToHoldCurrentDesiredInSupportFoot(RobotSide supportSide) {
        this.setToHoldCurrentDesired((ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide));
    }

    public void setToHoldCurrentDesired(ReferenceFrame desiredTrajectoryFrame) {
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPelvisOrientation);
        this.finalPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPelvisOrientation);
        this.initialize(desiredTrajectoryFrame);
    }

    public void setToZeroInMidFeetZUpFrame() {
        this.tempOrientation.setToZero(this.midFeetZUpGroundFrame);
        this.tempOrientation.changeFrame(worldFrame);
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.finalPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.desiredPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.tempOrientation);
        this.initialize(this.midFeetZUpGroundFrame);
    }

    public void moveToAverageInSupportFoot(RobotSide supportSide) {
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPelvisOrientation);
        ReferenceFrame otherAnkleZUpFrame = (ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide.getOppositeSide());
        ReferenceFrame supportAnkleZUpFrame = (ReferenceFrame)this.soleZUpFrames.get((Enum)supportSide);
        this.tempOrientation.setToZero(otherAnkleZUpFrame);
        this.tempOrientation.changeFrame(worldFrame);
        double yawOtherFoot = this.tempOrientation.getYaw();
        this.tempOrientation.setToZero(supportAnkleZUpFrame);
        this.tempOrientation.changeFrame(worldFrame);
        double yawSupportFoot = this.tempOrientation.getYaw();
        double finalDesiredPelvisYawAngle = AngleTools.computeAngleAverage((double)yawOtherFoot, (double)yawSupportFoot);
        this.finalPelvisOrientation.setYawPitchRollIncludingFrame(worldFrame, finalDesiredPelvisYawAngle, 0.0, 0.0);
        this.initialize(supportAnkleZUpFrame);
    }

    public void setUpcomingFootstep(Footstep upcomingFootstep) {
        this.nextFootstep = upcomingFootstep;
        this.nextSoleFrame.update();
        this.nextSoleZUpFrame.update();
    }

    public void setTrajectoryFromFootstep() {
        this.updateTrajectoryFromFootstep();
        this.initializeTiming();
    }

    public void updateTrajectoryFromFootstep() {
        this.initialPelvisOrientation.setIncludingFrame((FrameQuaternionReadOnly)this.desiredPelvisOrientation);
        RobotSide upcomingFootstepSide = this.nextFootstep.getRobotSide();
        ReferenceFrame supportSoleFrame = (ReferenceFrame)this.soleZUpFrames.get((Enum)upcomingFootstepSide.getOppositeSide());
        this.nextFootstep.getOrientation(this.tempOrientation);
        this.tempOrientation.changeFrame(worldFrame);
        double yawFootstep = this.tempOrientation.getYaw();
        this.tempOrientation.setToZero(supportSoleFrame);
        this.tempOrientation.changeFrame(worldFrame);
        double yawSupportFoot = this.tempOrientation.getYaw();
        double finalDesiredPelvisYawAngle = AngleTools.computeAngleAverage((double)yawFootstep, (double)yawSupportFoot);
        this.finalPelvisOrientation.setYawPitchRollIncludingFrame(worldFrame, finalDesiredPelvisYawAngle, 0.0, 0.0);
        this.initializeTrajectoryFrame(worldFrame);
    }

    public void initializeStanding() {
        this.setToHoldCurrentDesiredInMidFeetZUpFrame();
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return this.orientationFeedbackControlCommand;
    }
}

