/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.Arrays;
import java.util.EnumMap;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFeetManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingSupportFootState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingSwingFootState;
import us.ihmc.commonWalkingControlModules.momentumBasedController.ParameterProvider;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoEnum;

public class JumpingFootControlModule {
    private final YoRegistry registry;
    private final ContactablePlaneBody contactableFoot;
    private static final double defaultCoefficientOfFriction = 0.8;
    private final DoubleParameter coefficientOfFriction;
    private final StateMachine<ConstraintType, JumpingFootControlState> stateMachine;
    private final YoEnum<ConstraintType> requestedState;
    private final EnumMap<ConstraintType, boolean[]> contactStatesMap = new EnumMap(ConstraintType.class);
    private final JumpingControllerToolbox controllerToolbox;
    private final RobotSide robotSide;
    private final JumpingSwingFootState swingState;
    private final JumpingSupportFootState supportState;
    private final JumpingFootControlHelper footControlHelper;
    private final YoBoolean resetFootPolygon;

    public JumpingFootControlModule(RobotSide robotSide, WalkingControllerParameters walkingControllerParameters, PIDSE3GainsReadOnly swingFootControlGains, JumpingControllerToolbox controllerToolbox, YoRegistry parentRegistry) {
        this.contactableFoot = (ContactablePlaneBody)controllerToolbox.getContactableFeet().get((Enum)robotSide);
        controllerToolbox.setFootContactStateFullyConstrained(robotSide);
        SwingTrajectoryParameters swingTrajectoryParameters = walkingControllerParameters.getSwingTrajectoryParameters();
        String sidePrefix = robotSide.getCamelCaseNameForStartOfExpression();
        String namePrefix = sidePrefix + "Foot";
        this.registry = new YoRegistry(sidePrefix + this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.footControlHelper = new JumpingFootControlHelper(robotSide, walkingControllerParameters, controllerToolbox);
        this.controllerToolbox = controllerToolbox;
        this.robotSide = robotSide;
        this.requestedState = new YoEnum(namePrefix + "RequestedState", "", this.registry, ConstraintType.class, true);
        this.requestedState.set(null);
        this.setupContactStatesMap();
        this.supportState = new JumpingSupportFootState(this.footControlHelper, this.registry);
        this.swingState = new JumpingSwingFootState(this.footControlHelper, controllerToolbox.getGravityZ(), swingFootControlGains, this.registry);
        this.stateMachine = this.setupStateMachine(namePrefix);
        this.resetFootPolygon = new YoBoolean(namePrefix + "ResetFootPolygon", this.registry);
        String targetRegistryName = JumpingFeetManager.class.getSimpleName();
        String parameterRegistryName = JumpingFootControlModule.class.getSimpleName() + "Parameters";
        this.coefficientOfFriction = ParameterProvider.getOrCreateParameter(targetRegistryName, parameterRegistryName, "CoefficientOfFriction", this.registry, 0.8);
    }

    private void setupContactStatesMap() {
        boolean[] falses = new boolean[this.contactableFoot.getTotalNumberOfContactPoints()];
        Arrays.fill(falses, false);
        boolean[] trues = new boolean[this.contactableFoot.getTotalNumberOfContactPoints()];
        Arrays.fill(trues, true);
        this.contactStatesMap.put(ConstraintType.SWING, falses);
        this.contactStatesMap.put(ConstraintType.FULL, trues);
    }

    private StateMachine<ConstraintType, JumpingFootControlState> setupStateMachine(String namePrefix) {
        StateMachineFactory factory = new StateMachineFactory(ConstraintType.class);
        factory.setNamePrefix(namePrefix).setRegistry(this.registry).buildYoClock((DoubleProvider)this.footControlHelper.getJumpingControllerToolbox().getYoTime());
        factory.addState((Enum)ConstraintType.FULL, (State)this.supportState);
        factory.addState((Enum)ConstraintType.SWING, (State)this.swingState);
        for (ConstraintType from : ConstraintType.values()) {
            factory.addRequestedTransition((Enum)from, this.requestedState);
            factory.addRequestedTransition((Enum)from, (Enum)from, this.requestedState);
        }
        return factory.build((Enum)ConstraintType.FULL);
    }

    public void setWeights(Vector3DReadOnly loadedFootAngularWeight, Vector3DReadOnly loadedFootLinearWeight, Vector3DReadOnly footAngularWeight, Vector3DReadOnly footLinearWeight) {
        this.swingState.setWeights(footAngularWeight, footLinearWeight);
        this.supportState.setWeights(loadedFootAngularWeight, loadedFootLinearWeight);
    }

    public void setContactState(ConstraintType constraintType) {
        this.setContactState(constraintType, null);
    }

    public void setContactState(ConstraintType constraintType, FrameVector3D normalContactVector) {
        if (constraintType == ConstraintType.FULL) {
            this.footControlHelper.setFullyConstrainedNormalContactVector(normalContactVector);
        }
        this.controllerToolbox.setFootContactState(this.robotSide, this.contactStatesMap.get((Object)constraintType), normalContactVector);
        if (this.getCurrentConstraintType() == constraintType) {
            return;
        }
        this.requestedState.set((Enum)constraintType);
    }

    public ConstraintType getCurrentConstraintType() {
        return (ConstraintType)this.stateMachine.getCurrentStateKey();
    }

    public void initialize() {
        this.stateMachine.resetToInitialState();
    }

    public void doControl() {
        this.controllerToolbox.setFootContactCoefficientOfFriction(this.robotSide, this.coefficientOfFriction.getValue());
        if (this.resetFootPolygon.getBooleanValue()) {
            this.resetFootPolygon();
        }
        this.stateMachine.doTransitions();
        this.stateMachine.doAction();
    }

    public void resetCurrentState() {
        this.stateMachine.resetCurrentState();
    }

    public boolean isInFlatSupportState() {
        ConstraintType currentConstraintType = this.getCurrentConstraintType();
        return currentConstraintType == ConstraintType.FULL;
    }

    public void setFootstep(FramePose3DReadOnly footstepPoseRelativeToTouchdownCoM, double swingHeight, double swingTime) {
        this.swingState.setFootstep(footstepPoseRelativeToTouchdownCoM, swingHeight, swingTime);
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand() {
        return ((JumpingFootControlState)this.stateMachine.getCurrentState()).getInverseDynamicsCommand();
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand() {
        return ((JumpingFootControlState)this.stateMachine.getCurrentState()).getFeedbackControlCommand();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (ConstraintType constraintType : ConstraintType.values()) {
            JumpingFootControlState state = (JumpingFootControlState)this.stateMachine.getState((Enum)constraintType);
            if (state == null || state.getFeedbackControlCommand() == null) continue;
            ret.addCommand(state.getFeedbackControlCommand());
        }
        return ret;
    }

    private void resetFootPolygon() {
        if (!this.isInFlatSupportState()) {
            return;
        }
        this.resetFootPolygon.set(false);
        this.controllerToolbox.resetFootSupportPolygon(this.robotSide);
    }

    public static enum ConstraintType {
        FULL,
        SWING;


        public boolean isLoadBearing() {
            switch (this) {
                case FULL: {
                    return true;
                }
            }
            return false;
        }
    }
}

