/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.capturePoint.JumpingBalanceManager;
import us.ihmc.commonWalkingControlModules.controlModules.WalkingFailureDetectionControlModule;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFeetManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalHandler;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingStateEnum;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JumpingFlightState
extends JumpingState {
    private static final double swingHeight = 0.01;
    private final JumpingControllerToolbox controllerToolbox;
    private final WalkingFailureDetectionControlModule failureDetectionControlModule;
    private final JumpingBalanceManager balanceManager;
    private final JumpingFeetManager feetManager;
    private final JumpingParameters jumpingParameters;
    private final JumpingGoalHandler jumpingGoalHandler;
    private final JumpingGoal jumpingGoal = new JumpingGoal();
    private final FramePose3D footGoalPose = new FramePose3D();
    private final FramePose3D midFootPose = new FramePose3D();
    private final FramePose3D goalPose = new FramePose3D();
    private final FramePose3D touchdownCoMPose = new FramePose3D();
    private final PoseReferenceFrame touchdownCoMFrame = new PoseReferenceFrame("touchdownCoMFrame", ReferenceFrame.getWorldFrame());
    private final PoseReferenceFrame goalPoseFrame = new PoseReferenceFrame("goalPoseFrame", ReferenceFrame.getWorldFrame());
    private final FrameVector3D comVelocity = new FrameVector3D();
    private static final double minFractionThroughSwingForContact = 0.8;

    public JumpingFlightState(JumpingGoalHandler jumpingGoalHandler, JumpingControllerToolbox controllerToolbox, JumpingControlManagerFactory managerFactory, WalkingFailureDetectionControlModule failureDetectionControlModule, JumpingParameters jumpingParameters, YoRegistry parentRegistry) {
        super(JumpingStateEnum.FLIGHT, parentRegistry);
        this.jumpingGoalHandler = jumpingGoalHandler;
        this.controllerToolbox = controllerToolbox;
        this.failureDetectionControlModule = failureDetectionControlModule;
        this.jumpingParameters = jumpingParameters;
        this.balanceManager = managerFactory.getOrCreateBalanceManager();
        this.feetManager = managerFactory.getOrCreateFeetManager();
    }

    public void doAction(double timeInState) {
        this.balanceManager.computeCoMPlanForJumping(this.jumpingGoal);
    }

    public void onEntry() {
        this.jumpingGoalHandler.pollNextJumpingGoal(this.jumpingGoal);
        this.balanceManager.setMinimizeAngularMomentumRate(false);
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerToolbox.setFootContactStateFree(robotSide);
        }
        this.controllerToolbox.updateBipedSupportPolygons();
        this.balanceManager.initializeCoMPlanForFlight(this.jumpingGoal);
        this.midFootPose.setToZero((ReferenceFrame)this.controllerToolbox.getReferenceFrames().getMidFeetUnderPelvisFrame());
        this.goalPose.setIncludingFrame((FramePose3DReadOnly)this.midFootPose);
        this.goalPose.setX(this.jumpingGoal.getGoalLength());
        if (!Double.isNaN(this.jumpingGoal.getGoalHeight())) {
            this.goalPose.setZ(this.jumpingGoal.getGoalHeight());
        }
        if (!Double.isNaN(this.jumpingGoal.getGoalRotation())) {
            this.goalPose.getOrientation().setToYawOrientation(this.jumpingGoal.getGoalRotation());
        }
        this.goalPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.goalPoseFrame.setPoseAndUpdate((FramePose3DReadOnly)this.goalPose);
        this.touchdownCoMPose.getOrientation().set((FrameQuaternionReadOnly)this.goalPose.getOrientation());
        this.touchdownCoMPose.getPosition().set((FrameTuple3DReadOnly)this.balanceManager.getTouchdownCoMPosition());
        this.touchdownCoMFrame.setPoseAndUpdate((FramePose3DReadOnly)this.touchdownCoMPose);
        for (RobotSide robotSide : RobotSide.values) {
            this.footGoalPose.setToZero((ReferenceFrame)this.goalPoseFrame);
            double width = !Double.isNaN(this.jumpingGoal.getGoalFootWidth()) ? robotSide.negateIfRightSide(0.5 * this.jumpingGoal.getGoalFootWidth()) : robotSide.negateIfRightSide(0.5 * this.jumpingParameters.getDefaultFootWidth());
            this.footGoalPose.setY(width);
            this.footGoalPose.changeFrame((ReferenceFrame)this.touchdownCoMFrame);
            this.correctTouchdownFootPose(this.footGoalPose);
            double flightDuration = !Double.isNaN(this.jumpingGoal.getFlightDuration()) ? this.jumpingGoal.getFlightDuration() : this.jumpingParameters.getDefaultFlightDuration();
            this.feetManager.requestSwing(robotSide, (FramePose3DReadOnly)this.footGoalPose, 0.01, flightDuration);
            this.controllerToolbox.setFootContactStateFree(robotSide);
        }
    }

    private void correctTouchdownFootPose(FramePose3D footPose) {
        this.comVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.controllerToolbox.getCenterOfMassJacobian().getCenterOfMassVelocity());
        this.comVelocity.changeFrame((ReferenceFrame)this.touchdownCoMFrame);
        footPose.checkReferenceFrameMatch((ReferenceFrame)this.touchdownCoMFrame);
        footPose.setX(this.comVelocity.getX() / this.controllerToolbox.getOmega0());
    }

    public void onExit() {
        this.balanceManager.setMinimizeAngularMomentumRate(true);
    }

    public boolean isDone(double timeInState) {
        double desiredFlightDuration;
        double d = desiredFlightDuration = Double.isNaN(this.jumpingGoal.getFlightDuration()) ? this.jumpingParameters.getDefaultFlightDuration() : this.jumpingGoal.getFlightDuration();
        if (timeInState < 0.8 * desiredFlightDuration) {
            return false;
        }
        boolean bothFeetHaveHitGround = true;
        for (RobotSide robotSide : RobotSide.values) {
            if (!((FootSwitchInterface)this.controllerToolbox.getFootSwitches().get((Enum)robotSide)).hasFootHitGround()) {
                bothFeetHaveHitGround = false;
                continue;
            }
            if (this.feetManager.getCurrentConstraintType(robotSide).isLoadBearing()) continue;
            this.feetManager.setFlatFootContactState(robotSide);
            this.controllerToolbox.setFootContactStateFullyConstrained(robotSide);
            this.controllerToolbox.updateBipedSupportPolygons();
        }
        return bothFeetHaveHitGround;
    }
}

