/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingFootControlModule;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.registry.YoRegistry;

public class JumpingFeetManager {
    private static final boolean USE_WORLDFRAME_SURFACE_NORMAL_WHEN_FULLY_CONSTRAINED = true;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<JumpingFootControlModule> footControlModules = new SideDependentList();
    private final SideDependentList<ContactableFoot> feet;
    private final SideDependentList<FootSwitchInterface> footSwitches;
    private final FrameVector3D footNormalContactVector = new FrameVector3D(worldFrame, 0.0, 0.0, 1.0);

    public JumpingFeetManager(JumpingControllerToolbox controllerToolbox, WalkingControllerParameters walkingControllerParameters, PIDSE3GainsReadOnly swingFootGains, YoRegistry parentRegistry) {
        this.feet = controllerToolbox.getContactableFeet();
        this.footSwitches = controllerToolbox.getFootSwitches();
        for (RobotSide robotSide : RobotSide.values) {
            JumpingFootControlModule footControlModule = new JumpingFootControlModule(robotSide, walkingControllerParameters, swingFootGains, controllerToolbox, this.registry);
            this.footControlModules.put((Enum)robotSide, (Object)footControlModule);
        }
        parentRegistry.addChild(this.registry);
    }

    public void setWeights(Vector3DReadOnly loadedFootAngularWeight, Vector3DReadOnly loadedFootLinearWeight, Vector3DReadOnly footAngularWeight, Vector3DReadOnly footLinearWeight) {
        for (RobotSide robotSide : RobotSide.values) {
            JumpingFootControlModule footControlModule = (JumpingFootControlModule)this.footControlModules.get((Enum)robotSide);
            footControlModule.setWeights(loadedFootAngularWeight, loadedFootLinearWeight, footAngularWeight, footLinearWeight);
        }
    }

    public void initialize() {
        for (RobotSide robotSide : RobotSide.values) {
            ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).initialize();
        }
    }

    public void compute() {
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).hasFootHitGround();
            ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).doControl();
        }
    }

    public void requestSwing(RobotSide upcomingSwingSide, FramePose3DReadOnly footstepPoseRelativeToTouchdownCoM, double swingHeight, double swingTime) {
        JumpingFootControlModule footControlModule = (JumpingFootControlModule)this.footControlModules.get((Enum)upcomingSwingSide);
        footControlModule.setFootstep(footstepPoseRelativeToTouchdownCoM, swingHeight, swingTime);
        this.setContactStateForSwing(upcomingSwingSide);
    }

    public JumpingFootControlModule.ConstraintType getCurrentConstraintType(RobotSide robotSide) {
        return ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).getCurrentConstraintType();
    }

    public void initializeContactStatesForDoubleSupport(RobotSide transferToSide) {
        if (transferToSide == null) {
            for (RobotSide robotSide : RobotSide.values) {
                this.setFlatFootContactState(robotSide);
            }
        } else {
            if (this.getCurrentConstraintType(transferToSide.getOppositeSide()) == JumpingFootControlModule.ConstraintType.SWING) {
                this.setFlatFootContactState(transferToSide.getOppositeSide());
            }
            this.setFlatFootContactState(transferToSide);
        }
    }

    public void setFlatFootContactState(RobotSide robotSide) {
        this.footNormalContactVector.setIncludingFrame(worldFrame, 0.0, 0.0, 1.0);
        ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).setContactState(JumpingFootControlModule.ConstraintType.FULL, this.footNormalContactVector);
    }

    public void setContactStateForSwing(RobotSide robotSide) {
        JumpingFootControlModule footControlModule = (JumpingFootControlModule)this.footControlModules.get((Enum)robotSide);
        footControlModule.setContactState(JumpingFootControlModule.ConstraintType.SWING);
    }

    public InverseDynamicsCommand<?> getInverseDynamicsCommand(RobotSide robotSide) {
        return ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).getInverseDynamicsCommand();
    }

    public FeedbackControlCommand<?> getFeedbackControlCommand(RobotSide robotSide) {
        return ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).getFeedbackControlCommand();
    }

    public FeedbackControlCommandList createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        for (RobotSide robotSide : RobotSide.values) {
            FeedbackControlCommandList template = ((JumpingFootControlModule)this.footControlModules.get((Enum)robotSide)).createFeedbackControlTemplate();
            for (int i = 0; i < template.getNumberOfCommands(); ++i) {
                ret.addCommand(template.getCommand(i));
            }
        }
        return ret;
    }
}

