/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.ContactPointVisualizer;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoContactPoint;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.YoPlaneContactState;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.momentumBasedController.CapturePointCalculator;
import us.ihmc.commonWalkingControlModules.referenceFrames.CommonHumanoidReferenceFramesVisualizer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.MovingCenterOfMassReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.controllers.ControllerStateChangedListener;
import us.ihmc.robotics.lists.FrameTuple2dArrayList;
import us.ihmc.robotics.math.filters.AlphaFilteredYoFrameVector;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.MomentumCalculator;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.frames.ReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusChangedListener;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class JumpingControllerToolbox {
    protected static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final YoDouble standingHeight = new YoDouble("StandingHeight", this.registry);
    private final YoDouble squattingHeight = new YoDouble("SquattingHeight", this.registry);
    private final MovingCenterOfMassReferenceFrame centerOfMassFrame;
    private final FullHumanoidRobotModel fullRobotModel;
    private final CapturePointCalculator capturePointCalculator;
    private final CommonHumanoidReferenceFrames referenceFrames;
    private final CommonHumanoidReferenceFramesVisualizer referenceFramesVisualizer;
    private final SideDependentList<ContactableFoot> feet;
    private final SideDependentList<YoPlaneContactState> footContactStates = new SideDependentList();
    private final SideDependentList<FrameConvexPolygon2D> defaultFootPolygons = new SideDependentList();
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver;
    private final YoDouble finalTransferTime;
    private final ArrayList<Updatable> updatables = new ArrayList();
    private final YoDouble yoTime;
    private final double controlDT;
    private final double gravity;
    private final SideDependentList<FootSwitchInterface> footSwitches;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final JointBasics[] controlledJoints;
    private final OneDoFJointBasics[] controlledOneDoFJoints;
    private final OneDoFJointBasics[] uncontrolledOneDoFJoints;
    private final ArrayList<ControllerFailureListener> controllerFailureListeners = new ArrayList();
    private final ArrayList<ControllerStateChangedListener> controllerStateChangedListeners = new ArrayList();
    private final ArrayList<RobotMotionStatusChangedListener> robotMotionStatusChangedListeners = new ArrayList();
    private final BipedSupportPolygons bipedSupportPolygons;
    private final SideDependentList<FrameTuple2dArrayList<FramePoint2D>> previousFootContactPoints = new SideDependentList((Object)FrameTuple2dArrayList.createFramePoint2dArrayList(), (Object)FrameTuple2dArrayList.createFramePoint2dArrayList());
    private final YoFramePoint3D yoCapturePoint = new YoFramePoint3D("capturePoint", worldFrame, this.registry);
    private final YoDouble omega0 = new YoDouble("omega0", this.registry);
    private final MomentumCalculator momentumCalculator;
    private final YoFrameVector3D yoAngularMomentum;
    private final AlphaFilteredYoFrameVector filteredYoAngularMomentum;
    private final YoDouble totalMass = new YoDouble("TotalMass", this.registry);
    private final FramePoint2D centerOfPressure = new FramePoint2D();
    private final YoFramePoint2D yoCenterOfPressure = new YoFramePoint2D("CenterOfPressure", worldFrame, this.registry);
    private final YoBoolean controllerFailed = new YoBoolean("controllerFailed", this.registry);
    private final FramePoint2D tempFootCop2d = new FramePoint2D();
    private final FramePoint3D tempFootCop = new FramePoint3D();
    private final Wrench tempFootWrench = new Wrench();
    private final FramePoint2DBasics capturePoint2d = new FramePoint2D(worldFrame);
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final Momentum robotMomentum = new Momentum();
    private final FramePoint3D tempPosition = new FramePoint3D();

    public JumpingControllerToolbox(FullHumanoidRobotModel fullRobotModel, CommonHumanoidReferenceFrames referenceFrames, WalkingControllerParameters walkingControllerParameters, SideDependentList<? extends FootSwitchInterface> footSwitches, YoDouble yoTime, double gravityZ, double omega0, SideDependentList<ContactableFoot> feet, double controlDT, List<Updatable> updatables, YoGraphicsListRegistry yoGraphicsListRegistry, JointBasics ... jointsToIgnore) {
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        this.standingHeight.set(1.05);
        this.squattingHeight.set(0.7);
        this.finalTransferTime = new YoDouble("finalTransferTime", this.registry);
        this.finalTransferTime.set(0.25);
        this.bipedSupportPolygons = new BipedSupportPolygons(referenceFrames, this.registry, yoGraphicsListRegistry);
        this.footSwitches = new SideDependentList(footSwitches);
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver((FullRobotModel)fullRobotModel, (ReferenceFrames)referenceFrames);
        this.centerOfMassFrame = new MovingCenterOfMassReferenceFrame("centerOfMassFrame", worldFrame, (RigidBodyReadOnly)fullRobotModel.getElevator());
        this.capturePointCalculator = new CapturePointCalculator((ReferenceFrame)this.centerOfMassFrame, fullRobotModel.getElevator());
        MathTools.checkIntervalContains((double)gravityZ, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.fullRobotModel = fullRobotModel;
        this.referenceFrames = referenceFrames;
        this.controlDT = controlDT;
        this.gravity = gravityZ;
        this.yoTime = yoTime;
        this.omega0.set(omega0);
        this.referenceFramesVisualizer = yoGraphicsListRegistry != null ? new CommonHumanoidReferenceFramesVisualizer(referenceFrames, yoGraphicsListRegistry, this.registry, new ReferenceFrame[0]) : null;
        this.feet = feet;
        RigidBodyBasics elevator = fullRobotModel.getElevator();
        double totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)elevator);
        if (updatables != null) {
            this.updatables.addAll(updatables);
        }
        double coefficientOfFriction = 1.0;
        for (RobotSide robotSide : RobotSide.values) {
            ContactableFoot contactableFoot = (ContactableFoot)feet.get((Enum)robotSide);
            RigidBodyBasics rigidBody = contactableFoot.getRigidBody();
            YoPlaneContactState contactState = new YoPlaneContactState(contactableFoot.getSoleFrame().getName(), rigidBody, contactableFoot.getSoleFrame(), contactableFoot.getContactPoints2d(), coefficientOfFriction, this.registry);
            this.footContactStates.put((Enum)robotSide, (Object)contactState);
            ((FrameTuple2dArrayList)this.previousFootContactPoints.get((Enum)robotSide)).copyFromListAndTrimSize(contactableFoot.getContactPoints2d());
            FrameConvexPolygon2D defaultFootPolygon = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier((List)contactableFoot.getContactPoints2d()));
            this.defaultFootPolygons.put((Enum)robotSide, (Object)defaultFootPolygon);
        }
        this.controlledJoints = JumpingControllerToolbox.computeJointsToOptimizeFor(fullRobotModel, jointsToIgnore);
        this.controlledOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])this.controlledJoints, OneDoFJointBasics.class);
        this.uncontrolledOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])jointsToIgnore, OneDoFJointBasics.class);
        if (yoGraphicsListRegistry != null) {
            ArrayList<YoPlaneContactState> planeContactStateList = new ArrayList<YoPlaneContactState>();
            for (RobotSide robotSide : RobotSide.values) {
                planeContactStateList.add((YoPlaneContactState)this.footContactStates.get((Enum)robotSide));
            }
            ContactPointVisualizer contactPointVisualizer = new ContactPointVisualizer(planeContactStateList, yoGraphicsListRegistry, this.registry);
            this.addUpdatable(contactPointVisualizer);
        }
        String graphicListName = this.getClass().getSimpleName();
        if (yoGraphicsListRegistry != null) {
            YoArtifactPosition copViz = new YoArtifactPosition("Controller CoP", this.yoCenterOfPressure.getYoX(), this.yoCenterOfPressure.getYoY(), YoGraphicPosition.GraphicType.DIAMOND, Color.BLACK, 0.005);
            yoGraphicsListRegistry.registerArtifact(graphicListName, (Artifact)copViz);
        }
        this.yoCenterOfPressure.setToNaN();
        this.totalMass.set(totalMass);
        this.momentumCalculator = new MomentumCalculator(fullRobotModel.getElevator().subtreeArray());
        this.yoAngularMomentum = new YoFrameVector3D("AngularMomentum", (ReferenceFrame)this.centerOfMassFrame, this.registry);
        YoDouble alpha = new YoDouble("filteredAngularMomentumAlpha", this.registry);
        alpha.set(0.95);
        this.filteredYoAngularMomentum = new AlphaFilteredYoFrameVector("filteredAngularMomentum", "", this.registry, (DoubleProvider)alpha, (FrameTuple3DReadOnly)this.yoAngularMomentum);
        this.attachControllerFailureListener(fallingDirection -> this.controllerFailed.set(true));
    }

    public static JointBasics[] computeJointsToOptimizeFor(FullHumanoidRobotModel fullRobotModel, JointBasics ... jointsToRemove) {
        ArrayList<JointBasics> joints = new ArrayList<JointBasics>();
        JointBasics[] allJoints = MultiBodySystemTools.collectSupportAndSubtreeJoints((RigidBodyBasics)fullRobotModel.getRootJoint().getSuccessor());
        joints.addAll(Arrays.asList(allJoints));
        for (RobotSide robotSide : RobotSide.values) {
            RigidBodyBasics hand = fullRobotModel.getHand(robotSide);
            if (hand == null) continue;
            List<JointBasics> fingerJoints = Arrays.asList(MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{hand}));
            joints.removeAll(fingerJoints);
        }
        if (jointsToRemove != null) {
            for (RobotSide robotSide : jointsToRemove) {
                joints.remove(robotSide);
            }
        }
        return joints.toArray(new JointBasics[joints.size()]);
    }

    public SideDependentList<YoPlaneContactState> getFootContactStates() {
        return this.footContactStates;
    }

    public void update() {
        this.referenceFrames.updateFrames();
        this.centerOfMassFrame.update();
        if (this.referenceFramesVisualizer != null) {
            this.referenceFramesVisualizer.update();
        }
        this.computeCop();
        this.computeCapturePoint();
        this.updateBipedSupportPolygons();
        this.computeAngularMomentum();
        for (int i = 0; i < this.updatables.size(); ++i) {
            this.updatables.get(i).update(this.yoTime.getDoubleValue());
        }
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).updateCoP();
        }
    }

    private void computeCop() {
        double force = 0.0;
        this.centerOfPressure.setToZero(worldFrame);
        for (RobotSide robotSide : RobotSide.values) {
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).computeAndPackCoP(this.tempFootCop2d);
            if (this.tempFootCop2d.containsNaN()) continue;
            ((FootSwitchInterface)this.footSwitches.get((Enum)robotSide)).computeAndPackFootWrench(this.tempFootWrench);
            double footForce = this.tempFootWrench.getLinearPartZ();
            force += footForce;
            this.tempFootCop.setIncludingFrame(this.tempFootCop2d.getReferenceFrame(), this.tempFootCop2d.getX(), this.tempFootCop2d.getY(), 0.0);
            this.tempFootCop.changeFrame(worldFrame);
            this.tempFootCop.scale(footForce);
            this.centerOfPressure.add(this.tempFootCop.getX(), this.tempFootCop.getY());
        }
        this.centerOfPressure.scale(1.0 / force);
        this.yoCenterOfPressure.set((FrameTuple2DReadOnly)this.centerOfPressure);
    }

    public void updateBipedSupportPolygons() {
        this.bipedSupportPolygons.updateUsingContactStates(this.footContactStates);
    }

    private void computeCapturePoint() {
        this.capturePointCalculator.compute(this.capturePoint2d, this.omega0.getValue());
        this.capturePoint2d.changeFrame(this.yoCapturePoint.getReferenceFrame());
        this.yoCapturePoint.set((FrameTuple2DReadOnly)this.capturePoint2d, 0.0);
    }

    public CenterOfMassJacobian getCenterOfMassJacobian() {
        return this.capturePointCalculator.getCenterOfMassJacobian();
    }

    private void computeAngularMomentum() {
        this.robotMomentum.setToZero((ReferenceFrame)this.centerOfMassFrame);
        this.momentumCalculator.computeAndPack(this.robotMomentum);
        this.angularMomentum.setIncludingFrame((FrameTuple3DReadOnly)this.robotMomentum.getAngularPart());
        this.yoAngularMomentum.set((FrameTuple3DReadOnly)this.angularMomentum);
        this.filteredYoAngularMomentum.update();
    }

    public void getCapturePoint(FixedFramePoint2DBasics capturePointToPack) {
        capturePointToPack.set((FrameTuple3DReadOnly)this.yoCapturePoint);
    }

    public FramePoint3DReadOnly getCapturePoint() {
        return this.yoCapturePoint;
    }

    public YoFramePoint3D getYoCapturePoint() {
        return this.yoCapturePoint;
    }

    public double getStandingHeight() {
        return this.standingHeight.getDoubleValue();
    }

    public double getSquattingHeight() {
        return this.squattingHeight.getDoubleValue();
    }

    public void getCapturePoint(FixedFramePoint3DBasics capturePointToPack) {
        capturePointToPack.setMatchingFrame((FrameTuple3DReadOnly)this.yoCapturePoint);
    }

    public void addUpdatable(Updatable updatable) {
        this.updatables.add(updatable);
    }

    public void addUpdatables(List<Updatable> updatables) {
        for (int i = 0; i < updatables.size(); ++i) {
            this.updatables.add(updatables.get(i));
        }
    }

    public void initialize() {
        this.update();
        for (RobotSide robotSide : RobotSide.values) {
            ((YoPlaneContactState)this.footContactStates.get((Enum)robotSide)).notifyContactStateHasChanged();
        }
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.getName();
    }

    public void resetFootPlaneContactPoint(RobotSide robotSide) {
        ContactablePlaneBody foot = (ContactablePlaneBody)this.feet.get((Enum)robotSide);
        YoPlaneContactState footContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        List defaultContactPoints = foot.getContactPoints2d();
        ((FrameTuple2dArrayList)this.previousFootContactPoints.get((Enum)robotSide)).copyFromListAndTrimSize(defaultContactPoints);
        footContactState.setContactFramePoints(defaultContactPoints);
    }

    public void setFootContactCoefficientOfFriction(RobotSide robotSide, double coefficientOfFriction) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setCoefficientOfFriction(coefficientOfFriction);
    }

    public void setFootContactStateNormalContactVector(RobotSide robotSide, FrameVector3D normalContactVector) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setContactNormalVector((FrameVector3DReadOnly)normalContactVector);
    }

    public void setFootContactState(RobotSide robotSide, boolean[] newContactPointStates, FrameVector3D normalContactVector) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setContactPointsInContact(newContactPointStates);
        yoPlaneContactState.setContactNormalVector((FrameVector3DReadOnly)normalContactVector);
    }

    public void setFootContactStateFullyConstrained(RobotSide robotSide) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        yoPlaneContactState.setFullyConstrained();
    }

    public void setFootContactStateFree(RobotSide robotSide) {
        YoPlaneContactState yoPlaneContactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        if (yoPlaneContactState != null) {
            yoPlaneContactState.clear();
        }
    }

    public MovingReferenceFrame getCenterOfMassFrame() {
        return this.centerOfMassFrame;
    }

    public ReferenceFrame getPelvisZUpFrame() {
        return this.referenceFrames.getPelvisZUpFrame();
    }

    public CommonHumanoidReferenceFrames getReferenceFrames() {
        return this.referenceFrames;
    }

    public YoDouble getYoTime() {
        return this.yoTime;
    }

    public double getGravityZ() {
        return this.gravity;
    }

    public double getControlDT() {
        return this.controlDT;
    }

    public FullHumanoidRobotModel getFullRobotModel() {
        return this.fullRobotModel;
    }

    public SideDependentList<ContactableFoot> getContactableFeet() {
        return this.feet;
    }

    public YoPlaneContactState getFootContactState(RobotSide robotSide) {
        return (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
    }

    public void clearContacts() {
        for (RobotSide robotSide : RobotSide.values) {
            ((YoPlaneContactState)this.footContactStates.get((Enum)robotSide)).clear();
        }
    }

    public SideDependentList<FootSwitchInterface> getFootSwitches() {
        return this.footSwitches;
    }

    public BipedSupportPolygons getBipedSupportPolygons() {
        return this.bipedSupportPolygons;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public JointBasics[] getControlledJoints() {
        return this.controlledJoints;
    }

    public OneDoFJointBasics[] getControlledOneDoFJoints() {
        return this.controlledOneDoFJoints;
    }

    public OneDoFJointBasics[] getUncontrolledOneDoFJoints() {
        return this.uncontrolledOneDoFJoints;
    }

    public YoBoolean getControllerFailedBoolean() {
        return this.controllerFailed;
    }

    public void attachControllerFailureListener(ControllerFailureListener listener) {
        this.controllerFailureListeners.add(listener);
    }

    public void reportControllerFailureToListeners(FrameVector2D fallingDirection) {
        for (int i = 0; i < this.controllerFailureListeners.size(); ++i) {
            this.controllerFailureListeners.get(i).controllerFailed(fallingDirection);
        }
    }

    public void attachControllerStateChangedListener(ControllerStateChangedListener listener) {
        this.controllerStateChangedListeners.add(listener);
    }

    public void attachControllerStateChangedListeners(List<ControllerStateChangedListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.attachControllerStateChangedListener(listeners.get(i));
        }
    }

    public void reportControllerStateChangeToListeners(Enum<?> oldState, Enum<?> newState) {
        for (int i = 0; i < this.controllerStateChangedListeners.size(); ++i) {
            this.controllerStateChangedListeners.get(i).controllerStateHasChanged(oldState, newState);
        }
    }

    public void attachRobotMotionStatusChangedListener(RobotMotionStatusChangedListener listener) {
        this.robotMotionStatusChangedListeners.add(listener);
    }

    public void detachRobotMotionStatusChangedListener(RobotMotionStatusChangedListener listener) {
        this.robotMotionStatusChangedListeners.remove(listener);
    }

    public void reportChangeOfRobotMotionStatus(RobotMotionStatus newStatus) {
        for (int i = 0; i < this.robotMotionStatusChangedListeners.size(); ++i) {
            this.robotMotionStatusChangedListeners.get(i).robotMotionStatusHasChanged(newStatus, this.yoTime.getDoubleValue());
        }
    }

    public void resetFootSupportPolygon(RobotSide robotSide) {
        YoPlaneContactState contactState = (YoPlaneContactState)this.footContactStates.get((Enum)robotSide);
        List<YoContactPoint> contactPoints = contactState.getContactPoints();
        FrameConvexPolygon2D defaultSupportPolygon = (FrameConvexPolygon2D)this.defaultFootPolygons.get((Enum)robotSide);
        for (int i = 0; i < defaultSupportPolygon.getNumberOfVertices(); ++i) {
            this.tempPosition.setIncludingFrame((FrameTuple2DReadOnly)defaultSupportPolygon.getVertex(i), 0.0);
            contactPoints.get(i).setMatchingFrame((FrameTuple3DReadOnly)this.tempPosition);
        }
        contactState.notifyContactStateHasChanged();
    }

    public ConvexPolygon2DReadOnly getDefaultFootPolygon() {
        return (ConvexPolygon2DReadOnly)this.defaultFootPolygons.get((Enum)RobotSide.LEFT);
    }

    public double getOmega0() {
        return this.omega0.getDoubleValue();
    }

    public YoDouble getOmega0Provider() {
        return this.omega0;
    }

    public void getAngularMomentum(FrameVector3D upperBodyAngularMomentumToPack) {
        upperBodyAngularMomentumToPack.setIncludingFrame((FrameTuple3DReadOnly)this.angularMomentum);
    }

    public ReferenceFrameHashCodeResolver getReferenceFrameHashCodeResolver() {
        return this.referenceFrameHashCodeResolver;
    }

    public double getFinalTransferTime() {
        return this.finalTransferTime.getDoubleValue();
    }
}

