/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController;

import java.util.ArrayList;
import us.ihmc.commonWalkingControlModules.capturePoint.JumpingMomentumRateControlModule;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingControllerToolbox;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoal;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalHandler;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingHumanoidController;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingParameters;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.variable.YoBoolean;

public class JumpingControllerState
extends HighLevelControllerState {
    private static final HighLevelControllerName controllerState = HighLevelControllerName.WALKING;
    private final WholeBodyControllerCore controllerCore;
    private final JumpingMomentumRateControlModule momentumRateControlModule;
    private final JumpingHumanoidController jumpingController;
    private final ExecutionTimer controllerCoreTimer;
    private boolean requestIntegratorReset;
    private final YoBoolean yoRequestingIntegratorReset;
    private final JumpingControllerToolbox controllerToolbox;
    private final JointDesiredOutputList jointDesiredOutputList;
    private final JointDesiredOutputList uncontrolledJointDesiredOutputList;
    private final CommandInputManager commandInputManager;
    private final JumpingGoalHandler jumpingGoalHandler;

    public JumpingControllerState(CommandInputManager commandInputManager, JumpingControlManagerFactory managerFactory, JumpingControllerToolbox controllerToolbox, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters, JumpingCoPTrajectoryParameters jumpingCoPTrajectoryParameters, JumpingParameters jumpingParameters) {
        super(controllerState, highLevelControllerParameters, (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])controllerToolbox.getControlledJoints(), OneDoFJointBasics.class));
        this.controllerCoreTimer = new ExecutionTimer("controllerCoreTimer", 1.0, this.registry);
        this.requestIntegratorReset = false;
        this.yoRequestingIntegratorReset = new YoBoolean("RequestingIntegratorReset", this.registry);
        this.commandInputManager = commandInputManager;
        this.controllerToolbox = controllerToolbox;
        this.jumpingGoalHandler = new JumpingGoalHandler(jumpingParameters);
        controllerToolbox.getControlledJoints();
        this.jointDesiredOutputList = new JointDesiredOutputList((OneDoFJointReadOnly[])controllerToolbox.getFullRobotModel().getOneDoFJoints());
        this.uncontrolledJointDesiredOutputList = new JointDesiredOutputList((OneDoFJointReadOnly[])controllerToolbox.getUncontrolledOneDoFJoints());
        for (OneDoFJointBasics oneDoFJointBasics : controllerToolbox.getUncontrolledOneDoFJoints()) {
            this.uncontrolledJointDesiredOutputList.setJointControlMode((OneDoFJointReadOnly)oneDoFJointBasics, JointDesiredControlMode.EFFORT);
            this.uncontrolledJointDesiredOutputList.setDesiredJointTorque((OneDoFJointReadOnly)oneDoFJointBasics, 0.0);
        }
        this.jumpingController = new JumpingHumanoidController(this.jumpingGoalHandler, managerFactory, walkingControllerParameters, jumpingParameters, controllerToolbox);
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        JointBasics[] jointsToOptimizeFor = controllerToolbox.getControlledJoints();
        ArrayList<ContactablePlaneBody> contactableBodies = new ArrayList<ContactablePlaneBody>();
        for (RobotSide robotSide : RobotSide.values) {
            contactableBodies.add((ContactablePlaneBody)controllerToolbox.getContactableFeet().get((Enum)robotSide));
        }
        FloatingJointBasics floatingJointBasics = fullRobotModel.getRootJoint();
        MovingReferenceFrame centerOfMassFrame = controllerToolbox.getCenterOfMassFrame();
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(controllerToolbox.getControlDT(), controllerToolbox.getGravityZ(), floatingJointBasics, jointsToOptimizeFor, (ReferenceFrame)centerOfMassFrame, walkingControllerParameters.getMomentumOptimizationSettings(), controllerToolbox.getYoGraphicsListRegistry(), this.registry);
        toolbox.setJointPrivilegedConfigurationParameters(walkingControllerParameters.getJointPrivilegedConfigurationParameters());
        toolbox.setFeedbackControllerSettings(walkingControllerParameters.getFeedbackControllerSettings());
        toolbox.setupForInverseDynamicsSolver(contactableBodies);
        FeedbackControllerTemplate template = managerFactory.createFeedbackControlTemplate();
        template.setAllowDynamicControllerConstruction(false);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.controlledJoints);
        this.controllerCore = new WholeBodyControllerCore(toolbox, template, lowLevelControllerOutput, this.registry);
        this.momentumRateControlModule = new JumpingMomentumRateControlModule(controllerToolbox, walkingControllerParameters, this.registry);
        this.registry.addChild(this.jumpingController.getYoVariableRegistry());
    }

    public void initialize() {
        this.controllerCore.initialize();
        this.jumpingController.initialize();
        this.momentumRateControlModule.reset();
        this.requestIntegratorReset = true;
    }

    public void doAction(double timeInState) {
        if (this.commandInputManager.isNewCommandAvailable(JumpingGoal.class)) {
            this.jumpingGoalHandler.consumeJumpingGoal((JumpingGoal)this.commandInputManager.pollNewestCommand(JumpingGoal.class));
        }
        this.controllerToolbox.update();
        this.jumpingController.doAction();
        this.momentumRateControlModule.setInputFromWalkingStateMachine(this.jumpingController.getJumpingMomentumRateControlModuleInput());
        this.momentumRateControlModule.computeControllerCoreCommands();
        ControllerCoreCommand controllerCoreCommand = this.jumpingController.getControllerCoreCommand();
        controllerCoreCommand.addInverseDynamicsCommand(this.momentumRateControlModule.getInverseDynamicsCommand());
        JointDesiredOutputList stateSpecificJointSettings = this.getStateSpecificJointSettings();
        if (this.requestIntegratorReset) {
            stateSpecificJointSettings.requestIntegratorReset();
            this.requestIntegratorReset = false;
            this.yoRequestingIntegratorReset.set(true);
        } else {
            this.yoRequestingIntegratorReset.set(false);
        }
        controllerCoreCommand.addInverseDynamicsCommand(this.getAccelerationIntegrationCommand());
        controllerCoreCommand.completeLowLevelJointData((JointDesiredOutputListReadOnly)stateSpecificJointSettings);
        this.controllerCoreTimer.startMeasurement();
        this.controllerCore.submitControllerCoreCommand(controllerCoreCommand);
        this.controllerCore.compute();
        this.controllerCoreTimer.stopMeasurement();
        this.momentumRateControlModule.setInputFromControllerCore(this.controllerCore.getControllerCoreOutput());
        this.momentumRateControlModule.computeAchievedCMP();
        this.jointDesiredOutputList.clear();
        this.jointDesiredOutputList.overwriteWith(this.controllerCore.getOutputForLowLevelController());
        this.jointDesiredOutputList.completeWith((JointDesiredOutputListReadOnly)this.uncontrolledJointDesiredOutputList);
    }

    public void onEntry() {
        this.initialize();
    }

    public void onExit() {
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.UNKNOWN);
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.jointDesiredOutputList;
    }

    @Override
    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.controllerCore.getOutputForRootJoint();
    }

    @Override
    public boolean isJointLoadBearing(String jointName) {
        return this.jumpingController.isJointLoadBearing(jointName);
    }
}

