/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModule;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCore;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WalkingHighLevelHumanoidController;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.walkingController.states.WalkingStateEnum;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingControllerState
extends HighLevelControllerState {
    private static final HighLevelControllerName controllerState = HighLevelControllerName.WALKING;
    private static final FrameVector2D emptyVector = new FrameVector2D();
    private final WholeBodyControllerCore controllerCore;
    private final LinearMomentumRateControlModule linearMomentumRateControlModule;
    private final WalkingHighLevelHumanoidController walkingController;
    private final ExecutionTimer controllerCoreTimer;
    private boolean setupInverseDynamicsSolver;
    private boolean setupInverseKinematicsSolver;
    private boolean setupVirtualModelControlSolver;
    private final boolean deactivateAccelerationIntegrationInWBC;
    private boolean requestIntegratorReset;
    private final YoBoolean yoRequestingIntegratorReset;
    private final BooleanParameter useCoPObjective;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;

    public WalkingControllerState(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, HighLevelControlManagerFactory managerFactory, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters) {
        super(controllerState, highLevelControllerParameters, (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])controllerToolbox.getControlledJoints(), OneDoFJointBasics.class));
        this.controllerCoreTimer = new ExecutionTimer("controllerCoreTimer", 1.0, this.registry);
        this.setupInverseDynamicsSolver = true;
        this.setupInverseKinematicsSolver = false;
        this.setupVirtualModelControlSolver = false;
        this.requestIntegratorReset = false;
        this.yoRequestingIntegratorReset = new YoBoolean("RequestingIntegratorReset", this.registry);
        this.useCoPObjective = new BooleanParameter("UseCenterOfPressureObjectiveFromPlanner", this.registry, false);
        this.controllerToolbox = controllerToolbox;
        this.walkingController = new WalkingHighLevelHumanoidController(commandInputManager, statusOutputManager, managerFactory, walkingControllerParameters, controllerToolbox);
        FullHumanoidRobotModel fullRobotModel = controllerToolbox.getFullRobotModel();
        JointBasics[] jointsToOptimizeFor = controllerToolbox.getControlledJoints();
        FloatingJointBasics rootJoint = fullRobotModel.getRootJoint();
        ReferenceFrame centerOfMassFrame = controllerToolbox.getCenterOfMassFrame();
        WholeBodyControlCoreToolbox toolbox = new WholeBodyControlCoreToolbox(controllerToolbox.getControlDT(), controllerToolbox.getGravityZ(), rootJoint, jointsToOptimizeFor, centerOfMassFrame, walkingControllerParameters.getMomentumOptimizationSettings(), controllerToolbox.getYoGraphicsListRegistry(), this.registry);
        toolbox.setJointPrivilegedConfigurationParameters(walkingControllerParameters.getJointPrivilegedConfigurationParameters());
        toolbox.setFeedbackControllerSettings(walkingControllerParameters.getFeedbackControllerSettings());
        if (this.setupInverseDynamicsSolver) {
            toolbox.setupForInverseDynamicsSolver(controllerToolbox.getContactablePlaneBodies());
        }
        if (this.setupInverseKinematicsSolver) {
            toolbox.setupForInverseKinematicsSolver();
        }
        if (this.setupVirtualModelControlSolver) {
            toolbox.setupForVirtualModelControlSolver(fullRobotModel.getPelvis(), controllerToolbox.getContactablePlaneBodies());
        }
        fullRobotModel.getKinematicLoops().forEach(toolbox::addKinematicLoopFunction);
        FeedbackControllerTemplate template = managerFactory.createFeedbackControlTemplate();
        template.setAllowDynamicControllerConstruction(false);
        JointDesiredOutputList lowLevelControllerOutput = new JointDesiredOutputList((OneDoFJointReadOnly[])this.controlledJoints);
        this.controllerCore = new WholeBodyControllerCore(toolbox, template, lowLevelControllerOutput, this.registry);
        ControllerCoreOutputReadOnly controllerCoreOutput = this.controllerCore.getOutputForHighLevelController();
        this.walkingController.setControllerCoreOutput(controllerCoreOutput);
        this.deactivateAccelerationIntegrationInWBC = highLevelControllerParameters.deactivateAccelerationIntegrationInTheWBC();
        double controlDT = controllerToolbox.getControlDT();
        double gravityZ = controllerToolbox.getGravityZ();
        RigidBodyBasics elevator = fullRobotModel.getElevator();
        CommonHumanoidReferenceFrames referenceFrames = controllerToolbox.getReferenceFrames();
        YoDouble yoTime = controllerToolbox.getYoTime();
        YoGraphicsListRegistry yoGraphicsListRegistry = controllerToolbox.getYoGraphicsListRegistry();
        SideDependentList<ContactableFoot> contactableFeet = controllerToolbox.getContactableFeet();
        this.linearMomentumRateControlModule = new LinearMomentumRateControlModule(referenceFrames, contactableFeet, elevator, walkingControllerParameters, gravityZ, controlDT, this.registry, yoGraphicsListRegistry);
        managerFactory.getOrCreateBalanceManager().setPlanarRegionStepConstraintHandler(controllerToolbox.getWalkingMessageHandler().getStepConstraintRegionHandler());
        this.registry.addChild(this.walkingController.getYoVariableRegistry());
    }

    public void setupControllerCoreInverseDynamicsMode(boolean setup) {
        this.setupInverseDynamicsSolver = setup;
    }

    public void setupControllerCoreInverseKinematicsMode(boolean setup) {
        this.setupInverseKinematicsSolver = setup;
    }

    public void setupControllerCoreVirtualModelControlMode(boolean setup) {
        this.setupVirtualModelControlSolver = setup;
    }

    public void initialize() {
        this.controllerCore.initialize();
        this.walkingController.initialize();
        this.linearMomentumRateControlModule.reset();
        this.requestIntegratorReset = true;
    }

    public void doAction(double timeInState) {
        this.walkingController.doAction();
        this.linearMomentumRateControlModule.setInputFromWalkingStateMachine(this.walkingController.getLinearMomentumRateControlModuleInput());
        if (!this.linearMomentumRateControlModule.computeControllerCoreCommands()) {
            this.controllerToolbox.reportControllerFailureToListeners(emptyVector);
        }
        this.walkingController.setLinearMomentumRateControlModuleOutput(this.linearMomentumRateControlModule.getOutputForWalkingStateMachine());
        ControllerCoreCommand controllerCoreCommand = this.walkingController.getControllerCoreCommand();
        controllerCoreCommand.addInverseDynamicsCommand(this.linearMomentumRateControlModule.getMomentumRateCommand());
        if (this.useCoPObjective.getValue()) {
            controllerCoreCommand.addInverseDynamicsCommand(this.linearMomentumRateControlModule.getCenterOfPressureCommand());
        }
        JointDesiredOutputList stateSpecificJointSettings = this.getStateSpecificJointSettings();
        if (this.requestIntegratorReset) {
            stateSpecificJointSettings.requestIntegratorReset();
            this.requestIntegratorReset = false;
            this.yoRequestingIntegratorReset.set(true);
        } else {
            this.yoRequestingIntegratorReset.set(false);
        }
        JointAccelerationIntegrationCommand accelerationIntegrationCommand = this.getAccelerationIntegrationCommand();
        if (!this.deactivateAccelerationIntegrationInWBC) {
            controllerCoreCommand.addInverseDynamicsCommand(accelerationIntegrationCommand);
        }
        controllerCoreCommand.completeLowLevelJointData((JointDesiredOutputListReadOnly)stateSpecificJointSettings);
        this.controllerCoreTimer.startMeasurement();
        this.controllerCore.submitControllerCoreCommand(controllerCoreCommand);
        this.controllerCore.compute();
        this.controllerCoreTimer.stopMeasurement();
        this.linearMomentumRateControlModule.setInputFromControllerCore(this.controllerCore.getControllerCoreOutput());
        this.linearMomentumRateControlModule.computeAchievedCMP();
    }

    public void onEntry() {
        this.initialize();
    }

    public void onExit() {
        this.controllerToolbox.reportChangeOfRobotMotionStatus(RobotMotionStatus.UNKNOWN);
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.controllerCore.getOutputForLowLevelController();
    }

    @Override
    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.controllerCore.getOutputForRootJoint();
    }

    @Override
    public boolean isJointLoadBearing(String jointName) {
        return this.walkingController.isJointLoadBearing(jointName);
    }

    public WalkingStateEnum getWalkingStateEnum() {
        return this.walkingController.getWalkingStateEnum();
    }
}

