/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import com.google.common.base.CaseFormat;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.math.trajectories.yoVariables.YoPolynomial;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class StandPrepControllerState
extends HighLevelControllerState {
    private static final HighLevelControllerName controllerState = HighLevelControllerName.STAND_PREP_STATE;
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final PairList<OneDoFJointBasics, TrajectoryData> jointsData = new PairList();
    private final YoBoolean reinitialize = new YoBoolean("standPrepReinitialize", this.registry);
    private final YoBoolean continuousUpdate = new YoBoolean("standPrepContinuousUpdate", this.registry);
    private final YoDouble splineStartTime = new YoDouble("standPrepSplineStartTime", this.registry);
    private final YoDouble timeToPrepareForStanding = new YoDouble("timeToPrepareForStanding", this.registry);
    private final YoDouble minimumTimeDoneWithStandPrep = new YoDouble("minimumTimeDoneWithStandPrep", this.registry);
    private final JointDesiredOutputListReadOnly highLevelControlOutput;
    private final DoubleProvider timeProvider;

    public StandPrepControllerState(OneDoFJointBasics[] controlledJoints, HighLevelControllerParameters highLevelControllerParameters, JointDesiredOutputListReadOnly highLevelControlOutput, DoubleProvider timeProvider) {
        super(controllerState, highLevelControllerParameters, controlledJoints);
        this.highLevelControlOutput = highLevelControlOutput;
        this.timeProvider = timeProvider;
        this.timeToPrepareForStanding.set(highLevelControllerParameters.getTimeToMoveInStandPrep());
        WholeBodySetpointParameters standPrepParameters = highLevelControllerParameters.getStandPrepParameters();
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])controlledJoints);
        for (OneDoFJointBasics controlledJoint : controlledJoints) {
            String jointName = controlledJoint.getName();
            String namePrefix = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, jointName);
            YoPolynomial trajectory = new YoPolynomial(namePrefix + "StandPrepTrajectory", 4, this.registry);
            DoubleParameter standPrepFinalConfiguration = new DoubleParameter(namePrefix + "StandPrepPosition", this.registry, standPrepParameters.getSetpoint(jointName));
            YoDouble standPrepDesiredConfiguration = new YoDouble(namePrefix + "StandPrepCurrentDesired", this.registry);
            TrajectoryData jointData = new TrajectoryData((DoubleProvider)standPrepFinalConfiguration, standPrepDesiredConfiguration, trajectory);
            this.jointsData.add((Object)controlledJoint, (Object)jointData);
        }
    }

    public void setMinimumTimeDoneWithStandPrep(double minimumTimeDoneWithStandPrep) {
        this.minimumTimeDoneWithStandPrep.set(minimumTimeDoneWithStandPrep);
    }

    public void onEntry() {
        this.continuousUpdate.set(false);
        this.reinitialize.set(false);
        if (this.timeProvider != null) {
            this.initializeSplines(this.timeProvider.getValue());
        } else {
            this.initializeSplines(0.0);
        }
    }

    public void initializeSplines(double startTime) {
        this.splineStartTime.set(startTime);
        for (int jointIndex = 0; jointIndex < this.jointsData.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointsData.get(jointIndex)).getLeft();
            TrajectoryData trajectoryData = (TrajectoryData)((ImmutablePair)this.jointsData.get(jointIndex)).getRight();
            DoubleProvider standPrepFinal = trajectoryData.getFinalJointConfiguration();
            YoPolynomial trajectory = trajectoryData.getJointTrajectory();
            double desiredFinalPosition = standPrepFinal.getValue();
            double desiredFinalVelocity = 0.0;
            JointDesiredOutputReadOnly jointDesiredOutput = this.highLevelControlOutput.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            double startAngle = jointDesiredOutput != null && jointDesiredOutput.hasDesiredPosition() ? jointDesiredOutput.getDesiredPosition() : joint.getQ();
            double startVelocity = 0.0;
            trajectory.setCubic(0.0, this.timeToPrepareForStanding.getDoubleValue(), startAngle, startVelocity, desiredFinalPosition, desiredFinalVelocity);
        }
    }

    public void doAction(double timeInState) {
        double time = this.timeProvider != null ? this.timeProvider.getValue() : timeInState;
        if (this.continuousUpdate.getValue()) {
            this.reinitialize.set(false);
            this.initializeSplines(this.splineStartTime.getValue());
        } else if (this.reinitialize.getValue()) {
            this.reinitialize.set(false);
            this.initializeSplines(time);
        }
        double timeInTrajectory = MathTools.clamp((double)(time - this.splineStartTime.getValue()), (double)0.0, (double)this.timeToPrepareForStanding.getDoubleValue());
        for (int jointIndex = 0; jointIndex < this.jointsData.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointsData.get(jointIndex)).getLeft();
            TrajectoryData trajectoryData = (TrajectoryData)((ImmutablePair)this.jointsData.get(jointIndex)).getRight();
            YoPolynomial trajectory = trajectoryData.getJointTrajectory();
            YoDouble desiredPosition = trajectoryData.getDesiredJointConfiguration();
            trajectory.compute(timeInTrajectory);
            desiredPosition.set(trajectory.getValue());
            JointDesiredOutputBasics lowLevelJointData = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            lowLevelJointData.clear();
            lowLevelJointData.setDesiredPosition(desiredPosition.getDoubleValue());
            lowLevelJointData.setDesiredVelocity(trajectory.getVelocity());
            lowLevelJointData.setDesiredAcceleration(trajectory.getAcceleration());
        }
        this.lowLevelOneDoFJointDesiredDataHolder.completeWith((JointDesiredOutputListReadOnly)this.getStateSpecificJointSettings());
    }

    public void onExit() {
    }

    @Override
    public boolean isDone(double timeInState) {
        return timeInState > this.timeToPrepareForStanding.getDoubleValue() + this.minimumTimeDoneWithStandPrep.getDoubleValue();
    }

    public LowLevelOneDoFJointDesiredDataHolder getOutputForLowLevelController() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    private class TrajectoryData {
        private final DoubleProvider finalJointConfiguration;
        private final YoDouble desiredJointConfiguration;
        private final YoPolynomial jointTrajectory;

        public TrajectoryData(DoubleProvider finalJointConfiguration, YoDouble desiredJointConfiguration, YoPolynomial jointTrajectory) {
            this.finalJointConfiguration = finalJointConfiguration;
            this.desiredJointConfiguration = desiredJointConfiguration;
            this.jointTrajectory = jointTrajectory;
        }

        public DoubleProvider getFinalJointConfiguration() {
            return this.finalJointConfiguration;
        }

        public YoDouble getDesiredJointConfiguration() {
            return this.desiredJointConfiguration;
        }

        public YoPolynomial getJointTrajectory() {
            return this.jointTrajectory;
        }
    }
}

