/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.ParameterTools;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.parameters.JointAccelerationIntegrationParametersReadOnly;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.JointLoadStatusProvider;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.JointSettingConfiguration;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredBehaviorReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredLoadMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutput;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class JointSettingsHelper {
    private final YoRegistry registry;
    private final String[] jointNames;
    private final boolean[] jointsLoaded;
    private final YoBoolean[] yoJointsLoaded;
    private final JointAccelerationIntegrationParametersReadOnly[] accelerationIntegrationSettingsNoLoad;
    private final JointAccelerationIntegrationParametersReadOnly[] accelerationIntegrationSettingsLoaded;
    private final JointDesiredBehaviorReadOnly[] jointDesiredBehaviorNoLoad;
    private final JointDesiredBehaviorReadOnly[] jointDesiredBehaviorLoaded;
    private final JointAccelerationIntegrationCommand jointAccelerationIntegrationCommand;
    private final JointDesiredOutputList stateSpecificJointSettings;
    private final JointLoadStatusProvider jointLoadStatusProvider;

    public JointSettingsHelper(HighLevelControllerParameters parameters, OneDoFJointBasics[] joints, JointLoadStatusProvider jointLoadStatusProvider, HighLevelControllerName stateEnum, YoRegistry parentRegistry) {
        this(JointSettingConfiguration.extract(parameters, stateEnum), joints, jointLoadStatusProvider, CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, stateEnum.toString()), parentRegistry);
    }

    public JointSettingsHelper(JointSettingConfiguration configuration, List<OneDoFJointBasics> joints, JointLoadStatusProvider jointLoadStatusProvider, String stateName, YoRegistry parentRegistry) {
        this(configuration, joints.toArray(new OneDoFJointBasics[joints.size()]), jointLoadStatusProvider, stateName, parentRegistry);
    }

    public JointSettingsHelper(JointSettingConfiguration configuration, OneDoFJointBasics[] joints, JointLoadStatusProvider jointLoadStatusProvider, String stateName, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(stateName + "JointSettings");
        parentRegistry.addChild(this.registry);
        this.jointAccelerationIntegrationCommand = new JointAccelerationIntegrationCommand();
        this.stateSpecificJointSettings = new JointDesiredOutputList((OneDoFJointReadOnly[])joints);
        this.jointLoadStatusProvider = jointLoadStatusProvider;
        HashMap<String, JointAccelerationIntegrationParametersReadOnly> parameterJointNameMapNoLoad = new HashMap<String, JointAccelerationIntegrationParametersReadOnly>();
        ParameterTools.extractAccelerationIntegrationParameterMap("NoLoad", configuration.getJointAccelerationIntegrationParameters(), parameterJointNameMapNoLoad, this.registry);
        HashMap<String, JointAccelerationIntegrationParametersReadOnly> parameterJointNameMapLoaded = new HashMap<String, JointAccelerationIntegrationParametersReadOnly>();
        ParameterTools.extractAccelerationIntegrationParameterMap("Loaded", configuration.getJointAccelerationIntegrationParametersUnderLoad(), parameterJointNameMapLoaded, this.registry);
        HashMap<String, JointDesiredBehaviorReadOnly> jointBehaviorMapNoLoad = new HashMap<String, JointDesiredBehaviorReadOnly>();
        ParameterTools.extractJointBehaviorMap("NoLoad", configuration.getDesiredJointBehaviors(), jointBehaviorMapNoLoad, this.registry);
        HashMap<String, JointDesiredBehaviorReadOnly> jointBehaviorMapLoaded = new HashMap<String, JointDesiredBehaviorReadOnly>();
        ParameterTools.extractJointBehaviorMap("Loaded", configuration.getDesiredJointBehaviorsUnderLoad(), jointBehaviorMapLoaded, this.registry);
        this.jointNames = new String[joints.length];
        this.yoJointsLoaded = new YoBoolean[joints.length];
        this.jointsLoaded = new boolean[joints.length];
        this.accelerationIntegrationSettingsNoLoad = new JointAccelerationIntegrationParametersReadOnly[joints.length];
        this.accelerationIntegrationSettingsLoaded = new JointAccelerationIntegrationParametersReadOnly[joints.length];
        this.jointDesiredBehaviorNoLoad = new JointDesiredBehaviorReadOnly[joints.length];
        this.jointDesiredBehaviorLoaded = new JointDesiredBehaviorReadOnly[joints.length];
        ArrayList<String> jointsWithoutParameters = new ArrayList<String>();
        ArrayList<String> jointsWithoutBehaviors = new ArrayList<String>();
        for (int jointIdx = 0; jointIdx < joints.length; ++jointIdx) {
            String jointName;
            OneDoFJointBasics joint = joints[jointIdx];
            this.jointNames[jointIdx] = jointName = joint.getName();
            this.jointAccelerationIntegrationCommand.addJointToComputeDesiredPositionFor(joint);
            JointAccelerationIntegrationParametersReadOnly integrationParametersNoLoad = (JointAccelerationIntegrationParametersReadOnly)parameterJointNameMapNoLoad.get(jointName);
            JointAccelerationIntegrationParametersReadOnly integrationParametersLoaded = (JointAccelerationIntegrationParametersReadOnly)parameterJointNameMapLoaded.get(jointName);
            this.accelerationIntegrationSettingsNoLoad[jointIdx] = integrationParametersNoLoad;
            this.accelerationIntegrationSettingsLoaded[jointIdx] = integrationParametersLoaded;
            if (integrationParametersNoLoad == null) {
                jointsWithoutParameters.add(jointName);
            }
            JointDesiredBehaviorReadOnly desiredBehaviorNoLoad = (JointDesiredBehaviorReadOnly)jointBehaviorMapNoLoad.get(jointName);
            JointDesiredBehaviorReadOnly desiredBehaviorLoaded = (JointDesiredBehaviorReadOnly)jointBehaviorMapLoaded.get(jointName);
            this.jointDesiredBehaviorNoLoad[jointIdx] = desiredBehaviorNoLoad;
            this.jointDesiredBehaviorLoaded[jointIdx] = desiredBehaviorLoaded;
            if (desiredBehaviorNoLoad == null) {
                jointsWithoutBehaviors.add(jointName);
            }
            this.yoJointsLoaded[jointIdx] = integrationParametersNoLoad == null && desiredBehaviorNoLoad == null || integrationParametersLoaded == null && desiredBehaviorLoaded == null ? null : new YoBoolean(jointName + "_isUnderLoad", this.registry);
        }
        if (!jointsWithoutParameters.isEmpty()) {
            LogTools.warn((String)("In State " + stateName + "\nGot joints without acceleration integration parameters.\nWill use default values for: " + jointsWithoutParameters));
        }
        if (!jointsWithoutBehaviors.isEmpty()) {
            throw new RuntimeException("In State " + stateName + "\nMust define joint behaviors for: " + jointsWithoutBehaviors);
        }
    }

    public void update() {
        for (int jointIdx = 0; jointIdx < this.jointNames.length; ++jointIdx) {
            JointDesiredOutput jointDesiredOutput = this.stateSpecificJointSettings.getJointDesiredOutput(jointIdx);
            boolean isLoaded = this.jointLoadStatusProvider.isJointLoadBearing(this.jointNames[jointIdx]);
            boolean wasLoaded = this.jointsLoaded[jointIdx];
            jointDesiredOutput.setLoadMode(isLoaded ? JointDesiredLoadMode.LOADED : JointDesiredLoadMode.NOT_LOADED);
            jointDesiredOutput.setResetIntegrators(isLoaded != wasLoaded);
            this.jointsLoaded[jointIdx] = isLoaded;
            if (this.yoJointsLoaded[jointIdx] != null) {
                this.yoJointsLoaded[jointIdx].set(isLoaded);
            }
            JointAccelerationIntegrationParametersReadOnly integrationParametersNoLoad = this.accelerationIntegrationSettingsNoLoad[jointIdx];
            JointAccelerationIntegrationParametersReadOnly integrationParametersLoaded = this.accelerationIntegrationSettingsLoaded[jointIdx];
            if (isLoaded && integrationParametersLoaded != null) {
                this.jointAccelerationIntegrationCommand.setJointParameters(jointIdx, integrationParametersLoaded);
                jointDesiredOutput.setVelocityIntegrationBreakFrequency(integrationParametersLoaded.getVelocityBreakFrequency());
                jointDesiredOutput.setPositionIntegrationBreakFrequency(integrationParametersLoaded.getPositionBreakFrequency());
                jointDesiredOutput.setPositionIntegrationMaxError(integrationParametersLoaded.getMaxPositionError());
                jointDesiredOutput.setVelocityIntegrationMaxError(integrationParametersLoaded.getMaxVelocityError());
            } else if (integrationParametersNoLoad != null) {
                this.jointAccelerationIntegrationCommand.setJointParameters(jointIdx, integrationParametersNoLoad);
                jointDesiredOutput.setVelocityIntegrationBreakFrequency(integrationParametersNoLoad.getVelocityBreakFrequency());
                jointDesiredOutput.setPositionIntegrationBreakFrequency(integrationParametersNoLoad.getPositionBreakFrequency());
                jointDesiredOutput.setPositionIntegrationMaxError(integrationParametersNoLoad.getMaxPositionError());
                jointDesiredOutput.setVelocityIntegrationMaxError(integrationParametersNoLoad.getMaxVelocityError());
            }
            JointDesiredBehaviorReadOnly desiredBehaviorNoLoad = this.jointDesiredBehaviorNoLoad[jointIdx];
            JointDesiredBehaviorReadOnly desiredBehaviorLoaded = this.jointDesiredBehaviorLoaded[jointIdx];
            if (isLoaded && desiredBehaviorLoaded != null) {
                jointDesiredOutput.setControlMode(desiredBehaviorLoaded.getControlMode());
                jointDesiredOutput.setStiffness(desiredBehaviorLoaded.getStiffness());
                jointDesiredOutput.setDamping(desiredBehaviorLoaded.getDamping());
                jointDesiredOutput.setMasterGain(desiredBehaviorLoaded.getMasterGain());
                jointDesiredOutput.setVelocityScaling(desiredBehaviorLoaded.getVelocityScaling());
                jointDesiredOutput.setPositionFeedbackMaxError(desiredBehaviorLoaded.getMaxPositionError());
                jointDesiredOutput.setVelocityFeedbackMaxError(desiredBehaviorLoaded.getMaxVelocityError());
                continue;
            }
            jointDesiredOutput.setControlMode(desiredBehaviorNoLoad.getControlMode());
            jointDesiredOutput.setStiffness(desiredBehaviorNoLoad.getStiffness());
            jointDesiredOutput.setDamping(desiredBehaviorNoLoad.getDamping());
            jointDesiredOutput.setMasterGain(desiredBehaviorNoLoad.getMasterGain());
            jointDesiredOutput.setVelocityScaling(desiredBehaviorNoLoad.getVelocityScaling());
            jointDesiredOutput.setPositionFeedbackMaxError(desiredBehaviorNoLoad.getMaxPositionError());
            jointDesiredOutput.setVelocityFeedbackMaxError(desiredBehaviorNoLoad.getMaxVelocityError());
        }
    }

    public JointAccelerationIntegrationCommand getJointAccelerationIntegrationCommand() {
        return this.jointAccelerationIntegrationCommand;
    }

    public JointDesiredOutputList getStateSpecificJointSettings() {
        return this.stateSpecificJointSettings;
    }
}

