/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates;

import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.tools.lists.PairList;
import us.ihmc.yoVariables.variable.YoDouble;

public class HoldPositionControllerState
extends HighLevelControllerState {
    private final JointDesiredOutputListReadOnly highLevelControllerOutput;
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final PairList<OneDoFJointBasics, YoDouble> jointSetpoints = new PairList();

    public HoldPositionControllerState(HighLevelControllerName stateEnum, OneDoFJointBasics[] controlledJoints, HighLevelControllerParameters highLevelControllerParameters, JointDesiredOutputListReadOnly highLevelControllerOutput) {
        super(stateEnum, highLevelControllerParameters, controlledJoints);
        this.highLevelControllerOutput = highLevelControllerOutput;
        String nameSuffix = "_" + stateEnum.name();
        for (OneDoFJointBasics controlledJoint : controlledJoints) {
            String jointName = controlledJoint.getName();
            YoDouble freezePosition = new YoDouble(jointName + nameSuffix + "_qDesired", this.registry);
            freezePosition.setToNaN();
            this.jointSetpoints.add((Object)controlledJoint, (Object)freezePosition);
        }
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])controlledJoints);
    }

    public void setToCurrent() {
        for (int jointIndex = 0; jointIndex < this.jointSetpoints.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getLeft();
            YoDouble setpoint = (YoDouble)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getRight();
            setpoint.set(joint.getQ());
        }
    }

    public void onEntry() {
        for (int jointIndex = 0; jointIndex < this.jointSetpoints.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getLeft();
            YoDouble setpoint = (YoDouble)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getRight();
            JointDesiredOutputReadOnly lowLevelJointData = this.highLevelControllerOutput.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            if (lowLevelJointData != null && lowLevelJointData.hasDesiredPosition()) {
                setpoint.set(lowLevelJointData.getDesiredPosition());
                continue;
            }
            setpoint.set(joint.getQ());
        }
    }

    public void doAction(double timeInState) {
        for (int jointIndex = 0; jointIndex < this.jointSetpoints.size(); ++jointIndex) {
            OneDoFJointBasics joint = (OneDoFJointBasics)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getLeft();
            YoDouble desiredPosition = (YoDouble)((ImmutablePair)this.jointSetpoints.get(jointIndex)).getRight();
            JointDesiredOutputBasics lowLevelJointData = this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            lowLevelJointData.clear();
            lowLevelJointData.setDesiredPosition(desiredPosition.getDoubleValue());
            lowLevelJointData.setDesiredVelocity(0.0);
            lowLevelJointData.setDesiredAcceleration(0.0);
        }
        this.lowLevelOneDoFJointDesiredDataHolder.completeWith((JointDesiredOutputListReadOnly)this.getStateSpecificJointSettings());
    }

    public void onExit() {
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }
}

