/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories;

import controller_msgs.msg.dds.WholeBodyStreamingMessage;
import controller_msgs.msg.dds.WholeBodyTrajectoryMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.DefaultSplitFractionCalculatorParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.ControllerNetworkSubscriber;
import us.ihmc.commonWalkingControlModules.controllerAPI.input.userDesired.UserDesiredControllerCommandGenerators;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.QueuedControllerCommandGenerator;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.ContinuousStepGenerator;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScript;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.HeadingAndVelocityEvaluationScriptParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.falling.FallingControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.HumanoidHighLevelControllerManager;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerAPIDefinition;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerFailedTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.DoNothingControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ExitWalkingTransitionControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.FinishedControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.FreezeControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.RequestedControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.StandPrepControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.StandReadyControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.StandTransitionControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.WalkingControllerStateFactory;
import us.ihmc.commonWalkingControlModules.messageHandlers.WalkingMessageHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.CommandConversionInterface;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.MessageUnpackingTools;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.ClearDelayQueueConverter;
import us.ihmc.humanoidRobotics.communication.controllerAPI.converter.FrameMessageCommandConverter;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.ControllerFailureListener;
import us.ihmc.robotics.controllers.ControllerStateChangedListener;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.robotics.sensors.FootSwitchFactory;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.ros2.ROS2QosProfile;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.frames.CommonLeggedReferenceFrames;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.model.RobotMotionStatusChangedListener;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class HighLevelHumanoidControllerFactory
implements CloseableAndDisposable {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final CloseableAndDisposableRegistry closeableAndDisposableRegistry = new CloseableAndDisposableRegistry();
    private final ArrayList<HighLevelControllerStateFactory> controllerStateFactories = new ArrayList();
    private final EnumMap<HighLevelControllerName, HighLevelControllerStateFactory> controllerFactoriesMap = new EnumMap(HighLevelControllerName.class);
    private final ArrayList<ControllerStateTransitionFactory<HighLevelControllerName>> stateTransitionFactories = new ArrayList();
    private HighLevelHumanoidControllerToolbox controllerToolbox = null;
    private final YoEnum<HighLevelControllerName> requestedHighLevelControllerState = new YoEnum("requestedHighLevelControllerState", this.registry, HighLevelControllerName.class, true);
    private HighLevelControllerName initialControllerState;
    private final ContactableBodiesFactory<RobotSide> contactableBodiesFactory;
    private final HighLevelControllerParameters highLevelControllerParameters;
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusMessageOutputManager;
    private final HighLevelControlManagerFactory managerFactory;
    private final WalkingControllerParameters walkingControllerParameters;
    private final CoPTrajectoryParameters copTrajectoryParameters;
    private final ArrayList<Updatable> updatables = new ArrayList();
    private final ArrayList<ControllerStateChangedListener> controllerStateChangedListenersToAttach = new ArrayList();
    private final ArrayList<ControllerFailureListener> controllerFailureListenersToAttach = new ArrayList();
    private final SideDependentList<String> footSensorNames;
    private final SideDependentList<String> footContactSensorNames;
    private final SideDependentList<String> wristSensorNames;
    private YoGraphicsListRegistry yoGraphicsListRegistry;
    private HeadingAndVelocityEvaluationScriptParameters headingAndVelocityEvaluationScriptParameters;
    private boolean createComponentBasedFootstepDataMessageGenerator = false;
    private boolean createQueuedControllerCommandGenerator = false;
    private boolean createUserDesiredControllerCommandGenerator = false;
    private boolean useHeadingAndVelocityScript = true;
    private HeightMap heightMapForFootstepZ = null;
    private boolean isListeningToHighLevelStatePackets = true;
    private ConcurrentLinkedQueue<Command<?, ?>> controllerCommands;
    private HumanoidHighLevelControllerManager humanoidHighLevelControllerManager;
    private ContinuousStepGenerator continuousStepGenerator;
    private QueuedControllerCommandGenerator queuedControllerCommandGenerator;
    private UserDesiredControllerCommandGenerators userDesiredControllerCommandGenerators = null;

    public HighLevelHumanoidControllerFactory(ContactableBodiesFactory<RobotSide> contactableBodiesFactory, SideDependentList<String> footForceSensorNames, SideDependentList<String> footContactSensorNames, SideDependentList<String> wristSensorNames, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters, CoPTrajectoryParameters copTrajectoryParameters) {
        this(contactableBodiesFactory, footForceSensorNames, footContactSensorNames, wristSensorNames, highLevelControllerParameters, walkingControllerParameters, copTrajectoryParameters, new DefaultSplitFractionCalculatorParameters());
    }

    public HighLevelHumanoidControllerFactory(ContactableBodiesFactory<RobotSide> contactableBodiesFactory, SideDependentList<String> footForceSensorNames, SideDependentList<String> footContactSensorNames, SideDependentList<String> wristSensorNames, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters, CoPTrajectoryParameters copTrajectoryParameters, SplitFractionCalculatorParametersReadOnly splitFractionCalculatorParameters) {
        this.highLevelControllerParameters = highLevelControllerParameters;
        this.walkingControllerParameters = walkingControllerParameters;
        this.copTrajectoryParameters = copTrajectoryParameters;
        this.contactableBodiesFactory = contactableBodiesFactory;
        this.footSensorNames = footForceSensorNames;
        this.footContactSensorNames = footContactSensorNames;
        this.wristSensorNames = wristSensorNames;
        this.commandInputManager = new CommandInputManager(ControllerAPIDefinition.getControllerSupportedCommands());
        try {
            this.commandInputManager.registerConversionHelper((CommandConversionInterface)new ClearDelayQueueConverter(ControllerAPIDefinition.getControllerSupportedCommands()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        this.statusMessageOutputManager = new StatusMessageOutputManager(ControllerAPIDefinition.getControllerSupportedStatusMessages());
        this.managerFactory = new HighLevelControlManagerFactory(this.registry);
        this.managerFactory.setCopTrajectoryParameters(copTrajectoryParameters);
        this.managerFactory.setWalkingControllerParameters(walkingControllerParameters);
        this.managerFactory.setSplitFractionParameters(splitFractionCalculatorParameters);
    }

    public void createComponentBasedFootstepDataMessageGenerator() {
        this.createComponentBasedFootstepDataMessageGenerator(false, null);
    }

    public void createComponentBasedFootstepDataMessageGenerator(boolean useHeadingAndVelocityScript) {
        this.createComponentBasedFootstepDataMessageGenerator(useHeadingAndVelocityScript, null);
    }

    public void createComponentBasedFootstepDataMessageGenerator(boolean useHeadingAndVelocityScript, HeightMap heightMapForFootstepZ) {
        if (this.continuousStepGenerator != null) {
            return;
        }
        if (this.controllerToolbox != null) {
            CommonHumanoidReferenceFrames referenceFrames = this.controllerToolbox.getReferenceFrames();
            double controlDT = this.controllerToolbox.getControlDT();
            this.continuousStepGenerator = new ContinuousStepGenerator(this.registry);
            this.continuousStepGenerator.setFootstepStatusListener(this.statusMessageOutputManager);
            this.continuousStepGenerator.setFrameBasedFootPoseProvider((SideDependentList<? extends ReferenceFrame>)referenceFrames.getSoleZUpFrames());
            this.continuousStepGenerator.configureWith(this.walkingControllerParameters);
            this.continuousStepGenerator.setFootstepMessenger(arg_0 -> ((CommandInputManager)this.commandInputManager).submitMessage(arg_0));
            if (this.yoGraphicsListRegistry != null) {
                this.continuousStepGenerator.setupVisualization(this.controllerToolbox.getContactableFeet(), this.yoGraphicsListRegistry);
            }
            if (heightMapForFootstepZ != null) {
                this.continuousStepGenerator.setHeightMapBasedFootstepAdjustment(heightMapForFootstepZ);
            }
            if (useHeadingAndVelocityScript) {
                HeadingAndVelocityEvaluationScript script = new HeadingAndVelocityEvaluationScript(controlDT, (DoubleProvider)this.controllerToolbox.getYoTime(), this.headingAndVelocityEvaluationScriptParameters, this.registry);
                this.continuousStepGenerator.setDesiredTurningVelocityProvider(script.getDesiredTurningVelocityProvider());
                this.continuousStepGenerator.setDesiredVelocityProvider(script.getDesiredVelocityProvider());
                this.controllerToolbox.addUpdatable(script);
            } else {
                this.continuousStepGenerator.setYoComponentProviders();
            }
            this.controllerToolbox.addUpdatable(this.continuousStepGenerator);
        } else {
            this.createComponentBasedFootstepDataMessageGenerator = true;
            this.useHeadingAndVelocityScript = useHeadingAndVelocityScript;
            this.heightMapForFootstepZ = heightMapForFootstepZ;
        }
    }

    public void createQueuedControllerCommandGenerator(ConcurrentLinkedQueue<Command<?, ?>> controllerCommands) {
        if (this.queuedControllerCommandGenerator != null) {
            return;
        }
        if (this.controllerToolbox != null) {
            LogTools.info((String)"Creating queued controller command generator");
            SideDependentList<ContactableFoot> contactableFeet = this.controllerToolbox.getContactableFeet();
            CommonHumanoidReferenceFrames referenceFrames = this.controllerToolbox.getReferenceFrames();
            double controlDT = this.controllerToolbox.getControlDT();
            this.queuedControllerCommandGenerator = new QueuedControllerCommandGenerator(controllerCommands, this.commandInputManager, this.statusMessageOutputManager, this.walkingControllerParameters, referenceFrames, contactableFeet, controlDT, this.useHeadingAndVelocityScript, this.registry);
            this.controllerToolbox.attachRobotMotionStatusChangedListener(this.queuedControllerCommandGenerator);
            this.controllerToolbox.addUpdatables(this.queuedControllerCommandGenerator.getModulesToUpdate());
        } else {
            this.createQueuedControllerCommandGenerator = true;
            this.controllerCommands = controllerCommands;
        }
    }

    public void createUserDesiredControllerCommandGenerator() {
        if (this.userDesiredControllerCommandGenerators != null) {
            return;
        }
        if (this.controllerToolbox != null) {
            double defaultTrajectoryTime = 1.0;
            SideDependentList<ContactableFoot> contactableFeet = this.controllerToolbox.getContactableFeet();
            this.userDesiredControllerCommandGenerators = new UserDesiredControllerCommandGenerators(this.commandInputManager, this.controllerToolbox.getFullRobotModel(), this.controllerToolbox.getReferenceFrames(), contactableFeet, this.walkingControllerParameters, defaultTrajectoryTime, this.registry);
        } else {
            this.createUserDesiredControllerCommandGenerator = true;
        }
    }

    public void setHeadingAndVelocityEvaluationScriptParameters(HeadingAndVelocityEvaluationScriptParameters walkingScriptParameters) {
        this.headingAndVelocityEvaluationScriptParameters = walkingScriptParameters;
    }

    public void useDefaultDiagnosticControlState() {
    }

    public void useDefaultCalibrationControlState() {
    }

    public void useDefaultDoNothingControlState() {
        DoNothingControllerStateFactory controllerStateFactory = new DoNothingControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.DO_NOTHING_BEHAVIOR, controllerStateFactory);
    }

    public void useDefaultStandPrepControlState() {
        StandPrepControllerStateFactory controllerStateFactory = new StandPrepControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.STAND_PREP_STATE, controllerStateFactory);
    }

    public void useDefaultStandReadyControlState() {
        StandReadyControllerStateFactory controllerStateFactory = new StandReadyControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.STAND_READY, controllerStateFactory);
    }

    public void useDefaultStandTransitionControlState() {
        this.useDefaultStandTransitionControlState(HighLevelControllerName.STAND_READY, HighLevelControllerName.WALKING);
    }

    public void useDefaultStandTransitionControlState(HighLevelControllerName startState, HighLevelControllerName endState) {
        StandTransitionControllerStateFactory controllerStateFactory = new StandTransitionControllerStateFactory(startState, endState);
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.STAND_TRANSITION_STATE, controllerStateFactory);
    }

    public void useDefaultWalkingControlState() {
        WalkingControllerStateFactory controllerStateFactory = new WalkingControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.WALKING, controllerStateFactory);
    }

    public void useDefaultExitWalkingTransitionControlState(HighLevelControllerName targetState) {
        ExitWalkingTransitionControllerStateFactory controllerStateFactory = new ExitWalkingTransitionControllerStateFactory(targetState);
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.EXIT_WALKING, controllerStateFactory);
    }

    public void useDefaultFreezeControlState() {
        FreezeControllerStateFactory controllerStateFactory = new FreezeControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.FREEZE_STATE, controllerStateFactory);
    }

    public void useDefaultFallingControlState() {
        FallingControllerStateFactory controllerStateFactory = new FallingControllerStateFactory();
        this.controllerStateFactories.add(controllerStateFactory);
        this.controllerFactoriesMap.put(HighLevelControllerName.FALLING_STATE, controllerStateFactory);
    }

    public void addCustomControlState(HighLevelControllerStateFactory customControllerStateFactory) {
        this.controllerStateFactories.add(customControllerStateFactory);
        this.controllerFactoriesMap.put(customControllerStateFactory.getStateEnum(), customControllerStateFactory);
    }

    public void addFinishedTransition(HighLevelControllerName currentControlStateEnum, HighLevelControllerName nextControlStateEnum) {
        this.stateTransitionFactories.add(new FinishedControllerStateTransitionFactory<HighLevelControllerName>(currentControlStateEnum, nextControlStateEnum));
    }

    public void addFinishedTransition(HighLevelControllerName currentControlStateEnum, HighLevelControllerName nextControlStateEnum, boolean performNextStateOnEntry) {
        this.stateTransitionFactories.add(new FinishedControllerStateTransitionFactory<boolean>((boolean)currentControlStateEnum, (boolean)nextControlStateEnum, performNextStateOnEntry));
    }

    public void addRequestableTransition(HighLevelControllerName currentControlStateEnum, HighLevelControllerName nextControlStateEnum) {
        this.stateTransitionFactories.add(new RequestedControllerStateTransitionFactory<HighLevelControllerName>(this.requestedHighLevelControllerState, currentControlStateEnum, nextControlStateEnum));
    }

    public void addControllerFailureTransition(HighLevelControllerName currentControlStateEnum, HighLevelControllerName fallbackControlStateEnum) {
        this.stateTransitionFactories.add(new ControllerFailedTransitionFactory(currentControlStateEnum, fallbackControlStateEnum));
    }

    public void addCustomStateTransition(ControllerStateTransitionFactory<HighLevelControllerName> stateTransitionFactory) {
        this.stateTransitionFactories.add(stateTransitionFactory);
    }

    public void setInitialState(HighLevelControllerName initialStateEnum) {
        this.initialControllerState = initialStateEnum;
    }

    public YoEnum<HighLevelControllerName> getRequestedControlStateEnum() {
        return this.requestedHighLevelControllerState;
    }

    public RobotController getController(FullHumanoidRobotModel fullRobotModel, double controlDT, double gravity, YoDouble yoTime, YoGraphicsListRegistry yoGraphicsListRegistry, HumanoidRobotSensorInformation sensorInformation, ForceSensorDataHolderReadOnly forceSensorDataHolder, CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator, JointDesiredOutputListBasics lowLevelControllerOutput, JointBasics ... jointsToIgnore) {
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        HumanoidReferenceFrames referenceFrames = new HumanoidReferenceFrames(fullRobotModel);
        this.contactableBodiesFactory.setFullRobotModel((FullLeggedRobotModel<RobotSide>)fullRobotModel);
        this.contactableBodiesFactory.setReferenceFrames((CommonLeggedReferenceFrames<RobotSide>)referenceFrames);
        SideDependentList feet = new SideDependentList(this.contactableBodiesFactory.createFootContactableFeet());
        List<ContactablePlaneBody> additionalContacts = this.contactableBodiesFactory.createAdditionalContactPoints();
        this.contactableBodiesFactory.disposeFactory();
        ArrayList<ContactablePlaneBody> contactablePlaneBodies = new ArrayList<ContactablePlaneBody>();
        for (RobotSide robotSide : RobotSide.values) {
            contactablePlaneBodies.add((ContactablePlaneBody)feet.get((Enum)robotSide));
        }
        contactablePlaneBodies.addAll(additionalContacts);
        double gravityZ = Math.abs(gravity);
        double totalMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)fullRobotModel.getElevator());
        double totalRobotWeight = totalMass * gravityZ;
        SideDependentList<FootSwitchInterface> footSwitches = this.createFootSwitches((SideDependentList<? extends ContactablePlaneBody>)feet, forceSensorDataHolder, totalRobotWeight, yoGraphicsListRegistry, this.registry);
        SideDependentList<ForceSensorDataReadOnly> wristForceSensors = this.createWristForceSensors(forceSensorDataHolder);
        double omega0 = this.walkingControllerParameters.getOmega0();
        this.controllerToolbox = new HighLevelHumanoidControllerToolbox(fullRobotModel, (CommonHumanoidReferenceFrames)referenceFrames, footSwitches, wristForceSensors, yoTime, gravityZ, omega0, (SideDependentList<ContactableFoot>)feet, controlDT, this.updatables, contactablePlaneBodies, yoGraphicsListRegistry, jointsToIgnore);
        this.controllerToolbox.attachControllerStateChangedListeners(this.controllerStateChangedListenersToAttach);
        this.attachControllerFailureListeners(this.controllerFailureListenersToAttach);
        if (this.createComponentBasedFootstepDataMessageGenerator) {
            this.createComponentBasedFootstepDataMessageGenerator(this.useHeadingAndVelocityScript, this.heightMapForFootstepZ);
        }
        if (this.createQueuedControllerCommandGenerator) {
            this.createQueuedControllerCommandGenerator(this.controllerCommands);
        }
        if (this.createUserDesiredControllerCommandGenerator) {
            this.createUserDesiredControllerCommandGenerator();
        }
        double defaultTransferTime = this.walkingControllerParameters.getDefaultTransferTime();
        double defaultSwingTime = this.walkingControllerParameters.getDefaultSwingTime();
        double defaultInitialTransferTime = this.walkingControllerParameters.getDefaultInitialTransferTime();
        double defaultFinalTransferTime = this.walkingControllerParameters.getDefaultFinalTransferTime();
        WalkingMessageHandler walkingMessageHandler = new WalkingMessageHandler(defaultTransferTime, defaultSwingTime, defaultInitialTransferTime, defaultFinalTransferTime, (SideDependentList<? extends ContactablePlaneBody>)feet, this.statusMessageOutputManager, yoTime, yoGraphicsListRegistry, this.registry);
        this.controllerToolbox.setWalkingMessageHandler(walkingMessageHandler);
        this.managerFactory.setHighLevelHumanoidControllerToolbox(this.controllerToolbox);
        ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver = this.controllerToolbox.getReferenceFrameHashCodeResolver();
        FrameMessageCommandConverter commandConversionHelper = new FrameMessageCommandConverter(referenceFrameHashCodeResolver);
        this.commandInputManager.registerConversionHelper((CommandConversionInterface)commandConversionHelper);
        this.humanoidHighLevelControllerManager = new HumanoidHighLevelControllerManager(this.commandInputManager, this.statusMessageOutputManager, this.initialControllerState, this.highLevelControllerParameters, this.walkingControllerParameters, this.requestedHighLevelControllerState, this.controllerFactoriesMap, this.stateTransitionFactories, this.managerFactory, this.controllerToolbox, centerOfPressureDataHolderForEstimator, forceSensorDataHolder, lowLevelControllerOutput);
        this.humanoidHighLevelControllerManager.addYoVariableRegistry(this.registry);
        this.humanoidHighLevelControllerManager.setListenToHighLevelStatePackets(this.isListeningToHighLevelStatePackets);
        return this.humanoidHighLevelControllerManager;
    }

    private SideDependentList<FootSwitchInterface> createFootSwitches(SideDependentList<? extends ContactablePlaneBody> bipedFeet, ForceSensorDataHolderReadOnly forceSensorDataHolder, double totalRobotWeight, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry registry) {
        SideDependentList footSwitches = new SideDependentList();
        FootSwitchFactory footSwitchFactory = this.walkingControllerParameters.getFootSwitchFactory();
        for (RobotSide robotSide : RobotSide.values) {
            String footName = ((ContactablePlaneBody)bipedFeet.get((Enum)robotSide)).getName();
            ForceSensorDataReadOnly footForceSensor = forceSensorDataHolder.getByName((String)this.footSensorNames.get((Enum)robotSide));
            FootSwitchInterface footSwitch = footSwitchFactory.newFootSwitch(footName, (ContactablePlaneBody)bipedFeet.get((Enum)robotSide), Collections.singleton((ContactablePlaneBody)bipedFeet.get((Enum)robotSide.getOppositeSide())), footForceSensor, totalRobotWeight, yoGraphicsListRegistry, registry);
            footSwitches.put((Enum)robotSide, (Object)footSwitch);
        }
        return footSwitches;
    }

    private SideDependentList<ForceSensorDataReadOnly> createWristForceSensors(ForceSensorDataHolderReadOnly forceSensorDataHolder) {
        if (this.wristSensorNames == null) {
            return null;
        }
        SideDependentList wristForceSensors = new SideDependentList();
        for (RobotSide robotSide : RobotSide.values) {
            if (this.wristSensorNames.get((Enum)robotSide) == null) {
                return null;
            }
            ForceSensorDataReadOnly wristForceSensor = forceSensorDataHolder.getByName((String)this.wristSensorNames.get((Enum)robotSide));
            wristForceSensors.put((Enum)robotSide, (Object)wristForceSensor);
        }
        return wristForceSensors;
    }

    public void addUpdatable(Updatable updatable) {
        if (this.controllerToolbox == null) {
            this.updatables.add(updatable);
        } else {
            this.controllerToolbox.addUpdatable(updatable);
        }
    }

    public void closeAndDispose() {
        this.closeableAndDisposableRegistry.closeAndDispose();
    }

    public CommandInputManager getCommandInputManager() {
        return this.commandInputManager;
    }

    public StatusMessageOutputManager getStatusOutputManager() {
        return this.statusMessageOutputManager;
    }

    public void attachControllerFailureListeners(List<ControllerFailureListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.attachControllerFailureListener(listeners.get(i));
        }
    }

    public void attachControllerFailureListener(ControllerFailureListener listener) {
        if (this.controllerToolbox != null) {
            this.controllerToolbox.attachControllerFailureListener(listener);
        } else {
            this.controllerFailureListenersToAttach.add(listener);
        }
    }

    public void attachControllerStateChangedListeners(List<ControllerStateChangedListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.attachControllerStateChangedListener(listeners.get(i));
        }
    }

    public void attachControllerStateChangedListener(ControllerStateChangedListener listener) {
        if (this.controllerToolbox != null) {
            this.controllerToolbox.attachControllerStateChangedListener(listener);
        } else {
            this.controllerStateChangedListenersToAttach.add(listener);
        }
    }

    public void attachRobotMotionStatusChangedListener(RobotMotionStatusChangedListener listener) {
        this.controllerToolbox.attachRobotMotionStatusChangedListener(listener);
    }

    public void createControllerNetworkSubscriber(String robotName, RealtimeROS2Node realtimeROS2Node) {
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        ROS2Topic outputTopic = ROS2Tools.getControllerOutputTopic((String)robotName);
        ControllerNetworkSubscriber controllerNetworkSubscriber = new ControllerNetworkSubscriber(inputTopic, this.commandInputManager, outputTopic, this.statusMessageOutputManager, realtimeROS2Node);
        controllerNetworkSubscriber.registerSubcriberWithMessageUnpacker(WholeBodyTrajectoryMessage.class, 9, MessageUnpackingTools.createWholeBodyTrajectoryMessageUnpacker());
        controllerNetworkSubscriber.registerSubcriberWithMessageUnpacker(WholeBodyStreamingMessage.class, inputTopic, ROS2QosProfile.BEST_EFFORT(), 9, MessageUnpackingTools.createWholeBodyStreamingMessageUnpacker());
        controllerNetworkSubscriber.addMessageCollectors(ControllerAPIDefinition.createDefaultMessageIDExtractor(), 3);
        controllerNetworkSubscriber.addMessageValidator(ControllerAPIDefinition.createDefaultMessageValidation());
    }

    public HighLevelHumanoidControllerToolbox getHighLevelHumanoidControllerToolbox() {
        return this.controllerToolbox;
    }

    public HighLevelControllerName getCurrentHighLevelControlState() {
        return this.humanoidHighLevelControllerManager.getCurrentHighLevelControlState();
    }

    public void setListenToHighLevelStatePackets(boolean isListening) {
        if (this.humanoidHighLevelControllerManager != null) {
            this.humanoidHighLevelControllerManager.setListenToHighLevelStatePackets(isListening);
        } else {
            this.isListeningToHighLevelStatePackets = isListening;
        }
    }
}

