/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories;

import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import us.ihmc.commonWalkingControlModules.capturePoint.BalanceManager;
import us.ihmc.commonWalkingControlModules.capturePoint.CenterOfMassHeightManager;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.DefaultSplitFractionCalculatorParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.configurations.LeapOfFaithParameters;
import us.ihmc.commonWalkingControlModules.configurations.ParameterTools;
import us.ihmc.commonWalkingControlModules.configurations.PelvisOffsetWhileWalkingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controlModules.foot.FeetManager;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationManager;
import us.ihmc.commonWalkingControlModules.controlModules.pelvis.PelvisOrientationManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlManager;
import us.ihmc.commonWalkingControlModules.controlModules.rigidBody.RigidBodyControlMode;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerTemplate;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ParameterizedPIDGains;
import us.ihmc.robotics.controllers.pidGains.implementations.ParameterizedPIDSE3Gains;
import us.ihmc.robotics.dataStructures.parameters.ParameterVector3D;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class HighLevelControlManagerFactory {
    public static final String weightRegistryName = "MomentumOptimizationSettings";
    public static final String jointspaceGainRegistryName = "JointspaceGains";
    public static final String rigidBodyGainRegistryName = "RigidBodyGains";
    public static final String footGainRegistryName = "FootGains";
    public static final String comHeightGainRegistryName = "ComHeightGains";
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoRegistry momentumRegistry = new YoRegistry("MomentumOptimizationSettings");
    private final YoRegistry jointGainRegistry = new YoRegistry("JointspaceGains");
    private final YoRegistry bodyGainRegistry = new YoRegistry("RigidBodyGains");
    private final YoRegistry footGainRegistry = new YoRegistry("FootGains");
    private final YoRegistry comHeightGainRegistry = new YoRegistry("ComHeightGains");
    private BalanceManager balanceManager;
    private CenterOfMassHeightManager centerOfMassHeightManager;
    private FeetManager feetManager;
    private PelvisOrientationManager pelvisOrientationManager;
    private LegConfigurationManager legConfigurationManager;
    private final Map<String, RigidBodyControlManager> rigidBodyManagerMapByBodyName = new HashMap<String, RigidBodyControlManager>();
    private HighLevelHumanoidControllerToolbox controllerToolbox;
    private WalkingControllerParameters walkingControllerParameters;
    private CoPTrajectoryParameters copTrajectoryParameters;
    private SplitFractionCalculatorParametersReadOnly splitFractionParameters = new DefaultSplitFractionCalculatorParameters();
    private MomentumOptimizationSettings momentumOptimizationSettings;
    private final Map<String, PIDGainsReadOnly> jointGainMap = new HashMap<String, PIDGainsReadOnly>();
    private final Map<String, PID3DGainsReadOnly> taskspaceOrientationGainMap = new HashMap<String, PID3DGainsReadOnly>();
    private final Map<String, PID3DGainsReadOnly> taskspacePositionGainMap = new HashMap<String, PID3DGainsReadOnly>();
    private final Map<String, DoubleProvider> jointspaceWeightMap = new HashMap<String, DoubleProvider>();
    private final Map<String, DoubleProvider> userModeWeightMap = new HashMap<String, DoubleProvider>();
    private final Map<String, Vector3DReadOnly> taskspaceAngularWeightMap = new HashMap<String, Vector3DReadOnly>();
    private final Map<String, Vector3DReadOnly> taskspaceLinearWeightMap = new HashMap<String, Vector3DReadOnly>();
    private Vector3DReadOnly loadedFootAngularWeight;
    private Vector3DReadOnly loadedFootLinearWeight;
    private PIDSE3GainsReadOnly swingFootGains;
    private PIDSE3GainsReadOnly holdFootGains;
    private PIDSE3GainsReadOnly toeOffFootGains;
    private PIDGainsReadOnly walkingControllerComHeightGains;
    private DoubleProvider walkingControllerMaxComHeightVelocity;
    private PIDGainsReadOnly userModeComHeightGains;

    public HighLevelControlManagerFactory(YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
        parentRegistry.addChild(this.momentumRegistry);
        parentRegistry.addChild(this.jointGainRegistry);
        parentRegistry.addChild(this.bodyGainRegistry);
        parentRegistry.addChild(this.footGainRegistry);
        parentRegistry.addChild(this.comHeightGainRegistry);
    }

    public void setHighLevelHumanoidControllerToolbox(HighLevelHumanoidControllerToolbox controllerToolbox) {
        this.controllerToolbox = controllerToolbox;
    }

    public void setWalkingControllerParameters(WalkingControllerParameters walkingControllerParameters) {
        this.walkingControllerParameters = walkingControllerParameters;
        this.momentumOptimizationSettings = walkingControllerParameters.getMomentumOptimizationSettings();
        ParameterTools.extractJointGainMap(walkingControllerParameters.getJointSpaceControlGains(), this.jointGainMap, this.jointGainRegistry);
        ParameterTools.extract3DGainMap("Orientation", walkingControllerParameters.getTaskspaceOrientationControlGains(), this.taskspaceOrientationGainMap, this.bodyGainRegistry);
        ParameterTools.extract3DGainMap("Position", walkingControllerParameters.getTaskspacePositionControlGains(), this.taskspacePositionGainMap, this.bodyGainRegistry);
        ParameterTools.extractJointWeightMap("JointspaceWeight", this.momentumOptimizationSettings.getJointspaceWeights(), this.jointspaceWeightMap, this.momentumRegistry);
        ParameterTools.extractJointWeightMap("UserModeWeight", this.momentumOptimizationSettings.getUserModeWeights(), this.userModeWeightMap, this.momentumRegistry);
        ParameterTools.extract3DWeightMap("AngularWeight", this.momentumOptimizationSettings.getTaskspaceAngularWeights(), this.taskspaceAngularWeightMap, this.momentumRegistry);
        ParameterTools.extract3DWeightMap("LinearWeight", this.momentumOptimizationSettings.getTaskspaceLinearWeights(), this.taskspaceLinearWeightMap, this.momentumRegistry);
        this.loadedFootAngularWeight = new ParameterVector3D("LoadedFootAngularWeight", (Tuple3DReadOnly)this.momentumOptimizationSettings.getLoadedFootAngularWeight(), this.momentumRegistry);
        this.loadedFootLinearWeight = new ParameterVector3D("LoadedFootLinearWeight", (Tuple3DReadOnly)this.momentumOptimizationSettings.getLoadedFootLinearWeight(), this.momentumRegistry);
        this.swingFootGains = new ParameterizedPIDSE3Gains("SwingFoot", walkingControllerParameters.getSwingFootControlGains(), this.footGainRegistry);
        this.holdFootGains = new ParameterizedPIDSE3Gains("HoldFoot", walkingControllerParameters.getHoldPositionFootControlGains(), this.footGainRegistry);
        this.toeOffFootGains = new ParameterizedPIDSE3Gains("ToeOffFoot", walkingControllerParameters.getToeOffFootControlGains(), this.footGainRegistry);
        this.walkingControllerComHeightGains = new ParameterizedPIDGains("WalkingControllerComHeight", (PDGainsReadOnly)walkingControllerParameters.getCoMHeightControlGains(), this.comHeightGainRegistry);
        this.walkingControllerMaxComHeightVelocity = new DoubleParameter("MaximumVelocityWalkingControllerComHeight", this.comHeightGainRegistry, walkingControllerParameters.getMaximumVelocityCoMHeight());
        this.userModeComHeightGains = new ParameterizedPIDGains("UserModeComHeight", (PDGainsReadOnly)walkingControllerParameters.getCoMHeightControlGains(), this.comHeightGainRegistry);
    }

    public void setCopTrajectoryParameters(CoPTrajectoryParameters copTrajectoryParameters) {
        this.copTrajectoryParameters = copTrajectoryParameters;
    }

    public void setSplitFractionParameters(SplitFractionCalculatorParametersReadOnly splitFractionParameters) {
        this.splitFractionParameters = splitFractionParameters;
    }

    public BalanceManager getOrCreateBalanceManager() {
        if (this.balanceManager != null) {
            return this.balanceManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(BalanceManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(BalanceManager.class)) {
            return null;
        }
        if (!this.hasCoPTrajectoryParameters(BalanceManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(BalanceManager.class)) {
            return null;
        }
        this.balanceManager = new BalanceManager(this.controllerToolbox, this.walkingControllerParameters, this.copTrajectoryParameters, this.splitFractionParameters, this.registry);
        return this.balanceManager;
    }

    public CenterOfMassHeightManager getOrCreateCenterOfMassHeightManager() {
        if (this.centerOfMassHeightManager != null) {
            return this.centerOfMassHeightManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(CenterOfMassHeightManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(CenterOfMassHeightManager.class)) {
            return null;
        }
        String pelvisName = this.controllerToolbox.getFullRobotModel().getPelvis().getName();
        Vector3DReadOnly pelvisLinearWeight = this.taskspaceLinearWeightMap.get(pelvisName);
        this.centerOfMassHeightManager = new CenterOfMassHeightManager(this.controllerToolbox, this.walkingControllerParameters, this.registry);
        this.centerOfMassHeightManager.setPelvisTaskspaceWeights(pelvisLinearWeight);
        this.centerOfMassHeightManager.setPrepareForLocomotion(this.walkingControllerParameters.doPreparePelvisForLocomotion());
        this.centerOfMassHeightManager.setComHeightGains(this.walkingControllerComHeightGains, this.walkingControllerMaxComHeightVelocity, this.userModeComHeightGains);
        return this.centerOfMassHeightManager;
    }

    public RigidBodyControlManager getOrCreateRigidBodyManager(RigidBodyBasics bodyToControl, RigidBodyBasics baseBody, ReferenceFrame controlFrame, ReferenceFrame baseFrame) {
        RigidBodyControlManager manager;
        if (bodyToControl == null) {
            return null;
        }
        String bodyName = bodyToControl.getName();
        if (this.rigidBodyManagerMapByBodyName.containsKey(bodyName) && (manager = this.rigidBodyManagerMapByBodyName.get(bodyName)) != null) {
            return manager;
        }
        if (!this.hasWalkingControllerParameters(RigidBodyControlManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(RigidBodyControlManager.class)) {
            return null;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(RigidBodyControlManager.class)) {
            return null;
        }
        PID3DGainsReadOnly taskspaceOrientationGains = this.taskspaceOrientationGainMap.get(bodyName);
        PID3DGainsReadOnly taskspacePositionGains = this.taskspacePositionGainMap.get(bodyName);
        Vector3DReadOnly taskspaceAngularWeight = this.taskspaceAngularWeightMap.get(bodyName);
        Vector3DReadOnly taskspaceLinearWeight = this.taskspaceLinearWeightMap.get(bodyName);
        TObjectDoubleHashMap<String> homeConfiguration = this.walkingControllerParameters.getOrCreateJointHomeConfiguration();
        Pose3D homePose = this.walkingControllerParameters.getOrCreateBodyHomeConfiguration().get(bodyName);
        RigidBodyBasics elevator = this.controllerToolbox.getFullRobotModel().getElevator();
        YoDouble yoTime = this.controllerToolbox.getYoTime();
        ContactablePlaneBody contactableBody = this.controllerToolbox.getContactableBody(bodyToControl);
        YoGraphicsListRegistry graphicsListRegistry = this.controllerToolbox.getYoGraphicsListRegistry();
        RigidBodyControlMode defaultControlMode = this.walkingControllerParameters.getDefaultControlModesForRigidBodies().get(bodyName);
        RigidBodyControlManager manager2 = new RigidBodyControlManager(bodyToControl, baseBody, elevator, homeConfiguration, homePose, controlFrame, baseFrame, taskspaceAngularWeight, taskspaceLinearWeight, taskspaceOrientationGains, taskspacePositionGains, contactableBody, defaultControlMode, yoTime, graphicsListRegistry, this.registry);
        manager2.setGains(this.jointGainMap);
        manager2.setWeights(this.jointspaceWeightMap, this.userModeWeightMap);
        this.rigidBodyManagerMapByBodyName.put(bodyName, manager2);
        return manager2;
    }

    public FeetManager getOrCreateFeetManager() {
        if (this.feetManager != null) {
            return this.feetManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(FeetManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(FeetManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(FeetManager.class)) {
            return null;
        }
        this.feetManager = new FeetManager(this.controllerToolbox, this.walkingControllerParameters, this.swingFootGains, this.holdFootGains, this.toeOffFootGains, this.registry, this.controllerToolbox.getYoGraphicsListRegistry());
        String footName = this.controllerToolbox.getFullRobotModel().getFoot((Enum)RobotSide.LEFT).getName();
        Vector3DReadOnly angularWeight = this.taskspaceAngularWeightMap.get(footName);
        Vector3DReadOnly linearWeight = this.taskspaceLinearWeightMap.get(footName);
        if (angularWeight == null || linearWeight == null) {
            throw new RuntimeException("Not all weights defined for the foot control: " + footName + " needs weights.");
        }
        String otherFootName = this.controllerToolbox.getFullRobotModel().getFoot((Enum)RobotSide.RIGHT).getName();
        if (this.taskspaceAngularWeightMap.get(otherFootName) != angularWeight || this.taskspaceLinearWeightMap.get(otherFootName) != linearWeight) {
            throw new RuntimeException("There can only be one weight defined for both feet. Make sure they are in the same GroupParameter");
        }
        this.feetManager.setWeights(this.loadedFootAngularWeight, this.loadedFootLinearWeight, angularWeight, linearWeight);
        return this.feetManager;
    }

    @Deprecated
    public LegConfigurationManager getOrCreateKneeAngleManager() {
        return this.getOrCreateLegConfigurationManager();
    }

    public LegConfigurationManager getOrCreateLegConfigurationManager() {
        if (this.legConfigurationManager != null) {
            return this.legConfigurationManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(LegConfigurationManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(LegConfigurationManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(LegConfigurationManager.class)) {
            return null;
        }
        this.legConfigurationManager = new LegConfigurationManager(this.controllerToolbox, this.walkingControllerParameters, this.registry);
        return this.legConfigurationManager;
    }

    public PelvisOrientationManager getOrCreatePelvisOrientationManager() {
        if (this.pelvisOrientationManager != null) {
            return this.pelvisOrientationManager;
        }
        if (!this.hasHighLevelHumanoidControllerToolbox(PelvisOrientationManager.class)) {
            return null;
        }
        if (!this.hasWalkingControllerParameters(PelvisOrientationManager.class)) {
            return null;
        }
        if (!this.hasMomentumOptimizationSettings(PelvisOrientationManager.class)) {
            return null;
        }
        String pelvisName = this.controllerToolbox.getFullRobotModel().getPelvis().getName();
        PID3DGainsReadOnly pelvisGains = this.taskspaceOrientationGainMap.get(pelvisName);
        Vector3DReadOnly pelvisAngularWeight = this.taskspaceAngularWeightMap.get(pelvisName);
        PelvisOffsetWhileWalkingParameters pelvisOffsetWhileWalkingParameters = this.walkingControllerParameters.getPelvisOffsetWhileWalkingParameters();
        LeapOfFaithParameters leapOfFaithParameters = this.walkingControllerParameters.getLeapOfFaithParameters();
        this.pelvisOrientationManager = new PelvisOrientationManager(pelvisGains, pelvisOffsetWhileWalkingParameters, leapOfFaithParameters, this.controllerToolbox, this.registry);
        this.pelvisOrientationManager.setWeights(pelvisAngularWeight);
        this.pelvisOrientationManager.setPrepareForLocomotion(this.walkingControllerParameters.doPreparePelvisForLocomotion());
        return this.pelvisOrientationManager;
    }

    private boolean hasHighLevelHumanoidControllerToolbox(Class<?> managerClass) {
        if (this.controllerToolbox != null) {
            return true;
        }
        this.missingObjectWarning(HighLevelHumanoidControllerToolbox.class, managerClass);
        return false;
    }

    private boolean hasWalkingControllerParameters(Class<?> managerClass) {
        if (this.walkingControllerParameters != null) {
            return true;
        }
        this.missingObjectWarning(WalkingControllerParameters.class, managerClass);
        return false;
    }

    private boolean hasCoPTrajectoryParameters(Class<?> managerClass) {
        if (this.copTrajectoryParameters != null) {
            return true;
        }
        this.missingObjectWarning(CoPTrajectoryParameters.class, managerClass);
        return false;
    }

    private boolean hasMomentumOptimizationSettings(Class<?> managerClass) {
        if (this.momentumOptimizationSettings != null) {
            return true;
        }
        this.missingObjectWarning(MomentumOptimizationSettings.class, managerClass);
        return false;
    }

    private void missingObjectWarning(Class<?> missingObjectClass, Class<?> managerClass) {
        LogTools.warn((String)(missingObjectClass.getSimpleName() + " has not been set, cannot create: " + managerClass.getSimpleName()));
    }

    public void initializeManagers() {
        if (this.balanceManager != null) {
            this.balanceManager.initialize();
        }
        if (this.centerOfMassHeightManager != null) {
            this.centerOfMassHeightManager.initialize();
        }
        if (this.pelvisOrientationManager != null) {
            this.pelvisOrientationManager.initialize();
        }
        Collection<RigidBodyControlManager> bodyManagers = this.rigidBodyManagerMapByBodyName.values();
        for (RigidBodyControlManager bodyManager : bodyManagers) {
            if (bodyManager == null) continue;
            bodyManager.initialize();
        }
    }

    public FeedbackControllerTemplate createFeedbackControlTemplate() {
        FeedbackControlCommandList ret = new FeedbackControlCommandList();
        if (this.feetManager != null) {
            FeedbackControlCommandList template = this.feetManager.createFeedbackControlTemplate();
            for (int i = 0; i < template.getNumberOfCommands(); ++i) {
                ret.addCommand(template.getCommand(i));
            }
        }
        Collection<RigidBodyControlManager> bodyManagers = this.rigidBodyManagerMapByBodyName.values();
        for (RigidBodyControlManager bodyManager : bodyManagers) {
            if (bodyManager == null) continue;
            ret.addCommand(bodyManager.createFeedbackControlTemplate());
        }
        ret.addCommand(this.centerOfMassHeightManager.createFeedbackControlTemplate());
        if (this.pelvisOrientationManager != null) {
            ret.addCommand(this.pelvisOrientationManager.createFeedbackControlTemplate());
        }
        return new FeedbackControllerTemplate(ret);
    }
}

