/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.highLevelHumanoidControl;

import controller_msgs.msg.dds.HighLevelStateChangeStatusMessage;
import controller_msgs.msg.dds.RobotDesiredConfigurationData;
import java.util.ArrayList;
import java.util.EnumMap;
import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.YoLowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.HighLevelControllerFactoryHelper;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ControllerStateTransitionFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControllerStateFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.packets.ControllerCrashLocation;
import us.ihmc.communication.packets.MessageTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.humanoidRobotics.bipedSupportPolygons.ContactableFoot;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HighLevelControllerStateCommand;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.core.StateTransition;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.parameters.IntegerParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class HumanoidHighLevelControllerManager
implements RobotController {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private final StateMachine<HighLevelControllerName, HighLevelControllerState> stateMachine;
    private final HighLevelHumanoidControllerToolbox controllerToolbox;
    private final YoBoolean isListeningToHighLevelStateMessage = new YoBoolean("isListeningToHighLevelStateMessage", this.registry);
    private final YoEnum<HighLevelControllerName> requestedHighLevelControllerState;
    private final YoLowLevelOneDoFJointDesiredDataHolder yoLowLevelOneDoFJointDesiredDataHolder;
    private final CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator;
    private final JointDesiredOutputListBasics lowLevelControllerOutput;
    private final RootJointDesiredConfigurationData rootJointDesiredConfiguration = new RootJointDesiredConfigurationData();
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusMessageOutputManager;
    private final HighLevelControllerFactoryHelper controllerFactoryHelper;
    private final EnumMap<HighLevelControllerName, HighLevelControllerState> highLevelControllerStates = new EnumMap(HighLevelControllerName.class);
    private final HighLevelStateChangeStatusMessage highLevelStateChangeStatusMessage = new HighLevelStateChangeStatusMessage();
    private final ExecutionTimer highLevelControllerTimer = new ExecutionTimer("activeHighLevelControllerTimer", 1.0, this.registry);
    private final RobotDesiredConfigurationData robotDesiredConfigurationData = new RobotDesiredConfigurationData();
    private final IntegerParameter jointDesiredOutputBroadcastFrequency = new IntegerParameter("jointDesiredOutputBroadcastFrequency", this.registry, 10);
    private final SideDependentList<FramePoint2D> desiredFootCoPs = new SideDependentList((Object)new FramePoint2D(), (Object)new FramePoint2D());
    private int jointDesiredOutputBroadcastCounter = 0;

    public HumanoidHighLevelControllerManager(CommandInputManager commandInputManager, StatusMessageOutputManager statusMessageOutputManager, HighLevelControllerName initialControllerState, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters, YoEnum<HighLevelControllerName> requestedHighLevelControllerState, EnumMap<HighLevelControllerName, HighLevelControllerStateFactory> controllerStateFactories, ArrayList<ControllerStateTransitionFactory<HighLevelControllerName>> controllerTransitionFactories, HighLevelControlManagerFactory managerFactory, HighLevelHumanoidControllerToolbox controllerToolbox, CenterOfPressureDataHolder centerOfPressureDataHolderForEstimator, ForceSensorDataHolderReadOnly forceSensorDataHolder, JointDesiredOutputListBasics lowLevelControllerOutput) {
        this.commandInputManager = commandInputManager;
        this.statusMessageOutputManager = statusMessageOutputManager;
        this.controllerToolbox = controllerToolbox;
        this.requestedHighLevelControllerState = requestedHighLevelControllerState;
        this.centerOfPressureDataHolderForEstimator = centerOfPressureDataHolderForEstimator;
        this.lowLevelControllerOutput = lowLevelControllerOutput;
        this.requestedHighLevelControllerState.set((Enum)initialControllerState);
        this.registry.addChild(controllerToolbox.getYoVariableRegistry());
        this.controllerFactoryHelper = new HighLevelControllerFactoryHelper();
        this.controllerFactoryHelper.setCommandInputManager(commandInputManager);
        this.controllerFactoryHelper.setStatusMessageOutputManager(statusMessageOutputManager);
        this.controllerFactoryHelper.setParameters(highLevelControllerParameters, walkingControllerParameters);
        this.controllerFactoryHelper.setHighLevelHumanoidControllerToolbox(controllerToolbox);
        this.controllerFactoryHelper.setLowLevelControllerOutput(lowLevelControllerOutput);
        this.controllerFactoryHelper.setRequestedHighLevelControllerState(requestedHighLevelControllerState);
        this.controllerFactoryHelper.setForceSensorDataHolder(forceSensorDataHolder);
        this.stateMachine = this.setUpStateMachine(initialControllerState, controllerStateFactories, controllerTransitionFactories, managerFactory, controllerToolbox.getYoTime(), this.registry);
        this.isListeningToHighLevelStateMessage.set(true);
        for (HighLevelControllerState highLevelControllerState : this.highLevelControllerStates.values()) {
            this.registry.addChild(highLevelControllerState.getYoRegistry());
        }
        OneDoFJointBasics[] controlledOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])controllerToolbox.getControlledJoints(), OneDoFJointBasics.class);
        this.yoLowLevelOneDoFJointDesiredDataHolder = new YoLowLevelOneDoFJointDesiredDataHolder((OneDoFJointReadOnly[])controlledOneDoFJoints, this.registry);
    }

    public void addYoVariableRegistry(YoRegistry registryToAdd) {
        this.registry.addChild(registryToAdd);
    }

    public void requestHighLevelControllerState(HighLevelControllerName requestedHighLevelControllerName) {
        this.requestedHighLevelControllerState.set((Enum)requestedHighLevelControllerName);
    }

    public void setListenToHighLevelStatePackets(boolean isListening) {
        this.isListeningToHighLevelStateMessage.set(isListening);
    }

    public void initialize() {
        this.controllerToolbox.initialize();
        this.stateMachine.resetToInitialState();
    }

    public void doControl() {
        if (this.isListeningToHighLevelStateMessage.getBooleanValue() && this.commandInputManager.isNewCommandAvailable(HighLevelControllerStateCommand.class)) {
            this.requestedHighLevelControllerState.set((Enum)((HighLevelControllerStateCommand)this.commandInputManager.pollNewestCommand(HighLevelControllerStateCommand.class)).getHighLevelControllerName());
        }
        this.highLevelControllerTimer.startMeasurement();
        try {
            this.controllerToolbox.update();
            this.stateMachine.doActionAndTransition();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.statusMessageOutputManager.reportStatusMessage((Object)MessageTools.createControllerCrashNotificationPacket((ControllerCrashLocation)ControllerCrashLocation.CONTROLLER_RUN, (Throwable)e));
            this.controllerToolbox.reportControllerFailureToListeners(null);
        }
        this.highLevelControllerTimer.stopMeasurement();
        this.copyJointDesiredsToJoints();
        this.reportDesiredCenterOfPressureForEstimator();
        this.reportRobotDesiredConfigurationData();
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getDescription() {
        return this.getName();
    }

    private StateMachine<HighLevelControllerName, HighLevelControllerState> setUpStateMachine(HighLevelControllerName initialControllerState, EnumMap<HighLevelControllerName, HighLevelControllerStateFactory> controllerStateFactories, ArrayList<ControllerStateTransitionFactory<HighLevelControllerName>> controllerTransitionFactories, HighLevelControlManagerFactory managerFactory, YoDouble yoTime, YoRegistry registry) {
        this.controllerFactoryHelper.setControllerFactories(controllerStateFactories);
        this.controllerFactoryHelper.setHighLevelControlManagerFactory(managerFactory);
        StateMachineFactory factory = new StateMachineFactory(HighLevelControllerName.class);
        factory.setNamePrefix("highLevelControllerName").setRegistry(registry).buildYoClock((DoubleProvider)yoTime);
        for (HighLevelControllerStateFactory highLevelControllerStateFactory : controllerStateFactories.values()) {
            HighLevelControllerState highLevelControllerState = highLevelControllerStateFactory.getOrCreateControllerState(this.controllerFactoryHelper);
            factory.addState((Enum)highLevelControllerState.getHighLevelControllerName(), (State)highLevelControllerState);
            this.highLevelControllerStates.put(highLevelControllerStateFactory.getStateEnum(), highLevelControllerState);
            if (!highLevelControllerStateFactory.isTransitionToControllerRequested()) continue;
            this.requestedHighLevelControllerState.set((Enum)highLevelControllerStateFactory.getStateEnum());
        }
        for (ControllerStateTransitionFactory controllerStateTransitionFactory : controllerTransitionFactories) {
            StateTransition<HighLevelControllerName> stateTransition = controllerStateTransitionFactory.getOrCreateStateTransition(this.highLevelControllerStates, this.controllerFactoryHelper, registry);
            HighLevelControllerName stateToAttachEnum = (HighLevelControllerName)controllerStateTransitionFactory.getStateToAttachEnum();
            factory.addTransition((Enum)stateToAttachEnum, stateTransition);
        }
        factory.addStateChangedListener((StateChangedListener)new StateChangedListener<HighLevelControllerName>(){

            public void stateChanged(HighLevelControllerName from, HighLevelControllerName to) {
                byte fromByte = from == null ? (byte)-1 : (byte)from.toByte();
                byte toByte = to == null ? (byte)-1 : (byte)to.toByte();
                HumanoidHighLevelControllerManager.this.highLevelStateChangeStatusMessage.setInitialHighLevelControllerName(fromByte);
                HumanoidHighLevelControllerManager.this.highLevelStateChangeStatusMessage.setEndHighLevelControllerName(toByte);
                HumanoidHighLevelControllerManager.this.statusMessageOutputManager.reportStatusMessage((Object)HumanoidHighLevelControllerManager.this.highLevelStateChangeStatusMessage);
            }
        });
        return factory.build((Enum)initialControllerState);
    }

    private void reportDesiredCenterOfPressureForEstimator() {
        SideDependentList<ContactableFoot> contactableFeet = this.controllerToolbox.getContactableFeet();
        FullHumanoidRobotModel fullHumanoidRobotModel = this.controllerToolbox.getFullRobotModel();
        for (RobotSide robotSide : RobotSide.values) {
            this.controllerToolbox.getDesiredCenterOfPressure((ContactablePlaneBody)contactableFeet.get((Enum)robotSide), (FramePoint2D)this.desiredFootCoPs.get((Enum)robotSide));
            this.centerOfPressureDataHolderForEstimator.setCenterOfPressure((FramePoint2DReadOnly)this.desiredFootCoPs.get((Enum)robotSide), fullHumanoidRobotModel.getFoot((Enum)robotSide));
        }
    }

    private void copyJointDesiredsToJoints() {
        JointDesiredOutputListReadOnly lowLevelOneDoFJointDesiredDataHolder = ((HighLevelControllerState)this.stateMachine.getCurrentState()).getOutputForLowLevelController();
        for (int jointIndex = 0; jointIndex < lowLevelOneDoFJointDesiredDataHolder.getNumberOfJointsWithDesiredOutput(); ++jointIndex) {
            OneDoFJointReadOnly controlledJoint = lowLevelOneDoFJointDesiredDataHolder.getOneDoFJoint(jointIndex);
            JointDesiredOutputReadOnly lowLevelJointData = lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput(controlledJoint);
            if (lowLevelJointData.hasControlMode()) continue;
            throw new NullPointerException("Joint: " + controlledJoint.getName() + " has no control mode.");
        }
        this.yoLowLevelOneDoFJointDesiredDataHolder.overwriteWith(lowLevelOneDoFJointDesiredDataHolder);
        this.lowLevelControllerOutput.overwriteWith(lowLevelOneDoFJointDesiredDataHolder);
        RootJointDesiredConfigurationDataReadOnly rootJointDesiredConfiguration = ((HighLevelControllerState)this.stateMachine.getCurrentState()).getOutputForRootJoint();
        if (rootJointDesiredConfiguration != null) {
            this.rootJointDesiredConfiguration.set(rootJointDesiredConfiguration);
        }
    }

    private void reportRobotDesiredConfigurationData() {
        if (++this.jointDesiredOutputBroadcastCounter < this.jointDesiredOutputBroadcastFrequency.getValue()) {
            return;
        }
        this.jointDesiredOutputBroadcastCounter = 0;
        this.lowLevelControllerOutput.copyToMessage(this.robotDesiredConfigurationData);
        HighLevelControllerState currentState = (HighLevelControllerState)this.stateMachine.getCurrentState();
        if (currentState == null || currentState.getOutputForRootJoint() == null) {
            return;
        }
        currentState.getOutputForRootJoint().copyToMessage(this.robotDesiredConfigurationData);
        this.robotDesiredConfigurationData.setWallTime(System.nanoTime());
        this.statusMessageOutputManager.reportStatusMessage((Object)this.robotDesiredConfigurationData);
    }

    public HighLevelControllerName getCurrentHighLevelControlState() {
        return (HighLevelControllerName)this.stateMachine.getCurrentStateKey();
    }
}

