/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.heightPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.desiredFootStep.TransferToAndNextFootstepsData;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightPartialDerivativesDataBasics;
import us.ihmc.commonWalkingControlModules.heightPlanning.CoMHeightTrajectoryWaypoint;
import us.ihmc.commonWalkingControlModules.heightPlanning.HeightOffsetHandler;
import us.ihmc.commonWalkingControlModules.heightPlanning.SplinedHeightTrajectory;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.commons.lists.SupplierBuilder;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.parameters.BooleanParameter;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class LookAheadCoMHeightTrajectoryGenerator {
    private static final double defaultPercentageInOffset = 0.05;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private boolean visualize = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean initializeToCurrent = new YoBoolean("initializeCoMHeightToCurrent", this.registry);
    private final BooleanProvider processGoHome = new BooleanParameter("ProcessGoHome", this.registry, false);
    private final HeightOffsetHandler heightOffsetHandler;
    private final YoEnum<RobotSide> supportLegSide = new YoEnum("supportLegSide", this.registry, RobotSide.class);
    private final YoDouble minimumHeightAboveGround = new YoDouble("minimumHeightAboveGround", this.registry);
    private final YoDouble nominalHeightAboveGround = new YoDouble("nominalHeightAboveGround", this.registry);
    private final YoDouble maximumHeightAboveGround = new YoDouble("maximumHeightAboveGround", this.registry);
    private final YoDouble hipWidth = new YoDouble("hipWidth", this.registry);
    private final YoDouble extraToeOffHeight = new YoDouble("extraToeOffHeight", this.registry);
    private final YoDouble nominalDoubleSupportExchange = new YoDouble("nominalDoubleSupportExchange", this.registry);
    private final YoDouble doubleSupportExchange = new YoDouble("doubleSupportExchange", this.registry);
    private final YoDouble doubleSupportPercentageIn = new YoDouble("doubleSupportPercentageIn", this.registry);
    private final YoDouble doubleSupportPercentageOut = new YoDouble("doubleSupportPercentageOut", this.registry);
    private final YoDouble doubleSupportExchangeOffset = new YoDouble("doubleSupportExchangeOffset", this.registry);
    private final YoDouble percentageThroughSegment = new YoDouble("percentageThroughSegment", this.registry);
    private final YoDouble splineQuery = new YoDouble("splineQuery", this.registry);
    private final FramePoint3D transferFromPosition = new FramePoint3D();
    private final FramePoint3D transferToPosition = new FramePoint3D();
    private final YoFramePoint3D yoTransferFromPosition = new YoFramePoint3D("transferFromPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D yoTransferToPosition = new YoFramePoint3D("transferToPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D desiredCoMPositionAtStart = new YoFramePoint3D("desiredCoMPositionAtStart", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint2D desiredCoMPositionAtEnd = new YoFramePoint2D("desiredCoMPositionAtEnd", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D desiredCoMPosition = new YoFramePoint3D("desiredCoMPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoDouble desiredCoMHeight = new YoDouble("desiredCoMHeight", this.registry);
    private final YoFramePoint3D queryPosition = new YoFramePoint3D("queryPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final RecyclingArrayList<CoMHeightTrajectoryWaypoint> heightWaypoints;
    private final DoubleProvider yoTime;
    private ReferenceFrame frameOfSupportLeg;
    private final ReferenceFrame centerOfMassFrame;
    private final ReferenceFrame frameOfHeight;
    private final SideDependentList<? extends ReferenceFrame> soleFrames;
    private final FramePoint3D com = new FramePoint3D();
    private final FramePoint3D tempFramePoint = new FramePoint3D();
    private final FramePoint3D startCoMPosition = new FramePoint3D();
    private final FramePoint3D endCoMPosition = new FramePoint3D();
    private final SplinedHeightTrajectory splinedHeightTrajectory;
    private final Point2D point = new Point2D();
    private final PelvisHeightTrajectoryCommand tempPelvisHeightTrajectoryCommand = new PelvisHeightTrajectoryCommand();

    public LookAheadCoMHeightTrajectoryGenerator(double minimumHeightAboveGround, double nominalHeightAboveGround, double maximumHeightAboveGround, double defaultOffsetHeightAboveGround, double doubleSupportPercentageIn, ReferenceFrame centerOfMassFrame, ReferenceFrame frameOfHeight, SideDependentList<? extends ReferenceFrame> soleFrames, DoubleProvider yoTime, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this(minimumHeightAboveGround, nominalHeightAboveGround, maximumHeightAboveGround, defaultOffsetHeightAboveGround, doubleSupportPercentageIn, 0.0, centerOfMassFrame, frameOfHeight, soleFrames, yoTime, yoGraphicsListRegistry, parentRegistry);
    }

    public LookAheadCoMHeightTrajectoryGenerator(double minimumHeightAboveGround, double nominalHeightAboveGround, double maximumHeightAboveGround, double defaultOffsetHeightAboveGround, double doubleSupportPercentageIn, double hipWidth, ReferenceFrame centerOfMassFrame, ReferenceFrame frameOfHeight, SideDependentList<? extends ReferenceFrame> soleFrames, DoubleProvider yoTime, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.centerOfMassFrame = centerOfMassFrame;
        this.frameOfHeight = frameOfHeight;
        this.soleFrames = soleFrames;
        this.yoTime = yoTime;
        this.heightOffsetHandler = new HeightOffsetHandler(yoTime, defaultOffsetHeightAboveGround, this.registry);
        this.doubleSupportExchangeOffset.set(0.05);
        this.setMinimumHeightAboveGround(minimumHeightAboveGround);
        this.setNominalHeightAboveGround(nominalHeightAboveGround);
        this.setMaximumHeightAboveGround(maximumHeightAboveGround);
        this.hipWidth.set(hipWidth);
        this.heightWaypoints = new RecyclingArrayList(6, SupplierBuilder.indexedSupplier(this::createHeightWaypoint));
        this.splinedHeightTrajectory = new SplinedHeightTrajectory(this.registry, yoGraphicsListRegistry);
        this.setSupportLeg(RobotSide.LEFT);
        this.nominalDoubleSupportExchange.set(doubleSupportPercentageIn);
        parentRegistry.addChild(this.registry);
        if (yoGraphicsListRegistry == null) {
            this.visualize = false;
        }
        if (this.visualize) {
            double pointSize = 0.03;
            String prefix = "better_";
            ArrayList<AppearanceDefinition> colors = new ArrayList<AppearanceDefinition>();
            colors.add(YoAppearance.CadetBlue());
            colors.add(YoAppearance.Chartreuse());
            colors.add(YoAppearance.Yellow());
            colors.add(YoAppearance.Yellow());
            colors.add(YoAppearance.BlueViolet());
            colors.add(YoAppearance.Azure());
            String graphicListName = "BetterCoMHeightTrajectoryGenerator";
            this.heightWaypoints.clear();
            for (int i = 0; i < colors.size(); ++i) {
                ((CoMHeightTrajectoryWaypoint)this.heightWaypoints.add()).setupViz(graphicListName, prefix + "HeightWaypoint" + i, (AppearanceDefinition)colors.get(i), yoGraphicsListRegistry);
            }
            YoGraphicPosition desiredCoMPositionViz = new YoGraphicPosition(prefix + "desiredCoMPosition", this.desiredCoMPosition, 1.1 * pointSize, YoAppearance.Gold());
            yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)desiredCoMPositionViz);
        }
        this.heightWaypoints.clear();
    }

    private CoMHeightTrajectoryWaypoint createHeightWaypoint(int i) {
        return new CoMHeightTrajectoryWaypoint("heightWaypoint" + i, this.registry);
    }

    public void reset() {
        this.tempFramePoint.setToZero(this.frameOfHeight);
        this.tempFramePoint.changeFrame(this.frameOfSupportLeg);
        this.tempFramePoint.setZ(this.nominalHeightAboveGround.getDoubleValue());
        this.desiredCoMHeight.set(this.nominalHeightAboveGround.getDoubleValue());
        this.tempFramePoint.changeFrame(worldFrame);
        this.desiredCoMPosition.set((FrameTuple3DReadOnly)this.tempFramePoint);
        this.extraToeOffHeight.set(0.0);
        this.heightOffsetHandler.reset();
    }

    public void setMinimumHeightAboveGround(double minimumHeightAboveGround) {
        this.minimumHeightAboveGround.set(minimumHeightAboveGround);
    }

    public void setNominalHeightAboveGround(double nominalHeightAboveGround) {
        this.nominalHeightAboveGround.set(nominalHeightAboveGround);
    }

    public void setMaximumHeightAboveGround(double maximumHeightAboveGround) {
        this.maximumHeightAboveGround.set(maximumHeightAboveGround);
    }

    public double getDoubleSupportPercentageIn() {
        return this.doubleSupportPercentageIn.getDoubleValue();
    }

    public void setSupportLeg(RobotSide supportLeg) {
        this.supportLegSide.set((Enum)supportLeg);
        this.frameOfSupportLeg = (ReferenceFrame)this.soleFrames.get((Enum)supportLeg);
        this.splinedHeightTrajectory.setReferenceFrame(this.frameOfSupportLeg);
        this.heightOffsetHandler.setReferenceFrame(this.frameOfSupportLeg);
    }

    public void initializeToNominalHeight() {
        this.heightWaypoints.clear();
        this.transferToPosition.setToZero((ReferenceFrame)this.soleFrames.get((Enum)RobotSide.LEFT));
        this.transferFromPosition.setToZero((ReferenceFrame)this.soleFrames.get((Enum)RobotSide.RIGHT));
        this.transferToPosition.changeFrame(worldFrame);
        this.transferFromPosition.changeFrame(worldFrame);
        if (this.transferToPosition.getZ() > this.transferFromPosition.getZ()) {
            this.setSupportLeg(RobotSide.RIGHT);
        } else {
            this.setSupportLeg(RobotSide.LEFT);
        }
        this.transferToPosition.changeFrame(this.frameOfSupportLeg);
        this.transferFromPosition.changeFrame(this.frameOfSupportLeg);
        this.yoTransferFromPosition.setMatchingFrame((FrameTuple3DReadOnly)this.transferFromPosition);
        this.yoTransferToPosition.setMatchingFrame((FrameTuple3DReadOnly)this.transferToPosition);
        this.tempFramePoint.setToZero(this.frameOfSupportLeg);
        this.tempFramePoint.setZ(this.nominalHeightAboveGround.getDoubleValue());
        this.tempFramePoint.changeFrame(worldFrame);
        double midstanceY = 0.5 * (this.transferToPosition.getY() + this.transferFromPosition.getY());
        CoMHeightTrajectoryWaypoint startWaypoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        startWaypoint.setHeight(this.nominalHeightAboveGround.getDoubleValue());
        startWaypoint.setMinMax(this.nominalHeightAboveGround.getDoubleValue() - 0.05, this.nominalHeightAboveGround.getDoubleValue() + 0.05);
        startWaypoint.setXY(this.transferFromPosition.getX(), midstanceY);
        CoMHeightTrajectoryWaypoint endWaypoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        endWaypoint.setHeight(this.nominalHeightAboveGround.getDoubleValue());
        endWaypoint.setMinMax(this.nominalHeightAboveGround.getDoubleValue() - 0.05, this.nominalHeightAboveGround.getDoubleValue() + 0.05);
        endWaypoint.setXY(this.transferToPosition.getX(), midstanceY);
        this.desiredCoMPositionAtStart.set((FrameTuple3DReadOnly)this.desiredCoMPosition);
        this.desiredCoMPositionAtStart.setZ(this.tempFramePoint.getZ());
        for (int i = 0; i < this.heightWaypoints.size(); ++i) {
            ((CoMHeightTrajectoryWaypoint)this.heightWaypoints.get(i)).update();
        }
        this.splinedHeightTrajectory.clearWaypoints();
        this.splinedHeightTrajectory.addWaypoints((List<CoMHeightTrajectoryWaypoint>)this.heightWaypoints);
        this.splinedHeightTrajectory.computeSpline();
    }

    public void initialize(TransferToAndNextFootstepsData transferToAndNextFootstepsData, double extraToeOffHeight) {
        FramePoint3DReadOnly transferToFootstepPosition = transferToAndNextFootstepsData.getTransferToPosition();
        this.extraToeOffHeight.set(extraToeOffHeight);
        this.transferToPosition.setIncludingFrame((FrameTuple3DReadOnly)transferToFootstepPosition);
        this.transferFromPosition.setToZero((ReferenceFrame)this.soleFrames.get((Enum)transferToAndNextFootstepsData.getTransferToSide().getOppositeSide()));
        this.transferToPosition.changeFrame(this.frameOfSupportLeg);
        this.transferFromPosition.changeFrame(this.frameOfSupportLeg);
        double startAnkleZ = this.transferFromPosition.getZ();
        this.yoTransferFromPosition.setMatchingFrame((FrameTuple3DReadOnly)this.transferFromPosition);
        this.yoTransferToPosition.setMatchingFrame((FrameTuple3DReadOnly)this.transferToPosition);
        this.desiredCoMPositionAtStart.set((FrameTuple3DReadOnly)this.desiredCoMPosition);
        this.startCoMPosition.setIncludingFrame((FrameTuple3DReadOnly)this.desiredCoMPosition);
        this.startCoMPosition.changeFrame(this.frameOfSupportLeg);
        this.endCoMPosition.setIncludingFrame((FrameTuple3DReadOnly)transferToFootstepPosition);
        this.endCoMPosition.changeFrame(this.frameOfSupportLeg);
        double middleAnkleZ = this.endCoMPosition.getZ();
        this.endCoMPosition.addZ(this.nominalHeightAboveGround.getDoubleValue());
        double midstanceY = 0.5 * (this.transferToPosition.getY() + this.transferFromPosition.getY());
        this.startCoMPosition.setY(midstanceY);
        this.endCoMPosition.setY(midstanceY);
        this.desiredCoMPositionAtEnd.set((FrameTuple2DReadOnly)transferToAndNextFootstepsData.getCoMAtEndOfState());
        if (!this.desiredCoMPositionAtEnd.containsNaN()) {
            this.tempFramePoint.setIncludingFrame((FrameTuple2DReadOnly)transferToAndNextFootstepsData.getCoMAtEndOfState(), 0.0);
            this.tempFramePoint.changeFrame(this.frameOfSupportLeg);
            this.tempFramePoint.setZ(this.nominalHeightAboveGround.getDoubleValue());
            double percentExchange = EuclidGeometryTools.percentageAlongLineSegment3D((Point3DReadOnly)this.tempFramePoint, (Point3DReadOnly)this.startCoMPosition, (Point3DReadOnly)this.endCoMPosition);
            percentExchange = MathTools.clamp((double)percentExchange, (double)this.nominalDoubleSupportExchange.getDoubleValue(), (double)(1.0 - this.nominalDoubleSupportExchange.getDoubleValue()));
            this.doubleSupportExchange.set(percentExchange);
        } else {
            this.doubleSupportExchange.set(this.nominalDoubleSupportExchange.getDoubleValue());
        }
        this.doubleSupportPercentageIn.set(this.doubleSupportExchange.getDoubleValue() - this.doubleSupportExchangeOffset.getDoubleValue());
        this.doubleSupportPercentageOut.set(this.doubleSupportExchange.getDoubleValue() + this.doubleSupportExchangeOffset.getDoubleValue());
        this.heightWaypoints.clear();
        this.computeWaypoints((FramePoint3DReadOnly)this.startCoMPosition, (FramePoint3DReadOnly)this.endCoMPosition, startAnkleZ, middleAnkleZ, this.minimumHeightAboveGround.getDoubleValue(), this.maximumHeightAboveGround.getDoubleValue(), this.extraToeOffHeight.getDoubleValue());
        for (int i = 0; i < this.heightWaypoints.size(); ++i) {
            ((CoMHeightTrajectoryWaypoint)this.heightWaypoints.get(i)).update();
        }
        this.splinedHeightTrajectory.clearWaypoints();
        this.splinedHeightTrajectory.addWaypoints((List<CoMHeightTrajectoryWaypoint>)this.heightWaypoints);
        this.splinedHeightTrajectory.computeSpline();
    }

    private void computeWaypoints(FramePoint3DReadOnly startCoMPosition, FramePoint3DReadOnly endCoMPosition, double startGroundHeight, double endGroundHeight, double minimumHeight, double maximumHeight, double extraToeOffHeight) {
        double startAnkleX = this.transferFromPosition.getX();
        double startAnkleY = this.transferFromPosition.getY();
        double endAnkleX = this.transferToPosition.getX();
        double endAnkleY = this.transferToPosition.getY();
        double startWaypointX = startCoMPosition.getX();
        double endWaypointX = endCoMPosition.getX();
        double startWaypointY = startCoMPosition.getY();
        double endWaypointY = endCoMPosition.getY();
        double firstAlpha = 0.5 * this.doubleSupportPercentageIn.getDoubleValue();
        double secondAlpha = this.doubleSupportPercentageIn.getDoubleValue();
        double thirdAlpha = this.doubleSupportPercentageOut.getDoubleValue();
        double fourthAlpha = 0.5 * (1.0 + this.doubleSupportPercentageOut.getDoubleValue());
        double firstMidpointX = InterpolationTools.linearInterpolate((double)startWaypointX, (double)endWaypointX, (double)firstAlpha);
        double secondMidpointX = InterpolationTools.linearInterpolate((double)startWaypointX, (double)endWaypointX, (double)secondAlpha);
        double thirdMidpointX = InterpolationTools.linearInterpolate((double)startWaypointX, (double)endWaypointX, (double)thirdAlpha);
        double fourthMidpointX = InterpolationTools.linearInterpolate((double)startWaypointX, (double)endWaypointX, (double)fourthAlpha);
        double firstMidpointY = InterpolationTools.linearInterpolate((double)startWaypointY, (double)endWaypointY, (double)firstAlpha);
        double secondMidpointY = InterpolationTools.linearInterpolate((double)startWaypointY, (double)endWaypointY, (double)secondAlpha);
        double thirdMidpointY = InterpolationTools.linearInterpolate((double)startWaypointY, (double)endWaypointY, (double)thirdAlpha);
        double fourthMidpointY = InterpolationTools.linearInterpolate((double)startWaypointY, (double)endWaypointY, (double)fourthAlpha);
        CoMHeightTrajectoryWaypoint startWaypoint = this.heightWaypoints.size() > 0 ? (CoMHeightTrajectoryWaypoint)this.heightWaypoints.getLast() : this.getWaypointInFrame(this.frameOfSupportLeg);
        CoMHeightTrajectoryWaypoint firstMidpoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        CoMHeightTrajectoryWaypoint secondMidpoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        CoMHeightTrajectoryWaypoint thirdMidpoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        CoMHeightTrajectoryWaypoint fourthMidpoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        CoMHeightTrajectoryWaypoint endWaypoint = this.getWaypointInFrame(this.frameOfSupportLeg);
        startWaypoint.setXY(startWaypointX, startWaypointY);
        firstMidpoint.setXY(firstMidpointX, firstMidpointY);
        secondMidpoint.setXY(secondMidpointX, secondMidpointY);
        thirdMidpoint.setXY(thirdMidpointX, thirdMidpointY);
        fourthMidpoint.setXY(fourthMidpointX, fourthMidpointY);
        endWaypoint.setXY(endWaypointX, endWaypointY);
        double startMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, startWaypointX, startWaypointY, startGroundHeight);
        double startMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight + extraToeOffHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, startWaypointX, startWaypointY, startGroundHeight);
        startMinHeight = Math.min(startMinHeight, startCoMPosition.getZ() - this.heightOffsetHandler.getOffsetHeightAboveGround());
        startMaxHeight = Math.max(startMaxHeight, startCoMPosition.getZ() - this.heightOffsetHandler.getOffsetHeightAboveGround());
        double firstMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, firstMidpointX, firstMidpointY, startGroundHeight);
        double firstMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, firstMidpointX, firstMidpointY, startGroundHeight);
        firstMinHeight = Math.min(firstMinHeight, startMinHeight);
        firstMaxHeight = Math.min(firstMaxHeight, startMaxHeight);
        double exchangeInFromMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, secondMidpointX, secondMidpointY, startGroundHeight);
        double exchangeInToMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, secondMidpointX, secondMidpointY, endGroundHeight);
        double exchangeInFromMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight + extraToeOffHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, secondMidpointX, secondMidpointY, startGroundHeight);
        double exchangeInToMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, secondMidpointX, secondMidpointY, endGroundHeight);
        double secondMinHeight = Math.min(Math.max(exchangeInFromMinHeight, exchangeInToMinHeight), Math.min(exchangeInFromMaxHeight, exchangeInToMaxHeight));
        double secondMaxHeight = Math.min(exchangeInFromMaxHeight, exchangeInToMaxHeight);
        double exchangeOutFromMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, thirdMidpointX, thirdMidpointY, startGroundHeight);
        double exchangeOutToMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, thirdMidpointX, thirdMidpointY, endGroundHeight);
        double exchangeOutFromMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight + extraToeOffHeight, this.hipWidth.getDoubleValue(), startAnkleX, startAnkleY, thirdMidpointX, thirdMidpointY, startGroundHeight);
        double exchangeOutToMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, thirdMidpointX, thirdMidpointY, endGroundHeight);
        double thirdMinHeight = Math.min(Math.max(exchangeOutFromMinHeight, exchangeOutToMinHeight), Math.min(exchangeOutFromMaxHeight, exchangeOutToMaxHeight));
        double thirdMaxHeight = Math.min(exchangeOutFromMaxHeight, exchangeOutToMaxHeight);
        double fourthMinHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(minimumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, fourthMidpointX, fourthMidpointY, endGroundHeight);
        double fourthMaxHeight = LookAheadCoMHeightTrajectoryGenerator.findWaypointHeight(maximumHeight, this.hipWidth.getDoubleValue(), endAnkleX, endAnkleY, fourthMidpointX, fourthMidpointY, endGroundHeight);
        double endMinHeight = minimumHeight + endGroundHeight;
        double endMaxHeight = maximumHeight + endGroundHeight;
        fourthMinHeight = Math.min(fourthMinHeight, endMinHeight);
        fourthMaxHeight = Math.min(fourthMaxHeight, endMaxHeight);
        startWaypoint.setMinMax(startMinHeight, startMaxHeight);
        firstMidpoint.setMinMax(firstMinHeight, firstMaxHeight);
        secondMidpoint.setMinMax(secondMinHeight, secondMaxHeight);
        thirdMidpoint.setMinMax(thirdMinHeight, thirdMaxHeight);
        fourthMidpoint.setMinMax(fourthMinHeight, fourthMaxHeight);
        endWaypoint.setMinMax(endMinHeight, endMaxHeight);
        startWaypoint.setHeight(startCoMPosition.getZ() - this.heightOffsetHandler.getOffsetHeightAboveGround());
        endWaypoint.setHeight(MathTools.clamp((double)endCoMPosition.getZ(), (double)endMinHeight, (double)endMaxHeight));
    }

    private CoMHeightTrajectoryWaypoint getWaypointInFrame(ReferenceFrame referenceFrame) {
        CoMHeightTrajectoryWaypoint waypoint = (CoMHeightTrajectoryWaypoint)this.heightWaypoints.add();
        waypoint.setToZero(referenceFrame);
        return waypoint;
    }

    private static double findWaypointHeight(double desiredDistance, double hipWidth, double ankleX, double ankleY, double queryX, double queryY, double extraHeight) {
        double widthDisplacement = queryY - ankleY - Math.signum(queryY - ankleY) * 0.5 * hipWidth;
        double heightSquared = MathTools.square((double)desiredDistance) - MathTools.square((double)(queryX - ankleX)) - MathTools.square((double)widthDisplacement);
        return Math.sqrt(heightSquared) + extraHeight;
    }

    public void solve(CoMHeightPartialDerivativesDataBasics comHeightPartialDerivativesDataToPack, boolean isInDoubleSupport) {
        this.com.setToZero(this.centerOfMassFrame);
        this.com.changeFrame(worldFrame);
        this.solve(comHeightPartialDerivativesDataToPack, (FramePoint3DBasics)this.com, isInDoubleSupport);
        this.desiredCoMPosition.set(this.com.getX(), this.com.getY(), comHeightPartialDerivativesDataToPack.getComHeight());
    }

    void solve(CoMHeightPartialDerivativesDataBasics comHeightPartialDerivativesDataToPack, FramePoint3DBasics queryPoint, boolean isInDoubleSupport) {
        this.queryPosition.set((FrameTuple3DReadOnly)queryPoint);
        this.percentageThroughSegment.set(this.splinedHeightTrajectory.solve(comHeightPartialDerivativesDataToPack, queryPoint, (Point2DBasics)this.point));
        this.heightOffsetHandler.update(this.splinedHeightTrajectory.getHeightSplineSetpoint());
        this.handleInitializeToCurrent(this.point.getY() + this.heightOffsetHandler.getOffsetHeightAboveGround());
        this.point.addY(this.heightOffsetHandler.getOffsetHeightAboveGround());
        comHeightPartialDerivativesDataToPack.setCoMHeight(worldFrame, comHeightPartialDerivativesDataToPack.getComHeight() + this.heightOffsetHandler.getOffsetHeightAboveGround());
        this.splineQuery.set(this.point.getX());
        this.desiredCoMHeight.set(this.point.getY());
    }

    private void handleInitializeToCurrent(double normalDesiredHeight) {
        if (!this.initializeToCurrent.getBooleanValue()) {
            return;
        }
        this.initializeToCurrent.set(false);
        this.tempFramePoint.setToZero(this.frameOfHeight);
        this.tempFramePoint.changeFrame(this.frameOfSupportLeg);
        double heightOffset = this.tempFramePoint.getZ() - normalDesiredHeight + this.heightOffsetHandler.getOffsetHeightAboveGround();
        this.heightOffsetHandler.initializeToCurrent(heightOffset);
    }

    public boolean handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command) {
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        if (!se3Trajectory.getSelectionMatrix().isLinearZSelected()) {
            return false;
        }
        se3Trajectory.changeFrame(worldFrame);
        this.tempPelvisHeightTrajectoryCommand.set(command);
        this.handlePelvisHeightTrajectoryCommand(this.tempPelvisHeightTrajectoryCommand);
        return true;
    }

    public boolean handlePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command) {
        return this.heightOffsetHandler.handlePelvisHeightTrajectoryCommand(command, this.splinedHeightTrajectory.getHeightSplineSetpoint());
    }

    public void goHome(double trajectoryTime) {
        if (!this.processGoHome.getValue()) {
            return;
        }
        this.heightOffsetHandler.goHome(trajectoryTime);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        this.heightOffsetHandler.handleStopAllTrajectoryCommand(command);
    }

    public void initializeDesiredHeightToCurrent() {
        this.initializeToCurrent.set(true);
    }

    public void getCurrentDesiredHeight(FramePoint3D positionToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.desiredCoMPosition);
    }

    public double getOffsetHeightTimeInTrajectory() {
        return this.yoTime.getValue() - this.heightOffsetHandler.getOffsetHeightAboveGroundChangedTime();
    }
}

