/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.heightPlanning;

import us.ihmc.commons.lists.RecyclingArrayDeque;
import us.ihmc.communication.packets.ExecutionMode;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.EuclideanTrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.SE3TrajectoryControllerCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.StopAllTrajectoryCommand;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class HeightOffsetHandler {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final YoBoolean isTrajectoryOffsetStopped = new YoBoolean("isPelvisOffsetHeightTrajectoryStopped", this.registry);
    private final YoDouble offsetHeightAboveGround = new YoDouble("offsetHeightAboveGround", this.registry);
    private final YoDouble offsetHeightAboveGroundPrevValue = new YoDouble("offsetHeightAboveGroundPrevValue", this.registry);
    private final YoDouble offsetHeightAboveGroundChangedTime = new YoDouble("offsetHeightAboveGroundChangedTime", this.registry);
    private final YoDouble offsetHeightAboveGroundTrajectoryOutput = new YoDouble("offsetHeightAboveGroundTrajectoryOutput", this.registry);
    private final YoDouble offsetHeightAboveGroundTrajectoryTimeProvider = new YoDouble("offsetHeightAboveGroundTrajectoryTimeProvider", this.registry);
    private final MultipleWaypointsTrajectoryGenerator offsetHeightTrajectoryGenerator = new MultipleWaypointsTrajectoryGenerator("pelvisHeightOffset", this.registry);
    private final YoLong lastCommandId;
    private final YoBoolean isReadyToHandleQueuedCommands;
    private final YoLong numberOfQueuedCommands;
    private final RecyclingArrayDeque<PelvisHeightTrajectoryCommand> commandQueue = new RecyclingArrayDeque(PelvisHeightTrajectoryCommand.class, PelvisHeightTrajectoryCommand::set);
    private final FramePoint3D tempPoint = new FramePoint3D();
    private ReferenceFrame internalReferenceFrame;
    private final DoubleProvider yoTime;
    private final PelvisHeightTrajectoryCommand tempPelvisHeightTrajectoryCommand = new PelvisHeightTrajectoryCommand();

    public HeightOffsetHandler(final DoubleProvider yoTime, double defaultOffsetHeightAboveGround, YoRegistry parentRegistry) {
        this.yoTime = yoTime;
        this.offsetHeightAboveGroundChangedTime.set(yoTime.getValue());
        this.offsetHeightAboveGroundTrajectoryTimeProvider.set(0.5);
        this.offsetHeightAboveGround.set(defaultOffsetHeightAboveGround);
        this.offsetHeightAboveGroundPrevValue.set(defaultOffsetHeightAboveGround);
        this.offsetHeightAboveGround.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                HeightOffsetHandler.this.offsetHeightAboveGroundChangedTime.set(yoTime.getValue());
                double previous = HeightOffsetHandler.this.offsetHeightTrajectoryGenerator.getValue();
                HeightOffsetHandler.this.offsetHeightTrajectoryGenerator.clear();
                HeightOffsetHandler.this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, previous, 0.0);
                HeightOffsetHandler.this.offsetHeightTrajectoryGenerator.appendWaypoint(HeightOffsetHandler.this.offsetHeightAboveGroundTrajectoryTimeProvider.getValue(), HeightOffsetHandler.this.offsetHeightAboveGround.getDoubleValue(), 0.0);
                HeightOffsetHandler.this.offsetHeightTrajectoryGenerator.initialize();
            }
        });
        String namePrefix = "pelvisHeight";
        this.lastCommandId = new YoLong(namePrefix + "LastCommandId", this.registry);
        this.lastCommandId.set(0L);
        this.isReadyToHandleQueuedCommands = new YoBoolean(namePrefix + "IsReadyToHandleQueuedPelvisHeightTrajectoryCommands", this.registry);
        this.numberOfQueuedCommands = new YoLong(namePrefix + "NumberOfQueuedCommands", this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setReferenceFrame(ReferenceFrame internalReferenceFrame) {
        this.internalReferenceFrame = internalReferenceFrame;
    }

    public void reset() {
        this.lastCommandId.set(0L);
        this.isReadyToHandleQueuedCommands.set(false);
        this.numberOfQueuedCommands.set(0L);
        this.offsetHeightAboveGround.set(0.0, false);
        this.offsetHeightAboveGroundChangedTime.set(this.yoTime.getValue());
        this.offsetHeightTrajectoryGenerator.clear();
        this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, 0.0, 0.0);
        this.offsetHeightTrajectoryGenerator.initialize();
    }

    public void update(double currentDesiredHeight) {
        if (!this.isTrajectoryOffsetStopped.getBooleanValue()) {
            double deltaTime = this.yoTime.getValue() - this.offsetHeightAboveGroundChangedTime.getDoubleValue();
            if (!this.offsetHeightTrajectoryGenerator.isEmpty()) {
                this.offsetHeightTrajectoryGenerator.compute(deltaTime);
            }
            if (this.offsetHeightTrajectoryGenerator.isDone() && !this.commandQueue.isEmpty()) {
                double firstTrajectoryPointTime = this.offsetHeightTrajectoryGenerator.getLastWaypointTime();
                PelvisHeightTrajectoryCommand command = (PelvisHeightTrajectoryCommand)this.commandQueue.poll();
                this.numberOfQueuedCommands.decrement();
                this.initializeOffsetTrajectoryGenerator(command, firstTrajectoryPointTime, currentDesiredHeight);
                this.offsetHeightTrajectoryGenerator.compute(deltaTime);
            }
            this.offsetHeightAboveGround.set(this.offsetHeightTrajectoryGenerator.getValue(), false);
        }
        this.offsetHeightAboveGroundTrajectoryOutput.set(this.offsetHeightTrajectoryGenerator.getValue());
        this.offsetHeightAboveGroundPrevValue.set(this.offsetHeightTrajectoryGenerator.getValue());
    }

    public void initializeToCurrent(double currentHeightOffset) {
        this.offsetHeightAboveGround.set(currentHeightOffset);
        this.offsetHeightAboveGroundChangedTime.set(this.yoTime.getValue());
        this.offsetHeightTrajectoryGenerator.clear();
        this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, currentHeightOffset, 0.0);
        this.offsetHeightTrajectoryGenerator.initialize();
        this.isTrajectoryOffsetStopped.set(false);
    }

    public double getOffsetHeightAboveGround() {
        return this.offsetHeightAboveGround.getDoubleValue();
    }

    public double getOffsetHeightAboveGroundTrajectoryOutput() {
        return this.offsetHeightAboveGroundTrajectoryOutput.getValue();
    }

    public boolean handlePelvisTrajectoryCommand(PelvisTrajectoryCommand command, double currentDesiredHeight) {
        SE3TrajectoryControllerCommand se3Trajectory = command.getSE3Trajectory();
        if (!se3Trajectory.getSelectionMatrix().isLinearZSelected()) {
            return false;
        }
        se3Trajectory.changeFrame(worldFrame);
        this.tempPelvisHeightTrajectoryCommand.set(command);
        this.handlePelvisHeightTrajectoryCommand(this.tempPelvisHeightTrajectoryCommand, currentDesiredHeight);
        return true;
    }

    public boolean handlePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command, double currentDesiredHeight) {
        EuclideanTrajectoryControllerCommand euclideanTrajectory = command.getEuclideanTrajectory();
        if (euclideanTrajectory.getExecutionMode() == ExecutionMode.OVERRIDE) {
            this.isReadyToHandleQueuedCommands.set(true);
            this.clearCommandQueue(euclideanTrajectory.getCommandId());
            this.offsetHeightAboveGroundChangedTime.set(this.yoTime.getValue());
            this.initializeOffsetTrajectoryGenerator(command, 0.0, currentDesiredHeight);
            return true;
        }
        if (euclideanTrajectory.getExecutionMode() == ExecutionMode.QUEUE) {
            boolean success = this.queuePelvisHeightTrajectoryCommand(command);
            if (!success) {
                this.isReadyToHandleQueuedCommands.set(false);
                this.clearCommandQueue(0L);
                this.offsetHeightTrajectoryGenerator.clear();
                this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, this.offsetHeightAboveGroundPrevValue.getDoubleValue(), 0.0);
                this.offsetHeightTrajectoryGenerator.initialize();
            }
            return success;
        }
        if (euclideanTrajectory.getExecutionMode() == ExecutionMode.STREAM) {
            this.isReadyToHandleQueuedCommands.set(true);
            this.clearCommandQueue(euclideanTrajectory.getCommandId());
            this.offsetHeightAboveGroundChangedTime.set(this.yoTime.getValue());
            if (euclideanTrajectory.getNumberOfTrajectoryPoints() != 1) {
                LogTools.warn((String)("When streaming, trajectories should contain only 1 trajectory point, was: " + euclideanTrajectory.getNumberOfTrajectoryPoints()));
                return false;
            }
            FrameEuclideanTrajectoryPoint trajectoryPoint = euclideanTrajectory.getTrajectoryPoint(0);
            if (trajectoryPoint.getTime() != 0.0) {
                LogTools.warn((String)("When streaming, the trajectory point should have a time of zero, was: " + trajectoryPoint.getTime()));
                return false;
            }
            this.offsetHeightTrajectoryGenerator.clear();
            double time = trajectoryPoint.getTime();
            double z = this.fromAbsoluteToOffset(trajectoryPoint.getPositionZ(), currentDesiredHeight);
            double zDot = trajectoryPoint.getLinearVelocityZ();
            this.offsetHeightTrajectoryGenerator.appendWaypoint(time, z, zDot);
            time = euclideanTrajectory.getStreamIntegrationDuration();
            this.offsetHeightTrajectoryGenerator.appendWaypoint(time, z += time * zDot, zDot);
            this.offsetHeightTrajectoryGenerator.initialize();
            this.isTrajectoryOffsetStopped.set(false);
            return true;
        }
        LogTools.warn((String)"Unknown {} value: {}. Command ignored.", (Object)ExecutionMode.class.getSimpleName(), (Object)euclideanTrajectory.getExecutionMode());
        return false;
    }

    private boolean queuePelvisHeightTrajectoryCommand(PelvisHeightTrajectoryCommand command) {
        if (!this.isReadyToHandleQueuedCommands.getBooleanValue()) {
            LogTools.warn((String)"The very first {} of a series must be {}. Aborting motion.", (Object)command.getClass().getSimpleName(), (Object)ExecutionMode.OVERRIDE);
            return false;
        }
        long previousCommandId = command.getEuclideanTrajectory().getPreviousCommandId();
        if (previousCommandId != 0L && this.lastCommandId.getLongValue() != 0L && this.lastCommandId.getLongValue() != previousCommandId) {
            LogTools.warn((String)"Previous command ID mismatch: previous ID from command = {}, last message ID received by the controller = {}. Aborting motion.", (Object)previousCommandId, (Object)this.lastCommandId.getLongValue());
            return false;
        }
        if (command.getEuclideanTrajectory().getTrajectoryPoint(0).getTime() < 1.0E-5) {
            LogTools.warn((String)"Time of the first trajectory point of a queued command must be greater than zero. Aborting motion.");
            return false;
        }
        this.commandQueue.add((Object)command);
        this.numberOfQueuedCommands.increment();
        this.lastCommandId.set(command.getEuclideanTrajectory().getCommandId());
        return true;
    }

    private void initializeOffsetTrajectoryGenerator(PelvisHeightTrajectoryCommand command, double firstTrajectoryPointTime, double currentDesiredHeight) {
        command.getEuclideanTrajectory().addTimeOffset(firstTrajectoryPointTime);
        this.offsetHeightTrajectoryGenerator.clear();
        if (command.getEuclideanTrajectory().getTrajectoryPoint(0).getTime() > firstTrajectoryPointTime + 1.0E-5) {
            this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, this.offsetHeightAboveGroundPrevValue.getDoubleValue(), 0.0);
        }
        int numberOfTrajectoryPoints = this.queueExceedingTrajectoryPointsIfNeeded(command);
        for (int trajectoryPointIndex = 0; trajectoryPointIndex < numberOfTrajectoryPoints; ++trajectoryPointIndex) {
            this.appendTrajectoryPoint(command.getEuclideanTrajectory().getTrajectoryPoint(trajectoryPointIndex), currentDesiredHeight);
        }
        this.offsetHeightTrajectoryGenerator.initialize();
        this.isTrajectoryOffsetStopped.set(false);
    }

    private void appendTrajectoryPoint(FrameEuclideanTrajectoryPoint trajectoryPoint, double currentDesiredHeight) {
        double time = trajectoryPoint.getTime();
        this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)trajectoryPoint.getPosition());
        this.tempPoint.changeFrame(worldFrame);
        double z = this.fromAbsoluteToOffset(this.tempPoint.getZ(), currentDesiredHeight);
        double zDot = trajectoryPoint.getLinearVelocityZ();
        this.offsetHeightTrajectoryGenerator.appendWaypoint(time, z, zDot);
    }

    private double fromAbsoluteToOffset(double zInWorld, double currentDesiredHeight) {
        this.tempPoint.setIncludingFrame(worldFrame, 0.0, 0.0, zInWorld);
        this.tempPoint.changeFrame(this.internalReferenceFrame);
        double zOffset = this.tempPoint.getZ() - currentDesiredHeight;
        return zOffset;
    }

    private int queueExceedingTrajectoryPointsIfNeeded(PelvisHeightTrajectoryCommand command) {
        int maximumNumberOfWaypoints;
        int numberOfTrajectoryPoints = command.getEuclideanTrajectory().getNumberOfTrajectoryPoints();
        if (numberOfTrajectoryPoints <= (maximumNumberOfWaypoints = this.offsetHeightTrajectoryGenerator.getMaximumNumberOfWaypoints() - this.offsetHeightTrajectoryGenerator.getCurrentNumberOfWaypoints())) {
            return numberOfTrajectoryPoints;
        }
        PelvisHeightTrajectoryCommand commandForExcedent = (PelvisHeightTrajectoryCommand)this.commandQueue.addFirst();
        this.numberOfQueuedCommands.increment();
        commandForExcedent.clear();
        commandForExcedent.getEuclideanTrajectory().setPropertiesOnly(command.getEuclideanTrajectory());
        for (int trajectoryPointIndex = maximumNumberOfWaypoints; trajectoryPointIndex < numberOfTrajectoryPoints; ++trajectoryPointIndex) {
            commandForExcedent.getEuclideanTrajectory().addTrajectoryPoint(command.getEuclideanTrajectory().getTrajectoryPoint(trajectoryPointIndex));
        }
        double timeOffsetToSubtract = command.getEuclideanTrajectory().getTrajectoryPoint(maximumNumberOfWaypoints - 1).getTime();
        commandForExcedent.getEuclideanTrajectory().subtractTimeOffset(timeOffsetToSubtract);
        return maximumNumberOfWaypoints;
    }

    private void clearCommandQueue(long lastCommandId) {
        this.commandQueue.clear();
        this.numberOfQueuedCommands.set(0L);
        this.lastCommandId.set(lastCommandId);
    }

    public void goHome(double trajectoryTime) {
        this.offsetHeightAboveGroundChangedTime.set(this.yoTime.getValue());
        this.offsetHeightTrajectoryGenerator.clear();
        this.offsetHeightTrajectoryGenerator.appendWaypoint(0.0, this.offsetHeightAboveGroundPrevValue.getDoubleValue(), 0.0);
        this.offsetHeightTrajectoryGenerator.appendWaypoint(trajectoryTime, 0.0, 0.0);
        this.offsetHeightTrajectoryGenerator.initialize();
        this.isTrajectoryOffsetStopped.set(false);
    }

    public void handleStopAllTrajectoryCommand(StopAllTrajectoryCommand command) {
        this.isTrajectoryOffsetStopped.set(command.isStopAllTrajectory());
        this.offsetHeightAboveGround.set(this.offsetHeightAboveGroundPrevValue.getDoubleValue());
    }

    public double getOffsetHeightAboveGroundChangedTime() {
        return this.offsetHeightAboveGroundChangedTime.getDoubleValue();
    }
}

