/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.heightPlanning;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CoMHeightTrajectoryWaypoint {
    private final FramePoint3D waypoint = new FramePoint3D();
    private final FramePoint3D minWaypoint = new FramePoint3D();
    private final FramePoint3D maxWaypoint = new FramePoint3D();
    private final YoFramePoint3D yoWaypoint;
    private final YoFramePoint3D yoMinWaypoint;
    private final YoFramePoint3D yoMaxWaypoint;

    public CoMHeightTrajectoryWaypoint(String name, YoRegistry registry) {
        this.yoWaypoint = new YoFramePoint3D(name + "InWorld", ReferenceFrame.getWorldFrame(), registry);
        this.yoMinWaypoint = new YoFramePoint3D(name + "MinInWorld", ReferenceFrame.getWorldFrame(), registry);
        this.yoMaxWaypoint = new YoFramePoint3D(name + "MaxInWorld", ReferenceFrame.getWorldFrame(), registry);
    }

    public void setToZero(ReferenceFrame referenceFrame) {
        this.waypoint.setToZero(referenceFrame);
        this.minWaypoint.setToZero(referenceFrame);
        this.maxWaypoint.setToZero(referenceFrame);
    }

    public void setX(double x) {
        this.waypoint.setX(x);
        this.minWaypoint.setX(x);
        this.maxWaypoint.setX(x);
    }

    public void setY(double y) {
        this.waypoint.setY(y);
        this.minWaypoint.setY(y);
        this.maxWaypoint.setY(y);
    }

    public void setXY(double x, double y) {
        this.setX(x);
        this.setY(y);
    }

    public void setHeight(double height) {
        this.waypoint.setZ(height);
    }

    public void addHeightOffset(double offset) {
        double desiredHeight = MathTools.clamp((double)(this.waypoint.getZ() + offset), (double)this.minWaypoint.getZ(), (double)this.maxWaypoint.getZ());
        this.waypoint.setZ(desiredHeight);
    }

    public void setMinMax(double zMin, double zMax) {
        this.minWaypoint.setZ(zMin);
        this.maxWaypoint.setZ(zMax);
    }

    public double getX() {
        return this.waypoint.getX();
    }

    public double getHeight() {
        return this.waypoint.getZ();
    }

    public double getMinHeight() {
        return this.minWaypoint.getZ();
    }

    public double getMaxHeight() {
        return this.maxWaypoint.getZ();
    }

    public FramePoint3DReadOnly getWaypoint() {
        return this.waypoint;
    }

    public FramePoint3DReadOnly getMinWaypoint() {
        return this.minWaypoint;
    }

    public FramePoint3DReadOnly getMaxWaypoint() {
        return this.maxWaypoint;
    }

    public void update() {
        this.yoWaypoint.setMatchingFrame((FrameTuple3DReadOnly)this.waypoint);
        this.yoMinWaypoint.setMatchingFrame((FrameTuple3DReadOnly)this.minWaypoint);
        this.yoMaxWaypoint.setMatchingFrame((FrameTuple3DReadOnly)this.maxWaypoint);
    }

    public void setupViz(String graphicListName, String name, AppearanceDefinition color, YoGraphicsListRegistry yoGraphicsListRegistry) {
        double pointSize = 0.03;
        YoGraphicPosition pointD0Viz = new YoGraphicPosition(name, this.yoWaypoint, pointSize, color);
        YoGraphicPosition pointD0MinViz = new YoGraphicPosition(name + "Min", this.yoMinWaypoint, 0.8 * pointSize, color);
        YoGraphicPosition pointD0MaxViz = new YoGraphicPosition(name + "Max", this.yoMaxWaypoint, 0.9 * pointSize, color);
        yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)pointD0Viz);
        yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)pointD0MinViz);
        yoGraphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)pointD0MaxViz);
    }
}

