/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.heightPlanning;

import Jama.Matrix;
import us.ihmc.commonWalkingControlModules.heightPlanning.YoCoMHeightTimeDerivativesData;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.PDGains;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.linearDynamicSystems.EigenvalueDecomposer;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CoMHeightTimeDerivativesSmoother {
    private static final boolean DEBUG = false;
    private final double dt;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final FramePoint3D centerOfMassHeightPoint = new FramePoint3D(ReferenceFrame.getWorldFrame());
    private final YoBoolean hasBeenInitialized = new YoBoolean("hasBeenInitialized", this.registry);
    private final YoDouble comHeightError = new YoDouble("smoothComHeightError", this.registry);
    private final YoDouble comHeightVelocityError = new YoDouble("smoothComHeightVelocityError", this.registry);
    private final YoDouble comHeightAccelerationError = new YoDouble("smoothComHeightAccelerationError", this.registry);
    private final YoDouble comHeightFeedback = new YoDouble("smoothComHeightFeedback", this.registry);
    private final YoDouble comHeightVelocityFeedback = new YoDouble("smoothComHeightVelocityFeedback", this.registry);
    private final YoDouble comHeightAccelerationFeedback = new YoDouble("smoothComHeightAccelerationFeedback", this.registry);
    private final YoDouble inputComHeight = new YoDouble("inputComHeight", this.registry);
    private final YoDouble inputComHeightVelocity = new YoDouble("inputComHeightVelocity", this.registry);
    private final YoDouble inputComHeightAcceleration = new YoDouble("inputComHeightAcceleration", this.registry);
    private final YoDouble inputComHeightJerk = new YoDouble("inputComHeightJerk", this.registry);
    private final YoDouble smoothComHeight = new YoDouble("smoothComHeight", this.registry);
    private final YoDouble smoothComHeightVelocity = new YoDouble("smoothComHeightVelocity", this.registry);
    private final YoDouble smoothComHeightAcceleration = new YoDouble("smoothComHeightAcceleration", this.registry);
    private final YoDouble smoothComHeightJerk = new YoDouble("smoothComHeightJerk", this.registry);
    private final YoDouble comHeightGain = new YoDouble("comHeightGain", this.registry);
    private final YoDouble comHeightVelocityGain = new YoDouble("comHeightVelocityGain", this.registry);
    private final YoDouble comHeightAccelerationGain = new YoDouble("comHeightAccelerationGain", this.registry);
    private final YoDouble eigenValueOneReal = new YoDouble("eigenValueOneReal", this.registry);
    private final YoDouble eigenValueOneImag = new YoDouble("eigenValueOneImag", this.registry);
    private final YoDouble eigenValueTwoReal = new YoDouble("eigenValueTwoReal", this.registry);
    private final YoDouble eigenValueTwoImag = new YoDouble("eigenValueTwoImag", this.registry);
    private final YoDouble eigenValueThreeReal = new YoDouble("eigenValueThreeReal", this.registry);
    private final YoDouble eigenValueThreeImag = new YoDouble("eigenValueThreeImag", this.registry);
    private PDGainsReadOnly gains;
    private DoubleProvider maximumVelocity;

    public CoMHeightTimeDerivativesSmoother(double dt, YoRegistry parentRegistry) {
        this.dt = dt;
        double w0 = 20.0;
        double w1 = 12.0;
        double zeta1 = 0.9;
        this.computeGainsByPolePlacement(w0, w1, zeta1);
        parentRegistry.addChild(this.registry);
        this.computeEigenvalues();
        this.hasBeenInitialized.set(false);
        this.createDefaultGains();
    }

    public void computeGainsByPolePlacement(double w0, double w1, double zeta1) {
        this.comHeightGain.set(w0 * w1 * w1);
        this.comHeightVelocityGain.set(w1 * w1 + 2.0 * zeta1 * w1 * w0);
        this.comHeightAccelerationGain.set(w0 + 2.0 * zeta1 * w1);
    }

    public void computeEigenvalues() {
        double[][] matrixAValues = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-this.comHeightGain.getDoubleValue(), -this.comHeightVelocityGain.getDoubleValue(), -this.comHeightAccelerationGain.getDoubleValue()}};
        Matrix matrixA = new Matrix((double[][])matrixAValues);
        EigenvalueDecomposer eigenvalueDecomposer = new EigenvalueDecomposer(matrixA);
        ComplexNumber[] eigenvalues = eigenvalueDecomposer.getEigenvalues();
        this.eigenValueOneReal.set(eigenvalues[0].real());
        this.eigenValueOneImag.set(eigenvalues[0].imag());
        this.eigenValueTwoReal.set(eigenvalues[1].real());
        this.eigenValueTwoImag.set(eigenvalues[1].imag());
        this.eigenValueThreeReal.set(eigenvalues[2].real());
        this.eigenValueThreeImag.set(eigenvalues[2].imag());
    }

    public void smooth(YoCoMHeightTimeDerivativesData heightZDataOutputToPack, YoCoMHeightTimeDerivativesData heightZDataInput) {
        if (!this.hasBeenInitialized.getBooleanValue()) {
            this.initialize(heightZDataInput);
        }
        heightZDataInput.getComHeight((FramePoint3DBasics)this.centerOfMassHeightPoint);
        double heightIn = this.centerOfMassHeightPoint.getZ();
        double heightVelocityIn = heightZDataInput.getComHeightVelocity();
        double heightAccelerationIn = heightZDataInput.getComHeightAcceleration();
        double heightJerkIn = heightZDataInput.getComHeightJerk();
        this.inputComHeight.set(heightIn);
        this.inputComHeightVelocity.set(heightVelocityIn);
        this.inputComHeightAcceleration.set(heightAccelerationIn);
        this.inputComHeightJerk.set(heightJerkIn);
        this.comHeightError.set(heightIn - this.smoothComHeight.getDoubleValue());
        this.comHeightVelocityError.set(heightVelocityIn - this.smoothComHeightVelocity.getDoubleValue());
        this.comHeightAccelerationError.set(heightAccelerationIn - this.smoothComHeightAcceleration.getDoubleValue());
        this.comHeightFeedback.set(this.comHeightGain.getDoubleValue() * this.comHeightError.getDoubleValue());
        this.comHeightVelocityFeedback.set(this.comHeightVelocityGain.getDoubleValue() * this.comHeightVelocityError.getDoubleValue());
        this.comHeightAccelerationFeedback.set(this.comHeightAccelerationGain.getDoubleValue() * this.comHeightAccelerationError.getDoubleValue());
        this.smoothComHeightJerk.set(this.inputComHeightJerk.getDoubleValue());
        this.smoothComHeightJerk.add(this.comHeightFeedback.getDoubleValue());
        this.smoothComHeightJerk.add(this.comHeightVelocityFeedback.getDoubleValue());
        this.smoothComHeightJerk.add(this.comHeightAccelerationFeedback.getDoubleValue());
        this.smoothComHeightJerk.set(MathTools.clamp((double)this.smoothComHeightJerk.getDoubleValue(), (double)this.gains.getMaximumFeedbackRate()));
        double previousAcceleration = this.smoothComHeightAcceleration.getDoubleValue();
        this.smoothComHeightAcceleration.add(this.smoothComHeightJerk.getDoubleValue() * this.dt);
        this.smoothComHeightAcceleration.set(MathTools.clamp((double)this.smoothComHeightAcceleration.getDoubleValue(), (double)this.gains.getMaximumFeedback()));
        this.smoothComHeightJerk.set((this.smoothComHeightAcceleration.getDoubleValue() - previousAcceleration) / this.dt);
        double previousVelocity = this.smoothComHeightVelocity.getDoubleValue();
        this.smoothComHeightVelocity.add(this.smoothComHeightAcceleration.getDoubleValue() * this.dt);
        this.smoothComHeightVelocity.set(MathTools.clamp((double)this.smoothComHeightVelocity.getDoubleValue(), (double)this.maximumVelocity.getValue()));
        this.smoothComHeightAcceleration.set((this.smoothComHeightVelocity.getDoubleValue() - previousVelocity) / this.dt);
        this.smoothComHeight.add(this.smoothComHeightVelocity.getDoubleValue() * this.dt);
        heightZDataOutputToPack.setComHeight(this.centerOfMassHeightPoint.getReferenceFrame(), this.smoothComHeight.getDoubleValue());
        heightZDataOutputToPack.setComHeightVelocity(this.smoothComHeightVelocity.getDoubleValue());
        heightZDataOutputToPack.setComHeightAcceleration(this.smoothComHeightAcceleration.getDoubleValue());
        heightZDataOutputToPack.setComHeightJerk(this.smoothComHeightJerk.getDoubleValue());
    }

    public void initialize(YoCoMHeightTimeDerivativesData comHeightDataIn) {
        comHeightDataIn.getComHeight((FramePoint3DBasics)this.centerOfMassHeightPoint);
        this.smoothComHeight.set(this.centerOfMassHeightPoint.getZ());
        this.smoothComHeightVelocity.set(comHeightDataIn.getComHeightVelocity());
        this.smoothComHeightAcceleration.set(comHeightDataIn.getComHeightAcceleration());
        this.hasBeenInitialized.set(true);
    }

    public void reset() {
        this.hasBeenInitialized.set(false);
    }

    public void setGains(PDGainsReadOnly gains, DoubleProvider maximumVelocity) {
        this.gains = gains;
        this.maximumVelocity = maximumVelocity;
    }

    public void createDefaultGains() {
        PDGains gains = new PDGains();
        gains.setMaximumFeedback(4.905);
        gains.setMaximumFeedbackRate(98.1);
        DoubleProvider maxVelocity = () -> 0.25;
        this.setGains((PDGainsReadOnly)gains, maxVelocity);
    }
}

