/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.falling;

import us.ihmc.commonWalkingControlModules.configurations.HighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelControlManagerFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.HighLevelControllerState;
import us.ihmc.commonWalkingControlModules.momentumBasedController.HighLevelHumanoidControllerToolbox;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;

public class FallingControllerState
extends HighLevelControllerState {
    private static final HighLevelControllerName controllerState = HighLevelControllerName.FALLING_STATE;
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder;

    public FallingControllerState(CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, HighLevelControlManagerFactory managerFactory, HighLevelHumanoidControllerToolbox controllerToolbox, HighLevelControllerParameters highLevelControllerParameters, WalkingControllerParameters walkingControllerParameters) {
        super(controllerState, highLevelControllerParameters, controllerToolbox.getControlledOneDoFJoints());
        this.lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder(this.controlledJoints.length);
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])this.controlledJoints);
    }

    public void doAction(double timeInState) {
        LogTools.info((String)"Falling! Do something!");
        for (int i = 0; i < this.controlledJoints.length; ++i) {
            this.controlledJoints[i].setTau(0.0);
            this.lowLevelOneDoFJointDesiredDataHolder.getJointDesiredOutput((OneDoFJointReadOnly)this.controlledJoints[i]).clear();
            this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointTorque((OneDoFJointReadOnly)this.controlledJoints[i], 0.0);
            this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointPosition((OneDoFJointReadOnly)this.controlledJoints[i], this.controlledJoints[i].getQ());
            this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointVelocity((OneDoFJointReadOnly)this.controlledJoints[i], this.controlledJoints[i].getQd());
        }
        this.lowLevelOneDoFJointDesiredDataHolder.completeWith((JointDesiredOutputListReadOnly)this.getStateSpecificJointSettings());
    }

    public void onEntry() {
    }

    public void onExit() {
    }

    @Override
    public JointDesiredOutputListReadOnly getOutputForLowLevelController() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }
}

