/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.trajectoryOptimization.LQCostFunction;

public class SLIPRegularizationCost
implements LQCostFunction<SLIPState> {
    static double qX = 0.0;
    static double qY = 0.0;
    static double qZ = 0.0;
    static double qThetaX = 0.0;
    static double qThetaY = 0.0;
    static double qThetaZ = 0.0;
    static double qXDot = 1.0E-6;
    static double qYDot = 1.0E-6;
    static double qZDot = 1.0E-6;
    static double qThetaDotX = 1.0E-5;
    static double qThetaDotY = 1.0E-5;
    static double qThetaDotZ = 1.0E-5;
    static double rFx = 1.0E-7;
    static double rFy = 1.0E-7;
    static double rFz = 1.0E-8;
    static double rTauX = 1.0;
    static double rTauY = 1.0;
    static double rTauZ = 1.0;
    static double rXf = 0.0;
    static double rYf = 0.0;
    static double rK = 1.0E-12;
    private final DMatrixRMaj Q = new DMatrixRMaj(12, 12);
    private final DMatrixRMaj R = new DMatrixRMaj(9, 9);
    private DMatrixRMaj tempWX = new DMatrixRMaj(12, 1);
    private DMatrixRMaj tempWU = new DMatrixRMaj(9, 1);

    public SLIPRegularizationCost() {
        this.Q.set(0, 0, qX);
        this.Q.set(1, 1, qY);
        this.Q.set(2, 2, qZ);
        this.Q.set(3, 3, qThetaX);
        this.Q.set(4, 4, qThetaY);
        this.Q.set(5, 5, qThetaZ);
        this.Q.set(6, 6, qXDot);
        this.Q.set(7, 7, qYDot);
        this.Q.set(8, 8, qZDot);
        this.Q.set(9, 9, qThetaDotX);
        this.Q.set(10, 10, qThetaDotY);
        this.Q.set(11, 11, qThetaDotZ);
        this.R.set(0, 0, rFx);
        this.R.set(1, 1, rFy);
        this.R.set(2, 2, rFz);
        this.R.set(3, 3, rTauX);
        this.R.set(4, 4, rTauY);
        this.R.set(5, 5, rTauZ);
        this.R.set(6, 6, rXf);
        this.R.set(7, 7, rYf);
        this.R.set(8, 8, rK);
    }

    public double getCost(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants) {
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)stateVector, (DMatrix1Row)this.tempWX);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)controlVector, (DMatrix1Row)this.tempWU);
        return CommonOps_DDRM.dot((DMatrixD1)controlVector, (DMatrixD1)this.tempWU) + CommonOps_DDRM.dot((DMatrixD1)stateVector, (DMatrixD1)this.tempWX);
    }

    public void getCostStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)stateVector, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)controlVector, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostStateHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.Q, (DMatrixD1)matrixToPack);
    }

    public void getCostControlHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.R, (DMatrixD1)matrixToPack);
    }

    public void getCostStateGradientOfControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(9, 12);
        matrixToPack.zero();
    }

    public void getCostControlGradientOfStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(12, 9);
        matrixToPack.zero();
    }
}

