/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;

public class SLIPDesiredTrackingCost
implements LQTrackingCostFunction<SLIPState> {
    static double qXFlight = 0.001;
    static double qYFlight = 0.001;
    static double qZFlight = 0.1;
    static double qThetaXFlight = 0.1;
    static double qThetaYFlight = 0.1;
    static double qThetaZFlight = 0.1;
    static double qXDotFlight = 0.0;
    static double qYDotFlight = 0.0;
    static double qZDotFlight = 0.0;
    static double qThetaDotXFlight = 100.0;
    static double qThetaDotYFlight = 100.0;
    static double qThetaDotZFlight = 100.0;
    static double rFxFlight = 0.0;
    static double rFyFlight = 0.0;
    static double rFzFlight = 0.0;
    static double rTauXFlight = 0.0;
    static double rTauYFlight = 0.0;
    static double rTauZFlight = 0.0;
    static double rXfFlight = 0.0;
    static double rYfFlight = 0.0;
    static double rKFlight = 0.0;
    static double qXStance = 0.1;
    static double qYStance = 0.1;
    static double qZStance = 0.1;
    static double qThetaXStance = 1.0;
    static double qThetaYStance = 1.0;
    static double qThetaZStance = 1.0;
    static double qXDotStance = 0.0;
    static double qYDotStance = 0.0;
    static double qZDotStance = 0.0;
    static double qThetaDotXStance = 0.0;
    static double qThetaDotYStance = 0.0;
    static double qThetaDotZStance = 0.0;
    static double rFxStance = 0.0;
    static double rFyStance = 0.0;
    static double rFzStance = 100.0;
    static double rTauXStance = 0.0;
    static double rTauYStance = 0.0;
    static double rTauZStance = 0.0;
    static double rXfStance = 5000000.0;
    static double rYfStance = 5000000.0;
    static double rKStance = 100000.0;
    private final DMatrixRMaj QFlight = new DMatrixRMaj(12, 12);
    private final DMatrixRMaj RFlight = new DMatrixRMaj(9, 9);
    private final DMatrixRMaj QStance = new DMatrixRMaj(12, 12);
    private final DMatrixRMaj RStance = new DMatrixRMaj(9, 9);
    private DMatrixRMaj tempStateMatrix = new DMatrixRMaj(12, 1);
    private DMatrixRMaj tempControlMatrix = new DMatrixRMaj(9, 1);
    private DMatrixRMaj tempWX = new DMatrixRMaj(12, 1);
    private DMatrixRMaj tempWU = new DMatrixRMaj(9, 1);

    public SLIPDesiredTrackingCost() {
        this.QStance.set(0, 0, qXStance);
        this.QStance.set(1, 1, qYStance);
        this.QStance.set(2, 2, qZStance);
        this.QStance.set(3, 3, qThetaXStance);
        this.QStance.set(4, 4, qThetaYStance);
        this.QStance.set(5, 5, qThetaZStance);
        this.QStance.set(6, 6, qXDotStance);
        this.QStance.set(7, 7, qYDotStance);
        this.QStance.set(8, 8, qZDotStance);
        this.QStance.set(9, 9, qThetaDotXStance);
        this.QStance.set(10, 10, qThetaDotYStance);
        this.QStance.set(11, 11, qThetaDotZStance);
        this.RStance.set(0, 0, rFxStance);
        this.RStance.set(1, 1, rFyStance);
        this.RStance.set(2, 2, rFzStance);
        this.RStance.set(3, 3, rTauXStance);
        this.RStance.set(4, 4, rTauYStance);
        this.RStance.set(5, 5, rTauZStance);
        this.RStance.set(6, 6, rXfStance);
        this.RStance.set(7, 7, rYfStance);
        this.RStance.set(8, 8, rKStance);
        this.QFlight.set(0, 0, qXFlight);
        this.QFlight.set(1, 1, qYFlight);
        this.QFlight.set(2, 2, qZFlight);
        this.QFlight.set(3, 3, qThetaXFlight);
        this.QFlight.set(4, 4, qThetaYFlight);
        this.QFlight.set(5, 5, qThetaZFlight);
        this.QFlight.set(6, 6, qXDotFlight);
        this.QFlight.set(7, 7, qYDotFlight);
        this.QFlight.set(8, 8, qZDotFlight);
        this.QFlight.set(9, 9, qThetaDotXFlight);
        this.QFlight.set(10, 10, qThetaDotYFlight);
        this.QFlight.set(11, 11, qThetaDotZFlight);
        this.RFlight.set(0, 0, rFxFlight);
        this.RFlight.set(1, 1, rFyFlight);
        this.RFlight.set(2, 2, rFzFlight);
        this.RFlight.set(3, 3, rTauXFlight);
        this.RFlight.set(4, 4, rTauYFlight);
        this.RFlight.set(5, 5, rTauZFlight);
        this.RFlight.set(6, 6, rXfFlight);
        this.RFlight.set(7, 7, rYfFlight);
        this.RFlight.set(8, 8, rKFlight);
    }

    public double getCost(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVector, (DMatrixD1)this.tempControlMatrix);
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        switch (state) {
            case FLIGHT: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.QFlight, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)this.tempWX);
                DiagonalMatrixTools.preMult((DMatrix1Row)this.RFlight, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)this.tempWU);
                break;
            }
            case STANCE: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.QStance, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)this.tempWX);
                DiagonalMatrixTools.preMult((DMatrix1Row)this.RStance, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)this.tempWU);
            }
        }
        return CommonOps_DDRM.dot((DMatrixD1)this.tempControlMatrix, (DMatrixD1)this.tempWU) + CommonOps_DDRM.dot((DMatrixD1)this.tempStateMatrix, (DMatrixD1)this.tempWX);
    }

    public void getCostStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        switch (state) {
            case FLIGHT: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.QFlight, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)matrixToPack);
                break;
            }
            case STANCE: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.QStance, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)matrixToPack);
            }
        }
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVecotr, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVecotr, (DMatrixD1)this.tempControlMatrix);
        switch (state) {
            case FLIGHT: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.RFlight, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)matrixToPack);
                break;
            }
            case STANCE: {
                DiagonalMatrixTools.preMult((DMatrix1Row)this.RStance, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)matrixToPack);
            }
        }
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostStateHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        switch (state) {
            case FLIGHT: {
                CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.QFlight, (DMatrixD1)matrixToPack);
                break;
            }
            case STANCE: {
                CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.QStance, (DMatrixD1)matrixToPack);
            }
        }
    }

    public void getCostControlHessian(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        switch (state) {
            case FLIGHT: {
                CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.RFlight, (DMatrixD1)matrixToPack);
                break;
            }
            case STANCE: {
                CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.RStance, (DMatrixD1)matrixToPack);
            }
        }
    }

    public void getCostStateGradientOfControlGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(9, 12);
    }

    public void getCostControlGradientOfStateGradient(SLIPState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(12, 9);
    }
}

