/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.ContinuousSimpleReactionDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;

public class SimpleReactionDynamics
implements DiscreteHybridDynamics<SLIPState> {
    private double deltaT;
    private double deltaT2;
    private final double pendulumMass;
    private static final Vector3D boxSize = new Vector3D(0.3, 0.3, 0.5);
    private final Vector3D inertia = new Vector3D();
    private final ContinuousSimpleReactionDynamics continuousDynamics;
    private final DMatrixRMaj continuousDynamicsMatrix = new DMatrixRMaj(6, 1);

    public SimpleReactionDynamics(double deltaT, double pendulumMass, double gravityZ) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
        this.pendulumMass = pendulumMass;
        this.continuousDynamics = new ContinuousSimpleReactionDynamics(pendulumMass, gravityZ);
        this.inertia.setX(boxSize.getY() * boxSize.getY() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setY(boxSize.getX() * boxSize.getX() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setZ(boxSize.getX() * boxSize.getX() + boxSize.getY() * boxSize.getY());
        this.inertia.scale(pendulumMass / 12.0);
    }

    public void setTimeStepSize(double deltaT) {
        this.deltaT = deltaT;
        this.deltaT2 = deltaT * deltaT;
    }

    public int getStateVectorSize() {
        return 12;
    }

    public int getControlVectorSize() {
        return 9;
    }

    public int getConstantVectorSize() {
        return 2;
    }

    public void getNextState(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 1) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        double x_k = currentState.get(0, 0);
        double y_k = currentState.get(1, 0);
        double z_k = currentState.get(2, 0);
        double xDot_k = currentState.get(6, 0);
        double yDot_k = currentState.get(7, 0);
        double zDot_k = currentState.get(8, 0);
        double thetaX_k = currentState.get(3, 0);
        double thetaY_k = currentState.get(4, 0);
        double thetaZ_k = currentState.get(5, 0);
        double thetaXDot_k = currentState.get(9, 0);
        double thetaYDot_k = currentState.get(10, 0);
        double thetaZDot_k = currentState.get(11, 0);
        this.continuousDynamics.getDynamics(hybridState, currentState, currentControl, constants, this.continuousDynamicsMatrix);
        matrixToPack.set(0, 0, x_k + this.deltaT * xDot_k);
        matrixToPack.set(1, 0, y_k + this.deltaT * yDot_k);
        matrixToPack.set(2, 0, z_k + this.deltaT * zDot_k);
        matrixToPack.set(3, 0, thetaX_k + this.deltaT * thetaXDot_k);
        matrixToPack.set(4, 0, thetaY_k + this.deltaT * thetaYDot_k);
        matrixToPack.set(5, 0, thetaZ_k + this.deltaT * thetaZDot_k);
        matrixToPack.set(6, 0, xDot_k);
        matrixToPack.set(7, 0, yDot_k);
        matrixToPack.set(8, 0, zDot_k);
        matrixToPack.set(9, 0, thetaXDot_k);
        matrixToPack.set(10, 0, thetaYDot_k);
        matrixToPack.set(11, 0, thetaZDot_k);
        MatrixTools.addMatrixBlock((DMatrix)matrixToPack, (int)0, (int)0, (DMatrix1Row)this.continuousDynamicsMatrix, (int)0, (int)0, (int)6, (int)1, (double)(0.5 * this.deltaT2));
        MatrixTools.addMatrixBlock((DMatrix)matrixToPack, (int)6, (int)0, (DMatrix1Row)this.continuousDynamicsMatrix, (int)0, (int)0, (int)6, (int)1, (double)this.deltaT);
    }

    public void getDynamicsStateGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        matrixToPack.set(0, 6, this.deltaT);
        matrixToPack.set(1, 7, this.deltaT);
        matrixToPack.set(2, 8, this.deltaT);
        matrixToPack.set(3, 9, this.deltaT);
        matrixToPack.set(4, 10, this.deltaT);
        matrixToPack.set(5, 11, this.deltaT);
    }

    public void getDynamicsControlGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 9) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                matrixToPack.set(0, 0, 0.5 * this.deltaT2 / this.pendulumMass);
                matrixToPack.set(1, 1, 0.5 * this.deltaT2 / this.pendulumMass);
                matrixToPack.set(2, 2, 0.5 * this.deltaT2 / this.pendulumMass);
                matrixToPack.set(3, 3, 0.5 * this.deltaT2 / this.inertia.getX());
                matrixToPack.set(4, 4, 0.5 * this.deltaT2 / this.inertia.getY());
                matrixToPack.set(5, 5, 0.5 * this.deltaT2 / this.inertia.getZ());
                matrixToPack.set(6, 0, this.deltaT / this.pendulumMass);
                matrixToPack.set(7, 1, this.deltaT / this.pendulumMass);
                matrixToPack.set(8, 2, this.deltaT / this.pendulumMass);
                matrixToPack.set(9, 3, this.deltaT / this.inertia.getX());
                matrixToPack.set(10, 4, this.deltaT / this.inertia.getY());
                matrixToPack.set(11, 5, this.deltaT / this.inertia.getZ());
            }
        }
    }

    public void getDynamicsStateHessian(SLIPState hybridState, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
    }

    public void getDynamicsControlHessian(SLIPState hybridState, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
    }

    public void getDynamicsStateGradientOfControlGradient(SLIPState hybridState, int stateVariable, DMatrixRMaj currentState, DMatrixRMaj constants, DMatrixRMaj currentControl, DMatrixRMaj matrixToPack) {
    }

    public void getDynamicsControlGradientOfStateGradient(SLIPState hybridState, int controlVariable, DMatrixRMaj currentState, DMatrixRMaj constants, DMatrixRMaj currentControl, DMatrixRMaj matrixToPack) {
    }

    public void getContinuousAMatrix(DMatrixRMaj A) {
    }

    public void getContinuousBMatrix(DMatrixRMaj B) {
    }
}

