/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SimpleReactionDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs.SLIPDesiredTrackingCost;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs.SLIPModelForceTrackingCost;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs.SLIPRegularizationCost;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.costs.SLIPTerminalCost;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.trajectoryOptimization.CompositeLQCostFunction;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationData;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationSequence;
import us.ihmc.trajectoryOptimization.DiscreteSequence;
import us.ihmc.trajectoryOptimization.LQCostFunction;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;
import us.ihmc.trajectoryOptimization.SimpleDDPSolver;

public class SLIPJumpingDDPCalculator {
    private final SimpleReactionDynamics dynamics;
    private double deltaT;
    private final DiscreteOptimizationSequence optimalSequence;
    private final DiscreteOptimizationSequence desiredSequence;
    private final DiscreteSequence constantSequence;
    private final SimpleDDPSolver<SLIPState> ddpSolver;
    private final double mass;
    private final double gravityZ;
    private final double nominalHeight;
    private final DMatrixRMaj initialState;
    private final CompositeLQCostFunction<SLIPState> regularCostFunction = new CompositeLQCostFunction();
    private final LQTrackingCostFunction<SLIPState> terminalCostFunction = new SLIPTerminalCost();
    private final List<SLIPState> dynamicStates = new ArrayList<SLIPState>();
    private final List<LQTrackingCostFunction<SLIPState>> costFunctions = new ArrayList<LQTrackingCostFunction<SLIPState>>();
    private final List<LQTrackingCostFunction<SLIPState>> terminalCostFunctions = new ArrayList<LQTrackingCostFunction<SLIPState>>();
    private final TIntArrayList startIndices = new TIntArrayList();
    private final TIntArrayList endIndices = new TIntArrayList();

    public SLIPJumpingDDPCalculator(double deltaT, double mass, double nominalHeight, double gravityZ) {
        this.dynamics = new SimpleReactionDynamics(deltaT, mass, gravityZ);
        this.deltaT = deltaT;
        this.mass = mass;
        this.nominalHeight = nominalHeight;
        this.gravityZ = gravityZ;
        this.ddpSolver = new SimpleDDPSolver((DiscreteHybridDynamics)this.dynamics, true);
        SLIPModelForceTrackingCost slipModelTrackingCost = new SLIPModelForceTrackingCost(mass, gravityZ);
        SLIPRegularizationCost slipRegularizationCost = new SLIPRegularizationCost();
        SLIPDesiredTrackingCost slipDesiredTrackingCost = new SLIPDesiredTrackingCost();
        this.regularCostFunction.addLQCostFunction((LQCostFunction)slipModelTrackingCost);
        this.regularCostFunction.addLQCostFunction((LQCostFunction)slipRegularizationCost);
        this.regularCostFunction.addLQTrackingCostFunction((LQTrackingCostFunction)slipDesiredTrackingCost);
        int stateSize = this.dynamics.getStateVectorSize();
        int controlSize = this.dynamics.getControlVectorSize();
        int constantSize = this.dynamics.getConstantVectorSize();
        this.initialState = new DMatrixRMaj(stateSize, 1);
        this.optimalSequence = new DiscreteOptimizationSequence(stateSize, controlSize);
        this.desiredSequence = new DiscreteOptimizationSequence(stateSize, controlSize);
        this.constantSequence = new DiscreteSequence(constantSize);
    }

    public void setDeltaT(double deltaT) {
        this.dynamics.setTimeStepSize(deltaT);
        this.deltaT = deltaT;
    }

    public void initialize(DMatrixRMaj currentState, FramePoint3D firstSupport, FramePoint3D apexPoint, FramePoint3D secondSupport, double firstStanceDuration, double flightDuration, double secondStanceDuration, double nominalInitialStiffness, double nominalFinalStiffness) {
        DMatrixRMaj constants;
        DMatrixRMaj desiredControl;
        DMatrixRMaj desiredState;
        int i;
        this.initialState.set((DMatrixD1)currentState);
        int numberOfInitialTimeSteps = (int)Math.floor(firstStanceDuration / this.deltaT);
        int numberOfFlightTimeSteps = (int)Math.floor(flightDuration / this.deltaT);
        int numberOfFinalTimeSteps = (int)Math.floor(secondStanceDuration / this.deltaT);
        double nominalFirstLength = this.nominalHeight + this.mass * this.gravityZ / nominalInitialStiffness;
        double nominalSecondLength = this.nominalHeight + this.mass * this.gravityZ / nominalFinalStiffness;
        double modifiedDeltaT = firstStanceDuration / (double)numberOfInitialTimeSteps;
        this.dynamics.setTimeStepSize(modifiedDeltaT);
        this.dynamicStates.add(SLIPState.STANCE);
        this.startIndices.add(0);
        this.endIndices.add(numberOfInitialTimeSteps - 1);
        this.costFunctions.add((LQTrackingCostFunction<SLIPState>)this.regularCostFunction);
        this.terminalCostFunctions.add(null);
        this.dynamicStates.add(SLIPState.FLIGHT);
        this.startIndices.add(numberOfInitialTimeSteps);
        this.endIndices.add(numberOfInitialTimeSteps + numberOfFlightTimeSteps - 1);
        this.costFunctions.add((LQTrackingCostFunction<SLIPState>)this.regularCostFunction);
        this.terminalCostFunctions.add(null);
        this.dynamicStates.add(SLIPState.STANCE);
        this.startIndices.add(numberOfInitialTimeSteps + numberOfFlightTimeSteps);
        this.endIndices.add(numberOfInitialTimeSteps + numberOfFlightTimeSteps + numberOfFinalTimeSteps - 1);
        this.costFunctions.add((LQTrackingCostFunction<SLIPState>)this.regularCostFunction);
        this.terminalCostFunctions.add(this.terminalCostFunction);
        int totalSize = numberOfInitialTimeSteps + numberOfFlightTimeSteps + numberOfFinalTimeSteps;
        this.desiredSequence.setLength(totalSize);
        this.optimalSequence.setLength(totalSize);
        this.constantSequence.setLength(totalSize);
        for (i = 0; i < numberOfInitialTimeSteps; ++i) {
            desiredState = this.desiredSequence.getState(i);
            desiredState.set(0, firstSupport.getX());
            desiredState.set(1, firstSupport.getY());
            desiredState.set(2, firstSupport.getZ() + this.nominalHeight);
            desiredControl = this.desiredSequence.getControl(i);
            desiredControl.set(2, this.mass * this.gravityZ);
            desiredControl.set(6, firstSupport.getX());
            desiredControl.set(7, firstSupport.getY());
            desiredControl.set(8, nominalInitialStiffness);
            constants = (DMatrixRMaj)this.constantSequence.get(i);
            constants.set(0, firstSupport.getZ());
            constants.set(1, nominalFirstLength);
        }
        for (i = numberOfInitialTimeSteps; i < numberOfInitialTimeSteps + numberOfFlightTimeSteps; ++i) {
            desiredState = this.desiredSequence.getState(i);
            desiredState.set(0, apexPoint.getX());
            desiredState.set(1, apexPoint.getY());
            desiredState.set(2, apexPoint.getZ());
            desiredControl = this.desiredSequence.getControl(i);
            desiredControl.set(2, 0.0);
            desiredControl.set(6, firstSupport.getX());
            desiredControl.set(7, firstSupport.getY());
            desiredControl.set(8, 0.0);
        }
        for (i = numberOfInitialTimeSteps + numberOfFlightTimeSteps; i < totalSize; ++i) {
            desiredState = this.desiredSequence.getState(i);
            desiredState.set(0, secondSupport.getX());
            desiredState.set(1, secondSupport.getY());
            desiredState.set(2, secondSupport.getZ() + this.nominalHeight);
            desiredControl = this.desiredSequence.getControl(i);
            desiredControl.set(2, this.mass * this.gravityZ);
            desiredControl.set(6, secondSupport.getX());
            desiredControl.set(7, secondSupport.getY());
            desiredControl.set(8, nominalFinalStiffness);
            constants = (DMatrixRMaj)this.constantSequence.get(i);
            constants.set(0, secondSupport.getZ());
            constants.set(1, nominalSecondLength);
        }
        this.ddpSolver.initializeSequencesFromDesireds(currentState, (DiscreteOptimizationData)this.desiredSequence, this.constantSequence);
        this.optimalSequence.set((DiscreteOptimizationData)this.desiredSequence);
    }

    public int solve() {
        return this.ddpSolver.computeSequence(this.dynamicStates, this.costFunctions, this.terminalCostFunctions, this.startIndices, this.endIndices);
    }

    public void singleSolve() {
        this.ddpSolver.computeOnePass(this.dynamicStates, this.costFunctions, this.terminalCostFunctions, this.startIndices, this.endIndices);
        this.optimalSequence.set(this.ddpSolver.getOptimalSequence());
    }

    private double computeDeltaT(double trajectoryLength) {
        int numberOfTimeSteps = (int)Math.floor(trajectoryLength / this.deltaT);
        return trajectoryLength / (double)numberOfTimeSteps;
    }

    public DiscreteOptimizationSequence getOptimalSequence() {
        return this.optimalSequence;
    }

    public double getValue() {
        return 0.0;
    }
}

