/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.slipJumping.SLIPState;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.trajectoryOptimization.ContinuousHybridDynamics;

public class ContinuousSimpleReactionDynamics
implements ContinuousHybridDynamics<SLIPState> {
    private final double pendulumMass;
    private final double gravityZ;
    private static final Vector3D boxSize = new Vector3D(0.3, 0.3, 0.5);
    private final Vector3D inertia = new Vector3D();

    public ContinuousSimpleReactionDynamics(double pendulumMass, double gravityZ) {
        this.pendulumMass = pendulumMass;
        this.gravityZ = gravityZ;
        this.inertia.setX(boxSize.getY() * boxSize.getY() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setY(boxSize.getX() * boxSize.getX() + boxSize.getZ() * boxSize.getZ());
        this.inertia.setZ(boxSize.getX() * boxSize.getX() + boxSize.getY() * boxSize.getY());
        this.inertia.scale(pendulumMass / 12.0);
    }

    public int getStateVectorSize() {
        return 6;
    }

    public int getControlVectorSize() {
        return 9;
    }

    public void getDynamics(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 1) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case FLIGHT: {
                matrixToPack.set(2, 0, -this.gravityZ);
                break;
            }
            case STANCE: {
                double fX_k = currentControl.get(0, 0);
                double fY_k = currentControl.get(1, 0);
                double fZ_k = currentControl.get(2, 0);
                double tauX_k = currentControl.get(3, 0);
                double tauY_k = currentControl.get(4, 0);
                double tauZ_k = currentControl.get(5, 0);
                matrixToPack.set(0, 0, fX_k / this.pendulumMass);
                matrixToPack.set(1, 0, fY_k / this.pendulumMass);
                matrixToPack.set(2, 0, fZ_k / this.pendulumMass - this.gravityZ);
                matrixToPack.set(3, 0, tauX_k / this.inertia.getX());
                matrixToPack.set(4, 0, tauY_k / this.inertia.getY());
                matrixToPack.set(5, 0, tauZ_k / this.inertia.getZ());
            }
        }
    }

    public void getDynamicsStateGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 12) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
    }

    public void getDynamicsControlGradient(SLIPState hybridState, DMatrixRMaj currentState, DMatrixRMaj currentControl, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        if (matrixToPack.numRows != 6) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        if (matrixToPack.numCols != 9) {
            throw new RuntimeException("The state matrix size is wrong.");
        }
        matrixToPack.zero();
        switch (hybridState) {
            case STANCE: {
                matrixToPack.set(0, 0, 1.0 / this.pendulumMass);
                matrixToPack.set(1, 1, 1.0 / this.pendulumMass);
                matrixToPack.set(2, 2, 1.0 / this.pendulumMass);
                matrixToPack.set(3, 3, 1.0 / this.inertia.getX());
                matrixToPack.set(4, 4, 1.0 / this.inertia.getY());
                matrixToPack.set(5, 5, 1.0 / this.inertia.getZ());
            }
        }
    }
}

