/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.trajectoryOptimization.DefaultDiscreteState;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;

public class LIPMSimpleCostFunction
implements LQTrackingCostFunction<DefaultDiscreteState> {
    static final double qX = 1.0E-6;
    static final double qY = 1.0E-6;
    static final double qZ = 10.0;
    static final double qXDot = 1.0E-6;
    static final double qYDot = 1.0E-6;
    static final double qZDot = 1.0E-6;
    static final double rXf = 100.0;
    static final double rYf = 100.0;
    static final double rFz = 1.0E-6;
    private final DMatrixRMaj Q = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj R = new DMatrixRMaj(3, 3);
    private DMatrixRMaj tempStateMatrix = new DMatrixRMaj(6, 1);
    private DMatrixRMaj tempControlMatrix = new DMatrixRMaj(3, 1);
    private DMatrixRMaj tempWX = new DMatrixRMaj(6, 1);
    private DMatrixRMaj tempWU = new DMatrixRMaj(3, 1);

    public LIPMSimpleCostFunction() {
        this.Q.set(0, 0, 1.0E-6);
        this.Q.set(1, 1, 1.0E-6);
        this.Q.set(2, 2, 10.0);
        this.Q.set(3, 3, 1.0E-6);
        this.Q.set(4, 4, 1.0E-6);
        this.Q.set(5, 5, 1.0E-6);
        this.R.set(0, 0, 100.0);
        this.R.set(1, 1, 100.0);
        this.R.set(2, 2, 1.0E-6);
    }

    public double getCost(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVector, (DMatrixD1)this.tempControlMatrix);
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)this.tempWX);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)this.tempWU);
        return CommonOps_DDRM.dot((DMatrixD1)this.tempControlMatrix, (DMatrixD1)this.tempWU) + CommonOps_DDRM.dot((DMatrixD1)this.tempStateMatrix, (DMatrixD1)this.tempWX);
    }

    public void getCostStateGradient(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)stateVector, (DMatrixD1)desiredStateVector, (DMatrixD1)this.tempStateMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.Q, (DMatrix1Row)this.tempStateMatrix, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostControlGradient(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj desiredControlVector, DMatrixRMaj desiredStateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.subtract((DMatrixD1)controlVector, (DMatrixD1)desiredControlVector, (DMatrixD1)this.tempControlMatrix);
        DiagonalMatrixTools.preMult((DMatrix1Row)this.R, (DMatrix1Row)this.tempControlMatrix, (DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)matrixToPack);
    }

    public void getCostStateHessian(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.Q, (DMatrixD1)matrixToPack);
    }

    public void getCostControlHessian(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        CommonOps_DDRM.scale((double)2.0, (DMatrixD1)this.R, (DMatrixD1)matrixToPack);
    }

    public void getCostStateGradientOfControlGradient(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(3, 6);
    }

    public void getCostControlGradientOfStateGradient(DefaultDiscreteState state, DMatrixRMaj controlVector, DMatrixRMaj stateVector, DMatrixRMaj constants, DMatrixRMaj matrixToPack) {
        matrixToPack.reshape(6, 3);
    }
}

