/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.LIPMDynamics;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.LIPMSimpleCostFunction;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm.LIPMTerminalCostFunction;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.trajectoryOptimization.DefaultDiscreteState;
import us.ihmc.trajectoryOptimization.DiscreteHybridDynamics;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationData;
import us.ihmc.trajectoryOptimization.DiscreteOptimizationTrajectory;
import us.ihmc.trajectoryOptimization.DiscreteSequence;
import us.ihmc.trajectoryOptimization.DiscreteTimeVaryingTrackingLQRSolver;
import us.ihmc.trajectoryOptimization.LQRSolverInterface;
import us.ihmc.trajectoryOptimization.LQTrackingCostFunction;
import us.ihmc.trajectoryOptimization.SimpleDDPSolver;

public class LIPMDDPCalculator {
    private final DiscreteHybridDynamics<DefaultDiscreteState> dynamics;
    private double deltaT;
    private double modifiedDeltaT;
    private final DiscreteOptimizationTrajectory desiredTrajectory;
    private final DiscreteOptimizationTrajectory optimalTrajectory;
    private final DiscreteSequence constantSequence;
    private int numberOfTimeSteps;
    private final SimpleDDPSolver<DefaultDiscreteState> ddpSolver;
    private final LQRSolverInterface<DefaultDiscreteState> lqrSolver;
    private final LQTrackingCostFunction<DefaultDiscreteState> costFunction = new LIPMSimpleCostFunction();
    private final LQTrackingCostFunction<DefaultDiscreteState> terminalCostFunction = new LIPMTerminalCostFunction();
    private double mass;
    private double gravityZ;
    private final FramePoint3D tempPoint = new FramePoint3D();
    private final FrameVector3D tempVector = new FrameVector3D();

    public LIPMDDPCalculator(double deltaT, double mass, double gravityZ) {
        this.dynamics = new LIPMDynamics(deltaT, mass, gravityZ);
        this.deltaT = deltaT;
        this.mass = mass;
        this.gravityZ = gravityZ;
        this.ddpSolver = new SimpleDDPSolver(this.dynamics, true);
        this.lqrSolver = new DiscreteTimeVaryingTrackingLQRSolver(this.dynamics, this.costFunction, this.terminalCostFunction);
        int stateSize = this.dynamics.getStateVectorSize();
        int controlSize = this.dynamics.getControlVectorSize();
        int constantSize = this.dynamics.getConstantVectorSize();
        this.desiredTrajectory = new DiscreteOptimizationTrajectory(stateSize, controlSize);
        this.optimalTrajectory = new DiscreteOptimizationTrajectory(stateSize, controlSize);
        this.constantSequence = new DiscreteSequence(constantSize);
    }

    public void setDeltaT(double deltaT) {
        this.dynamics.setTimeStepSize(deltaT);
        this.deltaT = deltaT;
        this.modifiedDeltaT = deltaT;
    }

    public void initialize(DMatrixRMaj currentState, MultipleWaypointsPositionTrajectoryGenerator copDesiredPlan) {
        this.modifiedDeltaT = this.computeDeltaT(copDesiredPlan.getLastWaypointTime());
        this.dynamics.setTimeStepSize(this.modifiedDeltaT);
        this.desiredTrajectory.setTrajectoryDuration(0.0, copDesiredPlan.getLastWaypointTime(), this.deltaT);
        this.optimalTrajectory.setTrajectoryDuration(0.0, copDesiredPlan.getLastWaypointTime(), this.deltaT);
        this.constantSequence.setLength(this.desiredTrajectory.size());
        double height = currentState.get(2);
        double time = 0.0;
        copDesiredPlan.compute(time);
        this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getPosition());
        this.tempVector.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getVelocity());
        DMatrixRMaj desiredState = this.desiredTrajectory.getState(0);
        desiredState.set(0, this.tempPoint.getX());
        desiredState.set(1, this.tempPoint.getY());
        desiredState.set(2, this.tempPoint.getZ() + height);
        desiredState.set(3, this.tempVector.getX());
        desiredState.set(4, this.tempVector.getY());
        desiredState.set(5, this.tempVector.getZ());
        DMatrixRMaj desiredControl = this.desiredTrajectory.getControl(0);
        desiredControl.set(0, this.tempPoint.getX());
        desiredControl.set(1, this.tempPoint.getY());
        desiredControl.set(2, this.mass * this.gravityZ);
        time += this.modifiedDeltaT;
        for (int i = 1; i < this.numberOfTimeSteps; ++i) {
            copDesiredPlan.compute(time);
            this.tempPoint.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getPosition());
            this.tempVector.setIncludingFrame((FrameTuple3DReadOnly)copDesiredPlan.getVelocity());
            desiredState = this.desiredTrajectory.getState(i);
            desiredState.set(0, this.tempPoint.getX());
            desiredState.set(1, this.tempPoint.getY());
            desiredState.set(2, this.tempPoint.getZ() + height);
            desiredState.set(3, this.tempVector.getX());
            desiredState.set(4, this.tempVector.getY());
            desiredState.set(5, this.tempVector.getZ());
            desiredControl = this.desiredTrajectory.getControl(i);
            desiredControl.set(0, this.tempPoint.getX());
            desiredControl.set(1, this.tempPoint.getY());
            desiredControl.set(2, this.mass * this.gravityZ);
            time += this.modifiedDeltaT;
        }
        this.lqrSolver.setDesiredSequence((DiscreteOptimizationData)this.desiredTrajectory, this.constantSequence, currentState);
        this.lqrSolver.solveRiccatiEquation((Enum)DefaultDiscreteState.DEFAULT, 0, this.desiredTrajectory.size() - 1);
        this.lqrSolver.computeOptimalSequences((Enum)DefaultDiscreteState.DEFAULT, 0, this.desiredTrajectory.size() - 1);
        this.lqrSolver.getOptimalSequence((DiscreteOptimizationData)this.optimalTrajectory);
        this.ddpSolver.initializeFromLQRSolution((Enum)DefaultDiscreteState.DEFAULT, this.costFunction, (DiscreteOptimizationData)this.optimalTrajectory, (DiscreteOptimizationData)this.desiredTrajectory, this.constantSequence, this.lqrSolver.getOptimalFeedbackGainSequence(), this.lqrSolver.getOptimalFeedForwardControlSequence());
    }

    public int solve() {
        int iterations = this.ddpSolver.computeSequence((Enum)DefaultDiscreteState.DEFAULT, this.costFunction, this.terminalCostFunction);
        this.optimalTrajectory.set(this.ddpSolver.getOptimalSequence());
        return iterations;
    }

    private double computeDeltaT(double trajectoryLength) {
        this.numberOfTimeSteps = (int)Math.floor(trajectoryLength / this.deltaT);
        return trajectoryLength / (double)this.numberOfTimeSteps;
    }

    public double getDT() {
        return this.modifiedDeltaT;
    }

    public DiscreteOptimizationTrajectory getOptimalTrajectory() {
        return this.optimalTrajectory;
    }

    public double getValue() {
        return 0.0;
    }
}

