/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.lipm;

import java.util.ArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class BasicCoPPlanner {
    private static final int numberOfStepsToCompute = 3;
    private static final double finalTransferDuration = 1.0;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ArrayList<Footstep> upcomingFootsteps = new ArrayList();
    private final ArrayList<FootstepTiming> upcomingTimings = new ArrayList();
    private final SideDependentList<? extends ContactablePlaneBody> contactableFeet;
    private final FramePoint3D desiredCoPPosition = new FramePoint3D();
    private final FrameVector3D desiredCoPVelocity = new FrameVector3D();
    private final FrameVector3D desiredCoPAcceleration = new FrameVector3D();
    private final MultipleWaypointsPositionTrajectoryGenerator copTrajectory;
    private boolean isInTransfer = false;
    private boolean isInStanding = true;
    private double initialTime = 0.0;
    private final YoDouble timeInCurrentStateRemaining;
    private final FramePoint3D initialSegmentCoP = new FramePoint3D();
    private final FramePoint3D finalSegmentCoP = new FramePoint3D();
    private final FramePoint3D footstepPosition = new FramePoint3D();
    private final FrameVector3D zeroVelocity = new FrameVector3D();

    public BasicCoPPlanner(SideDependentList<? extends ContactablePlaneBody> contactableFeet, YoRegistry registry) {
        this.contactableFeet = contactableFeet;
        this.timeInCurrentStateRemaining = new YoDouble("timeInCurrentStateRemaining", registry);
        this.desiredCoPPosition.setToZero();
        this.copTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("copTrajectory", worldFrame, registry);
    }

    public void clearPlan() {
        this.upcomingFootsteps.clear();
        this.upcomingTimings.clear();
        this.copTrajectory.clear();
    }

    public void submitFootstep(Footstep footstep, FootstepTiming timing) {
        this.upcomingFootsteps.add(footstep);
        this.upcomingTimings.add(timing);
    }

    public void initializeForStanding() {
        this.isInStanding = true;
        this.isInTransfer = false;
    }

    public void initializeForTransfer(double currentTime) {
        int stepIndex;
        this.initialTime = currentTime;
        this.isInStanding = false;
        this.isInTransfer = true;
        Footstep currentFootstep = this.upcomingFootsteps.get(0);
        RobotSide supportSide = currentFootstep.getRobotSide().getOppositeSide();
        this.finalSegmentCoP.setToZero(((ContactablePlaneBody)this.contactableFeet.get((Enum)supportSide)).getSoleFrame());
        this.desiredCoPPosition.changeFrame(worldFrame);
        this.finalSegmentCoP.changeFrame(worldFrame);
        double endTime = this.upcomingTimings.get(0).getTransferTime();
        this.copTrajectory.appendWaypoint(0.0, (FramePoint3DReadOnly)this.desiredCoPPosition, (FrameVector3DReadOnly)this.zeroVelocity);
        this.copTrajectory.appendWaypoint(endTime, (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
        this.copTrajectory.appendWaypoint(endTime += this.upcomingTimings.get(0).getSwingTime(), (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
        Footstep previousFootstep = currentFootstep;
        for (stepIndex = 1; stepIndex < Math.min(3, this.upcomingFootsteps.size()); ++stepIndex) {
            this.initialSegmentCoP.set(this.finalSegmentCoP);
            this.finalSegmentCoP.setToZero(previousFootstep.getSoleReferenceFrame());
            this.finalSegmentCoP.changeFrame(worldFrame);
            this.copTrajectory.appendWaypoint(endTime += this.upcomingTimings.get(stepIndex).getTransferTime(), (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
            this.copTrajectory.appendWaypoint(endTime += this.upcomingTimings.get(stepIndex).getSwingTime(), (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
            previousFootstep = this.upcomingFootsteps.get(stepIndex);
        }
        this.upcomingFootsteps.get(stepIndex - 1).getPosition(this.footstepPosition);
        this.initialSegmentCoP.set(this.finalSegmentCoP);
        this.finalSegmentCoP.interpolate((FrameTuple3DReadOnly)this.initialSegmentCoP, (FrameTuple3DReadOnly)this.footstepPosition, 0.5);
        this.copTrajectory.appendWaypoint(endTime += 1.0, (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
        this.copTrajectory.initialize();
    }

    public void initializeForSingleSupport(double currentTime) {
        int stepIndex;
        this.initialTime = currentTime;
        this.isInStanding = false;
        this.isInTransfer = false;
        Footstep currentFootstep = this.upcomingFootsteps.get(0);
        RobotSide supportSide = currentFootstep.getRobotSide().getOppositeSide();
        this.finalSegmentCoP.setToZero(((ContactablePlaneBody)this.contactableFeet.get((Enum)supportSide)).getSoleFrame());
        this.desiredCoPPosition.changeFrame(worldFrame);
        this.finalSegmentCoP.changeFrame(worldFrame);
        double endTime = this.upcomingTimings.get(0).getSwingTime();
        this.copTrajectory.appendWaypoint(0.0, (FramePoint3DReadOnly)this.desiredCoPPosition, (FrameVector3DReadOnly)this.zeroVelocity);
        this.copTrajectory.appendWaypoint(endTime, (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
        Footstep previousFootstep = currentFootstep;
        for (stepIndex = 1; stepIndex < Math.min(3, this.upcomingFootsteps.size()); ++stepIndex) {
            this.initialSegmentCoP.set(this.finalSegmentCoP);
            this.finalSegmentCoP.setToZero(previousFootstep.getSoleReferenceFrame());
            this.finalSegmentCoP.changeFrame(worldFrame);
            this.copTrajectory.appendWaypoint(endTime += this.upcomingTimings.get(stepIndex).getTransferTime(), (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
            this.copTrajectory.appendWaypoint(endTime += this.upcomingTimings.get(stepIndex).getSwingTime(), (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
            previousFootstep = this.upcomingFootsteps.get(stepIndex);
        }
        this.upcomingFootsteps.get(stepIndex - 1).getPosition(this.footstepPosition);
        this.initialSegmentCoP.set(this.finalSegmentCoP);
        this.finalSegmentCoP.interpolate((FrameTuple3DReadOnly)this.initialSegmentCoP, (FrameTuple3DReadOnly)this.footstepPosition, 0.5);
        this.copTrajectory.appendWaypoint(endTime += 1.0, (FramePoint3DReadOnly)this.finalSegmentCoP, (FrameVector3DReadOnly)this.zeroVelocity);
        this.copTrajectory.initialize();
    }

    public void compute(double time) {
        double timeInCurrentState = time - this.initialTime;
        this.timeInCurrentStateRemaining.set(this.getCurrentStateDuration() - timeInCurrentState);
        if (this.isInStanding) {
            this.desiredCoPVelocity.setToZero();
            this.desiredCoPAcceleration.setToZero();
        } else {
            this.copTrajectory.compute(timeInCurrentState);
            this.desiredCoPPosition.set((FrameTuple3DReadOnly)this.copTrajectory.getPosition());
            this.desiredCoPVelocity.set((FrameTuple3DReadOnly)this.copTrajectory.getVelocity());
            this.desiredCoPAcceleration.set((FrameTuple3DReadOnly)this.copTrajectory.getAcceleration());
        }
    }

    public double getCurrentStateDuration() {
        if (this.isInTransfer) {
            return this.upcomingTimings.get(0).getTransferTime();
        }
        return this.upcomingTimings.get(0).getSwingTime();
    }

    public MultipleWaypointsPositionTrajectoryGenerator getCoPTrajectory() {
        return this.copTrajectory;
    }

    public void getDesiredCoPData(FramePoint3D desiredCoPPosition, FrameVector3D desiredCoPVelocity, FrameVector3D desiredCoPAcceleration) {
        desiredCoPPosition.set(this.desiredCoPPosition);
        desiredCoPVelocity.set(this.desiredCoPVelocity);
        desiredCoPAcceleration.set(this.desiredCoPAcceleration);
    }

    public boolean isDone() {
        return this.timeInCurrentStateRemaining.getDoubleValue() <= 0.0;
    }
}

