/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerInterface;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanningCostPolicy;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;

public class TouchDownHeightObjectivePolicy
implements CoMTrajectoryPlanningCostPolicy {
    private final double weight;
    private final DoubleProvider omega;

    public TouchDownHeightObjectivePolicy(DoubleProvider omega, double weight) {
        this.omega = omega;
        this.weight = weight;
    }

    @Override
    public void assessPolicy(CoMTrajectoryPlannerInterface comTrajectoryPlanner, List<? extends ContactStateProvider> contactSequence, DMatrix hessianToPack, DMatrix xGradientToPack, DMatrix yGradientToPack, DMatrix zGradientToPack) {
        for (int sequenceId = 0; sequenceId < contactSequence.size() - 1; ++sequenceId) {
            boolean isEndTouchDown;
            ContactStateProvider contactState = contactSequence.get(sequenceId);
            boolean bl = isEndTouchDown = contactSequence.get(sequenceId + 1).getContactState().isLoadBearing() && !contactState.getContactState().isLoadBearing();
            if (!isEndTouchDown) continue;
            double duration = contactState.getTimeInterval().getDuration();
            double copHeight = contactSequence.get(sequenceId + 1).getECMPStartPosition().getZ();
            double objectiveCoMHeight = copHeight + comTrajectoryPlanner.getNominalCoMHeight();
            CoMTrajectoryPlannerTools.addValueObjective(this.weight, sequenceId, this.omega.getValue(), duration, objectiveCoMHeight, CoMTrajectoryPlannerTools.comPositionCoefficientProvider, CoMTrajectoryPlannerTools.comPositionCoefficientSelectedProvider, hessianToPack, zGradientToPack);
        }
    }
}

